<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper"
	data-ng-controller="addObjectStoreController">
	<div class="setup-title">
		<h1><cv:msg key="title.add.networkStore" bundle="storage"/></h1>
	</div>
	<div class="text-center" data-ng-if="addNetworkStoreError">
		<div class="serverMessage error">{{serverErrorMessage}}</div>
	</div>
	<form name="addNfsStore" novalidate autocomplete="off"
		data-cv-submit="createStore()">
		<div class="form-horizontal">
		<div class="panel panel-default">
			<div class="panel-body">
				<div ng-if="false" class="form-group">
					<label class="col-xs-12 col-sm-5" for="clientList"><cv:msg key="label.networkStore.nfsClients" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" data-ng-model="computeNode.clientList"
							data-ng-required="true" id="clientList" name="clientList" />
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="nfsObjectStoreName"><cv:msg key="label.networkStore.nfsObjectStore" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" data-ng-model="computeNode.nfsObjectStoreName"
							data-ng-required="true" id="nfsObjectStoreName" name="nfsObjectStoreName" />
						<span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.nfsObjectStoreName)"><cv:msg key="label.networkStore.nfsObjectStoreNameNeeded" bundle="storage"/></span>
					</div>
				</div>
				<div class="form-group" data-ng-if="enableSMBSupport">
                    <label class="col-xs-12 col-sm-5" for="protocol"><cv:msg key="label.networkStore.protocol" bundle="storage"/></label>
                    <div class="col-xs-12 col-sm-7">
                        <select 
                            id="protocol" 
                            name="protocol" 
							data-ng-model="config.protocol"
							data-ng-change="onProtocolHandler()"
                        >
                            <option ng-repeat="file in protocolData.availableFiles" value="{{file.name}}">{{file.name}}</option>
                        </select>
                    </div>
                </div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="nfsServer"><cv:msg key="label.networkStore.nfsServer" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<%-- <select name="nfsServer" id="nfsServer" data-ng-required="true"
							data-ng-options="nfsServer.mediaAgent.mediaAgentName for nfsServer in nfsServers"
							data-ng-model="computeNode.nfsServer" data-ng-change="changeNFSServer()">
							<option value=""><cv:msg key="hint.select.nfs.server" bundle="storage"/></option>
						</select> <span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.nfsServer)"><cv:msg key="label.networkStore.nfsServerNeeded" bundle="storage"/></span> --%>

						<isteven-multi-select id="nfsServer"
                             data-input-model="nfsServers"
                             on-item-click="setNFSServer(data)"
                             data-tick-property="selected" data-item-label="nfsServerName"
                             class="isteven-multi-select user-group-select"
                             data-button-label="nfsServerName" data-helper-elements="filter"
                             data-selection-mode="single" translation="localLang">
                         </isteven-multi-select>
					</div>
				</div>
				<div class="form-group" data-ng-if="computeNode.nfsServer && !computeNode.isNFSCachePathSet.length">
					<label class="col-xs-12 col-sm-5" for="nfsCachePath"><cv:msg key="label.networkStore.nfsCachePath" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group">
							<input
								class="data-cache-path"
								type="text" 
								data-ng-model="computeNode.nfsCachePath"
								data-ng-required="true" 
								id="physicalPathFolder" 
								name="nfsCachePath"
								data-ng-pattern="nfsCachePathPattern"
							/>
                            <span class="input-group-btn">
                                   <cv-machine-browse
										id="dataFilePathBrowse"
                                        button-label='<cv:msg key="label.browse" bundle="restore"/>'
                                        client-id='{{computeNode.nfsServer.mediaAgent.mediaAgentId}}'
                                        result-function="setNFSCachePath">
									</cv-machine-browse>
				            </span>
						</div>
						<span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.nfsCachePath) && !addNfsStore.nfsCachePath.$error.pattern"><cv:msg key="label.networkStore.nfsCachePathNeeded" bundle="storage"/></span>
						<span 
							class="help-block"
							data-ng-show="addNfsStore.nfsCachePath.$error.pattern && cv.addNfsStore.needsAttention(storageForm.nfsCachePath)"
						>
							<cv:msg key="error.networkStoreCache.required" bundle="storage"/>
						</span>	
					</div>
				</div>
				<div class="form-group" data-ng-if="computeNode.nfsServer && !computeNode.isSolrIndexCachePathSet.length">
					<label class="col-xs-12 col-sm-5" for="solrIndexCachePath"><cv:msg key="label.networkStore.indexDirectory" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<div class="input-group">
							<input class="index-cache-path-folder" type="text" data-ng-model="computeNode.solrIndexCachePath"
							data-ng-required="true" id="physicalPathFolder" name="solrIndexCachePath" data-ng-pattern='indexCachePathPattern'/>

                            <span class="input-group-btn">
								<cv-machine-browse
									id="dataFilePathBrowse"
                                    button-label='<cv:msg key="label.browse" bundle="restore"/>'
                                    client-id='{{computeNode.nfsServer.mediaAgent.mediaAgentId}}'
                                    result-function="setSolrIndexCachePath">
								</cv-machine-browse>
				            </span>
						</div>

						<span 
							class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.solrIndexCachePath) && !addNfsStore.solrIndexCachePath.$error.pattern"
						>
							<cv:msg key="label.networkStore.indexCachePathNeeded" bundle="storage"/>
						</span>
						<span 
							class="help-block"
							data-ng-show="addNfsStore.solrIndexCachePath.$error.pattern && cv.addNfsStore.needsAttention(storageForm.solrIndexCachePath)"
						>
							<cv:msg key="error.networkStore.required" bundle="storage"/>
						</span>	
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="backupPlan"><cv:msg key="label.backup.plan" bundle="storage"/></label>
					<div class="col-xs-12 col-sm-7">
						<%-- <select name="backupPlan" id="backupPlan" data-ng-required="true"
							data-ng-options="response.plan.planName for response in plansList"
							data-ng-model="computeNode.planResponse">
							<option value=""><cv:msg key="hint.select.backup.plan" bundle="storage"/></option>
						</select> <span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.backupPlan)"><cv:msg key="label.networkStore.backupPlanNeeded" bundle="storage"/></span> --%>
						<isteven-multi-select id="backupPlan"
                             data-input-model="plansList"
                             on-item-click="setPlan(data)"
                             data-tick-property="selected" data-item-label="planName"
                             class="isteven-multi-select user-group-select"
                             data-button-label="planName" data-helper-elements="filter"
                             data-selection-mode="single" translation="localLang">
                         </isteven-multi-select>
					</div>
				</div>
				<!-- <div class="form-group">
					<label class="col-xs-12 col-lg-6" for="nfsIndexName"><cv:msg key="label.networkStore.indexServer" bundle="storage"/></label>
					<div class="col-xs-12 col-lg-6">
						<select name="nfsIndexName" id="nfsIndexName"
							data-ng-required="true"
							data-ng-options="nfsIndexServer.clientName for nfsIndexServer in nfsIndexServers"
							data-ng-model="computeNode.nfsIndexServer">
							<option value="">Select NFS Index Server</option>
						</select> <span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.nfsIndexName)"><cv:msg key="label.networkStore.indexServerNeeded" bundle="storage"/></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-6" for="user"> <cv:msg key="label.userName" bundle="storage"/> </label>
					<div class="col-xs-12 col-lg-6">
						<select name="user" id="user" data-ng-required="true"
							data-ng-options="user.userName for user in nfsUsers"
							data-ng-model="computeNode.user">
							<option value="">Select User</option>
						</select> <span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.user)"><cv:msg key="label.networkStore.userNeeded" bundle="storage"/></span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-6" for="storagepolicy">  <cv:msg key="label.storagePolicy" bundle="storage"/> </label>
					<div class="col-xs-12 col-lg-6">
						<select name="storagepolicy" id="storagepolicy"
							data-ng-required="true"
							data-ng-options="storagePolicy.storagePolicyName for storagePolicy in storagePolicies"
							data-ng-model="computeNode.storagepolicy">
							<option value="">Select Storage Policy</option>
						</select> <span class="help-block"
							data-ng-show="cv.addNfsStore.needsAttention(addNfsStore.storagepolicy)"><cv:msg key="label.networkStore.storagePolicyNeeded" bundle="storage"/></span>
					</div>
				</div>

				<div ng-if="false" class="form-group">
					<label class="col-xs-12 col-lg-6" for="squashtype"><cv:msg key="label.networkStore.squashType" bundle="storage"/></label>
					<div class="col-xs-12 col-lg-6">
						<select name="squashtype" id="squashtype" data-ng-required="true"
							data-ng-options="squashtype.text for squashtype in squashtypes"
							data-ng-model="computeNode.squashtype">
						</select>
					</div>
				</div>
				<div ng-if="false" class="form-group">
					<label class="col-xs-12 col-lg-6" for="anonGID"><cv:msg key="label.networkStore.anonGID" bundle="storage"/></label>
					<div class="col-xs-12 col-lg-6">
						<input min="-2" max="65536" type="number"
							data-ng-model="computeNode.anonGID" data-ng-required="true"
							id="anonGID" name="anonGID" />
					</div>
				</div>
				<div ng-if="false" class="form-group">
					<label class="col-xs-12 col-lg-6" for="anonUID"><cv:msg key="label.networkStore.anonUID" bundle="storage"/></label>
					<div class="col-xs-12 col-lg-6">
						<input min="-2" max="65536" type="number"
							data-ng-model="computeNode.anonUID" data-ng-required="true"
							id="anonUID" name="anonUID" />
					</div>
				</div>
				<div ng-if="false" class="form-group">
                    <label class="col-xs-12 col-lg-6" > <cv:msg key="label.networkStore.useVersions" bundle="storage"/></label>
                    <div class="col-xs-12 col-lg-6 ">
                        <input type="checkbox" id="version3"
                            data-ng-model="computeNode.version" /> <label
                            class="checkbox-label" for="version3">  </label>
                    </div>
                </div>
                -->
			</div>
		</div></div>
		<div class="modal-footer">
			<button id="addNetworkStore_button_#5802" type="button" class="btn btn-default setup-btn--hidden"
				data-ng-click="closeModal()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="addNetworkStore_button_#4471" type="submit" class="btn btn-primary"
				data-ng-click="createStore()" data-ng-disabled="!computeNode.planResponse || !computeNode.nfsServer">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>
</div>