<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="form-group">
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
		<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
		<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sendLogs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1 data-ng-show="!isEditMode">
			<cv:msg key="header.addResourcePool" bundle="storage" />
			<cv-help-component help-text="<cv:msg key="label.resourcePoolHelpText" bundle="storage"/>"></cv-help-component>
		</h1>
		<h1 data-ng-show="isEditMode">
			<cv:msg key="header.editResourcePool" bundle="storage" />
			<cv-help-component help-text="<cv:msg key="label.resourcePoolHelpText" bundle="storage"/>"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content">
		<span data-ng-if="serverErrorMessage" class="server-message {{serverErrorMessage.type}}" data-ng-bind="serverErrorMessage.message"></span>
		<form name="addEditResourcePoolForm" data-cv-submit="addResourcePool()" novalidate autocomplete="off">
			<div class="form-group row margin-0 padding-top-10">
				<div class="col-xs-12 col-md-5 col-lg-5 margin-top-10">
					<label class="cv-label line-height-normal" > <cv-help-text help-label="label.solutionType" help-text="info.solutionType"/>
					</label>
				</div>
				<div data-ng-if="!isEditMode && !appTypeChangeDisabled" class="col-xs-12 col-md-7 col-lg-7">
					<select id="resourcePoolTypeList" name="resourcePoolTypeList"
						data-ng-model="resourcePoolInfo.appType"
						data-ng-options="resourcePoolType as (resourcePoolType | resourcePoolAppTypeName) for resourcePoolType in resourcePoolTypeList | orderBy: (resourcePoolType | resourcePoolAppTypeName)"
						data-ng-change="solutionTypeChanged()"
						required >
					</select>
				</div>
				<div data-ng-if="isEditMode || appTypeChangeDisabled" class="col-xs-12 col-md-7 col-lg-7">
					<label class="no-margin"><span
						data-ng-bind="resourcePoolInfo.appType | resourcePoolAppTypeName"></span></label>
				</div>

			</div>
			<div class="form-group row margin-0 padding-top-10">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="name"><cv:msg key="Name" bundle="storage" /> </label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="full-text" type="text" id="name" name="name"
						data-ng-model="resourcePoolInfo.resourcePool.resourcePoolName"
						required
						data-ng-class="{'has-error': cv.addEditResourcePoolForm.needsAttention(addEditResourcePoolForm.name)}" />
					<span class="cv-help-block"
						data-ng-show="cv.addEditResourcePoolForm.needsAttention(addEditResourcePoolForm.name)"><cv:msg
							key="error.resourcePoolName.required" bundle="storage" />
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-10">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label><cv:msg key="label.storage" bundle="profiles" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<isteven-multi-select id="addEditResourcePool_isteven-multi-select_#2150" input-model="storagePoolList"
						output-model="modalData.selectedStoragePool"
						button-label="storagePoolName" item-label="storagePoolName"
						helper-elements="all none reset filter" tick-property="selected"
						disable-property="disabled"
						directive-id="'storagePools'"
						class="isteven-multi-select user-group-select"
						translation="localLangStoragePool" selection-mode="single"
						required> </isteven-multi-select>
					<span class="cv-help-block"
						data-ng-show="addEditResourcePoolForm.$submitted && selectedStoragePool.length == 0"><cv:msg
							key="error.selectStoragePool" bundle="storage" /></span>
				</div>
			</div>
			<div class="form-group row margin-0 padding-top-10" data-ng-show="showAcessNodes">
				<div class="col-xs-12 col-md-5 col-lg-5">
					<label><cv:msg key="label.dataAccessNodes" bundle="bigData" />
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<isteven-multi-select
						id="addEditResourcePool_isteven-multi-select_#8300"
						input-model="accessNodesList"
						output-model="selectedAccessNodes"
						button-label="clientName"
						item-label="clientName"
						helper-elements="reset filter"
						tick-property="selected"
						disable-property="disabled"
						directive-id="'dataAccessNodes'"
						class="isteven-multi-select user-group-select"
						translation="localLangDataAccessNodes"
						selection-mode="{{accessNodeSelectionMode}}"
						required
						group-property="msGroup"
						on-item-click="accessNodeSelectionChanged()"
						on-reset="resetAccessNodeSelection()"> </isteven-multi-select>
					<span class="cv-help-block"
						data-ng-show="addEditResourcePoolForm.$submitted && selectedAccessNodes.length == 0"><cv:msg
							key="error.dataAccessNodes" bundle="bigData" /></span>
				</div>
			</div>
			<div class="row margin-0" data-ng-show="resourcePoolInfo.appType == 'SALESFORCE'">
				<cv-capps-access-nodes instance-type="'SALESFORCE'"
						selected-access-nodes-list="resourcePoolInfo.extendedProp.salesforceProperties.accessNodes"
						label-class="'col-xs-12 col-md-5 col-lg-5'"
						input-class="'col-xs-12 col-md-7 col-lg-7'">
					</cv-capps-access-nodes>
			</div>
			<div class="form-group row margin-0 padding-top-10" data-ng-show="showIndexServers">
				<div class="col-xs-12 col-md-5 col-lg-5 margin-top-10">
					<label class="cv-label line-height-normal" > <cv-help-text help-label="label.indexServer" help-text="info.indexServer"/>
					</label>
				</div>
				<div class="col-xs-12 col-md-7 col-lg-7">
				<div data-ng-if="!isEditMode" class="input-group">
					<isteven-multi-select id="addEditResourcePool_isteven-multi-select_#3549" input-model="indexServers"
						output-model="modalData.selectedIndexServer"
						button-label="clientName" item-label="clientName"
						helper-elements="all none reset filter" tick-property="selected"
						disable-property="disabled"
						directive-id="'indexServerNodes'"
						class="isteven-multi-select user-group-select"
						translation="localLangIndexServer" selection-mode="single" required>
					</isteven-multi-select>
					<span class="cv-help-block"
						data-ng-show="addEditResourcePoolForm.$submitted && selectedIndexServer.length==0"><cv:msg
							key="error.selectIndexServerNodes" bundle="storage" /></span>
					<span class="input-group-btn">
											<button id="createIndexServer_button_#3718" type="button"
												data-ng-click="createNewIndexServer()"
												class="icon-style cv-material-button browse">
												<div class="cv-material-button-icon cursor-pointer">
													<svg height="20" id="cv_cc" viewBox="0 0 448 448" width="20" xmlns="http://www.w3.org/2000/svg">
														<path d="m408 184h-136c-4.417969 0-8-3.582031-8-8v-136c0-22.089844-17.910156-40-40-40s-40 17.910156-40 40v136c0 4.417969-3.582031 8-8 8h-136c-22.089844 0-40 17.910156-40 40s17.910156 40 40 40h136c4.417969 0 8 3.582031 8 8v136c0 22.089844 17.910156 40 40 40s40-17.910156 40-40v-136c0-4.417969 3.582031-8 8-8h136c22.089844 0 40-17.910156 40-40s-17.910156-40-40-40zm0 0"/>
													</svg>
												</div>
												<div class="cv-material-button-tooltip">
													<cv:msg key="label.newExchangeIndexServer" bundle="exchange" />
												</div>
											</button>
										</span>
										</div>
				</div>
				<div data-ng-if="isEditMode" class="col-xs-12 col-md-7 col-lg-7">
					<label class="no-margin"><span
						data-ng-bind="resourcePoolInfo.indexServer.clientName"></span></label>
				</div>
			</div>
			<div data-ng-show="isExchangeAppType">
				 <h4 class="text-left padding-left-20">
					<cv:msg key="label.additionalProperties" bundle="storage" />
				</h4>
				<div class="form-group row margin-0 padding-top-10">
					<div class="col-xs-12 col-md-5 col-lg-5">
						<label for="jobResultsDirectory"><cv:msg
								key="label.jobResultsDirectory" bundle="exchange" /></label>
					</div>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input class="full-text" type="text" id="jobResultsDirectory"
							name="jobResultsDirectory"
							placeholder='<cv:msg key="label.help.jobResultsDirectory" bundle="exchange" />'
							data-ng-model="resourcePoolInfo.extendedProp.exchangeOnePassClientProperties.jobResulsDir.path"
							data-ng-class="{'has-error': helpText.jobResultsDirPath}"
							maxlength="100" /> <span class="cv-help-block"
							data-ng-show="helpText.jobResultsDirPath"><cv:msg
								key="error.noJobResultsDirectory" bundle="exchange" /></span>
					</div>
				</div>
				<div class="form-group row margin-0 padding-top-10">
					<div class="col-xs-12 col-md-5 col-lg-5">
						<label for="username"><cv:msg key="User Name"
								bundle="storage" /> </label>
					</div>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input class="full-text" type="text" id="username" name="username"
							data-ng-model="userName"
							data-ng-change="helpText.userName=false;"
							data-ng-class="{'has-error': helpText.userName}"
							maxlength="100" /> <span class="cv-help-block"
							data-ng-show="helpText.userName"><cv:msg
								key="error.UserName.required" bundle="storage" /></span>
					</div>
				</div>
				<div class="form-group row margin-0 padding-top-10">
					<div class="col-xs-12 col-md-5 col-lg-5">
						<label for="password"><cv:msg key="Password"
								bundle="storage" /> </label>
					</div>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input class="full-text" type="password" id="password" name="password"
							data-ng-model="password"
							data-ng-class="{'has-error': helpText.password}"
							maxlength="100" /> <span class="cv-help-block"
							data-ng-show="helpText.password"><cv:msg
								key="error.Password.required" bundle="storage" /></span>
					</div>
				</div>
			</div>
			<div data-ng-if="resourcePoolInfo.appType == 'SALESFORCE'">
				 <h4 class="text-left padding-left-20">
					<cv:msg key="label.additionalProperties" bundle="storage" />
				</h4>
				<!-- Download Cache Path -->
				<div class="form-group row margin-0 padding-top-10">
					<div class="col-xs-12 col-md-5 col-lg-5">
						<label for="downloadCachePath"><cv:msg key="label.downloadCachePath" bundle="capps" /> </label>
					</div>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input class="full-text" id="downloadCachePath" type="text"
							data-ng-class="{'has-error': helpText.downloadCachePath}"
							data-ng-model="resourcePoolInfo.extendedProp.salesforceProperties.downloadCachePath" />
						<span class="cv-help-block"
							data-ng-show="helpText.downloadCachePath"><cv:msg key="error.downloadCachePath" bundle="capps" /></span>
					</div>
				</div>

				<div class="form-group row margin-0 padding-top-10" data-ng-if="sfProps.credManager">
				<cv-credential-manager model="sfProps.credManager"
					show-credential="false" input-name="resourcePoolInfo.connectedAppCredentials"
					password-complexity="1" form-name="addEditResourcePoolForm"
					need-confirm="false" label-class="'col-xs-12 col-md-4'"
					input-class="'col-xs-12 col-md-7 col-lg-7 padding-left-25'"></cv-credential-manager>
				</div>

				<!-- Sync database options -->
				<div >
					<cv-sync-database sync-database="resourcePoolInfo.extendedProp.salesforceProperties.syncDatabase"
						show-dummy-password="true" server-message="serverMessage"
						proxy-servers="resourcePoolInfo.extendedProp.salesforceProperties.accessNodes"
						always-enable="true"
						label-class="'col-xs-12 col-md-5 col-lg-5'"
						input-class="'col-xs-12 col-md-7 col-lg-7'"
						form-group-class="'row margin-0 padding-top-10'"
						hide-database-name="true"
						hide-test-connection="true" />
				</div>

			</div>
			<div class="button-container">
				<button id="addEditResourcePool_button_#3285" type="button" class="btn btn-default cvBusyOnAjax"
					data-ng-click="cancel()">
					<cv:msg key="Cancel" />
				</button>
				<button id="addEditResourcePool_button_#1909" type="submit" class="btn btn-primary cvBusyOnAjax">
					<cv:msg key="Save" />
				</button>
			</div>
		</form>
	</div>
</div>