<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
			<h1 class="float-left">{{arrayName}}</h1>
			<span><a class="page-action-item" href="" data-ng-click="deleteArray()"><cv:msg key="action.delete" bundle="snapArray" /></a></span>
	</div>
</div>
<span class="server-message {{arrayDetailsMessage.type}}">{{arrayDetailsMessage.message}}</span>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="snapArrayDetails-label_general-snapArray" data-title='<cv:msg key="label.general" bundle="snapArray"/>' loader="generalTab">
			<div class="page-details-box-links">
					<a href="" data-ng-click="editSnapArray(isConfigAvailable)"><cv:msg key="action.edit" bundle="snapArray" />
					</a>
			</div>
			<ul class="list-style-secondary">
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.snapEngineIdName" bundle="snapArray" /></span>
					 <span class="pageDetailColumn">{{snapDetails.vendor.name}}</span></li>
 				<li class="group"><span class="pageDetailColumn">{{arrayNameLabel}}</span>
					 <span class="pageDetailColumn">{{arrayName}}</span>
				</li>
				<li class="group" data-ng-if="hostName !== ''">
					<span class="pageDetailColumn">
						{{arrayHostNameLabel}}
					</span>
					<span class="pageDetailColumn">{{hostName}}</span>
				</li>	 
				<li class="group" data-ng-if="userName && !hasSavedCredential">
					<span class="pageDetailColumn">
						{{arrayUserNameLabel}}
					</span>
					<span class="pageDetailColumn">{{userName}}</span>
				</li>
				<li class="group" data-ng-if="hasSavedCredential">
					<span class="pageDetailColumn">
						{{credentialLabel}}
					</span>
					<span class="pageDetailColumn region-detail-span" id="credential-value-span">{{savedCredentialFromBackend.credentialName}}</span>
				</li>
				<li class="group" data-ng-if="isNetApp">
					<span class="pageDetailColumn"> 
						{{regionLabel}}
					</span>
					<span data-ng-if="region && region.regionName" class="pageDetailColumn region-detail-span" id="region-value-span" data-uib-tooltip={{region.regionName}} data-tooltip-placement="bottom" >{{region.regionName}}</span>
					<span data-ng-if="!region.regionName" class="pageDetailColumn region-detail-span" id="region-value-span">{{regionNotSelected}}</span>
				</li>
				<div data-ng-repeat="elem in snapConfForm" data-ng-if="elem.showInGeneralTab">
					<div data-ng-if="elem.formType === 'input'">
						<li class="group" >
							<span class="pageDetailColumn">
								{{elem.label}}
							</span>
							<span class="pageDetailColumn">{{elem.value}}</span>
						</li>
					</div>					
				</div>

				
			</ul>
		</cv-tile-component>
		<cv-security-component show-edit='showEdit' entity-type='entityType' generic-entity = 'genericEntity' associations='formattedSecurityAssociations' associations-loaded='associationsLoaded'>
		 </cv-security-component>
		 
		<cv-tile-component data-ac-id="snapArrayDetails-label_general-snapArray" data-title='<cv:msg key="label.arrayAccessNodes" bundle="snapArray" />' loader="generalTab">
			<div class="page-details-box-links">
				<a href="" data-ng-click="editSnapArrayMAs(isConfigAvailable)">
					<cv:msg key="action.edit" bundle="snapArray" />
				</a>
			</div>
			<p data-ng-if="!snapDetails.selectedMAs || snapDetails.selectedMAs.length === 0" class="info-place-holder center"><cv:msg key="error.noArrayAcessNodes" bundle="snapArray" /></p>
			<div data-ng-if="snapDetails.selectedMAs.length > 0" class="arrayControllers extendedWidth noTop">
				<ul class="list-style-secondary">
					<li class="group">
						<span class="controllers-heading principalTitle">
							<b><cv:msg key="label.Name" bundle="snapArray" /></b>
						</span>
						<span class="controllers-heading">
							<b><cv:msg key="label.pruning" bundle="snapArray" /></b>
						</span>
					</li>
				</ul>
				<ul class="list-style-secondary selectedMas-list">
					<li class="group" data-ng-repeat="elem in snapDetails.selectedMAs">
						<span title="{{elem.name}}">
							<svg class="mediaAgent-type" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
								<path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"
								/>
							</svg>
							{{elem.mediaAgent.name}}
						</span>
						<span class="controllers-content" title="Prunning">{{elem.arrCtrlOptions[0].isEnabled | userEnabled}} </span>
					</li>
				</ul>
			</div>
		</cv-tile-component>
	</div>
	<div class="col-md-6"  data-ng-if="arrayType != 1">
		<cv-tile-component data-ac-id="snapArrayDetails-label_snapConfigurations-snapArray" data-title='<cv:msg key="label.snapConfigurations" bundle="snapArray"/>' loader="configTab">
			<div class="page-details-box-links" data-ng-if="showSnapConfigEditButton">
				<a href="" data-ng-click="editSnapArrayConfig(isConfigAvailable)"><cv:msg key="action.edit" bundle="snapArray" />
				</a>
			</div>
			<span data-ng-if="showSnapConfigEditButton === false">
				<p class="info-place-holder center"><cv:msg key="label.noSnapConfigurations" bundle="snapArray" /></p>
			</span>
			<ul class="list-style-secondary snapArrayDetailsList" data-ng-class="{greaterListStyle: greaterList}" >
				<li class="group" data-ng-repeat="elem in snapConfForm" data-ng-if="elem.showInGeneralTab === false">
					<span class="snapDetailColumn head">{{elem.label}}</span>
					<span data-ng-if="elem.type === 'checkbox'" class="snapDetailColumn body ">{{elem.value | userEnabled}} </span>
					<span data-ng-if="elem.type === 'list'" class="snapDetailColumn arrayHostList">
						<ul>
							<li data-ng-repeat="elem in elem.hostConfigList track by $index"><span>{{elem.name}}</span></li>
						</ul>
					</span>
					<span data-ng-if="elem.type !== 'checkbox' && elem.type !== 'list'" class="snapDetailColumn body">{{((elem.value) ? elem.value : '')}} </span>
				</li>
			</ul>
		</cv-tile-component>
	</div>
</div>
<%-- <div>
	<cv-grid cv-grid-options="snapArrayDetailsGridOptions"></cv-grid>
</div> --%>
