<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
    <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-10 col-md-8 col-xs-offset-1 col-md-offset-2">
        
        <div class="setup-title">
            <h1><cv:msg key="label.snapConfigurations" bundle="snapArray" /></h1>
        </div>
        <span class="help-block margin-left-0 padding-top-5">{{serverErrorMessage}}</span>
        <div class="setup-section">
            <div class="bootstrap-wrapper">
                <div class="form-horizontal">
                    <div class="createWizardMain">
                    
                    <%-- Show all snap configurations except configurations with flag SM_MASTERCONFIGS_FLAGS_SHOW_IN_GENERAL_TAB --%>
                    <div class="form-group" data-ng-repeat="elem in snapConfForm" data-ng-if="elem.showInGeneralTab === false" >
                        <div data-ng-if="elem.formType === 'checkbox'">
                            <label class="col-xs-12 col-md-8 col-lg-8" data-ng-attr-for="{{elem.label}}">
                                {{elem.label}}
                                <cv-help-component help-text="{{elem.description}}"></cv-help-component>
                            </label>
                            <div class="col-xs-12 col-md-4 col-lg-4 togleCheck" >
                                <toggle-control data-ng-attr-id="{{elem.masterConfigId}}" data-ng-class="elem.value ? 'enabled-activity disabled' : 'disabled-activity'" status="elem.value ? 'enabled-activity' : 'disabled-activity'"
                                        data-ng-click="changeBoolean($index)">
                                </toggle-control>
                            </div>
                        </div>
                        <div data-ng-if="elem.formType === 'input'">
                            <label class="col-xs-12 col-md-8 col-lg-8" data-ng-attr-for="{{elem.label}}">
                                {{elem.label}}
                                <cv-help-component help-text="{{elem.description}}"></cv-help-component>
                            </label>
                            <div class="col-xs-12 col-md-4 col-lg-4">
                                    <input class="full-width max-width-200 float-left" data-ng-attr-id="{{elem.masterConfigId}}" data-ng-attr-type="{{elem.type}}" name="snapConfigInput" data-ng-disabled="!elem.enabled"
                                    data-ng-model="elem.value" autofocus />
                            </div>
                        </div>
                        <div data-ng-if="elem.formType === 'password'">
                            <label class="col-xs-12 col-md-8 col-lg-8" data-ng-attr-for="{{elem.label}}">
                                {{elem.label}}
                                <cv-help-component help-text="{{elem.description}}"></cv-help-component>
                            </label>
                            <div class="col-xs-12 col-md-4 col-lg-4">
                                    <input class="full-width max-width-200 float-left" data-ng-attr-id="{{elem.masterConfigId}}" data-ng-attr-type="{{elem.type}}" name="snapConfigInput" data-ng-disabled="!elem.enabled"
                                    data-ng-model="elem.userPswd.password" autofocus />
                            </div>
                        </div>
                        <div data-ng-if="elem.formType === 'list'">
                                <label for="AliasInput" class="col-xs-12 col-md-8 col-lg-8">{{elem.label}} <cv-help-component help-text="{{elem.description}}"></cv-help-component></label>
                                <div class="createListSnapArray col-xs-12 col-md-4 col-lg-4">
                                    <input data-ng-attr-id="{{elem.masterConfigId}}" class="max-width-200 float-left" type="text" name="snapConfigInput" data-ng-model="addAliasInput" autofocus />
                                    <button id="createSnapArraySnapConf_button_#2799" type="button" data-ng-click="addAlias(addAliasInput)" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="label.add" bundle="snapArray" /></button> 
                                </div>
                            <div class="col-xs-12 col-md-12 col-lg-12">
                                <div>
                                        <ul data-ng-if="alliasArray.length > 0" class="users-list__user group users-list limit-modal-height col-md-8" >
                                        <li data-ng-repeat="elem in alliasArray track by $index">
                                            <span>{{elem}}</span>
                                            <a class="delete-allias" href="" data-ng-click="removeAlias($index)" title="Delete">&times;</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                        </div>
                    
                    <div class="button-container no-margin text-center">
                        <button id="createSnapArraySnapConf_button_#9544" type="button" data-ng-click="goPreviousStep()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.back" bundle="snapArray" /></button> 
                        <button id="createSnapArraySnapConf_button_#5933" type="button" data-ng-click="saveGeneralTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="action.save" bundle="snapArray" /></button> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>