<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
    <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-10 col-md-6 col-xs-offset-1 col-md-offset-3">
        <div class="setup-title">
            <h1><cv:msg key="label.general" bundle="snapArray" /></h1>
        </div>
        <div class="setup-section">
            <div class="bootstrap-wrapper">
                <div class="form-horizontal">
                    <div class="createWizardMain createSnapArray">
                        <div class="form-group">
                            <label for="vendorInput" class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="label.snapEngineIdName" bundle="snapArray"/>
                            </label>
                            <div class="col-xs-12 col-md-8 col-lg-8">
                                <select data-ng-disabled="action=='editArray'" name="vendorInput" id="vendorInput"
                                        data-ng-options="vendor as vendor.vendor.name for vendor in arrayVendors | orderBy:'vendor.name'"
                                        data-ng-model="arrayVendor" required
                                        data-ng-readonly="arrayInfo.snapEngineIdName.id != 0"
                                        data-ng-class="{'has-error': cv.addSnapForm.needsAttention(addSnapForm.vendor)}" data-ng-change="changeVendor(arrayVendor)" >
                                </select>
                                <span class="help-block padding-top-5">{{errorMessage.vendor}}</span>
                                <span class="help-block" data-ng-show="cv.addSnapForm.needsAttention(addSnapForm.vendor)"><cv:msg key="error.vendor" bundle="snapArray"/></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-xs-12 col-md-4 col-lg-4" for="arrayNameInput" data-ng-bind="arrayNameLabel"></label>
                            <div class="col-xs-12 col-md-8 col-lg-8">
                                <input id="arrayNameInput" type="text" name="arrayNameInput" data-ng-model="arrayName" data-ng-change="changeArrayName(arrayName)" autofocus />
                                <span class="help-block padding-top-5">{{errorMessage.name}}</span>           
                            </div>
                        </div>
                        <div class="form-group" data-ng-if="arrayVendor.capabilities.enableControlHost">
                            <label class="col-xs-12 col-md-4 col-lg-4" for="arrayHostInput" data-ng-bind="arrayHostNameLabel"></label>
                            <div class="col-xs-12 col-md-8 col-lg-8">
                                <input id="arrayHostInput" type="text" name="arrayHostInput" data-ng-model="mountHostName" data-ng-change="changeHost(mountHostName)" autofocus />
                                <div class="error serverMessage">{{errorMessage.host}}</div>                            
                            </div>
                        </div>
                        <div class="form-group" data-ng-repeat="elem in snapConfForm" data-ng-if="elem.showInGeneralTab">
                            <div data-ng-if="elem.formType === 'input'">
                                <label class="col-xs-12 col-md-4 col-lg-4" for="{{elem.label}}" data-ng-bind="elem.label"></label>
                                <div class="col-xs-12 col-md-8 col-lg-8">
                                    <input id="{{elem.masterConfigId}}" type="text" name="snapConfigInput" data-ng-model="elem.value" autofocus />
                                </div>
                            </div>
                            <div data-ng-if="elem.formType === 'password'">
                                <label class="col-xs-12 col-md-4 col-lg-4" for="{{elem.label}}" data-ng-bind="elem.label"></label>
                                <div class="col-xs-12 col-md-8 col-lg-8">
                                    <input id="{{elem.masterConfigId}}" type="password" name="snapConfigInput" data-ng-model="elem.userPswd.password" autofocus />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="credentials-snap-arrays">
                        <div>
                            <h4 class="text-align-left padding-top-20"><span><cv:msg key="label.credentials" bundle="vmManagement"/></span></h4>
                            <label>
                                <toggle-control status="switchToCM" data-ng-click="toggleCredentialType()"></toggle-control>
                                <span><cv:msg key="label.useSavedCred" bundle="storage"/></span>
                            </label>
                        </div>
                        <div class="margin-left-50" data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, 'add-collection-form form-group panel-body no-padding' : showSwitchToCM }" data-ng-if="showCredentialDropDown">
                            <div>
                                <label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="credential"><cv:msg key="Name" bundle="storage"/></label>
                                <div class="col-xs-9 col-md-9 col-lg-9 snap-array-credential-containar padding-right-30">
                                    <select-with-create-button
                                        select-id="credential"
                                        select-name="credential"
                                        key-label="credentialName"
                                        key-id="credentialId"
                                        option-list="savedCredentials"
                                        selected-option="selectCredentialData.credential"
                                        on-click-create-button="openCreateCredentialModal"
                                        on-change-option="onChangeCredential"
                                        is-required="true"
                                        has-error="cv.addCollectionForm.needsAttention(addCollectionForm.credential)"
                                        class="no-float-auto tile-large-width"
                                        placeholder='<cv:msg key="placeholder.credential" bundle="snapArray"/>'
                                        edit-disabled="selectCredentialData.credential === null"
                                        on-click-edit-button="openEditCredentialModal"
                                        is-credential="true">
                                    </select-with-create-button>
                                    <span class="help-block padding-top-5" data-ng-show="emptyCredential"><cv:msg key="error.credentialDropdown.required" bundle="snapArray"/></span>
                                </div>
                            </div>
                        </div>
                        <div class="margin-left-50" data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, ' add-collection-form form-group panel-body no-padding' : showSwitchToCM }" data-ng-if="!showCredentialDropDown">
                            <div>
                                <label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="userName"><cv:msg key="User Name" bundle="storage" /></label>
                                <div class="col-xs-9 col-md-9 col-lg-9 create-snap-array-username">
                                    <input type="text" class="network-path" name="userName" id="userName" data-ng-model="userName" data-ng-change="changeUsername(userName)" autofocus />
                                    <span class="help-block padding-top-5" data-ng-show="emptyUserName"><cv:msg key="error.loginName.required" bundle="storage"/></span>
                                </div>
                            </div>
                            <div>
                                <label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="password"><cv:msg key="Password" bundle="storage" /></label>
                                <div class="col-xs-9 col-md-9 col-lg-9 create-snap-array-password">
                                    <input type=password class="network-path" name="password" id="password" data-ng-model="password" data-ng-change="changePassword(password)" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="button-container no-margin text-center">
                        <button id="createSnapArrayGeneralTemplate_button_#8855" type="button" data-ng-click="nextGeneralTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="action.next" bundle="snapArray" /></button> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>