<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script>
    <cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-xs-10 col-md-6 col-xs-offset-1 col-md-offset-3">
        <div class="setup-title">
            <h1><cv:msg key="label.arrayAccessNodes" bundle="snapArray" /></h1>
        </div>
        <span class="help-block margin-left-0 padding-top-5">{{serverErrorMessage}}</span>
        <div class="setup-section">
            <div class="bootstrap-wrapper">
                <div class="form-horizontal" >
                    <div class="createWizardMain">
                        
                        <div class="form-group">
                            <label for="vendorInput" class="col-xs-12 col-md-4 col-lg-4">
                                <cv:msg key="label.availableMediaAgents" bundle="snapArray" />
                            </label>
                            <div class="col-xs-12 col-md-8 col-lg-8">
                                <isteven-multi-select id="ArrayControllers" name="ArrayControllers" input-model="availableControllers"
                                    output-model="addedControllers" button-label="name" item-label="name" tick-property="ticked" class="isteven-multi-select user-group-select"
                                    title="{{selectedSnapControllers}}" helper-elements="reset filter" disable-property="disabled" hide-search-button="true" search-limit="10"
                                    on-item-click="arrayControllerSelection()" on-select-none="arrayControllerSelection()" on-select-all="arrayControllerSelection()"
                                    on-reset="arrayControllerSelection()"
                                    search-property="name">
                                </isteven-multi-select>
                            </div>
                        </div>
                        <div class="form-group" ng-if="addedControllers.length > 0">
                            <label for="vendorInput" class="col-xs-12 col-md-12 col-lg-12">
                                <cv:msg key="label.arrayAccessNodes" bundle="snapArray" />
                            </label>
                            <div class="arrayControllers extendedWidth noTop col-xs-12 col-md-12 col-lg-12">
                                <ul class="list-style-secondary">
                                    <li class="group">
                                        <span class="principalTitle">
                                            <b><cv:msg key="label.Name" bundle="snapArray" /></b>
                                        </span>
                                        <span data-ng-repeat="elem in controllerOptions">
                                            <b>{{elem.arrCtrlOption.name}}</b>
                                        </span>
                                    </li>
                                </ul>
                                <ul class="list-style-secondary selectedMas-list" >
                                    <li class="group" data-ng-repeat="elem in addedControllers" ng-init="parentIndex = $index">
                                        <span title="{{elem.name}}">
                                            <svg class="mediaAgent-type" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
                                                <path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"
                                                />
                                            </svg>
                                            {{elem.mediaAgent.name}}
                                        </span>
                                        
                                        <span class="controllers-content" data-ng-repeat="elem2 in controllersValues[parentIndex]">
                                            <toggle-control data-ng-class="elem2.isEnabled ? 'enabled-activity' : 'disabled-activity'" status="elem2.isEnabled ? 'enabled-activity'
                                            : 'disabled-activity'" data-ng-click="changePrunning(parentIndex,$index)">
                                            </toggle-control>
                                        </span>
                                        <span class="delete-controller">
                                            <a class="delete-allias" href="" data-ng-click="removeController($index)" title="Delete">&times;</a>
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="button-container no-margin text-center">
                        <button id="createSnapArrayControllers_button_#7833" type="button" data-ng-click="goPreviousStep()" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.back" bundle="snapArray" /></button> 
                        <button id="createSnapArrayControllers_button_#7107" data-ng-if="steps.length > 2" type="button" data-ng-click="nextGeneralTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="action.next" bundle="snapArray" /></button> 
                        <button id="createSnapArrayControllers_button_#4308" data-ng-if="steps.length === 2" type="button" data-ng-click="saveGeneralTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="action.save" bundle="snapArray" /></button> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>