<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.snapArray"></cv:cvMessages>
</script>
<div data-ng-controller="addArrayController as aac">
<div class="setup-title">
	<h1 data-ng-if="action ==='editArray'"><cv:msg key="label.editSnapGeneral" bundle="snapArray" /></h1>
	<h1 data-ng-if="action ==='editArrayConfig'"><cv:msg key="label.editSnapConfigurations" bundle="snapArray" /></h1>
	<h1 data-ng-if="action ==='editArrayMAs'"><cv:msg key="label.editArrayAccessNodes" bundle="snapArray" /></h1>
		
</div>
<span class="help-block padding-top-10 margin-left-0 text-align-center">{{serverErrorMessage}}</span>
<div class="setup-content schedule remove-top-padding">
<form name="addSnapForm" novalidate autocomplete="off">
	<span class="server-message {{aac.serverMessage.type}} padding-bottom-0" data-ng-bind="aac.serverMessage.message"></span>
	<div>
		<div class="no-top-margin"  data-ng-if="action ==='editArray'">
			<label for="vendor" class="select-label"><cv:msg key="label.snapEngineIdName" bundle="snapArray"/>
				<select data-ng-disabled="action=='editArray'" name="vendor" id="vendor"
					data-ng-options="vendor as vendor.name for vendor in aac.arrayVendors | orderBy:'vendor.name'"
					data-ng-model="aac.arrayInfo.vendor"
					data-ng-class="{'has-error': cv.addSnapForm.needsAttention(addSnapForm.vendor)}" data-ng-change="aac.changeConfigurations()" data-ng-readonly="aac.arrayInfo.snapEngineIdName.id != 0">
				</select>
				
				<span class="help-block" data-ng-show="cv.addSnapForm.needsAttention(addSnapForm.vendor)"><cv:msg key="error.vendor" bundle="snapArray"/></span>
			</label>
			<label for="arrayName">{{aac.arrayNameLabel}}
				<input data-ng-disabled="action=='editArray'" type="text" id="arrayName" name="arrayName" data-ng-model="aac.arrayInfo.array.name"
					data-ng-class="{'has-error': cv.addSnapForm.needsAttention(addSnapForm.arrayName)}" />
				<span class="help-block" data-ng-show="cv.addSnapForm.needsAttention(addSnapForm.arrayName)"><cv:msg key="error.arrayName" bundle="snapArray"/></span>
			</label>
			<label for="hostname" data-ng-if="aac.hostName !== null">
				{{aac.arrayHostNameLabel}}
				<input type="text" name="hostName" id="hostName" data-ng-model="aac.hostName" />
			</label>
			<div data-ng-repeat="elem in aac.snapConfForm" data-ng-if="elem.showInGeneralTab">
				<div data-ng-if="elem.formType === 'input'">
					<label for="snapConfigInput">
						{{elem.label}}
						<input type="text"  name="snapConfigInput" id="{{elem.masterConfigId}}" data-ng-model="elem.value" />
					</label>
				</div>
				<div data-ng-if="elem.formType === 'password'">
					<label for="snapConfigInput">
						{{elem.label}}
						<input type="password"  name="snapConfigInput" id="{{elem.masterConfigId}}" data-ng-model="elem.value" />
					</label>
				</div> 				 
			</div>
			<div class="snap-array-regions-container" data-ng-if="isNetApp">
				<label class="col-xs-4 col-md-4 col-lg-4 padding-left-0 margin-right-25" for="regions">{{aac.regionLabel}}</label>
				<isteven-multi-select 
					id="configureRegionForServer_isteven-multi-select_#6302"
					input-model="regionList"
					output-model="selectedRegion"
					button-label="name"
					item-label="name"
					tick-property="selected"
					class="isteven-multi-select col-xs-8 col-md-8 col-lg-8 padding-right-20"
					helper-elements="none"
					selection-mode="single"
					group-property="msGroup"
					on-item-click="selectedRegionValue()"
				> 
				</isteven-multi-select>
			</div>
			<div class="credentials-snap-arrays">
				<div>
					<h4 class="text-align-left padding-top-20"><span><cv:msg key="label.credentials" bundle="vmManagement"/></span></h4>
					<label>
						<toggle-control status="switchToCM" data-ng-click="toggleCredentialType()"></toggle-control>
						<span><cv:msg key="label.useSavedCred" bundle="storage"/></span>
					</label>
				</div>
				<div class="margin-left-50" data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, 'add-collection-form form-group panel-body no-padding' : showSwitchToCM }" data-ng-if="showCredentialDropDown">
					<div class="label-dropdown-credential-container">
						<label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="credential"><cv:msg key="Name" bundle="storage"/></label>
						<div class="col-xs-9 col-md-9 col-lg-9 snap-array-edit-container-credential">
							<select-with-create-button
								select-id="credential"
								select-name="credential"
								key-label="credentialName"
								key-id="credentialId"
								option-list="savedCredentials"
								selected-option="selectCredentialData.credential"
								on-click-create-button="openCreateCredentialModal"
								is-required="true"
								has-error="cv.addCollectionForm.needsAttention(addCollectionForm.credential)"
								class="no-float-auto tile-large-width"
								placeholder='<cv:msg key="placeholder.credential" bundle="snapArray"/>'
								edit-disabled="selectCredentialData.credential === null"
								on-click-edit-button="openEditCredentialModal"
								is-credential="true"
							>
							</select-with-create-button>
							<div class="emptyCredentialMessageContainer">
								<span class="help-block padding-top-10 credentialEmpty" data-ng-show="isCredentialEmpty"><cv:msg key="error.credentialDropdown.required" bundle="snapArray"/></span>
							</div>
						</div>
					</div>
				</div>
				<div class="margin-left-50" data-ng-class="{'add-collection-form form-group' : !showSwitchToCM, ' add-collection-form form-group panel-body no-padding' : showSwitchToCM }" data-ng-if="!showCredentialDropDown">
					<div class="display-flex-cm-inputs">
						<label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="userName"><cv:msg key="User Name" bundle="storage" /></label>
						<div class="col-xs-9 padding-right-20 snap-array-edit-container-userName">
							<input type="text"  name="userName" id="userName" data-ng-model="aac.currentUserName"/>
							<span class="help-block padding-top-5 margin-left-0 text-align-left" data-ng-if="isUserNameRequired">{{aac.userNameError}}</span>
						</div>
					</div>
					<div class="display-flex-cm-inputs">
						<label class="col-xs-3 col-md-3 col-lg-3 padding-0" for="password"><cv:msg key="Password" bundle="storage" /></label>
						<div class="col-xs-9 padding-right-20 snap-array-edit-container-password">
							<input type="password" name="password" id="password" data-ng-model="aac.currentPass" />
						</div>
					</div>
			</div>
			</div>
		</div>
		<div data-ng-if="action ==='editArrayConfig'" class="snapDetailWindow">
				<div class="snapDetailWindow"  >
					
					<div class="modal-wrapper line-height-1" data-ng-repeat="elem in aac.snapConfForm track by $index" data-ng-if="elem.showInGeneralTab === false">
						
						<div class="snapDetailDivision detailsList" data-ng-if="elem.formType === 'checkbox'">
							<label class="snapDetailColumn label" data-ng-attr-for="{{elem.label}}">{{elem.label}}</label>
							<div class="snapDetailColumn body checkboxDiv" >
								<toggle-control data-ng-attr-id="{{elem.masterConfigId}}" data-ng-class="elem.value ? 'enabled-activity disabled' : 'disabled-activity'" status="elem.value ? 'enabled-activity' : 'disabled-activity'"
								data-ng-click="aac.changeBoolean($index)">
								</toggle-control>
							</div>
						</div>
						<div class="snapDetailDivision" data-ng-if="elem.formType === 'input'">
							<label class="snapDetailColumn label" data-ng-attr-for="{{elem.label}}">{{elem.label}}</label>
							<div class="snapDetailColumn body">
								<input data-ng-attr-id="{{elem.masterConfigId}}" data-ng-attr-type="{{elem.type}}" name="snapConfigInput" data-ng-disabled="!elem.enabled"
								 data-ng-model="elem.value" autofocus />
							</div>
						</div>
						
						
						<div class="snapDetailDivision" class="form-group" data-ng-if="elem.formType === 'password'">
							<label class="snapDetailColumn label" data-ng-attr-for="{{elem.label}}">{{elem.label}}</label>
							<div class="snapDetailColumn body">
								<input data-ng-attr-id="{{elem.masterConfigId}}" data-ng-attr-type="{{elem.type}}" name="snapConfigInput" data-ng-disabled="!elem.enabled"
								 data-ng-model="elem.value" autofocus />
							</div>						
						</div>
						<div  class="snapDetailDivision" data-ng-if="elem.formType === 'list'">
							<label class="label" data-ng-attr-for="{{elem.label}}">{{elem.label}}</label>
							<div class="snapDetailColumn body createListSnapArray"> 
								<input data-ng-attr-id="{{elem.masterConfigId}}" type="text" name="snapConfigInput"
								 data-ng-disabled="!elem.enabled" data-ng-model="aac.hostInputList[$index]" autofocus />
								<button id="addSnapArray_button_#7040" type="button" data-ng-click="aac.addHost(aac.hostInputList[$index], elem.id, $index)" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"><cv:msg key="label.add" bundle="snapArray" /></button>
							</div>
							<div class="form-group arrayHostList margin-top-20" class="col-md-8">
								<ul data-ng-if="elem.hostConfigList.length > 0">
									<li data-ng-repeat="el in elem.hostConfigList track by $index">
											<span>{{el.name}}</span>
											<a class="delete-allias" href="" data-ng-click="aac.removeHost($index, elem.id)" title="Delete">&times;</a>
									</li>
								</ul>
							</div>
						</div>
						
					</div>
				</div>
			<!-- </uib-accordion> -->
		</div>
			<div data-ng-if="action ==='editArrayMAs' && aac.availableControllers.length > 0" class="snapDetailWindowEdit margin-top-30">
				
				<isteven-multi-select id="ArrayControllers" name="ArrayControllers"
									input-model="aac.availableControllers"
									output-model="aac.addedControllers"
									button-label="name" item-label="name" tick-property="ticked"
									class="isteven-multi-select user-group-select"
									helper-elements="reset"
									disable-property="disabled"
									hide-search-button="true"
									search-limit="10"
									on-item-click="aac.arrayControllerSelection()"
									on-select-none="aac.arrayControllerSelection()"
									on-select-all="aac.arrayControllerSelection()"
									on-reset="aac.arrayControllerSelection()">
				</isteven-multi-select>
				
				<div>
					<div class="arrayControllers">
						<ul class="list-style-secondary">
							<li class="group">
								<span class="principalTitle">
									<b><cv:msg key="label.Name" bundle="snapArray" /></b>
								</span>
								<span data-ng-repeat="elem in aac.selectedVendor.arrCtrlopts">
									<b>{{elem.arrCtrlOption.name}}</b>
								</span>
								<span class="delete-controller"></span>
							</li>
						</ul>
						<ul class="list-style-secondary editSnapArrayDetails">
							<li class="group" data-ng-repeat="elem in aac.addedControllers" data-ng-init="parentIndex = $index">
								<span title="{{elem.name}}">
									<svg class="mediaAgent-type" xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 25 25">
										<path d="M11.3,18A6.3,6.3,0,0,1,17,11.7V1H2V24H15.5A6.3,6.3,0,0,1,11.3,18ZM4,4H15V5H4ZM4,6H15V7H4ZM4,8H15V9H4Zm6,12H8V18h2Zm11.8-2.4,1.1-.4a5.4,5.4,0,0,0-.9-2.2l-1.1.5-.7-.7.5-1.1a5.4,5.4,0,0,0-2.2-.9l-.4,1.1h-.9l-.4-1.1a5.4,5.4,0,0,0-2.2.9l.5,1.1-.7.7-1.1-.5a5.4,5.4,0,0,0-.9,2.2l1.1.4v.9l-1.1.4a5.4,5.4,0,0,0,.9,2.2l1.1-.5.7.7-.5,1.1a5.4,5.4,0,0,0,2.2.9l.4-1.1h.9l.4,1.1a5.4,5.4,0,0,0,2.2-.9l-.5-1.1.7-.7,1.1.5a5.4,5.4,0,0,0,.9-2.2l-1.1-.4Zm-4.2,2.9a2.5,2.5,0,1,1,2.5-2.5A2.5,2.5,0,0,1,17.6,20.4Zm1.6-2.5a1.6,1.6,0,1,1-1.6-1.6A1.6,1.6,0,0,1,19.2,17.9Z"/>
									</svg>
									{{elem.mediaAgent.name}}
								</span>
					
								<span data-ng-repeat="elem2 in aac.controllersValues[parentIndex]">
									<toggle-control data-ng-class="elem2.isEnabled ? 'enabled-activity' : 'disabled-activity'" status="elem2.isEnabled ? 'enabled-activity' : 'disabled-activity'"
									 data-ng-click="aac.changePrunning(parentIndex,$index)">
									</toggle-control>
								</span>
								<span class="delete-controller">
									<a class="delete-allias" href="" data-ng-click="aac.removeController($index)" title="Delete">&times;</a>
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>
	</div>
		<div class="button-container">
			<button id="addSnapArray_button_#1439" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="aac.cancel()"> 
				<cv:msg key="action.cancel" bundle="snapArray"/>
			</button>
			<button id="addSnapArray_button_#2641" class="btn btn-primary cvBusyOnAjax" data-ng-click="aac.addEditArray()"> 
				<cv:msg key="action.save" bundle="snapArray"/>
			</button>
		</div>
</form>
</div>
</div>