export const getArrayNameColumn = cvLoc => ({
	name: {
		title: cvLoc('label.Name'),
		searchField: 'arrayName.name',
		type: 'string',
		width: '40%',
		template: '<a href="\\#snapArray?arrayId=#:arrayName.id#">#:arrayName.name#</a>'
	}
});

export const getUserNameColumn = cvLoc => ({
	user: {
		type: 'string',
		width: '25%',
		searchField: 'user',
		title: cvLoc('label.UserName'),
		template: '<span class="crop" title="#:userPswd.userName#">#:userPswd.userName#</span>'
	}
});

export const getSnapVendorColumn = cvLoc => ({
	snapEngineIdName: {
		type: 'string',
		searchField: 'snapEngineIdName',
		width: '35%',
		title: cvLoc('label.snapEngineIdName'),
		template: '<span class="crop" title="#:vendor.name#">#:vendor.name#</span>'
	}
});

export const getActionsColumn = cvLoc => ({
	action: {
		title: cvLoc('label.actions'),
		type: 'string',
		template: `<div class="permittedActions"></div>`,
		disableViewFiltering: true,
		sortable: false,
		disableColumnFilter: true,
		width: '10%',
		attributes: {
			class: 'permitted-actions'
		}
	}
});

export const getSnapArrayColumnTemplate = ({ cvLoc }) => ({
	...getArrayNameColumn(cvLoc),
	...getUserNameColumn(cvLoc),
	...getSnapVendorColumn(cvLoc),
	...getActionsColumn(cvLoc)
});
