import { cvModuleSnapArrayModule } from 'common/js/modules';

cvModuleSnapArrayModule.service('snapArrayService', [
	'$http',
	function($http) {
		this.getAllArrays = function() {
			const request = $http.get(`proxy/StorageArrays`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteArray = function(arrayID) {
			const request = $http.delete(`proxy/StorageArrays/${arrayID}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getSnapArrayDetails = function(arrayID) {
			const request = $http.get(`proxy/StorageArrays/${arrayID}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.listSnaps = function(controlId) {
			return $http.post('getListOfVolumesOfSnap.do', {
				controlId: controlId
			});
		};

		this.createArray = function(data) {
			const request = $http.post(`proxy/StorageArrays`, data, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.editArrayInfo = function(data) {
			const request = $http.put(`proxy/StorageArrays`, data, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getArrayVendorList = function() {
			const request = $http.get(`proxy/StorageArrays/Vendors`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getMediaAgents = function() {
			return $http.get('mediaAgents.do');
		};

		this.getExistingServers = function(arrayId, associationType, snapEngineName) {
			return $http.get('getExistingServers.do', {
				params: {
					arrayId: arrayId,
					associationType: associationType,
					snapEngineName: snapEngineName
				}
			});
		};

		this.snapOperations = function(arrayInfo, operationId) {
			/*if (mountHostId === "") {
	  mountHostId = 0;
	  mountPath = "";
}*/

			return $http.post('snapOperations.do', {
				arrayInfoList: JSON.stringify(arrayInfo),
				operationId: operationId
			});
		};

		this.addExistingHypervisor = function(obj) {
			return $http.post('associateServers.do', obj);
		};

		this.getVendorConfig = function(vendorID) {
			const request = $http.get(`proxy/StorageArrays/Vendors/${vendorID}`, httpHeader['jsonDefaultHeader']);
			return request;
		};
	}
]);

export default cvModuleSnapArrayModule;
