export const getSouceClientNameColumn = cvLoc => ({
	souceClientName: {
		title: cvLoc('label.sourceClient'),
		searchField: 'souceClientName',
		type: 'string',
		width: '10%',
		template: '<div class="crop"><a href="\\#/nasClientDetails/#:sourceClientId#">#:souceClientName#</a></div>'
	}
});

export const getSourcePathColumn = cvLoc => ({
	sourcePath: {
		title: cvLoc('label.sourcePath'),
		searchField: 'sourcePath',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:sourcePath#">#:sourcePath#</span>'
	}
});

export const getMountHostNameColumn = cvLoc => ({
	mountHostName: {
		title: cvLoc('label.mountHost'),
		searchField: 'mountHostName',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:mountHostName#">#:mountHostName#</span>',
		hidden: true
	}
});

export const getMountPathColumn = cvLoc => ({
	mountPath: {
		title: cvLoc('label.mountPath'),
		searchField: 'mountPath',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:mountPath#">#:mountPath#</span>',
		hidden: true
	}
});

export const getAppTypeNameColumn = cvLoc => ({
	appTypeName: {
		title: cvLoc('label.applicationTypeName'),
		searchField: 'appTypeName',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:appTypeName#">#:appTypeName#</span>'
	}
});

export const getJobIdColumn = cvLoc => ({
	jobId: {
		title: cvLoc('label.jobId'),
		searchField: 'jobId',
		type: 'string',
		width: '10%',
		template: '<div class="crop"><a href="\\#/jobs/#:jobId#">#:jobId#</a></div>'
	}
});

export const getMountStatusNameColumn = cvLoc => ({
	mountStatusName: {
		title: cvLoc('label.mountStatus'),
		searchField: 'mountStatusName',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:mountStatusName#">#:mountStatusName#</span>'
	}
});

export const getMountStatusUpdateTimeColumn = cvLoc => ({
	mountStatusUpdateTime: {
		title: cvLoc('label.mountStatusUpdateTime'),
		searchField: 'mountStatusUpdateTime',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:mountStatusUpdateTime#">#:mountStatusUpdateTime#</span>'
	}
});

// export const getCreationTimeColumn = (cvLoc) => ({
//   "creationTime": {
//       title: cvLoc("label.creationTime"),
//       searchField: "creationTime",
//       type: "string",
//       width: "10%",
//       template: '<span class="crop" title="#:creationTime#">#:creationTime#</span>'
//   }
// });

export const getStoragePolicyColumn = cvLoc => ({
	storagePolicy: {
		title: cvLoc('label.storagePolicy'),
		searchField: 'spName',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:spName#">#:spName#</span>'
		// template: '<div class="crop"><a href="\\#/storagePolicyInfo?storagePolicyId=#:spName#">#:spName#</a></div>'
	}
});
export const getStoragePolicyCopyColumn = cvLoc => ({
	storagePolicyCopy: {
		title: cvLoc('label.storagePolicyCopy'),
		searchField: 'copyName',
		type: 'string',
		width: '10%',
		template: '<span class="crop" title="#:copyName#">#:copyName#</span>'
	}
});

export const getActionsColumn = cvLoc => ({
	action: {
		title: cvLoc('label.actions'),
		type: 'string',
		template: `<div class="permittedActions"></div>`,
		disableViewFiltering: true,
		sortable: false,
		disableColumnFilter: true,
		width: '10%',
		attributes: {
			class: 'permitted-actions'
		}
	}
});

export const getListSnapsColumnTemplate = ({ cvLoc }) => ({
	...getSouceClientNameColumn(cvLoc),
	...getSourcePathColumn(cvLoc),
	...getMountHostNameColumn(cvLoc),
	...getMountPathColumn(cvLoc),
	...getAppTypeNameColumn(cvLoc),
	...getJobIdColumn(cvLoc),
	...getMountStatusNameColumn(cvLoc),
	// ...getMountStatusUpdateTimeColumn(cvLoc),
	// ...getCreationTimeColumn(cvLoc),
	...getStoragePolicyColumn(cvLoc),
	...getStoragePolicyCopyColumn(cvLoc),
	...getActionsColumn(cvLoc)
});
