import 'modules/snapArrays/js/controllers/snapArray.ctrl.js';
import 'modules/snapArrays/js/controllers/addsnapArray.ctrl.js';
import 'commonForAllAgents/js/controllers/pushInstallSoftware.ctrl.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'users/js/filters/users.filters.js';
import 'adminConsole/js/directives/acDirectives.js';
import 'vsa/js/controllers/addServerContent.ctrl.js';
import 'vsa/js/controllers/addServer.ctrl.js';
import 'vsa/js/controllers/addExistingServer.ctrl.js';
import 'modules/storage/js/controllers/storage.ctrl.js';

import { cvModuleSnapArrayModule } from 'common/js/modules';

var snapMod = cvModuleSnapArrayModule;
var snapControllers = {};

snapControllers.snapArrayDetailsController = [
	'sharedData',
	'$http',
	'snapArrayService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'securityFactory',
	'cvUtil',
	'MMSMAssocType',
	'$scope',
	'$location',
	'pushInstallSoftwareFactory',
	'editArrayFactory',
	function(
		sharedData,
		$http,
		snapArrayService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		securityFactory,
		cvUtil,
		MMSMAssocType,
		$scope,
		$location,
		pushInstallSoftwareFactory,
		editArrayFactory
	) {
		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.infrastructure'),
				link: '#nav/mInfrastructure'
			},
			{
				title: cvLoc('label.Arrays'),
				link: '#snapArrays'
			}
		]);
		$scope.isConfigAvailable = false;
		$scope.controlId = $stateParams['arrayId'];
		$scope.arrayName = null;
		//$scope.snapEngineId = $stateParams["snapEngineId"];
		//$scope.snapEngineName = $stateParams["snapEngineName"];
		$scope.arrayControllers = [];
		$scope.associatedExistingServersController = [];
		$scope.userName = '';
		$scope.hostName = '';
		$scope.arrayType = 0;
		$scope.arrayNameLabel = cvLoc('label.ArrayName');
		$scope.arrayHostNameLabel = cvLoc('label.hostName');
		$scope.arrayUserNameLabel = cvLoc('label.UserName');
		$scope.regionLabel = cvLoc('label.RegionName');
		$scope.credentialLabel = cvLoc('label.credential');
		$scope.regionNotSelected = cvLoc('value.regionNotSelected');
		$scope.showSnapConfigEditButton = false;

		sharedData.data = {
			controlId: $scope.controlId,
			arrayName: true,
			snapEngineIdName: {
				id: null,
				name: null
			}
		};

		$scope.entityType = 'ARRAY_ENTITY';
		$scope.entityType = $scope.entityType;

		$scope.genericEntity = {
			entityId: parseInt($scope.controlId)
		};
		$scope.genericEntity = $scope.genericEntity;

		$scope.getCount = function(count) {
			return count == undefined ? 0 : count;
		};

		$scope.addServer = function(clientId, clientName, installedAgents, useAgent) {
			var pushInstallParams = {
				clientId: clientId,
				clientName: clientName,
				installedAgents: installedAgents,
				useAgent: useAgent
			};
			pushInstallSoftwareFactory.openPushInstallDialog(pushInstallParams);
		};

		$scope.addHypervisor = function() {
			$modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/addServerContent.jsp',
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: 'addServerContent',
				resolve: {
					model: function() {
						return '';
					},
					loadServerList: function() {
						return '';
					}
				}
			});
		};

		$scope.addExistingServer = function() {
			$modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/addExistingServerContent.jsp',
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: [
					'$uibModalInstance',
					'$scope',
					'$window',
					function($modalInstance, $scope, $window) {
						$scope.cancel = function() {
							$modalInstance.dismiss();
						};
						$scope.$on('serverAdded', function(evt, serverId) {
							$log.debug('serverAdded....');
							$window.location.reload(true);
						});
					}
				]
			});
		};

		//    $scope.deassociateServerFromArray = function (clientId) {
		//        var callBackFunctions = {
		//            noFunction: function () { },
		//            yesFunction: function () {
		//                var clientList = [];
		//                clientList.push(clientId);
		//                var objToSend = {
		//                    'arrayId': parseInt($scope.controlId),
		//                    'clients': JSON.stringify(clientList),
		//                    'operation': false
		//                };
		//                snapArrayService.addExistingHypervisor(objToSend).success(function () {
		//                    $state.forceReload();
		//                }).error(function (e) {
		//                    $scope.addServerMessage = cvUtil.errMsg(e);
		//                });
		//            }
		//        };
		//        $dialogs.confirm(cvLoc('label.confirmDisassociate'), cvLoc('label.confirmDisassociateServer'), callBackFunctions);
		//    };

		$scope.arrayDetailsMessage = cvUtil.infoMsgLoc('Loading');
		$scope.arrayDetailsControllerMessage = cvUtil.infoMsgLoc('Loading');

		//    snapArrayService.getExistingServers($stateParams["arrayId"], "ASSOCIATED", $stateParams["snapEngineName"]).success(function (associatedExistingServersDatas) {
		//        $scope.associatedExistingServersDatas = associatedExistingServersDatas;
		//        $scope.associatedExistingServersDatas = associatedExistingServersDatas;
		//        if (associatedExistingServersDatas) {
		//            for (var i = 0; i < associatedExistingServersDatas.length; i++) {
		//                $scope.associatedExistingServersController.push({
		//                    'id': associatedExistingServersDatas[i].client.clientEntity.clientId,
		//                    'name': associatedExistingServersDatas[i].client.clientEntity.displayName,
		//                    'selected': true
		//                });
		//            }
		//            $scope.arrayDetailsControllerMessage = cvUtil.emptyMsg()
		//        } else {
		//            $scope.arrayDetailsControllerMessage.message = cvLoc("label.noServersAssociated");
		//        }
		//
		//        $scope.arrayDetailsMessage = cvUtil.emptyMsg();
		//    }).error(function (e) {
		//        $scope.arrayDetailsMessage = {
		//            message: e,
		//            type: 'error'
		//        };
		//    });

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'associatedExistingServersDatas',
			showGridFooter: true,
			enableGridMenu: false,
			columnDefs: [
				{
					field: 'client.clientEntity.displayName',
					sort: {
						direction: 'asc',
						priority: 0
					},
					displayName: cvLoc('label.Name'),
					enableHiding: false,
					cellTemplate:
						'<a data-ng-if="row.entity.client.idaList[0].idaEntity.applicationId === 106" class="crop" href="#servers/{{row.entity.client.clientEntity.clientId}}">{{row.entity.client.clientEntity.displayName}}</a>' +
						'<a data-ng-if="row.entity.client.idaList[0].idaEntity.applicationId !== 106" class="crop" href="#clientDetails/{{row.entity.client.clientEntity.clientId}}?clientGroupId=all&clientGroupName=Active servers">{{row.entity.client.clientEntity.clientName}}</a>',
					width: '90%'
				},
				{
					name: 'action',
					displayName: cvLoc('label.actions'),
					enableHiding: false,
					enableFiltering: false,
					enableSorting: false,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"><li><a href="" class="ui-grid-action-items" ng-click="grid.appScope.deassociateServerFromArray(row.entity.client.clientEntity.clientId)">' +
						cvLoc('label.disassociate') +
						'</div>'
				}
			]
		});

		$scope.snapArrayDetailsGridOptions = {
			cvPageLinks: [
				{
					label: cvLoc('action.associateServer'),
					subLinks: [
						{
							label: cvLoc('label.newHypervisor'),
							onclick: $scope.addHypervisor
						},
						{
							label: cvLoc('label.existingServer'),
							onclick: $scope.addExistingServer
						}
					]
				}
			],
			cvGridTitle: cvLoc('label.servers'),
			cvTableName: 'snapArrayServersTable',
			cvIsSearchable: false,
			cvServerMessage: 'arrayDetailsControllerMessage',
			cvAppScope: $scope,
			gridOptions: globalGridOptions
		};

		snapArrayService
			.getSnapArrayDetails($scope.controlId)
			.success(function(snapDetails) {
				// shared data to use in addSnapArray
				sharedData.hasSavedCredential = snapDetails.info.savedCredential.credentialId > 0;
				sharedData.savedCredentialFromBackend = snapDetails.info.savedCredential;
				sharedData.userPswdFromBackend = snapDetails.info.userPswd;
				sharedData.hasUserPswd = snapDetails.info.userPswd.userName ? true : false;
				sharedData.isNetApp = snapDetails.vendor.id === 3;
				sharedData.uniqueIdentifier = snapDetails.info.uniqueIdentifier;
				sharedData.arrayType = snapDetails.info.arrayType;

				$scope.isNetApp = sharedData.isNetApp;
				$scope.region = snapDetails.info.region;
				$scope.greaterList = snapDetails.selectedMAs && snapDetails.selectedMAs.length > 0;
				$scope.snapDetails = snapDetails;
				$scope.hasSavedCredential = sharedData.hasSavedCredential;
				$scope.savedCredentialFromBackend = sharedData.savedCredentialFromBackend;
				$scope.userName =
					snapDetails.info.userPswd && snapDetails.info.userPswd.userName ? snapDetails.info.userPswd.userName : '';
				$scope.hostName = snapDetails.info.ctrlHostName ? snapDetails.info.ctrlHostName : '';
				$scope.arrayType = snapDetails.info.arrayType;
				$scope.alliasArray = [];

				/* If backend sent some custom value for array name label */
				if ($scope.snapDetails.arrayNameLabel.length > 0) {
					$scope.arrayNameLabel = $scope.snapDetails.arrayNameLabel;
				} else {
					$scope.arrayNameLabel = cvLoc('label.ArrayName');
				}

				/* If backend sent some custom value for hostname (control host) label */
				if ($scope.snapDetails.arrayControlHostLabel.length > 0) {
					$scope.arrayHostNameLabel = $scope.snapDetails.arrayControlHostLabel;
				} else {
					$scope.arrayHostNameLabel = cvLoc('label.hostName');
				}

				/* If backend sent some custom value for username label */
				if ($scope.snapDetails.arrayUserNameLabel.length > 0) {
					$scope.arrayUserNameLabel = $scope.snapDetails.arrayUserNameLabel;
				} else {
					$scope.arrayUserNameLabel = cvLoc('label.userName');
				}

				$scope.snapConfForm = [];
				if ($scope.snapDetails.configList.configList) {
					$scope.snapDetails.configList.configList.map((configObject, index) => {
						const typeValue = $scope.getSnapTypeValue(configObject);
						let name = configObject.name.name;
						const firstLetter = name[0];
						name = firstLetter.toLowerCase() + name.slice(1);

						let finalDesc = '';

						if (configObject.notes !== '') {
							const desc = configObject.notes.replace(/<br\/>|<\/b>|<html>|<\/html>|<body>|<\/body>/g, '').split('<b>');

							finalDesc = desc[2] ? desc[2].split(':')[1] : '';

							if (typeValue.type !== 'list' && desc.length > 3) {
								finalDesc = finalDesc.toLowerCase().includes('default value') ? finalDesc : finalDesc + '. ' + desc[3];
								if (desc.length > 4) {
									finalDesc = finalDesc + '. ' + desc[4];
								}
							}
						}

						const finalName = configObject.name.name;

						const obj = {
							id: index,
							key: name.replace(/\s/g, ''),
							label: finalName,
							value: typeValue.value,
							type: typeValue.type,
							enabled: configObject.isEnabled,
							description: finalDesc,
							flags: configObject.flags,
							formType: $scope.getFormType(typeValue.type),
							showInGeneralTab:
								(configObject.flags & 64) == 64 /* SM_MASTERCONFIGS_FLAGS_SHOW_IN_GENERAL_TAB */ ? true : false,
							hostConfigList: $scope.alliasArray,
							masterConfigId: configObject.masterConfigId
						};
						$scope.snapConfForm.push(obj);

						if ((configObject.flags & 64) !== 64 /* SM_MASTERCONFIGS_FLAGS_SHOW_IN_GENERAL_TAB */)
							$scope.showSnapConfigEditButton = true;
					});
				}

				$scope.arrayDetailsMessage = cvUtil.emptyMsg();

				sharedData.data = $scope.snapDetails;
				sharedData.conf = $scope.snapConfForm;
				sharedData.list = $scope.alliasArray;
				$scope.configTab = true;
				$scope.generalTab = $scope.snapDetails.array.name;
				$scope.arrayName = $scope.snapDetails.array.name;
			})
			.error(function(e) {
				$scope.arrayDetailsMessage = cvUtil.errMsg(e);
			});

		$scope.getTypeFromNum = function(typeNumber) {
			switch (typeNumber) {
				case 0:
					return 'MMSM_CT_NONE';
				case 1:
					return 'MMSM_CT_BOOL';
				case 2:
					return 'MMSM_CT_INT';
				case 3:
					return 'MMSM_CT_UINT';
				case 4:
					return 'MMSM_CT_LONG';
				case 5:
					return 'MMSM_CT_ULONG';
				case 6:
					return 'MMSM_CT_LONGLONG';
				case 7:
					return 'MMSM_CT_ULONGLONG';
				case 8:
					return 'MMSM_CT_STRING';
				case 9:
					return 'MMSM_CT_IP_ADDR';
				case 10:
					return 'MMSM_CT_LIST';
				case 11:
					return 'MMSM_CT_COMBO';
				case 12:
					return 'MMSM_CT_PSWD';
				case 13:
					return 'MMSM_CT_ENC_STRING';
			}
		};
		$scope.getSnapTypeValue = function(complexType) {
			const elem = $scope.getTypeFromNum(complexType.type);
			const name = elem.toLowerCase();

			if (name.includes('enc_string')) {
				return { type: 'text', value: '' };
			} else if (name.includes('string')) {
				return { type: 'text', value: complexType.value };
			} else if (name.includes('bool')) {
				return { type: 'checkbox', value: complexType.value === 'true' };
			} else if (name.includes('int')) {
				return { type: 'number', value: Number(complexType.value) };
			} else if (name.includes('pswd')) {
				return { type: 'password', value: '*****' };
			} else if (name.includes('list')) {
				if (complexType.values) {
					$scope.alliasArray = complexType.values.map(elem => {
						return elem;
					});
				} else {
					$scope.alliasArray = [];
				}

				return { type: 'list', values: complexType.values ? complexType.values : [] };
			} else {
				return { type: '', value: '' };
			}
		};

		$scope.formattedSecurityAssociations = securityFactory.createSecurityAssociationsObject();
		$scope.associationsLoaded = false;

		securityFactory.getSecurityAssociation($scope.entityType, parseInt($scope.controlId)).success(function(data) {
			$scope.formattedSecurityAssociations = securityFactory.formatSecurityAssociationsObject(
				data.securityAssociations
			);
			$scope.associationsLoaded = true;
		});

		$scope.editSnapArray = function(config) {
			editArrayFactory.addOrEditArray($scope, $rootScope, $modal, cvLoc, config, 'editArray');
		};

		$scope.editSnapArrayConfig = function(config) {
			sharedData.data = _.cloneDeep($scope.snapDetails);
			sharedData.conf = _.cloneDeep($scope.snapConfForm);
			sharedData.list = _.cloneDeep($scope.alliasArray);
			editArrayFactory.addOrEditArray($scope, $rootScope, $modal, cvLoc, config, 'editArrayConfig');
		};
		$scope.editSnapArrayMAs = function(config) {
			editArrayFactory.addOrEditArray($scope, $rootScope, $modal, cvLoc, config, 'editArrayMAs');
		};
		$scope.deleteArray = () => {
			var callBackFunctions = {
				noFunction: () => {},
				yesFunction: () => {
					snapArrayService
						.deleteArray($scope.controlId)
						.success(function(data) {
							if (_.get(data, 'errorCode', 0) != 0) {
								$log.error('Delete Array failed');
								$dialogs.error(cvLoc('label.error'), data.errorMessage);
							} else {
								cvToaster.showSuccessMessage({
									ttl: '5000',
									message: cvLoc('info.deleteArraySuccess', '<b>' + $scope.arrayName + '</b>')
								});
								$location.url('/snapArrays');
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Array failed');
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmDeleteSnapArray', '<b>' + $scope.arrayName + '</b>'),
				callBackFunctions
			);
		};

		$scope.getFormType = function(elemType) {
			switch (elemType) {
				case 'checkbox':
					return 'checkbox';
				case 'list':
					return 'list';
				case 'password':
					return 'password';
				default:
					return 'input';
			}
		};
	}
];

snapMod.controller(snapControllers);

export default snapMod;
