import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'modules/storage/js/controllers/storage.ctrl.js';
import 'common/js/newGrid/cv-kendo-grid.js';

import { cvModuleSnapArrayModule } from 'common/js/modules';
import * as snapArrayColumnTemplates from '../snapArray.column.template';

var snapMod = cvModuleSnapArrayModule;
var snapControllers = {};

snapMod.constant('MMSMAssocType', {
	MMSM_AT_NONE: 0,
	MMSM_AT_TEMPL: 1,
	MMSM_AT_VENDOR: 2,
	MMSM_AT_ARRAY: 3,
	MMSM_AT_CTRL_HOST: 4,
	MMSM_AT_SUBCLT_POLICY: 5,
	MMSM_AT_COPY: 6,
	MMSM_AT_CLIENT_GROUP: 7,
	MMSM_AT_CLIENT: 8,
	MMSM_AT_SUBCLIENT: 9
});

snapMod.factory('sharedData', function() {
	var dataHolder = {};

	dataHolder.data = {
		destinationClientId: 0,
		destinationPath: '',
		preventSnapFlag: 0,
		snapEngineIdName: {
			id: 0,
			name: ''
		},
		controlHostId: 0,
		smVolumeId: 0,
		controlHost: '',
		mountHostName: '',
		mountHostId: 0,
		mountPath: '',
		controlId: 0,
		arrayName: '',
		smArrayId: '',
		userName: '',
		password: '',
		mountRetryInterval: -1,
		mountRetryCount: -1,
		hostGroup: false,
		useHost: false,
		diagLogging: false,
		remoteSnapMA: ''
	};
	dataHolder.selectedRows = [];

	return dataHolder;
});
snapMod.factory('editArrayFactory', [
	'cvLoc',
	'$state',
	'$dialogs',
	'$log',
	'$location',
	'cvToaster',
	'snapArrayService',
	function(cvLoc, $state, $dialogs, $log, $location, cvToaster, snapArrayService) {
		var factory = {};
		factory.addOrEditArray = function($scope, $rootScope, $modal, cvLoc, onlyConfig, action) {
			var self = this;
			$scope.action = action;
			$scope.onlyConfig = onlyConfig;
			self.entity = {};
			if (!self.entity) {
				self.entity = {
					arrayEntity: {
						arrayId: ''
					}
				};
			}
			var template = 'modules/snapArrays/partials/addSnapArray.jsp';
			if (action === 'mount') {
				template = 'modules/snapArrays/partials/snapMountDialog.jsp';
			}
			const region = $scope.region;
			$modal.open({
				templateUrl: appUtil.appRoot + template,
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: [
					'$uibModalInstance',
					'$log',
					'arrayInfo',
					'action',
					'$state',
					'cvLoc',
					'cvUtil',
					'$scope',
					function($modalInstance, $log, arrayInfo, action, $state, cvLoc, cvUtil, $scope) {
						var self = this;
						self.serverMessage = cvUtil.emptyMsg();
						$scope.action = action;
						self.oldarrayInfo = arrayInfo;
						self.arrayInfo = angular.copy(arrayInfo);
						$scope.onlyConfig = onlyConfig;
						$scope.region = region;
						$rootScope.$on('arrayAdded', function() {
							$log.debug('ArrayAdded....');
							$state.forceReload();
							$modalInstance.dismiss();
						});
						$rootScope.$on('arrayAddCancelled', function() {
							$log.debug('ArrayAddCancelled....');
							$modalInstance.dismiss();
						});
						$rootScope.$on('editArray', function() {
							$log.debug('editArray success received');
							$state.forceReload();
							$modalInstance.dismiss();
						});
						$rootScope.$on('editArrayFailed', function() {
							$log.debug('editArrayFailed....');
						});
						$rootScope.$on('snapMountOperation', function() {
							$log.debug('snapMountOperation....');
							$modalInstance.dismiss();
							$state.forceReload();
						});
						$rootScope.$on('snapMountOperationCancelled', function() {
							$log.debug('snapMountOperationCancelled....');
							$modalInstance.dismiss();
							$state.forceReload();
						});
					}
				],
				resolve: {
					arrayInfo: function() {
						return self.entity;
					},
					action: function() {
						return $scope.action;
					}
				}
			});
		};

		factory.getActions = function(entity) {
			const arrayOfActions = [
				{
					show: true,
					value: 'DELETE',
					label: cvLoc('action.delete'),
					onClick: () => deleteArray(entity.arrayName)
				},
				{
					show: true,
					value: 'LIST_SNAPSHOT',
					label: cvLoc('action.listSnaps'),
					onClick: () => $state.go('listSnaps', { controlId: entity.arrayName.id })
				}
			];
			return arrayOfActions;
		};

		var deleteArray = function(array) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					snapArrayService
						.deleteArray(array.id)
						.success(function(data) {
							if (_.get(data, 'errorCode', 0) != 0) {
								$log.error('Delete Array failed');
								$dialogs.error(cvLoc('label.error'), data.errorMessage);
							} else {
								cvToaster.showSuccessMessage({
									ttl: '5000',
									message: cvLoc('info.deleteArraySuccess', '<b>' + array.name + '</b>')
								});
								$state.reload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Array failed');
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				`${cvLoc('label.confirmMessageDeleteSnapArray')}<br>
				${cvLoc('label.confirmDeleteSnapArray', '<b>' + array.name + '</b>')}`,
				callBackFunctions
			);
		};

		factory.goToCreateSnapArray = function() {
			$location.url('/createSnapArray');
		};

		return factory;
	}
]);

snapControllers.snapArrayController = [
	'sharedData',
	'$http',
	'snapArrayService',
	'$rootScope',
	'$uibModal',
	'$stateParams',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'cvGridSearchFactory',
	'userPrefService',
	'MMSMAssocType',
	'$scope',
	'editArrayFactory',
	'cvBreadcrumbsTabsFactory',
	'cvToaster',
	'$compile',
	function(
		sharedData,
		$http,
		snapArrayService,
		$rootScope,
		$modal,
		$stateParams,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		cvGridSearchFactory,
		userPrefService,
		MMSMAssocType,
		$scope,
		editArrayFactory,
		cvBreadcrumbsTabsFactory,
		cvToaster,
		$compile
	) {
		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.infrastructure'),
				link: '#nav/mInfrastructure'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		_setupBreadCrumbs();

		$scope.highlightFilteredHeader = function(row, rowRenderIndex, col, colRenderIndex) {
			if (col.filters[0].term) {
				return 'header-filtered';
			} else {
				return '';
			}
		};
		$scope.snapArrayMessage = cvUtil.infoMsgLoc('Loading...');

		const fetchSnapArrayData = options => {
			return snapArrayService
				.getAllArrays()
				.success(function(data) {
					$scope.snapArrayMessage = {
						message: cvLoc('Loading'),
						type: 'ok'
					};
					if (!data.error || data.error.errorCode === 0) {
						$scope.snapArrayMessage = cvUtil.emptyMsg();
						$scope.arrays = data.arrayList && data.arrayList.length > 0 ? data.arrayList : [];
						$scope.arrays.forEach(item => {
							item.permittedOptions = {
								entityId: item.arrayName.id,
								entityName: item.arrayName.name,
								entity: angular.copy(item),
								appendToBody: true,
								permittedActionList: editArrayFactory.getActions(item)
							};
						});
						options.success($scope.arrays);
					} else {
						$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
						options.error(data.error);
					}
				})
				.error(function(e) {
					$scope.snapArrayMessage = cvUtil.errMsg(e);
					options.error(data.error);
				});
		};
		const initSCGrid = function() {
			setupGridOptions();
			// self.setupGridActionMenus();
			// self.setupGridToolbarMenu();
		};

		const setupGridOptions = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			gridOptions.gridTitle = cvLoc('label.Arrays');
			gridOptions.tableName = 'snapArrayTable';
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.url = fetchSnapArrayData.bind(this);
			gridOptions.usePageToolbar = true;
			gridOptions.onGridDataBound = _onGridDataBound.bind(this);
			gridOptions.hasViews = false;
			gridOptions.enablePaging = true;
			gridOptions.pageSize = 20;
			gridOptions.pageSizes = [5, 10, 20, 50, 100];
			gridOptions.sortDirection = {
				field: 'arrayName.name',
				dir: 'asc'
			};
			gridOptions.gridToolbarMenu = [
				{
					id: 'AddSnapArray',
					disableOnDeselect: false,
					label: cvLoc('action.add'),
					onSelect: () => {
						editArrayFactory.goToCreateSnapArray();
					}
				}
			];

			gridOptions.gridEmptyMessage = '<div class="text-align-center">' + cvLoc('label.noArrays') + '</div>';
			gridOptions.gridEmptySvg =
				'<svg data-cv-on-grid-empty class="add-new-placeholder" version="1.1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M139.9,44H20.1A5,5,0,0,0,15,48.9V69.1A5,5,0,0,0,20.1,74H139.9a5,5,0,0,0,5.1-4.9V48.9A5,5,0,0,0,139.9,44ZM80,61.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,62.8Z"/><path d="M139.9,79H20.1A5,5,0,0,0,15,83.9v20.2a5,5,0,0,0,5.1,4.9H139.9a5,5,0,0,0,5.1-4.9V83.9A5,5,0,0,0,139.9,79ZM80,96.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,97.8Z"/><path d="M139.9,114H20.1a5,5,0,0,0-5.1,4.9v20.2a5,5,0,0,0,5.1,4.9H139.9a5,5,0,0,0,5.1-4.9V118.9A5,5,0,0,0,139.9,114ZM80,131.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,132.8Z"/><path d="M90,162H83V149H77v13H70a5,5,0,0,0-5,5H15v5H65a5,5,0,0,0,5,5H90a5,5,0,0,0,5-5h50v-5H95A5,5,0,0,0,90,162Zm1,10a1,1,0,0,1-1,1H70a1,1,0,0,1-1-1v-5a1,1,0,0,1,1-1H90a1,1,0,0,1,1,1v5Z"/></svg>';
			$scope.snapArrayGridOptions = gridOptions;
		};
		const _onGridDataBound = (dataItem, row) => {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)($scope));
		};

		const initColumnDefs = function() {
			return snapArrayColumnTemplates.getSnapArrayColumnTemplate({ cvLoc: cvLoc });
		};

		initSCGrid();

		$scope.addSnapArray = function() {
			editArrayFactory.addOrEditArray($scope, $rootScope, $modal, cvLoc, false, 'newArray');
		};

		//	$scope.planType = 'SNAP';

		/*
		 * profileService.getProfiles($scope.planType, true, 'snap').success(function (snapPlansDatas) { if
		 * (!snapPlansDatas.error || (snapPlansDatas.error.errorCode === 0)) { $scope.addServerMessage =
		 * cvUtil.emptyMsg(); $scope.allSnapPlans = snapPlansDatas.map(function (data) { return { value:
		 * data.planSummary.plan.planId, planName: data.planSummary.plan.planName, ticked: false }; });
		 * $scope.allSnapPlans = cvUtil.sortAscending($scope.allSnapPlans, 'planName'); } else {
		 * $dialogs.error(cvLoc('label.error'), data.error.errorMessage); }
		 *
		 * });
		 */
		//	$scope.createSnapPlan = function () {
		//		var modalInstance = $modal.open({
		//			templateUrl: appUtil.appRoot + 'dlo/partials/addSnapPlan.jsp',
		//			backdrop: 'static',
		//			controller: ['$scope', '$log', '$uibModalInstance', '$state', 'cvLoc', '$stateParams', 'cvUtil', '$location', '$rootScope', function ($scope, $log, $modalInstance, $state, cvLoc, $stateParams, cvUtil, $location, $rootScope) {
		//
		//				$scope.cancel = function () {
		//					$modalInstance.dismiss();
		//				};
		//
		//				$scope.planSubType = 'Snap';
		//
		//				$rootScope.$on("planAdded", function (evt, data) {
		//					$location.path('/profileDetails/' + data.profile.summary.plan.planId);
		//					$modalInstance.dismiss();
		//				});
		//			}]
		//		});
		//	};
	}
];

snapMod.controller(snapControllers);

export default snapMod;
