import 'modules/snapArrays/js/controllers/snapArray.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'adminConsole/js/controllers/security.ctrl.js';
import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'modules/storage/js/controllers/storage.ctrl.js';
import 'common/js/newGrid/cv-kendo-grid.js';

import { cvModuleSnapArrayModule } from 'common/js/modules';
import * as listSnapsColumnTemplates from '../listSnaps.column.template';

var snapMod = cvModuleSnapArrayModule;
var snapControllers = {};

snapControllers.listSnapsController = [
	'$scope',
	'sharedData',
	'$http',
	'snapArrayService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'securityFactory',
	'cvUtil',
	'MMSMAssocType',
	'cvGridSearchFactory',
	'mbService',
	'editArrayFactory',
	'$compile',
	function(
		$scope,
		sharedData,
		$http,
		snapArrayService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvLoc,
		$dialogs,
		$log,
		$state,
		securityFactory,
		cvUtil,
		MMSMAssocType,
		cvGridSearchFactory,
		mbService,
		editArrayFactory,
		$compile
	) {
		var self = this;

		self.arrayInfo = {
			destinationClientId: 0,
			destinationPath: '',
			preventSnapFlag: 0,
			snapEngineIdName: {
				id: 0,
				name: ''
			},
			controlHostId: 0,
			smVolumeId: 0,
			controlHost: '',
			mountHostName: '',
			mountHostId: 0,
			mountPath: '',
			controlId: 0,
			arrayName: '',
			smArrayId: '',
			userName: '',
			password: '',
			mountRetryInterval: -1,
			mountRetryCount: -1,
			hostGroup: false,
			useHost: false,
			diagLogging: false,
			remoteSnapMA: '',
			mountRetryIntervalId: 0,
			mountRetryCountId: 0,
			hostGroupId: 0,
			useHostId: 0,
			diagLoggingId: 0,
			remoteSnapMAId: 0
		};
		self.localPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
		self.linuxPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
		self.pathPattern = self.localPathPattern;

		self.controlId = $stateParams['controlId'];

		self.listSnapsMessage = cvUtil.infoMsgLoc('Loading');

		self.openMountSnapDialog = function(controlHostId, smArrayId, smVolumeId, mountHostName, mountHostId, mountPath) {
			sharedData.data.controlHostId = controlHostId;
			sharedData.data.arrayName = smArrayId;
			sharedData.data.smVolumeId = smVolumeId;
			sharedData.data.mountHostName = mountHostName;
			sharedData.data.mountHostId = mountHostId;
			sharedData.data.mountPath = mountPath;
			var operationId = 0;

			editArrayFactory.addOrEditArray($scope, $rootScope, $modal, cvLoc, false, 'mount');
		};

		self.unMountSnap = function(controlHostId, smArrayId, smVolumeId, mountHostName, mountHostId, mountPath) {
			var operationId = 1;
			var arraylist = new Array();
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					self.arrayInfo.controlHostId = controlHostId;
					self.arrayInfo.smArrayId = smArrayId;
					self.arrayInfo.smVolumeId = smVolumeId;
					self.arrayInfo.mountHostName = mountHostName;
					self.arrayInfo.mountHostId = mountHostId;
					self.arrayInfo.mountPath = mountPath;
					self.arrayInfo.preventSnapFlag = self.arrayInfo.preventSnapFlag ? 1 : 0;
					arraylist.push(self.arrayInfo);
					snapArrayService
						.snapOperations(arraylist, operationId)
						.success(function(data) {
							if (data.error && data.error.errorCode > 0) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.error.errorMessage).message);
								$log.error('UnMount Opeartion failed');
							} else {
								$log.debug('UnMount Opeartion success');
								$state.forceReload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('UnMount Opeartion failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmUnMount'), cvLoc('label.confirmUnMountSnapArray'), callBackFunctions);
		};

		self.deleteSnap = function(controlHostId, smArrayId, smVolumeId, mountHostName, mountHostId, mountPath) {
			var operationId = 2;
			var arraylist = new Array();
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					self.arrayInfo.controlHostId = controlHostId;
					self.arrayInfo.smArrayId = smArrayId;
					self.arrayInfo.smVolumeId = smVolumeId;
					self.arrayInfo.mountHostName = mountHostName;
					self.arrayInfo.mountHostId = mountHostId;
					self.arrayInfo.mountPath = mountPath;
					self.arrayInfo.preventSnapFlag = self.arrayInfo.preventSnapFlag ? 1 : 0;
					arraylist.push(self.arrayInfo);
					snapArrayService
						.snapOperations(arraylist, operationId)
						.success(function(data) {
							if (data.error && data.error.errorCode > 0) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.error.errorMessage).message);
								$log.error('Delete Opeartion failed');
							} else {
								$log.debug('Delete Opeartion success');
								var msg = cvLoc('notification.workflowJobForDelete', data.jobId);
								var viewMsg = cvLoc('notification.viewJob');
								cvToaster.showInfoMessage({
									ttl: '10000', //10 sec
									message: msg + ' <br><a href="#/jobs/' + data.jobId + '">' + viewMsg + '</a>'
								});
								//								$state.forceReload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Opeartion failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteSnap'), callBackFunctions);
		};

		self.revertSnap = function(controlHostId, smArrayId, smVolumeId, mountHostName, mountHostId, mountPath) {
			var operationId = 3;
			var arraylist = new Array();
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					self.arrayInfo.controlHostId = controlHostId;
					self.arrayInfo.smArrayId = smArrayId;
					self.arrayInfo.smVolumeId = smVolumeId;
					self.arrayInfo.mountHostName = mountHostName;
					self.arrayInfo.mountHostId = mountHostId;
					self.arrayInfo.mountPath = mountPath;
					self.arrayInfo.preventSnapFlag = self.arrayInfo.preventSnapFlag ? 1 : 0;
					arraylist.push(self.arrayInfo);
					snapArrayService
						.snapOperations(arraylist, operationId)
						.success(function(data) {
							if (data.error && data.error.errorCode > 0) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.error.errorMessage).message);
								$log.error('Revert Opeartion failed');
							} else {
								$log.debug('Revert Opeartion success');
								$state.forceReload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Revert Opeartion failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmRevert'), cvLoc('label.confirmRevertSnapArray'), callBackFunctions);
		};

		self.listSnapDetails = function(controlId) {
			self.arrayInfo.controlHostId = controlId;
			var operationId = 4;
			var arraylist = new Array();
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					arraylist.push(self.arrayInfo);
					snapArrayService
						.snapOperations(arraylist, operationId)
						.success(function(data) {
							if (data.error && data.error.errorCode > 0) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.error.errorMessage).message);
								$log.error('Details Opeartion failed');
							} else {
								$log.debug('Details Opeartion success');
								$state.forceReload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Details Operation failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteSnapArray'), callBackFunctions);
		};

		const _computePermittedActions = function(entity) {
			const arrayOfActions = [
				{
					show: true,
					value: 'DELETE',
					label: cvLoc('action.delete'),
					onClick: () =>
						self.deleteSnap(
							entity.controlHostId,
							entity.smArrayId,
							entity.smVolumeId,
							entity.mountHostName,
							entity.mountHostId,
							entity.mountPath
						)
				}
			];
			return arrayOfActions;
		};

		const fetchListSnapsData = options => {
			return snapArrayService
				.listSnaps(self.controlId)
				.success(function(data) {
					self.listSnapsMessage = cvUtil.emptyMsg();
					self.listSnapsData = data;
					self.listSnapsData.forEach(item => {
						item.permittedOptions = {
							entityId: item.smVolumeId,
							appendToBody: true,
							permittedActionList: _computePermittedActions(item)
						};
					});
					options.success(self.listSnapsData);
				})
				.error(function(e) {
					self.listSnapsMessage = cvUtil.errMsg(e);
					options.error(e);
				});
		};
		const initSCGrid = function() {
			setupGridOptions();
		};

		self.multiDeleteSnapShot = function({ selectedRowValues }) {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					// var selectedRows = gridApi.selection.getSelectedRows();
					var operationId = 2;
					angular.forEach(selectedRowValues, function(arrayInfo, key) {
						self.currentDeletedRows.push(arrayInfo);
					});
					snapArrayService
						.snapOperations(self.currentDeletedRows, operationId)
						.success(function(data) {
							if (data.error && data.error.errorCode > 0) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.error.errorMessage).message);
								$log.error('Delete Opeartion failed');
							} else {
								$log.debug('Delete Opeartion success');
								var msg = cvLoc('notification.workflowJobForDelete', data.jobId);
								var viewMsg = cvLoc('notification.viewJob');
								cvToaster.showInfoMessage({
									ttl: '10000', //10 sec
									message: msg + ' <br><a href="#/jobs/' + data.jobId + '">' + viewMsg + '</a>'
								});
								//											$state.forceReload();
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error('Delete Operation failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmDelete'), cvLoc('label.confirmDeleteSnap'), callBackFunctions);
		};

		const _onSelectionChange = e => {
			if (e.values) {
				if (e.values.length > 1) {
					_disableEnableActionMenuOptions(e, true);
				} else {
					_disableEnableActionMenuOptions(e.values[0]);
				}
			}
		};

		const _disableEnableActionMenuOptions = (e, disableNotesAction) => {
			if (disableNotesAction) {
				self.grid.enableActionMenuOption('deleteSnapShot');
			} else {
				self.grid.disableActionMenuOption('deleteSnapShot');
			}
		};

		const setupGridOptions = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			gridOptions.gridTitle = cvLoc('label.listOfSnaps');
			gridOptions.tableName = 'snapsListTable';
			gridOptions.enableCheckBoxColumn = true;
			gridOptions.url = fetchListSnapsData.bind(self);
			gridOptions.usePageToolbar = true;
			gridOptions.onGridDataBound = _onGridDataBound.bind(self);
			gridOptions.hasViews = true;
			gridOptions.enablePaging = true;
			gridOptions.pageSize = 20;
			gridOptions.pageSizes = [5, 10, 20, 50, 100];
			gridOptions.onGridSelectionChange = _onSelectionChange.bind(self);
			gridOptions.sortDirection = {
				field: 'souceClientName',
				dir: 'asc'
			};
			gridOptions.beforeGridInitialize = ({ grid }) => {
				self.grid = grid;
			};
			gridOptions.actionMenu = [
				{
					id: 'deleteSnapShot',
					label: cvLoc('action.delete'),
					onSelect: self.multiDeleteSnapShot.bind(this)
				}
			];
			gridOptions.gridEmptyMessage = '<div class="text-align-center">' + cvLoc('label.noListSnaps') + '</div>';
			gridOptions.gridEmptySvg =
				'<svg data-cv-on-grid-empty class="add-new-placeholder" version="1.1" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M139.9,44H20.1A5,5,0,0,0,15,48.9V69.1A5,5,0,0,0,20.1,74H139.9a5,5,0,0,0,5.1-4.9V48.9A5,5,0,0,0,139.9,44ZM80,61.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,62.8Z"/><path d="M139.9,79H20.1A5,5,0,0,0,15,83.9v20.2a5,5,0,0,0,5.1,4.9H139.9a5,5,0,0,0,5.1-4.9V83.9A5,5,0,0,0,139.9,79ZM80,96.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,97.8Z"/><path d="M139.9,114H20.1a5,5,0,0,0-5.1,4.9v20.2a5,5,0,0,0,5.1,4.9H139.9a5,5,0,0,0,5.1-4.9V118.9A5,5,0,0,0,139.9,114ZM80,131.5H30v-5H80v5Zm38,1.3a3.8,3.8,0,1,1,3.8-3.7A3.7,3.7,0,0,1,118,132.8Z"/><path d="M90,162H83V149H77v13H70a5,5,0,0,0-5,5H15v5H65a5,5,0,0,0,5,5H90a5,5,0,0,0,5-5h50v-5H95A5,5,0,0,0,90,162Zm1,10a1,1,0,0,1-1,1H70a1,1,0,0,1-1-1v-5a1,1,0,0,1,1-1H90a1,1,0,0,1,1,1v5Z"/></svg>';
			self.snapListGridOptions = gridOptions;
		};
		const _onGridDataBound = (dataItem, row) => {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)($scope));
		};

		const initColumnDefs = function() {
			return listSnapsColumnTemplates.getListSnapsColumnTemplate({ cvLoc: cvLoc });
		};

		initSCGrid();

		self.currentDeletedRows = new Array();
	}
];

snapMod.controller(snapControllers);

export default snapMod;
