import 'modules/snapArrays/js/controllers/snapArray.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'modules/storage/js/controllers/storage.ctrl.js';
import 'storage/js/services/storage.svc.js';

import { cvModuleSnapArrayModule } from 'common/js/modules';

var snapMod = cvModuleSnapArrayModule;
var snapControllers = {};

snapControllers.createSnapArrayController = [
	'sharedData',
	'$uibModal',
	'$log',
	'snapArrayService',
	'$location',
	'cvUtil',
	'cvTableOptions',
	'cvLoc',
	'$filter',
	'mbService',
	'$scope',
	'MMSMAssocType',
	'$dialogs',
	'storageService',
	'storageFactory',
	'CREDENTIAL_TYPE',
	function(
		sharedData,
		$modal,
		$log,
		snapArrayService,
		$location,
		cvUtil,
		cvTableOptions,
		cvLoc,
		$filter,
		mbService,
		$scope,
		MMSMAssocType,
		$dialogs,
		storageService,
		storageFactory,
		CREDENTIAL_TYPE
	) {
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		$scope.title = cvLoc('label.addArrays');
		$scope.addAliasInput = '';
		$scope.alliasArray = [];
		$scope.snapConfForm = [];
		$scope.arrayVendor = null;
		$scope.arrayName = '';
		$scope.arrayVendors = [];
		$scope.step = 0;
		$scope.mountHostName = '';
		$scope.arrayInfo = {
			snapEngineIdName: {
				id: '',
				name: ''
			},
			controlHostId: 0,
			controlHost: '',
			controlId: 0,
			arrayName: '',
			userName: '',
			password: '',
			configs: null
		};
		$scope.userName = '';
		$scope.password = '';
		$scope.arrayNameLabel = cvLoc('label.ArrayName');
		$scope.arrayHostNameLabel = cvLoc('label.hostName');
		$scope.arrayPasswordLabel = cvLoc('label.password');
		$scope.arrayUserNameLabel = cvLoc('label.UserName');
		$scope.selectCredentialData = { credential: null };
		$scope.showSwitchToCM = true;
		$scope.showCredentialDropDown = false;
		$scope.switchToCM = 'disabled-activity';
		$scope.showUsernamePassword = false;
		storageService
			.getCredentials(CREDENTIAL_TYPE.STORAGE_ARRAY_ACCOUNT)
			.then(credentialsList => ($scope.savedCredentials = credentialsList.list));

		/**
		 * @method toggleCredentialType
		 * method responsible of show credential manager dropdown
		 * or username and password inputs depending on the toggle
		 */
		$scope.toggleCredentialType = function() {
			$scope.switchToCM = $scope.switchToCM == 'disabled-activity' ? 'enabled-activity' : 'disabled-activity';
			if ($scope.switchToCM == 'enabled-activity') {
				$scope.showCredentialDropDown = true;
				$scope.emptyUserName = false;
			} else {
				$scope.showCredentialDropDown = false;
				$scope.emptyCredential = false;
			}
			$scope.credentialNotSelectedError = false;
		};

		/**
		 * @method openCreateCredentialModal
		 * method responsible of open the create credential modal and
		 * put the credential created as the selected value
		 * in saved credential dropdown
		 */
		$scope.openCreateCredentialModal = () =>
			storageFactory.openCreateCredentialModal(CREDENTIAL_TYPE.STORAGE_ARRAY_ACCOUNT).then(response => {
				if (response) {
					$scope.savedCredentials = response.list || $scope.savedCredentials;
					$scope.savedCredentials.forEach(function(credential) {
						if (credential.credentialName === response.name) {
							credential.selected = true;
							$scope.selectCredentialData.credential = [credential];
						}
					});
				}
			});

		/**
		 * @method openEditCredentialModal
		 * method responsible of open the edit credential modal and
		 * put the the current credential edited as the selected
		 * value in saved credential dropdown
		 * @param {Array} credentialEntity
		 */
		$scope.openEditCredentialModal = function(credentialEntity) {
			storageFactory.openEditCredentialModal(credentialEntity[0]).then(editedCredentialName => {
				if (editedCredentialName) {
					$scope.selectCredentialData.credential.credentialName = editedCredentialName;
					$scope.savedCredentials.forEach(function(credential) {
						if (credential.credentialId === $scope.selectCredentialData.credential[0].credentialId) {
							credential.credentialName = editedCredentialName;
						}
					});
				}
			});
		};

		$scope.errorMessage = {
			vendor: '',
			name: '',
			host: ''
		};
		$scope.steps = [
			{
				template: appUtil.appRoot + 'modules/snapArrays/partials/createSnapArrayGeneralTemplate.jsp',
				name: cvLoc('label.general')
			},
			{
				template: appUtil.appRoot + 'modules/snapArrays/partials/createSnapArrayControllers.jsp',
				name: cvLoc('label.arrayAccessNodes')
			}
		];
		$scope.myStyle = { width: '50%' };

		$scope.addedControllers = [];
		$scope.availableControllers = [];

		$scope.addAlias = elem => {
			if (elem !== '') {
				$scope.addAliasInput = '';
				$scope.alliasArray.push(elem);
			}
		};
		$scope.removeAlias = index => {
			$scope.alliasArray.splice(index, 1);
		};
		$scope.changeBoolean = index => {
			$scope.snapConfForm[index].value = !$scope.snapConfForm[index].value;
		};

		$scope.arrayControllerSelection = () => {
			$scope.selectedSnapControllers = '';
			$scope.addedControllers = [];
			$scope.controllersValues = [];
			if ($scope.availableControllers && $scope.availableControllers.length > 0) {
				$scope.availableControllers
					.filter(data => {
						return data.ticked;
					})
					.forEach(value => {
						$scope.addedControllers.push({
							mediaAgent: value.mediaAgent,
							arrCtrlOptions: value.arrCtrlopts,
							controllerId: 0
						});
						$scope.controllersValues.push(value.arrCtrlopts);
					});
				const arrayEx = $scope.addedControllers.map(elem => elem.mediaAgent.name);
				$scope.selectedSnapControllers = arrayEx.join(' , ');
			}
		};

		$scope.changePrunning = (mainIndex, index) => {
			const newElem = $scope.controllersValues.map(elem => {
				return Object.assign({}, elem);
			});
			const newValue = !$scope.controllersValues[mainIndex][index].isEnabled;
			$scope.controllersValues[mainIndex][index].isEnabled = newValue;
			$scope.addedControllers[mainIndex].arrCtrlOptions[index].isEnabled = newValue;
		};

		$scope.moveSelectedList = function(list1, list2) {
			const initList = [];
			const targetList = [];
			list1.map(elem => {
				if (elem.selected) {
					elem.selected = false;
					targetList.push(elem);
				} else {
					initList.push(elem);
				}
			});
			return { origin: initList, target: [...targetList, ...list2] };
		};

		snapArrayService
			.getArrayVendorList()
			.success(data => {
				if (!data.erroCode) {
					if ('vendorList' in data) {
						$scope.arrayVendors = data.vendorList;
					}

					if ('availableMAs' in data) {
						data['availableMAs'].forEach(ma => {
							$scope.availableControllers.push({
								mediaAgent: ma.mediaAgent,
								name: ma.mediaAgent.name,
								ticked: false,
								arrCtrlopts: $scope.controllerOptions
							});
						});
					}
					$scope.availableControllers.sort(function(a, b) {
						if (a.name < b.name) {
							return -1;
						}
						if (a.name > b.name) {
							return 1;
						}
						return 0;
					});
				} else {
					if (data.errorCode !== 0) {
						$dialogs.error(cvLoc('label.error'), data.errorMessage);
					}
				}
			})
			.error(function(data, status, headers, config) {
				$scope.serverMessage = cvUtil.errMsg(data.errorMessage);
				return false;
			});

		/**
		 * @method onChangeCredential
		 * method responsible of check if credential input is populated
		 * and set the emptyCredential value to false
		 */
		$scope.onChangeCredential = () => {
			if ($scope.selectCredentialData.credential[0].credentialId) {
				$scope.emptyCredential = false;
			}
		};

		$scope.changeArrayName = value => {
			$scope.arrayName = value;
			$scope.arrayInfo.arrayName = value;
			$scope.errorMessage.name = '';
		};

		$scope.changeHost = value => {
			$scope.mountHostName = value;
			$scope.arrayInfo.mountHostName = value;
			$scope.errorMessage.host = '';
		};
		$scope.changeUsername = value => {
			$scope.userName = value;
			$scope.arrayInfo.userName = value;
			$scope.emptyUserName = false;
		};

		$scope.changePassword = value => {
			$scope.Password = value;
			$scope.arrayInfo.Password = value;
		};

		$scope.changeVendor = value => {
			$scope.addedControllers = [];

			$scope.errorMessage.vendor = '';

			$scope.arrayVendor = value;
			$scope.alliasArray = [];
			const id = value.vendor.id;
			const name = value.vendor.name;

			$scope.arrayInfo.snapEngineIdName.id = id;
			$scope.arrayInfo.snapEngineIdName.name = name;

			/* If backend sent some custom value for array name label */
			if (value.arrayNameLabel.length > 0) {
				$scope.arrayNameLabel = value.arrayNameLabel;
			} else {
				$scope.arrayNameLabel = cvLoc('label.ArrayName');
			}

			/* If backend sent some custom value for hostname (control host) label */
			if (value.arrayControlHostLabel.length > 0) {
				$scope.arrayHostNameLabel = value.arrayControlHostLabel;
			} else {
				$scope.arrayHostNameLabel = cvLoc('label.hostName');
			}

			/* If backend sent some custom value for username label */
			if (value.arrayUserNameLabel.length > 0) {
				$scope.arrayUserNameLabel = value.arrayUserNameLabel;
			} else {
				$scope.arrayUserNameLabel = cvLoc('label.userName');
			}

			/* If backend sent some custom value for password label */
			if (value.arrayPasswordLabel.length > 0) {
				$scope.arrayPasswordLabel = value.arrayPasswordLabel;
			} else {
				$scope.arrayPasswordLabel = cvLoc('label.password');
			}

			$scope.controllerOptions = value.arrCtrlopts ? value.arrCtrlopts : [];

			const currentAvailable = $scope.availableControllers;

			$scope.availableControllers = [];

			currentAvailable.forEach(elem => {
				$scope.availableControllers.push({
					mediaAgent: elem.mediaAgent,
					name: elem.mediaAgent.name,
					ticked: false,
					arrCtrlopts: Array.from($scope.controllerOptions, val => {
						return {
							arrCtrlOption: val.arrCtrlOption,
							isEnabled: true
						};
					})
				});
			});

			snapArrayService
				.getVendorConfig(id)
				.success(snapDetails => {
					if (!snapDetails.error || snapDetails.error.errorCode === 0) {
						$scope.snapDetails = snapDetails;
						if ($scope.snapDetails.configs && $scope.snapDetails.configs.configList) {
							var showSnapConfigTab = false;
							for (var i = 0; i < $scope.snapDetails.configs.configList.length; ++i) {
								if (
									($scope.snapDetails.configs.configList[i].flags & 64) !==
									64 /* SM_MASTERCONFIGS_FLAGS_SHOW_IN_GENERAL_TAB */
								) {
									showSnapConfigTab = true;
									break;
								}
							}
							if (showSnapConfigTab === true) {
								if ($scope.steps.length < 3) {
									$scope.steps.push({
										template: appUtil.appRoot + 'modules/snapArrays/partials/createSnapArraySnapConf.jsp',
										name: cvLoc('label.snapConfigurations')
									});
								}

								$scope.myStyle = { width: '33%' };
							} else {
								if ($scope.steps.length > 2) {
									$scope.steps.splice(2, 1);
								}
								$scope.myStyle = { width: '50%' };
							}
							$scope.getSnapConfObject();
						} else {
							if ($scope.steps.length > 2) {
								$scope.steps.splice(2, 1);
							}
							$scope.myStyle = { width: '50%' };
							$scope.snapConfForm = [];
						}
					} else {
						$log.error('Getting vendor config failed');
						$dialogs.error(cvLoc('label.error'), snapDetails.error.errorMessage);
						$scope.snapArrayMessage = cvUtil.errMsg(snapDetails.error.errorMessage);
					}
				})
				.error(function(e) {
					$log.error('Getting vendor config failed');
					$dialogs.error(cvLoc('label.error'), e);
					$scope.snapArrayMessage = cvUtil.errMsg(e.errorMessage);
				});
		};
		$scope.getSnapConfObject = function() {
			$scope.snapConfForm = [];
			$scope.snapDetails.configs.configList.map((configObject, index) => {
				const typeValue = $scope.getSnapTypeValue(configObject);
				let name = configObject.name.name;
				const firstLetter = name[0];
				name = firstLetter.toLowerCase() + name.slice(1);
				let desc = '';

				let finalDesc = '';

				if (configObject.notes !== '') {
					desc = configObject.notes.replace(/<br\/>|<\/b>|<html>|<\/html>|<body>|<\/body>/g, '').split('<b>');

					finalDesc = desc[2].split(':')[1];

					if (typeValue.type !== 'list' && desc.length > 3) {
						finalDesc = finalDesc.toLowerCase().includes('default value') ? finalDesc : finalDesc + '. ' + desc[3];
						if (desc.length > 4) {
							finalDesc = finalDesc + '. ' + desc[4];
						}
					}
				}

				const finalName = configObject.name.name;

				const obj = {
					id: index,
					key: name.replace(/\s/g, ''),
					label: finalName,
					value: typeValue.value,
					type: typeValue.type,
					enabled: configObject.isEnabled,
					description: finalDesc,
					flags: configObject.flags,
					formType: $scope.getFormType(typeValue.type),
					showInGeneralTab:
						(configObject.flags & 64) == 64 /* SM_MASTERCONFIGS_FLAGS_SHOW_IN_GENERAL_TAB */ ? true : false,
					masterConfigId: configObject.masterConfigId
				};
				$scope.snapConfForm.push(obj);
			});
		};
		$scope.getFormType = function(elemType) {
			switch (elemType) {
				case 'checkbox':
					return 'checkbox';
				case 'list':
					return 'list';
				case 'password':
					return 'password';
				default:
					return 'input';
			}
		};
		$scope.getTypeFromNum = function(typeNumber) {
			switch (typeNumber) {
				case 0:
					return 'MMSM_CT_NONE';
				case 1:
					return 'MMSM_CT_BOOL';
				case 2:
					return 'MMSM_CT_INT';
				case 3:
					return 'MMSM_CT_UINT';
				case 4:
					return 'MMSM_CT_LONG';
				case 5:
					return 'MMSM_CT_ULONG';
				case 6:
					return 'MMSM_CT_LONGLONG';
				case 7:
					return 'MMSM_CT_ULONGLONG';
				case 8:
					return 'MMSM_CT_STRING';
				case 9:
					return 'MMSM_CT_IP_ADDR';
				case 10:
					return 'MMSM_CT_LIST';
				case 11:
					return 'MMSM_CT_COMBO';
				case 12:
					return 'MMSM_CT_PSWD';
				case 13:
					return 'MMSM_CT_ENC_STRING';
			}
		};
		$scope.getSnapTypeValue = function(complexType) {
			const elem = $scope.getTypeFromNum(complexType.type);
			const name = elem.toLowerCase();

			if (name.includes('enc_string')) {
				return { type: 'text', value: '' };
			} else if (name.includes('string')) {
				return { type: 'text', value: complexType.value };
			} else if (name.includes('bool')) {
				return { type: 'checkbox', value: complexType.value === 'true' };
			} else if (name.includes('int')) {
				return { type: 'number', value: Number(complexType.value) };
			} else if (name.includes('pswd')) {
				return { type: 'password', value: { pass: '', conf: '' } };
			} else if (name.includes('list')) {
				if (complexType.values) {
					$scope.alliasArray = complexType.values.map(elem => {
						return elem.name;
					});
				} else {
					$scope.alliasArray = [];
				}

				return { type: 'list', values: complexType.values ? complexType.values : [] };
			} else {
				return { type: '', value: '' };
			}
		};

		$scope.getCurrentStep = function() {
			return $scope.step;
		};
		$scope.nextGeneralTab = () => {
			$scope.emptyUserName = false;
			switch ($scope.step) {
				case 0:
					let isIncomplete = false;
					if (!$scope.arrayVendor) {
						$scope.errorMessage.vendor = cvLoc('error.arrayVendor');
						isIncomplete = true;
					} else if (
						$scope.arrayVendor.capabilities.enableControlHost &&
						(!$scope.arrayInfo.mountHostName || $scope.arrayInfo.mountHostName === '')
					) {
						$scope.errorMessage.host = cvLoc('error.arrayHost');
						isIncomplete = true;
					}

					if (!$scope.arrayInfo.arrayName || $scope.arrayInfo.arrayName === '') {
						$scope.errorMessage.name = cvLoc('error.arrayName');
						isIncomplete = true;
					}

					if (!$scope.showCredentialDropDown && $scope.arrayInfo.Password && !$scope.arrayInfo.userName) {
						$scope.emptyUserName = true;
						isIncomplete = true;
					}

					if ($scope.showCredentialDropDown && $scope.selectCredentialData.credential.length === 0) {
						$scope.emptyCredential = true;
						isIncomplete = true;
					}

					if (!isIncomplete) {
						$scope.step += 1;
					}
					break;
				case 1:
					$scope.step += 1;
					break;
				case 2:
					$scope.step += 1;
					break;
			}
		};
		$scope.goPreviousStep = function() {
			$scope.serverErrorMessage = '';
			$scope.step -= 1;
		};
		$scope.saveGeneralTab = function() {
			if ($scope.snapConfForm.length > 0) {
				const newList = $scope.alliasArray.map(elem => {
					return { name: elem, id: 0 };
				});

				$scope.snapConfForm.map((newElem, index) => {
					const name = newElem.type.toLowerCase();
					name.includes('list')
						? ($scope.snapDetails.configs.configList[index].values = newList)
						: ($scope.snapDetails.configs.configList[index].value =
								typeof newElem.value !== 'string' ? JSON.stringify(newElem.value) : newElem.value);

					if (name.includes('password')) {
						$scope.snapDetails.configs.configList[index].userPswd = {};
						$scope.snapDetails.configs.configList[index].userPswd = {
							password: newElem.userPswd ? btoa(newElem.userPswd.password) : ''
						};
						$scope.snapDetails.configs.configList[index].value = '';
						$scope.snapDetails.configs.configList[index].isUpdated = true;
					}
				});

				$scope.arrayInfo.configs = JSON.stringify($scope.snapDetails.configs.configList);
			}

			let info = {
				arrayName: {
					name: $scope.arrayInfo.arrayName,
					id: 0
				},
				vendor: {
					name: $scope.arrayInfo.snapEngineIdName.name,
					id: $scope.arrayInfo.snapEngineIdName.id
				}
			};

			if (!$scope.showCredentialDropDown && $scope.arrayInfo.userName) {
				info = {
					...info,
					userPswd: {
						password: $scope.arrayInfo.Password ? btoa($scope.arrayInfo.Password) : '',
						userName: $scope.arrayInfo.userName
					}
				};
			} else {
				if ($scope.selectCredentialData.credential) {
					info = {
						...info,
						savedCredential: {
							credentialId: $scope.selectCredentialData.credential[0].credentialId,
							credentialName: $scope.selectCredentialData.credential[0].credentialName
						}
					};
				}
			}

			const element = {
				assocType: 3,
				selectedMAs: $scope.addedControllers,
				configs: {
					configList: $scope.snapDetails.configs.configList
				},
				info
			};

			if ($scope.mountHostName !== '') {
				element.info['ctrlHostName'] = $scope.mountHostName;
			}

			const value = JSON.stringify(element);

			snapArrayService
				.createArray(value)
				.success(data => {
					if (data.errorCode === 0) {
						const arrayId = data.errorMessage;
						$log.debug('add Array');
						$location.url(`/snapArray?arrayId=${arrayId}`);
					} else {
						$scope.serverErrorMessage = data.errorMessage;
						$log.error('Adding an Array failed');
					}
				})
				.error(e => {
					$log.error('Adding an Array failed');
					$scope.snapArrayMessage = cvUtil.errMsg(e.errorMessage);
				});
		};
		$scope.removeController = index => {
			const id = $scope.addedControllers[index].mediaAgent.id;
			$scope.addedControllers.splice(index, 1);
			$scope.controllersValues.splice(index, 1);
			const avIndex = $scope.availableControllers.findIndex(elem => elem.mediaAgent.id === id);
			$scope.availableControllers[avIndex].ticked = false;
		};
	}
];

snapMod.controller(snapControllers);

export default snapMod;
