import 'modules/snapArrays/js/controllers/snapArray.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'modules/snapArrays/js/services/snapArray.svc.js';
import 'modules/storage/js/controllers/storage.ctrl.js';
import 'storage/js/services/storage.svc.js';

import { cvModuleSnapArrayModule } from 'common/js/modules';

var snapMod = cvModuleSnapArrayModule;
var snapControllers = {};

snapControllers.addArrayController = [
	'sharedData',
	'$uibModal',
	'$log',
	'snapArrayService',
	'$location',
	'cvUtil',
	'cvTableOptions',
	'cvLoc',
	'$filter',
	'mbService',
	'$scope',
	'MMSMAssocType',
	'$dialogs',
	'regionsUIFactory',
	'storageFactory',
	'storageService',
	'CREDENTIAL_TYPE',
	function(
		sharedData,
		$modal,
		$log,
		snapArrayService,
		$location,
		cvUtil,
		cvTableOptions,
		cvLoc,
		$filter,
		mbService,
		$scope,
		MMSMAssocType,
		$dialogs,
		regionsUIFactory,
		storageFactory,
		storageService,
		CREDENTIAL_TYPE
	) {
		this.cvLoc = cvLoc;
		this.arrayVendors = [];
		this.isConfigAvailable = false;
		this.arrayControllers = [];

		this.selectedArrayControllers = [];
		this.entityType = 'ARRAY_ENTITY';

		this.addedControllers = [];
		this.availableControllers = [];
		this.controllersValues = [];

		this.selectedSnapControllers = '';
		this.status = {
			isOpen: false
		};
		let regionId = $scope.region ? $scope.region.regionId : 0;
		let regionName = $scope.region ? $scope.region.regionName : '';
		$scope.selectedRegion = [];
		$scope.regionList = [];
		regionsUIFactory.getGroupedRegionList().then(regions => {
			if (regions && regions.length > 0) {
				$scope.regionList = regions;
				if ($scope.region.regionId) {
					$scope.selectedRegion = $scope.regionList.map(data => {
						if ($scope.region.regionId == data.id) {
							data.selected = true;
							return data;
						}
					});
				}
			}
		});
		$scope.selectedRegionValue = function() {
			$scope.selectedRegion = $scope.regionList.filter(function(value) {
				return value.selected;
			});
			$scope.regionSelectedId = $scope.selectedRegion[0].id;
			regionId = $scope.selectedRegion[0].id;
			regionName = $scope.selectedRegion[0].name;
		};

		$scope.selectCredentialData = { credential: null };
		$scope.showSwitchToCM = sharedData.hasSavedCredential ? true : false;
		$scope.showCredentialDropDown = sharedData.hasSavedCredential ? true : false;
		$scope.switchToCM = sharedData.hasSavedCredential ? 'enabled-activity' : 'disabled-activity';
		$scope.showUsernamePassword = false;
		$scope.isNetApp = sharedData.isNetApp;

		storageService.getCredentials(CREDENTIAL_TYPE.STORAGE_ARRAY_ACCOUNT).then(credentialsList => {
			$scope.savedCredentials = credentialsList.list;
			matchExistingSavedCredential();
		});

		/**
		 * @method toggleCredentialType
		 * method responsible of show credential manager dropdown
		 * or username and password inputs depending on the toggle
		 */
		$scope.toggleCredentialType = function() {
			$scope.switchToCM = $scope.switchToCM == 'disabled-activity' ? 'enabled-activity' : 'disabled-activity';
			if ($scope.switchToCM == 'enabled-activity') {
				$scope.showCredentialDropDown = true;
				$scope.isUserNameRequired = false;
			} else {
				$scope.showCredentialDropDown = false;
				$scope.isCredentialEmpty = false;
			}
			$scope.credentialNotSelectedError = false;
		};

		/**
		 * @method openCreateCredentialModal
		 * method responsible of open the create credential modal and
		 * put the credential created as the selected value
		 * in saved credential dropdown
		 */
		$scope.openCreateCredentialModal = () =>
			storageFactory.openCreateCredentialModal(CREDENTIAL_TYPE.STORAGE_ARRAY_ACCOUNT).then(response => {
				if (response) {
					$scope.savedCredentials = response.list || $scope.savedCredentials;
					$scope.savedCredentials.forEach(function(credential) {
						if (credential.credentialName === response.name) {
							credential.selected = true;
							$scope.selectCredentialData.credential = [credential];
						}
					});
				}
			});

		/**
		 * @method openEditCredentialModal
		 * method responsible of open the edit credential modal and
		 * put the the current credential edited as the selected
		 * value in saved credential dropdown
		 * @param {Array} credentialEntity
		 */
		$scope.openEditCredentialModal = function(credentialEntity) {
			storageFactory.openEditCredentialModal(credentialEntity[0]).then(editedCredentialName => {
				if (editedCredentialName) {
					$scope.selectCredentialData.credential.credentialName = editedCredentialName;
					$scope.savedCredentials.forEach(function(credential) {
						if (credential.credentialId === $scope.selectCredentialData.credential[0].credentialId) {
							credential.credentialName = editedCredentialName;
						}
					});
				}
			});
		};

		/**
		 * @method matchExistingSavedCredential
		 * method responsible of put the credential value from backend
		 * as the selected value in saved crendential dropdown
		 */
		const matchExistingSavedCredential = () => {
			if (sharedData.hasSavedCredential && $scope.savedCredentials) {
				$scope.savedCredentials.forEach(function(credential) {
					if (credential.credentialId === sharedData.savedCredentialFromBackend.credentialId) {
						credential.selected = true;
						$scope.selectCredentialData.credential = [credential];
					}
				});
			}
		};

		if ($scope.action == 'editArrayMAs') {
			snapArrayService
				.getArrayVendorList()
				.success(data => {
					if (!data.erroCode) {
						if ('vendorList' in data) {
							this.originalVendors = data.vendorList;
						}

						this.selectedVendor = this.originalVendors.find(elem => elem.vendor.name === this.arrayInfo.vendor.name);

						if ('availableMAs' in data) {
							data['availableMAs'].forEach(ma => {
								const index = sharedData.data.selectedMAs
									? sharedData.data.selectedMAs.findIndex(elem => elem.mediaAgent.id === ma.mediaAgent.id)
									: -1;
								const generalOptions = this.selectedVendor.arrCtrlopts
									? this.selectedVendor.arrCtrlopts.map(opt => {
											return { isEnabled: true, arrCtrlOption: opt.arrCtrlOption };
									  })
									: [];
								const availableObj = {
									mediaAgent: ma.mediaAgent,
									name: ma.mediaAgent.name,
									ticked: index === -1 ? false : true,
									arrCtrlOptions: generalOptions
								};

								if (index !== -1) {
									const currentSelected = Object.assign({}, sharedData.data.selectedMAs[index]);
									const options = currentSelected.arrCtrlOptions.map(opt => {
										return { isEnabled: true && opt.isEnabled, arrCtrlOption: opt.arrCtrlOption };
									});
									this.addedControllers.push({
										mediaAgent: currentSelected.mediaAgent,
										arrCtrlOptions: options,
										controllerId: currentSelected.arrayControllerId
									});
									availableObj.arrCtrlOptions = options;

									this.controllersValues.push(options);
								}
								this.availableControllers.push(availableObj);
							});
						}
					} else {
						if (data.errorCode !== 0) {
							$log.error('Adding an Array failed');
							$dialogs.error(cvLoc('label.error'), data.errorMessage);
						}
					}
				})
				.error(function(data, status, headers, config) {
					this.serverMessage = cvUtil.errMsg(data.errorMessage);
					return false;
				});
		}

		this.arrayInfo = sharedData.data;
		this.currentUserName = sharedData.data.info.userPswd.userName;
		this.hostName = sharedData.data.info.ctrlHostName ? sharedData.data.info.ctrlHostName : null;
		this.currentPass = sharedData.data.info.userPswd.password;

		this.snapConfForm = sharedData.conf;
		this.hostInputList = [];
		this.snapConfForm.map(snapConf => {
			if (snapConf.type === 'list') {
				$scope.hostName = '';
				this.hostInputList.push($scope.hostName);
			}
		});

		this.arrayVendors[0] = this.arrayInfo.vendor;

		this.arrayInfo.snapEngineIdName = sharedData.data.vendor;

		this.arrayNameLabel = cvLoc('label.ArrayName');
		this.arrayHostNameLabel = cvLoc('label.hostName');
		this.arrayUserNameLabel = cvLoc('label.userName');
		this.arrayPasswordLabel = cvLoc('label.password');
		this.regionLabel = cvLoc('label.RegionName');
		this.userNameError = cvLoc('label.userNameError');

		/* If backend sent some custom value for array name label */
		if (this.arrayInfo.arrayNameLabel.length > 0) {
			this.arrayNameLabel = this.arrayInfo.arrayNameLabel;
		}

		/* If backend sent some custom value for hostname (control host) label */
		if (this.arrayInfo.arrayControlHostLabel.length > 0) {
			this.arrayHostNameLabel = this.arrayInfo.arrayControlHostLabel;
		}

		/* If backend sent some custom value for username label */
		if (this.arrayInfo.arrayUserNameLabel.length > 0) {
			this.arrayUserNameLabel = this.arrayInfo.arrayUserNameLabel;
		}

		/* If backend sent some custom value for password label */
		if (this.arrayInfo.arrayPasswordLabel.length > 0) {
			this.arrayPasswordLabel = this.arrayInfo.arrayPasswordLabel;
		}

		this.changePrunning = (mainIndex, index) => {
			const newValue = true && !this.controllersValues[mainIndex][index].isEnabled;
			this.controllersValues[mainIndex][index].isEnabled = newValue;
			this.addedControllers[mainIndex].arrCtrlOptions[index].isEnabled = newValue;
			const indexAv = this.availableControllers.findIndex(
				elem => elem.mediaAgent.id === this.addedControllers[mainIndex].mediaAgent.id
			);
			this.availableControllers[indexAv].arrCtrlOptions[index].isEnabled = newValue;
		};

		this.arrayControllerSelection = () => {
			this.controllersValues = this.addedControllers.map(elem => {
				return elem.arrCtrlOptions;
			});
		};

		this.getFormType = function(elemType) {
			switch (elemType) {
				case 'checkbox':
					return 'checkbox';
				case 'list':
					return 'list';
				case 'password':
					return 'password';
				default:
					return 'input';
			}
		};

		/**
		 * @method addHost
		 * method responsible of add host array to the corresponding list
		 * for each new host added it will have an id with 0 value
		 * @param {String} hostInput
		 * @param {Number} idOfHostConfigList
		 * @param {Number} indexOfHostInput
		 */
		this.addHost = (hostInput, idOfHostConfigList, indexOfHostInput) => {
			if (hostInput !== '') {
				let indexToAdd;
				this.snapConfForm.map((item, index) => {
					if (idOfHostConfigList === item.id) {
						indexToAdd = index;
						return;
					}
				});
				this.snapConfForm[indexToAdd].hostConfigList.push({ name: hostInput, id: 0 });
				this.hostInputList[indexOfHostInput] = '';
			}
		};

		/**
		 * @method removeHost
		 * method responsible of remove host item from the corresponding list
		 * @param {Number} index
		 * @param {Number} elementIdToRemove
		 */
		this.removeHost = (index, elementIdToRemove) => {
			let idxToRemove;
			this.snapConfForm.map((item, idx) => {
				if (elementIdToRemove === item.id) {
					idxToRemove = idx;
					return;
				}
			});
			this.snapConfForm[idxToRemove].hostConfigList.splice(index, 1);
		};

		this.changeBoolean = index => {
			this.snapConfForm[index].value = !this.snapConfForm[index].value;
		};

		this.addEditArray = function() {
			this.serverMessage = cvUtil.emptyMsg();
			sharedData.data = this.arrayInfo;

			this.snapConfForm.map((newElem, index) => {
				const name = newElem.type.toLowerCase();
				if (name.includes('list')) {
					if (newElem.hostConfigList.length === 0) {
						delete this.arrayInfo.configList.configList[index].values;
					} else {
						this.arrayInfo.configList.configList[index].values = newElem.hostConfigList;
					}
					this.arrayInfo.configList.configList[index].isUpdated = true;
				} else if (name.includes('password')) {
					this.arrayInfo.configList.configList[index].userPswd = {};
					if (newElem.value !== '*****') {
						this.arrayInfo.configList.configList[index].userPswd = {
							password: newElem.value ? btoa(newElem.value) : ''
						};
						this.arrayInfo.configList.configList[index].value = '';
						this.arrayInfo.configList.configList[index].isUpdated = true;
					}
				} else if (this.arrayInfo.configList.configList[index].type == 13 /* MMSM_CT_ENC_STRING */) {
					if (newElem.value.length == 0) {
						this.arrayInfo.configList.configList[index].isUpdated = false;
					} else {
						this.arrayInfo.configList.configList[index].value = JSON.parse(JSON.stringify({ key: newElem.value })).key;
						this.arrayInfo.configList.configList[index].isUpdated = true;
					}
				} else {
					const newValue = typeof newElem.value !== 'string' ? JSON.stringify(newElem.value) : newElem.value;
					if (this.arrayInfo.configList.configList[index].value !== newValue) {
						this.arrayInfo.configList.configList[index].value = newValue;
						this.arrayInfo.configList.configList[index].isUpdated = true;
					}
				}
			});

			let info = {
				arrayName: {
					name: this.arrayInfo.info.arrayName.name,
					id: this.arrayInfo.info.arrayName.id
				},
				vendor: this.arrayInfo.vendor,
				uniqueIdentifier: sharedData.uniqueIdentifier,
				arrayType: sharedData.arrayType
			};

			if ($scope.action === 'editArray') {
				if ($scope.selectedRegion.length !== 0 && $scope.regionSelectedId !== 0 && sharedData.isNetApp) {
					info = {
						...info,
						region: {
							regionId: regionId,
							regionName: regionName
						}
					};
				}
				if (!$scope.showCredentialDropDown) {
					if (this.currentPass && this.currentUserName) {
						info = {
							...info,
							userPswd: {
								password: btoa(this.currentPass),
								userName: this.currentUserName
							}
						};
					}
					if (this.currentPass && !this.currentUserName) {
						// if the user doesn't fill userName input
						$scope.isUserNameRequired = true;
						return;
					}
					if (!this.currentPass && this.currentUserName) {
						info = {
							...info,
							userPswd: {
								userName: this.currentUserName
							}
						};
					}
				} else {
					if ($scope.selectCredentialData.credential.length > 0) {
						delete info.userPswd;
						info = {
							...info,
							savedCredential: {
								credentialId: $scope.selectCredentialData.credential[0].credentialId,
								credentialName: $scope.selectCredentialData.credential[0].credentialName
							}
						};
					} else {
						$scope.isCredentialEmpty = true;
						return;
					}
				}
			} else {
				// general tile not opened
				if (sharedData.hasUserPswd) {
					info = {
						...info,
						userPswd: sharedData.userPswdFromBackend
					};
				}
				if (sharedData.hasSavedCredential) {
					//if backend brought savedCredential
					info = {
						...info,
						savedCredential: sharedData.savedCredentialFromBackend
					};
				}
				if ($scope.region.regionName && sharedData.isNetApp) {
					info = {
						...info,
						region: {
							regionId: $scope.region.regionId,
							regionName: $scope.region.regionName
						}
					};
				}
			}

			$scope.isUserNameRequired = false;

			const element = {
				assocType: 3,
				selectedMAs: $scope.action === 'editArrayMAs' ? this.addedControllers : this.arrayInfo.selectedMAs,
				configs: {
					configList: this.arrayInfo.configList.configList
				},
				info,
				add: false
			};

			if (this.hostName !== null) {
				element.info['ctrlHostName'] = this.hostName;
			}
			snapArrayService
				.editArrayInfo(JSON.stringify(element))
				.success(function(data) {
					if (data.errorCode === 0) {
						if ($scope.selectedRegion[0]) {
							$scope.selectedRegion[0].selected = false;
						}
						$scope.regionList = [];
						$scope.$emit('arrayAdded');
						$log.debug('add Array');
					} else {
						$log.error('Adding an Array failed');
						$scope.serverErrorMessage = data.errorMessage;
					}
				})
				.error(e => {
					$log.error('Adding an Array failed');
					this.serverMessage = cvUtil.errMsg(e.errorMessage);
				});
		};

		this.cancel = function() {
			if ($scope.selectedRegion[0]) {
				$scope.selectedRegion[0].selected = false;
			}
			$scope.regionList = [];
			$log.log('array addition cancelled...');
			$scope.$emit('arrayAddCancelled');
		};

		this.changeConfigurations = function() {
			if (this.arrayInfo.snapEngineIdName.id === 25) {
				this.isConfigAvailable = true;
				this.arrayInfo.mountRetryInterval = 30;
				this.arrayInfo.mountRetryCount = 5;
			} else {
				this.isConfigAvailable = false;
				this.arrayInfo.mountRetryInterval = -1;
				this.arrayInfo.mountRetryCount = -1;
			}
		};

		this.removeController = index => {
			const id = this.addedControllers[index].mediaAgent.id;
			this.addedControllers.splice(index, 1);
			this.controllersValues.splice(index, 1);
			const avIndex = this.availableControllers.findIndex(elem => elem.mediaAgent.id === id);
			this.availableControllers[avIndex].ticked = false;
		};

		this.getMediaAgents = function() {
			this.localPathPattern = /^([a-zA-Z]:){1}(\\[^<>:"/\\|?*]+)*\\?$/;
			this.linuxPathPattern = /^(\/[^<>:"/\\|?*]+)+\/?$/;
			this.pathPattern = this.localPathPattern;

			snapArrayService
				.getMediaAgents()
				.success(function(data) {
					this.agentList = cvUtil.sortAscending(data, 'name');
					if (data.length > 0) {
						this.arrayInfo.destinationClientId = data[0].id;
						this.setClientType();
					}
				})
				.error(function(data, status, headers, config) {
					this.listSnapsMessage = cvUtil.errMsg(data.errorMessage);
					return false;
				});
		};

		this.setClientType = function() {
			mbService.getOSType(this.arrayInfo.destinationClientId).then(function successCallBack(response) {
				this.separator = response.data.toLowerCase() == 'unix' ? '/' : '\\';
				this.isUnixMA = response.data.toLowerCase() == 'unix';
				this.pathPattern = this.isUnixMA ? this.linuxPathPattern : this.localPathPattern;
			});
		};

		this.browse = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							foldersOnly: true,
							clientId: this.arrayInfo.destinationClientId
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					this.arrayInfo.destinationPath = '';
					this.arrayInfo.destinationPath = result.path;
				},
				function() {
					$log.info('Cancel clicked: ');
				}
			);
		};

		this.mountSnap = function() {
			var operationId = 0;
			var arraylist = new Array();
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					this.arrayInfo.controlHostId = sharedData.data.controlHostId;
					(this.arrayInfo.arrayName = sharedData.data.arrayName),
						(this.arrayInfo.smArrayId = sharedData.data.arrayName);
					this.arrayInfo.smVolumeId = sharedData.data.smVolumeId;
					this.arrayInfo.mountHostName = sharedData.data.mountHostName;
					this.arrayInfo.mountHostId = sharedData.data.mountHostId;
					this.arrayInfo.mountPath = sharedData.data.mountPath;
					arraylist.push(this.arrayInfo);
					snapArrayService
						.snapOperations(arraylist, operationId)
						.success(function(data) {
							$scope.$emit('snapMountOperation');
							$log.debug('Mount Opeartion success');
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data.errorMessage));
							$log.error('Mount Opeartion failed');
						});
				}
			};
			$dialogs.confirm(cvLoc('label.confirmMount'), cvLoc('label.confirmMountSnapArray'), callBackFunctions);
		};

		this.cancelMount = function() {
			$log.log('snapMount Operation Cancelled...');
			$scope.$emit('snapMountOperationCancelled');
		};
	}
];

snapMod.controller(snapControllers);

export default snapMod;
