<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
    <script nonce="${sessionScope.cspNonce}">
        <cv:cvMessages bundle="localization.storage"></cv:cvMessages >
    </script>
<div class="row">
    <div class="col-xs-10 col-xs-offset-1 col-md-8 col-md-offset-2">
        <div class="setup-title">
            <h1><cv:msg key="label.retention" bundle="storage"/></h1>
        </div>
        <div class="setup-section">
            <div class="bootstrap-wrapper">
                <div class="form-horizontal">
                    <div class="form-group margin-bottom-20 form-policy-division">
                        <label><cv:msg key="label.dataAging" bundle="storage" /></label>
                        <div class="policy-content">
                            <toggle-control data-ng-class="isDataAging ? 'enabled-activity' : 'disabled-activity'" status="isDataAging ? 'enabled-activity' : 'disabled-activity'"
                                data-ng-click="changeDataAging()">
                            </toggle-control>
                        </div>
                    </div>
                    <div class="form-group margin-bottom-20 form-policy-division">
                        <label class="text-align-left"><cv:msg key="label.infinite" bundle="storage"/></label>
                        <div class="policy-content">
                            <div class="checked-content">
                                <input class="full-width" id="isInfiniteCheck" type="checkbox" data-ng-model="isInfinite" ng-change="changeInfinite()" />
                                <label for="isInfiniteCheck" class="checkbox-label text-align-left margin-top-20"></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group margin-bottom-20 form-policy-division">
                        <label class="text-align-left">
                            <cv:msg key="label.retention" bundle="storage" />
                        </label>
                        <div class="policy-content">
                            <div class="checked-content input-with-units">
                                <input class="full-width max-width-200" type="number" name="input" ng-model="retentionValue" min="0" ng-disabled="isInfinite || !isDataAging"
                                    ng-change="changeRetentionValue(retentionValue)">
                                <span class="inputMeasures margin-top-20">
                                    <cv:msg key="label.days" bundle="storage" />
                                </span>
                            </div>
                        </div>
                    </div>
                    <p ng-if="extendedErrors.hasMainRetError" class="error">
                        <cv:msg key="error.mainRetentionGreaterError" bundle="storage" />
                    </p>
                    <div class="button-container no-margin text-center">
                        <button id="storagePolicyRetentionTemplate_button_#5281" type="button" data-ng-click="goPreviousStep()" class="btn btn-primary cvBusyOnAjax"> 
                            <cv:msg key="action.back" bundle="storage"/>
                        </button>
                        <button id="storagePolicyRetentionTemplate_button_#6049" type="button" ng-disable="extendedErrors.hasRetError || extendedErrors.hasTypError || extendedErrors.hasMainRetError" data-ng-click="saveRetentionTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"> 
                            <cv:msg key="label.next" bundle="storage"/>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>