<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
    <script nonce="${sessionScope.cspNonce}">
        <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
    </script>
<div class="row">
    <div class="col-xs-10 col-md-8 col-xs-offset-1 col-md-offset-2">
        <div class="setup-title">
            <h1><cv:msg key="label.general" bundle="storage"/></h1>
        </div>
        <div class="setup-section">
            <div class="bootstrap-wrapper">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="col-xs-12 col-md-4 col-lg-4" for="storagePoolName"><cv:msg key="Name" bundle="storage"/></label>
                        <div class="col-xs-12 col-md-8 col-lg-8 text-align-left">
                            <input id="storagePoolName" type="text" name="storagePoolName" data-ng-model="policyName" autofocus ng-change="changeName(policyName)" />
                            <span class="error" data-ng-if="generalTabErrors.name">{{generalTabErrors.name}}</span>
                        </div>
                    </div>
                    <div class="form-group" >
                        <label class="col-xs-12 col-md-4 col-lg-4" for="storage"><cv:msg key="label.storage" bundle="storage"/></label>
                        <div class="col-xs-12 col-md-8 col-lg-8 text-align-left">
                            <select id="storage" name="repeatSelect" id="repeatSelect" ng-model="selectedPool" ng-change="changeSelectedPool(selectedPool)">
                                <option ng-repeat="pool in pools" value="{{pool}}">{{pool.storagePool.clientGroupName}}</option>
                            </select>
                            <span class="error" data-ng-if="generalTabErrors.storagePool">{{generalTabErrors.storagePool}}</span>                            
                        </div>
                    </div>
                    <div class="form-group" >
                        <div class="col-xs-12 col-md-12 col-lg-12">
                            <input id="selectedCopyCheck" type="checkbox" ng-model="isSelectiveCopy.selected" ng-change="changeSelectiveCopy(isSelectiveCopy)"/>
                            <label for="selectedCopyCheck" class="checkbox-label">
                                <cv:msg key="label.selectiveCopy" bundle="storage"/>
                            </label>
                        </div>
                        <div ng-if="isSelectiveCopyChecked()">
                            <div class="col-xs-12 col-md-4 col-lg-4 margin-top-20 text-align-left">
                                <span><cv:msg key="label.backupsAtFreq" bundle="storage"/></span>
                            </div>
                            <div class="col-xs-12 col-md-8 col-lg-8 margin-top-20 text-align-left">
                                <select id="selectiveCopy" name="repeatSelect" ng-model="selectedFreq.frequency" ng-change="changeCopyElem(selectedFreq)">
                                    <option ng-repeat="freq in selectiveFreqs track by freq.value" value="{{freq.value}}">{{freq.label}}</option>
                                </select>
                                <span class="error" data-ng-if="generalTabErrors.selectiveCopy">{{generalTabErrors.selectiveCopy}}</span>                                
                            </div>
                        </div>
                    </div>
                    <div class="button-container no-margin text-center">
                        <button id="storagePolicyGeneralTemplate_button_#8859" type="button" data-ng-click="saveGeneralTab()" class="btn btn-primary cvBusyOnAjax setup-btn--hidden"> 
                            <cv:msg key="label.next" bundle="storage"/>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
