<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages >
		<cv:cvMessages bundle="localization.navJs"></cv:cvMessages >
	</script>
<h1 class="page-title">{{storagePolicyName}}</h1>
<div class="group row" >
	<div class="col-md-6">	
		 <cv-tile-component data-title='<cv:msg key="label.general" bundle="storage" />'>
			<span class="page-details-box-links">
				<a ng-if="!editing" ng-click="onEdit()"><cv:msg key="action.edit" bundle="storage"/></a>
				<a ng-if="editing" ng-click="onSave()"><cv:msg key="action.save" bundle="storage"/></a>
			</span>
			 <ul class="list-style-secondary">
				 <li class="group"><span class="pageDetailColumn"><cv:msg key="label.amountCopies" bundle="storage"/></span>
					<span class="pageDetailColumn" >{{numberOfCopies}}</span>					 
				 </li>
				 <li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.deviceStreams" bundle="storage"/></span>
					<div class="pageDetailColumn max-width-200">
							<span ng-if="!editing">{{stream}}</span>
							<input ng-if="editing" type="number" name="input" ng-model="stream" min="0" ng-change="changeStreams(stream)">
					</div>
				 </li>
				 <li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.contentIndex" bundle="storage"/></span>
					<div class="pageDetailColumn">						
						<toggle-control 
							data-ng-class="{'enabled-activity': isIndexed, 'disabled-activity': !isIndexed, 'noToggle': !editing}"
							status="isIndexed ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="changeIsIndexed()" >
						</toggle-control>
					</div>
				 </li>
				 <li class="group" ng-if="isIndexed">
					 <span class="pageDetailColumn disabled"><cv:msg key="label.searchEngine" bundle="storage"/></span>
					 <div class="pageDetailColumn">
						<div class="form-group">
							<span ng-if="!editing">{{selectedSearchEngine.entityInfo.name}}</span>
							<div class="form-group max-width-200" ng-if="editing">
								<select name="repeatSelect" id="repeatSelect" ng-model="selectedSearchEngine.entityInfo.id" ng-change="changeSearchEngine(selectedSearchEngine)">
									<option ng-repeat="se in search_engines track by se.entityInfo.id" value="{{se.entityInfo.id}}">{{se.entityInfo.name}}</option>
								</select>
								<span class="error" data-ng-if="searchEngineError"><cv:msg key="error.searchEngine" bundle="storage" /></span>
							</div>
						</div>
					 </div>
				 </li>
			 </ul>
		 </cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-title='<cv:msg key="label.associatedPlans" bundle="storage" />'>
			<ul class="list-style-secondary" ng-if="plans.length > 0">
				<li class="group" ng-repeat="plan in plans track by plan.planId">
					<a href="#profileDetails/{{plan.planId | encodeParam}}">{{plan.planName}}</a>
				</li>
			</ul>
			<p class="margin-top-20" ng-if="plans.length === 0"><cv:msg key="label.noAssociatedPlans" bundle="storage" />.</p>
		</cv-tile-component>
	</div>
</div>
<cv-grid cv-grid-options="gridOptions"></cv-grid>
