<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages >
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages >
</script>
<h1 class="page-title">{{polyCopyName}}</h1>
<div class="group row" >
	<div class="col-md-6">
		 <cv-tile-component data-title='General'>
			<span class="page-details-box-links">
				<a ng-if="!editing.general && !isPrimary" ng-click="onEdit('general')">
					<cv:msg key="action.edit" bundle="storage"/>
				</a>
				<a ng-if="editing.general" ng-click="onGeneralSave()">
					<cv:msg key="action.save" bundle="storage"/>
				</a>
			</span>
			 <ul class="list-style-secondary">
				 <li class="group" ng-if="storagePoolName === ''">
					<span class="pageDetailColumn">
						<cv:msg key="label.nav.storage" bundle="navJs"/>
					</span>
					 <div class="pageDetailColumn">
						 <span>{{libraryName}}</span>
					 </div>
				 </li>
				 <li class="group" ng-if="storagePoolName!== ''">
					<span class="pageDetailColumn">
						<cv:msg key="label.storage" bundle="storage"/>
					</span>
					 <div class="pageDetailColumn">
						 <span>{{storagePoolName}}</span>
					 </div>
				 </li>
				 <li class="group" ng-if="!isPrimary">
					<span class="pageDetailColumn"><cv:msg key="label.selectiveCopy" bundle="storage"/></span>
					 <div class="pageDetailColumn">
						 <toggle-control
								 data-ng-class="{'enabled-activity': isSelectiveCopy, 'disabled-activity': !isSelectiveCopy, 'noToggle': !editing.general}"
								 status="isSelectiveCopy ? 'enabled-activity' : 'disabled-activity'"
								 data-ng-click="changeSelectiveCopy()"
								 >
						 </toggle-control>
					 </div>
				 </li>
				 <li class="group" ng-if="isSelectiveCopy && !isPrimary">
					 <span class="pageDetailColumn"><cv:msg key="label.backupsAtFreq" bundle="storage"/></span>
					 <div class="pageDetailColumn">
							 <span ng-if="!editing.general">{{selectedBackupFreq.label}}</span>
							 <div class="form-group max-width-200" ng-if="editing.general">
								 <select name="repeatSelect" id="repeatSelect" ng-model="selectedBackupFreq.value" ng-change="changeBackFreq(selectedBackupFreq)">
									 <option ng-repeat="backfreq in selectiveFreqs track by backfreq.value" value="{{backfreq.value}}">{{backfreq.label}}</option>
								 </select>
							 </div>
							<span ng-if="noSelectiveCopy" class="error">
								<cv:msg key="error.storagePolicyCopyBackupFreq.required" bundle="storage" />
							</span>
					 </div>
				 </li>
				 <li class="group" ng-if="!isPrimary">
					<span class="pageDetailColumn"><cv:msg key="label.throttleNetwork" bundle="storage"/></span>
					 <div class="pageDetailColumn">
						 <toggle-control
								 data-ng-class="{'enabled-activity': isThrottle, 'disabled-activity': !isThrottle, 'noToggle': !editing.general}"
								 status="isThrottle ? 'enabled-activity' : 'disabled-activity'"
								 data-ng-click="changeThrottle()"
								 >
						 </toggle-control>
					 </div>
				 </li>
				 <li class="group" ng-if="isThrottle && !isPrimary">
					<span class="pageDetailColumn"><cv:msg key="label.bandWidth" bundle="storage"/></span>
					<div class="pageDetailColumn">
						<span ng-if="!editing.general">{{policyBandwith}}</span>
						<label ng-if="editing.general">
							<input type="number" name="input" ng-model="policyBandwith" min="1" max="2000000" ng-change="changeBandwith(policyBandwith)">
						</label>
						<span>
							<cv:msg key="label.freqMeasure" bundle="storage" />
						</span>
					</div>
				 </li>
			 </ul>
		 </cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-title='Retention'>
			<span class="page-details-box-links">
				<a ng-if="!editing.retention" ng-click="onEdit('retention')">
					<cv:msg key="action.edit" bundle="storage" />
				</a>
				<a ng-if="editing.retention" ng-click="onSaveRetention()">
					<cv:msg key="action.save" bundle="storage" />
				</a>
			</span>
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.dataAging" bundle="storage" />
					</span>
					<div class="pageDetailColumn">
						<toggle-control
							data-ng-class="{'enabled-activity': isDataAging, 'disabled-activity': !isDataAging, 'noToggle': !editing.retention}"
							status="isDataAging ? 'enabled-activity' : 'disabled-activity'"
						 	data-ng-click="changeDataAging()">
						</toggle-control>
					</div>
				</li>
				<li ng-if="isDataAging && editing.retention" class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.infinite" bundle="storage" />
					</span>
					<div ng-if="editing.retention" class="pageDetailColumn" ng-click="changeRetentionInfinite()">
						<input ng-id="isInfiniteRetCheck" type="checkbox" data-ng-model="isInfinite" ng-disabled="!isDataAging" />
						<label ng-for="isInfiniteRetCheck" class="checkbox-label "></label>
					</div>
				</li>
				<li ng-if="isDataAging" class="group">
					<span class="pageDetailColumn">
						<cv:msg key="label.retention" bundle="storage" />
					</span>
					<span ng-if="!editing.retention" class="pageDetailColumn">{{policyRetention}}</span>
					<label ng-if="editing.retention">
						<input type="number" name="input" ng-model="policyRetentionValue" min="1" class="fixed-size-70"
							ng-disabled="isInfinite || !isDataAging" 
							ng-change="changePolicyRetention(policyRetentionValue)">
						<span>
							<cv:msg key="label.days" bundle="storage" />
						</span>
					</label>
					<p ng-if="extendedErrors.hasMainRetError" class="error">
						<cv:msg key="error.mainRetentionGreaterError" bundle="storage" />
					</p>
				</li>
				<li ng-if="!isInfinite && isDataAging" class="group">
					<a ng-if="!showExtended && !editing.retention" ng-click="onShowExtended()">
						<cv:msg key="label.showExtendedRetention" bundle="storage" />
					</a>
					<div ng-if="showExtended || editing.retention">
						<h4>
							<cv:msg key="label.extendedRetention" bundle="storage" />
						</h4>
						<p ng-if="extendedRetention.length === 0">
							<cv:msg key="label.noExtendedRetention" bundle="storage" />
						</p>
						<p ng-if="!editing.retention" ng-repeat="ret in extendedRetention">
							<span ng-if="(ret.result.endDays === -1)">
								<cv:msg key="label.infinite" bundle="storage" />
							</span>{{(ret.result.endDays === -1) ? '' : ret.result.endDays}} {{ret.label}}
						</p>
						<div class="addExtendedButtonClass">
							<a ng-if="extendedRetentionCount < 3 && editing.retention && !elemInfinite" ng-click="AddExtended()">
								<cv:msg key="action.add" bundle="storage" />
							</a>
						</div>
						<div ng-if="extendedRetentionCount !== 0 && editing.retention" class="form-group">
							<ul class="list-style-secondary">
								<li>
									<div class="retentionRulesDivison">
										<span class="small-retention-text">
											<b>
												<cv:msg key="label.number" bundle="storage" />
											</b>
										</span>
										<span class="small-retention-text">
											<b>
												<cv:msg key="label.infinite" bundle="storage" />
											</b>
										</span>
										<span class="small-retention-text flex-basis-fixed-40">
											<b>
												<cv:msg key="label.retention" bundle="storage" />
											</b>
										</span>
										<span>
											<b>
												<cv:msg key="label.cloudType" bundle="storage" />
											</b>
										</span>
										<span class="small-retention-text"></span>
									</div>
								</li>
								<li class="group" ng-repeat="ret in extendedRetention" ng-if="!ret.isHide">
									<div class="retentionRulesDivison">
										<span class="small-retention-text retentionRulesTag ">{{$index + 1}}</span>
										<span class="small-retention-text retentionRulesTag" ng-click="changeRetInfinite($index)">
											<input ng-id="isInfiniteRetCheck+{{$index}}" type="checkbox" data-ng-model="ret.isInfinite" ng-disabled="!ret.isEnabled"
											/>
											<label ng-for="isInfiniteRetCheck+{{$index}}" class="checkbox-label "></label>
										</span>
										<span class="small-retention-text flex-basis-fixed-40"> <!-- here -->
											<input type="number" name="input" ng-model="ret.retention" min="0" class="fixed-size-70"
												ng-disabled="ret.isInfinite || !ret.isEnabled" 
												ng-change="changeRetention($index,ret.retention)">
											<span>
												<cv:msg key="label.days" bundle="storage" />
											</span>
										</span>
										<span>
											<select name="repeatSelect" id="repeatSelect" ng-model="ret.selected" ng-change="changeSelection($index,ret.selected)" ng-disabled="!ret.isEnabled">
												<option ng-repeat="retentionType in extendedFreqs track by retentionType.value" value="{{retentionType.value}}">{{retentionType.label}}</option>
											</select>
										</span>
										<span class="small-retention-text retentionRulesTag" data-ng-click="removeRetention($index)">
											<a href="" ng-if="$index === (extendedRetentionCount - 1)" title="Delete">&times;</a>
										</span>
									</div>
									<p class="error" data-ng-if="extendedErrors.retentionError[$index]">{{extendedErrors.retentionError[$index]}}</p>
									<p class="error" data-ng-if="extendedErrors.typeError[$index]">{{extendedErrors.typeError[$index]}}</p>
									<p class="error" data-ng-if="extendedErrors.emptyError[$index]">{{extendedErrors.emptyError[$index]}}</p>
								</li>
							</ul>
						</div>
					</div>
				</li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-title='Copy Policy' ng-if="!isPrimary">
			<span class="page-details-box-links">
				<a ng-if="!editing.policy" ng-click="onEdit('policy')">
					<cv:msg key="action.edit" bundle="storage" />
				</a>
				<a ng-if="editing.policy" ng-click="onSavePolicyCopy()">
					<cv:msg key="action.save" bundle="storage" />
				</a>
			</span>
			<ul class="list-style-secondary">
				<!-- STARTS: backups setting -->
				<li class="group" ng-if="!editing.policy">
					<span class="pageDetailColumn">
						<cv:msg key="label.backupsOn" bundle="storage" />
					</span>
					<div class="pageDetailColumn">
						<span>{{policyBackups}}</span>
					</div>
				</li> <!-- ENDS: backups setting READ ONLY -->
				<li class="group" ng-if="!isSelectiveCopy && editing.policy">
					<span class="pageDetailColumn">
						<cv:msg key="label.allBackups" bundle="storage" />
					</span>
					<div class="pageDetailColumn">
						<toggle-control
							data-ng-class="allBackups ? 'enabled-activity' : 'disabled-activity'"
							status="allBackups ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="changeBackups()">
						</toggle-control>
					</div>
				</li> 
				<li class="group" ng-if="!allBackups && editing.policy">
					<span class="pageDetailColumn">
						<cv:msg key="label.backupsOn" bundle="storage" />
					</span>
					<div class="pageDetailColumn">
						<div class="input-group date max-width-200 full-width">
							<div class="cv-inline-wrapper calendar-wrapper date-picker date-input-icon">
								<input type="text" class="date-box" data-datetime-picker="MM/dd/yyyy" data-ng-model="datepicker.value" data-is-open="datepicker.open"
									data-datepicker-options="datepicker.dateOptions" enable-time="false" append-to-body="true" ng-change="changeDate(datepicker.value)"/>
								<span class="input-group-btn calendar-span">
									<button id="storagePolicyCopyDetails_button_#9406" type="button" class="btn btn-default" data-ng-click="openDateModal()"> 
										<i class="glyphicon glyphicon-calendar"></i>
									</button>
								</span>
							</div>
						</div>
					</div>
				</li> <!-- ENDS: backups setting -->
				<!-- STARTS: Source copy settings -->
				<li class="group" ng-if="auxCopyValues.length > 0">
					<span class="pageDetailColumn">
						<cv:msg key="label.auxiliaryCopy" bundle="storage" />
					</span>
					<div class="pageDetailColumn">
						<span ng-if="policySource && !editing.policy">{{policySource}}</span> <!-- READ ONLY -->
						<toggle-control ng-if="!policySource || editing.policy"
							data-ng-class="{'enabled-activity': auxCopy, 'disabled-activity': !auxCopy, 'noToggle': !editing.policy}"
							status="auxCopy ? 'enabled-activity' : 'disabled-activity'"
							data-ng-click="changeAuxCopy()">
					   </toggle-control>
					</div>
				</li> 
				<li class="group" ng-if="auxCopy && editing.policy">
					<span class="pageDetailColumn">
						<cv:msg key="label.setAuxiliaryCopy" bundle="storage" />
					</span>
					<span class="pageDetailColumn">
						<select class="max-width-200 full-width" name="repeatSelect" id="repeatSelect" ng-model="policySource" ng-change="changeSelectedAux(policySource)">
							<option value="" selected><cv:msg key="placeholder.selectSourceCopy" bundle="storage" /> </option>
							<option ng-show="isSelectiveCopy || !isSelectiveCopy && aux.copyType==1" ng-repeat="aux in auxCopyValues" value="{{aux.copyName}}">{{aux.copyName}}</option>
						</select>
						<div ng-if="policySourceCopyError" class="error">
							<cv:msg key="error.selectSourceCopyError" bundle="storage" />
						</div>
					</span>
				</li><!-- ENDS: Source copy settings -->
			</ul>
		</cv-tile-component>
	</div>
</div>
