<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<script nonce="${sessionScope.cspNonce}">
		<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	</script>
	<div class="setup-title">
		<h1 id="title" class="full-width"><cv:msg key="title.addStoragePolicy" bundle="storage" /></h1>
	</div>
	<div class="bootstrap-wrapper modal-margin margin-top-20" data-ng-controller="addStoragePolicyController">
	<form name="addProxyForm" class="form-horizontal" novalidate cv-submit="addPolicy()" autocomplete="off" class="add-proxy-form" data-ng-hide="showSkip || formConfig.hide">
	<p class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</p>
	<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="hostName"><cv:msg key="Name" bundle="storage" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input class="full-width" autofocus type="text" name="hostName" id="hostName" data-ng-model="name" />
				<span class="help-block" data-ng-if="nameError">{{nameError}}</span>
			</div>
	</div>
	<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="repeatSelect"><cv:msg key="label.storage" bundle="storage"/></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<select name="repeatSelect" id="repeatSelect" ng-model="selectedPool" ng-change="changePool(selectedPool)">
						<option ng-repeat="pool in pools" value="{{pool.storagePool}}">{{pool.storagePool.clientGroupName}}</option>
				</select>
				<span class="help-block" data-ng-if="poolError">{{poolError}}</span>
			</div>
	</div>
	<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="isInfiniteCheck"><cv:msg key="label.retention" bundle="storage"/></label>
			<div class="col-xs-12 col-md-3 col-lg-3">
				<input class="full-width" id="isInfiniteCheck" type="checkbox" data-ng-model="isInfinite" />
				<label for="isInfiniteCheck"><cv:msg key="label.infinite" bundle="storage" /></label>
			</div>
			<div class="col-xs-12 col-md-5 col-lg-5">
				<input type="number" name="input"
				id="input-days" ng-model="retentionRules" min="1" max="9999" ng-disabled="isInfinite" />
				<label for="input-days"><cv:msg key="label.days" bundle="storage" /></label>
				<span class="help-block" data-ng-if="retentionError">{{retentionError}}</span>
			</div>
	</div>
	<div class="button-container">
				<button id="addStoragePolicy_button_#5926" type="button" data-ng-if="setup" class="btn btn-default cvBusyOnAjax skip-btn--hidden" data-ng-click="skip()"><cv:msg key="Skip" /></button> 
				<button id="addStoragePolicy_button_#4469" type="button" data-ng-if="!setup" class="btn btn-default cvBusyOnAjax" data-ng-click="close()"><cv:msg key="Cancel" /></button> 
				<button id="addStoragePolicy_button_#8744" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save"/></button> 
	</div>
	</form>
	</div>
