import { commonStoragePolicy } from 'common/js/modules';

commonStoragePolicy.service('storagePolicyService', [
	'$http',
	function($http) {
		this.getAllStoragePolicies = function(propertyLevel = 10) {
			const request = $http.get(
				`proxy/V2/StoragePolicy?propertyLevel=${propertyLevel}`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getStoragePolicyDetails = function(storagePolicyId, propertyLevel = 30) {
			const request = $http.get(
				`proxy/V2/StoragePolicy/${storagePolicyId}?propertyLevel=${propertyLevel}`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.deleteStoragePolicy = function(storagePolicyId) {
			const request = $http.delete(`proxy/V2/StoragePolicy/${storagePolicyId}`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.deleteStoragePolicyCopy = function(storagePolicyId, copyId) {
			const request = $http.delete(
				`proxy/V2/StoragePolicy/${storagePolicyId}/Copy/${copyId}`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getStoragePolicyCopyDetails = function(storagePolicyId, copyId) {
			const request = $http.get(
				`proxy/V2/StoragePolicy/${storagePolicyId}/Copy/${copyId}`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.createStoragePolicy = function(data) {
			const request = $http.post(`proxy/V2/StoragePolicy`, JSON.stringify(data), httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.createStoragePolicyCopy = function(storagePolicyId, data) {
			const request = $http.post(
				`proxy/V2/StoragePolicy/${storagePolicyId}/Copy`,
				JSON.stringify(data),
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.updateStoragePolicy = function(storagePolicyId, data) {
			const request = $http.put(
				`proxy/V2/StoragePolicy/${storagePolicyId}`,
				JSON.stringify(data),
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.updateStoragePolicyCopy = function(storagePolicyId, copyId, data) {
			const request = $http.put(
				`proxy/V2/StoragePolicy/${storagePolicyId}/Copy/${copyId}`,
				JSON.stringify(data),
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getStoragePolicySearchEngines = function(storagePolicyId) {
			const request = $http.get(
				`proxy/V2/StoragePolicy/${storagePolicyId}/SearchEngineProperties`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.editStoragePolicySearchEngines = function(storagePolicyId, data) {
			const request = $http.put(
				`proxy/V2/StoragePolicy/${storagePolicyId}/SearchEngineProperties`,
				JSON.stringify(data),
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};

		this.getSearchEngines = function() {
			const request = $http.get(`proxy/SearchEngines`, httpHeader['jsonDefaultHeader']);
			return request;
		};

		this.getCopySize = function(storagePolicyId, copyId) {
			const request = $http.get(
				`proxy/V2/StoragePolicy/${storagePolicyId}/Copy/${copyId}/Size`,
				httpHeader['jsonDefaultHeader']
			);
			return request;
		};
	}
]);

export default commonStoragePolicy;
