import 'modules/storage/js/controllers/storage.ctrl.js';
import 'storage/js/services/storage.svc.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc.js';

import { commonStoragePolicy } from 'common/js/modules';

var storagePolicyMod = commonStoragePolicy;

var storagePolicyControllers = {};

storagePolicyControllers.storagePolicyCopyDetailsController = [
	'$q',
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'storagePolicyService',
	function(
		$q,
		$scope,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		storagePolicyService
	) {
		$scope.isDirty = false;
		$scope.policyDirty = false;
		$scope.showExtended = false;
		$scope.noSelectiveCopy = false;
		$scope.polyCopyName = '';
		$scope.policyRetentionValue = null;
		$scope.isPrimary = false;
		$scope.policyBandwith = null;
		$scope.elemInfinite = false;
		$scope.policySourceCopyError = false;
		$scope.auxCopyValues = [];

		$scope.policySource = null;
		$scope.auxCopy = false;

		$scope.storagePolicyId = $stateParams['storagePolicyId'];
		$scope.storagePolicyName = $stateParams['storagePolicyName'];
		$scope.storagePolicyCopyId = $stateParams['storagePolicyCopyId'];

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.storagePolicy'),
				link: '#storagePolicies'
			},
			{
				title: $scope.storagePolicyName,
				link: '#/storagePolicyInfo?storagePolicyId=' + encodeURIComponent($scope.storagePolicyId)
			}
		]);

		$scope.editing = {
			general: false,
			retention: false,
			policy: false
		};

		$scope.extendedErrors = {
			hasRetError: false,
			retentionError: ['', '', ''],
			hasTypError: false,
			typeError: ['', '', ''],
			hasMainRetError: false,
			emptyError: ['', '', '']
		};

		$scope.datepicker = {
			open: false,
			dateOptions: {
				dateFormat: 'YYYY-MM-DD',
				showWeeks: false
			},
			value: setNewDateCVStandard()
		};

		$scope.openDateModal = () => {
			$scope.policyDirty = true;
			$scope.datepicker.open = !$scope.datepicker.open;
		};

		$scope.generalFreqs = identifier => {
			const result = [
				{ value: `${identifier}_ALLFULL`, label: cvLoc('label.allFull') },
				{ value: `${identifier}_HOUR`, label: cvLoc('label.hourlyFull') },
				{ value: `${identifier}_DAY`, label: cvLoc('label.dailyFull') },
				{ value: `${identifier}_WEEK`, label: cvLoc('label.weeklyFull') },
				{ value: `${identifier}_MONTH`, label: cvLoc('label.monthlyFull') },
				{ value: `${identifier}_QUARTER`, label: cvLoc('label.quarterlyFull') },
				{ value: `${identifier}_HALFYEAR`, label: cvLoc('label.halfYearlyFull') },
				{ value: `${identifier}_YEAR`, label: cvLoc('label.yearlyFull') }
			];
			return result;
		};
		$scope.extendedFreqs = $scope.generalFreqs('EXTENDED');
		$scope.selectiveFreqs = $scope.generalFreqs('SELECTIVE');

		// **************************************
		// 	Initialize controller
		// **************************************
		const requestPromises = [
			storagePolicyService.getStoragePolicyCopyDetails($scope.storagePolicyId, $scope.storagePolicyCopyId),
			storagePolicyService.getStoragePolicyDetails($scope.storagePolicyId) // get the copies list
		];

		$q.all(requestPromises)
			.then(([{ data: policyCopyDetailsData }, { data: policyDetailsData }]) => {
				const { copy, error: ErrorPolicyCopyDetailsData } = policyCopyDetailsData;
				const { policies, error: ErrorPolicyDetailsData } = policyDetailsData;
				let selectedSourceCopy = null;
				const thereWasAnError =
					!ErrorPolicyCopyDetailsData ||
					!ErrorPolicyDetailsData ||
					ErrorPolicyDetailsData.errorCode !== 0 ||
					ErrorPolicyCopyDetailsData.errorCode !== 0;

				if (thereWasAnError) {
					$log.error(cvLoc('error.loadingStoragePolicyDetails'));
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				} else {
					$scope.processGetCopyDetails({ copy }); // main process for configuration
					selectedSourceCopy = copy.sourceCopy;
					const policy = policies && policies.length > 0 ? policies[0] : null;
					if (policy !== null) {
						if (policy.copies.length > 0) {
							policy.copies.forEach(node => {
								const { StoragePolicyCopy } = node;
								StoragePolicyCopy.copyType = node.copyType;
								if (
									!node.isDefault &&
									StoragePolicyCopy.copyId !== Number($scope.storagePolicyCopyId) &&
									node.isSnapCopy === 0
								) {
									$scope.auxCopyValues.push(StoragePolicyCopy);
								}

								if (selectedSourceCopy && selectedSourceCopy.copyId === StoragePolicyCopy.copyId) {
									$scope.policySource = node.isDefault ? null : selectedSourceCopy.copyName;
									$scope.auxCopy = !node.isDefault; // must show option if not the default
								}
							});
						}
					}
				}
			})
			.catch(e => {
				$scope.storagePolicyMessage = cvUtil.errMsg(e);
			});

		// **************************************
		// 	Functions
		// **************************************

		$scope.processGetCopyDetails = data => {
			$scope.isPrimary = data.copy.isDefault && data.copy.isDefault === 1;
			$scope.polyCopyName = data.copy.StoragePolicyCopy.copyName;
			$scope.policyBandwith = data.copy.throttleNetworkBandWidthMBHR;
			$scope.storagePoolName = data.copy.storagePool.storagePoolName;
			$scope.libraryName = data.copy.library.libraryName;

			$scope.originalData = {
				storagePolicyCopyInfo: data.copy
			};
			$scope.originalData.storagePolicyCopyInfo.StoragePolicyCopy['storagePolicyName'] = $scope.storagePolicyName;
			$scope.originalData.storagePolicyCopyInfo.StoragePolicyCopy['storagePolicyId'] = +$scope.storagePolicyId;

			if (data.copy.selectiveCopyRules) {
				$scope.isSelectiveCopy = true;
				$scope.selectedBackupFreq = $scope.getSelectiveType(data.copy.selectiveCopyRules.selectiveRule);
			}

			if (data.copy.throttleNetworkBandWidthMBHR && data.copy.throttleNetworkBandWidthMBHR >= 0) {
				$scope.isThrottle = true;
				$scope.policyBandwith = data.copy.throttleNetworkBandWidthMBHR;
			}

			if (data.copy.startTime.time !== -1) {
				$scope.allBackups = false;
				$scope.datepicker.value = new Date(data.copy.startTime.time * 1000);
				$scope.policyBackups = $scope.datepicker.value.toLocaleString().split(',')[0];
			} else {
				$scope.datepicker.value = setNewDateCVStandard();
				$scope.allBackups = true;
				$scope.policyBackups = cvLoc('label.allBackups');
			}

			$scope.isDataAging = data.copy.retentionRules.retentionFlags.enableDataAging === 0 ? false : true;
			$scope.policyRetention =
				data.copy.retentionRules.retainBackupDataForDays === -1 &&
				data.copy.retentionRules.retainBackupDataForCycles === -1
					? cvLoc('label.infinite')
					: data.copy.retentionRules.retainBackupDataForDays + ' ' + cvLoc('label.days');
			$scope.policyRetentionValue =
				data.copy.retentionRules.retainBackupDataForDays === -1 ? 30 : data.copy.retentionRules.retainBackupDataForDays;
			$scope.isInfinite =
				data.copy.retentionRules.retainBackupDataForDays === -1 &&
				data.copy.retentionRules.retainBackupDataForCycles === -1;
			$scope.retentionValue =
				data.copy.retentionRules.retainBackupDataForCycles === -1
					? 30
					: data.copy.retentionRules.retainBackupDataForDays;

			$scope.extendedRetention = [];

			const retentionOne = data.copy.retentionRules.extendedRetentionRuleOne;
			let selectiveType = null;
			if (retentionOne) {
				selectiveType = $scope.getSelectiveType(retentionOne.rule, 'EXTENDED');
				retentionOne.rule = selectiveType.value;
				const obj = {
					isInfinite: retentionOne.endDays === -1 ? true : false,
					selected: retentionOne.rule,
					retention: retentionOne.endDays === -1 ? 90 : retentionOne.endDays,
					isEnabled: retentionOne.isEnabled === 1 ? true : false,
					result: retentionOne,
					isHide: false,
					label: cvLoc('label.days') + ' ' + selectiveType.label
				};
				$scope.elemInfinite = !$scope.elemInfinite ? obj.isInfinite : false;
				$scope.extendedRetention.push(obj);
				const retentionTwo = data.copy.retentionRules.extendedRetentionRuleTwo;
				if (retentionTwo) {
					selectiveType = $scope.getSelectiveType(retentionTwo.rule, 'EXTENDED');
					retentionTwo.rule = selectiveType.value;
					const obj2 = {
						isInfinite: retentionTwo.endDays === -1 ? true : false,
						selected: retentionTwo.rule,
						retention: retentionTwo.endDays === -1 ? 365 : retentionTwo.endDays,
						isEnabled: retentionTwo.isEnabled === 1 ? true : false,
						result: retentionTwo,
						isHide: false,
						label: cvLoc('label.days') + ' ' + selectiveType.label
					};
					$scope.elemInfinite = !$scope.elemInfinite ? obj2.isInfinite : false;
					$scope.extendedRetention.push(obj2);
					const retentionThree = data.copy.retentionRules.extendedRetentionRuleThree;
					if (retentionThree) {
						selectiveType = $scope.getSelectiveType(retentionThree.rule, 'EXTENDED');
						retentionThree.rule = selectiveType.value;
						const obj3 = {
							isInfinite: retentionThree.endDays === -1 ? true : false,
							selected: retentionThree.rule,
							retention: retentionThree.endDays === -1 ? 1825 : retentionThree.endDays,
							isEnabled: retentionThree.isEnabled === 1 ? true : false,
							result: retentionThree,
							isHide: false,
							label: cvLoc('label.days') + ' ' + selectiveType.label
						};
						$scope.elemInfinite = !$scope.elemInfinite ? obj3.isInfinite : false;
						$scope.extendedRetention.push(obj3);
					}
				}
			}
			$scope.extendedRetentionCount = $scope.extendedRetention.length;
			$scope.initialRetention = $scope.extendedRetentionCount;
		};

		$scope.changeBackFreq = selectedBackupFreq => {
			$scope.selectedBackupFreq = selectedBackupFreq;
			$scope.isDirty = true;
		};

		$scope.getSelectiveType = (type, ext = 'SELECTIVE') => {
			switch (type) {
				case 2:
					return { value: ext + '_ALLFULL', label: cvLoc('label.allFull') };
				case 4:
					return { value: ext + '_WEEK', label: cvLoc('label.weeklyFull') };
				case 8:
					return { value: ext + '_MONTH', label: cvLoc('label.monthlyFull') };
				case 16:
					return { value: ext + '_QUARTER', label: cvLoc('label.quarterlyFull') };
				case 32:
					return { value: ext + '_HALFYEAR', label: cvLoc('label.halfYearlyFull') };
				case 64:
					return { value: ext + '_YEAR', label: cvLoc('label.yearlyFull') };
				case 262144:
					return { value: ext + '_HOUR', label: cvLoc('label.hourlyFull') };
				case 524288:
					return { value: ext + '_DAY', label: cvLoc('label.dailyFull') };
			}
		};

		$scope.onShowExtended = () => {
			$scope.showExtended = !$scope.showExtended;
		};

		$scope.changeSelectiveCopy = function() {
			$scope.noSelectiveCopy = false;
			if ($scope.editing.general) {
				$scope.isSelectiveCopy = !$scope.isSelectiveCopy;
				$scope.isDirty = true;
			}
		};
		$scope.changeThrottle = function() {
			if ($scope.editing.general) {
				$scope.isThrottle = !$scope.isThrottle;
				$scope.isDirty = true;
				$scope.policyBandwith = $scope.policyBandwith ? $scope.policyBandwith : 500;
			}
		};
		$scope.changeBandwith = value => {
			$scope.policyBandwith = value;
			$scope.isDirty = true;
		};

		$scope.onEdit = type => {
			const currentEditingArray = Object.keys($scope.editing).filter(item => {
				return $scope.editing[item] === true;
			});

			let isCurrentEditing = false;
			if (currentEditingArray.length > 0 && currentEditingArray[0] !== 'undefined' && currentEditingArray[0] !== type) {
				isCurrentEditing = true;
			}

			if (isCurrentEditing) {
				var callBackFunctions = {
					noFunction: () => {},
					yesFunction: () => {
						$state.forceReload();
					}
				};
				$dialogs.confirm(cvLoc('label.confirmNavigation'), cvLoc('label.changeEdit'), callBackFunctions);
			} else {
				$scope.edition(type);
			}
		};

		$scope.edition = type => {
			$scope.editing = {
				general: false,
				retention: false,
				policy: false
			};
			$scope.editing[type] = !$scope.editing[type];
		};

		$scope.onSave = value => {
			if ($scope.isDirty) {
				var callBackFunctions = {
					noFunction: () => {
						$scope.editing[value] = false;
						$state.forceReload();
					},
					yesFunction: () => {
						switch (value) {
							case 'general':
								$scope.processSave();
								break;
							case 'retention':
								$scope.editPolicyRetention();
								break;
							case 'policy':
								$scope.editPolicy();
								break;
						}

						storagePolicyService
							.updateStoragePolicyCopy($scope.storagePolicyId, $scope.storagePolicyCopyId, $scope.originalData)
							.success(function(data) {
								if (!data.error || data.error.errorCode === 0) {
									$log.debug(cvLoc('log.succesUpdatePolicy'));
									$state.forceReload();
								} else {
									$log.error(cvLoc('log.errorUpdatePolicy'));
									$dialogs.error(cvLoc('label.error'), data.error.errorMessage).result.then(function() {
										$state.forceReload();
									});
								}
							})
							.error(function(data) {
								$log.error(cvLoc('log.errorUpdatePolicy'));
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message).result.then(function() {
									$state.forceReload();
								});
							});
					}
				};

				$dialogs.confirm(
					cvLoc('title.confirmStoragePolicy'),
					cvLoc('label.confirmStoragePolicyEdit'),
					callBackFunctions
				);
			} else {
				$scope.editing[value] = false;
			}
		};

		$scope.onSaveRetention = () => {
			let pass = true;
			let infinite = false;
			const arrayToValidate = $scope.extendedRetention.filter(elem => !elem.isHide);
			arrayToValidate.forEach((elem, index) => {
				if (infinite) {
					$scope.extendedRetention[index].isEnabled = 0;
					return;
				}
				if (elem.isInfinite) {
					infinite = true;
				}
				if (elem.selected === '') {
					if (elem.isInfinite) {
						infinite = true;
						pass = false;
						$scope.extendedErrors.emptyError[index] = cvLoc('error.noRetention');
						return;
					} else {
						if (infinite) {
							$scope.extendedRetention[index].isEnabled = 0;
							return;
						} else {
							pass = false;
							$scope.extendedErrors.emptyError[index] = cvLoc('error.noRetention');
							return;
						}
					}
				}
			});
			if (
				!$scope.extendedErrors.hasRetError &&
				!$scope.extendedErrors.hasTypError &&
				!$scope.extendedErrors.hasMainRetError &&
				pass
			) {
				$scope.onSave('retention');
			}
		};

		$scope.onGeneralSave = () => {
			if ($scope.isSelectiveCopy) {
				$scope.selectedBackupFreq && $scope.selectedBackupFreq.value !== ''
					? $scope.onSave('general')
					: ($scope.noSelectiveCopy = true);
			} else {
				$scope.onSave('general');
			}
		};

		$scope.onSavePolicyCopy = () => {
			$scope.policySourceCopyError = $scope.auxCopy && $scope.policySource === null;
			if (!$scope.policySourceCopyError || $scope.auxCopyValues.length === 0) {
				$scope.onSave('policy');
			}
		};

		$scope.processSave = () => {
			if ($scope.isSelectiveCopy) {
				$scope.originalData.storagePolicyCopyInfo.copyType = 'SELECTIVE';
				$scope.originalData.storagePolicyCopyInfo['selectiveCopyRules'] = {
					selectiveRule: $scope.selectedBackupFreq.value,
					dayStartsAt: {
						dayStartsHoursMinutes: {
							hours: 12,
							minutes: 0,
							seconds: 0
						},
						amOrPm: 1
					},
					weekDayStartsOn: 5,
					monthStartsOn: 1
				};
			} else {
				$scope.originalData.storagePolicyCopyInfo.copyType = 'SYNCHRONOUS';
				delete $scope.originalData.storagePolicyCopyInfo['selectiveCopyRules'];
			}

			$scope.originalData.storagePolicyCopyInfo.throttleNetworkBandWidthMBHR = $scope.isThrottle
				? $scope.policyBandwith
				: 0;
		};

		$scope.editPolicyRetention = () => {
			$scope.originalData.storagePolicyCopyInfo['retentionRules'] = {
				retainBackupDataForCycles: !$scope.isInfinite ? 1 : -1,
				retainBackupDataForDays: !$scope.isInfinite ? $scope.policyRetentionValue : -1,
				retainArchiverDataForDays: -1,
				retentionFlags: {
					enableDataAging: $scope.isDataAging ? 1 : 0
				}
			};

			delete $scope.originalData.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleOne'];
			delete $scope.originalData.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleTwo'];
			delete $scope.originalData.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleThree'];

			let newExtendedRetention = $scope.extendedRetention.filter(elem => !elem.isHide);
			let isValid = true;
			let index = 0;
			if (!$scope.isInfinite || $scope.initialRetention > 0) {
				newExtendedRetention.forEach(elem => {
					const keyLabelIndex = index === 0 ? 'One' : index === 1 ? 'Two' : 'Three';
					const realKey = 'extendedRetentionRule' + keyLabelIndex;
					if (elem.selected !== '' && (isValid || $scope.initialRetention > index)) {
						$scope.originalData.storagePolicyCopyInfo.retentionRules[realKey] = {
							isEnabled: $scope.isInfinite ? 0 : !isValid ? 0 : 1,
							rule: elem.result.rule,
							endDays: elem.isInfinite ? -1 : elem.result.endDays
						};
					}
					isValid = isValid ? !elem.isInfinite : false;
					index += 1;
				});
				if (newExtendedRetention.length < $scope.initialRetention) {
					const emptyArray = $scope.extendedRetention.filter(elem => elem.isHide);

					while (index < $scope.initialRetention) {
						const elem = emptyArray.pop();
						const keyLabelIndex = index === 0 ? 'One' : index === 1 ? 'Two' : 'Three';
						const realKey = 'extendedRetentionRule' + keyLabelIndex;
						if (elem.selected !== '') {
							$scope.originalData.storagePolicyCopyInfo.retentionRules[realKey] = {
								isEnabled: 0,
								rule: elem.result.rule,
								endDays: elem.isInfinite ? -1 : elem.result.endDays
							};
						}
						index += 1;
					}
				}
			}
		};

		$scope.editPolicy = () => {
			if ($scope.policyDirty) {
				$scope.originalData.storagePolicyCopyInfo['startTime'] = {
					time: !$scope.allBackups ? Math.round($scope.datepicker.value.getTime() / 1000) : -1
				};

				if ($scope.auxCopy) {
					$scope.originalData.storagePolicyCopyInfo['sourceCopy'] = $scope.auxCopyValues.find(
						val => val.copyName === $scope.policySource
					);
				} else {
					$scope.originalData.storagePolicyCopyInfo['sourceCopy'] = {
						copyId: 0,
						copyName: ''
					};
				}
			}
		};

		$scope.changeDataAging = function() {
			if ($scope.editing.retention) {
				$scope.isDataAging = !$scope.isDataAging;
				$scope.isDirty = true;
			}
		};

		$scope.changeRetentionInfinite = () => {
			$scope.isInfinite = !$scope.isInfinite;
			$scope.isDirty = true;
		};

		$scope.AddExtended = () => {
			const lengthValue = $scope.extendedRetention.length;
			$scope.extendedRetentionCount = $scope.extendedRetention.filter(item => !item.isHide).length;
			if ($scope.extendedRetentionCount == 0) {
				$scope.extendedRetention = [];
			}
			const days = lengthValue === 0 ? 90 : lengthValue === 1 ? 365 : 1825;
			const obj = {
				isInfinite: false,
				selected: '',
				retention: days,
				isEnabled: true,
				isHide: false,
				label: '',
				result: {
					isEnabled: 1,
					rule: '',
					endDays: days,
					graceDays: days,
					everyXHours: '',
					rulename: ''
				}
			};
			$scope.extendedRetention.push(obj);
			$scope.extendedRetentionCount = $scope.extendedRetention.filter(item => !item.isHide).length;
			$scope.isDirty = true;
		};

		$scope.checkRetentionValues = (index, array) => {
			$scope.extendedErrors.hasMainRetError = $scope.policyRetentionValue >= array[index].retention;
			$scope.extendedErrors.hasRetError = false;
			$scope.extendedErrors.retentionError = ['', '', ''];
			array.forEach((elem, i) => {
				if (i < index && elem.retention >= array[index].retention && !elem.isInfinite) {
					$scope.extendedErrors.hasRetError = true;
					$scope.extendedErrors.retentionError[i] = cvLoc('error.retentionLowerError');
				} else if (i > index && elem.retention <= array[index].retention && !elem.isInfinite) {
					$scope.extendedErrors.hasRetError = true;
					$scope.extendedErrors.retentionError[i] = cvLoc('error.retentionGreaterError');
				}
			});
		};

		$scope.checkRetentionType = (index, array) => {
			$scope.extendedErrors.hasTypError = false;
			$scope.extendedErrors.typeError = ['', '', ''];

			const index1 = $scope.extendedFreqs.findIndex(elem => elem.value === array[index].result.rule);
			let index2;
			array.forEach((elem, i) => {
				index2 = $scope.extendedFreqs.findIndex(elem2 => elem2.value === elem.result.rule);
				if (i < index && index2 >= index1 && index2 !== -1) {
					$scope.extendedErrors.hasTypError = true;
					$scope.extendedErrors.typeError[i] = cvLoc('error.retentionLowerError');
				} else if (i > index && index2 <= index1 && index2 !== -1) {
					$scope.extendedErrors.hasTypError = true;
					$scope.extendedErrors.typeError[i] = cvLoc('error.retentionGreaterError');
				}
			});
		};

		$scope.changeRetInfinite = index => {
			if ($scope.extendedRetention[index].isEnabled) {
				$scope.extendedRetention[index].isInfinite = !$scope.extendedRetention[index].isInfinite;
				$scope.extendedRetention[index].result.endDays = $scope.extendedRetention[index].isInfinite
					? -1
					: $scope.extendedRetention[index].retention;
				$scope.checkDisabled(index, $scope.extendedRetention);
			}
			$scope.isDirty = true;
		};

		$scope.checkDisabled = (index, array) => {
			let isInfinite = array[index].isInfinite;
			$scope.elemInfinite = isInfinite;
			array.forEach((elem, i) => {
				if (i > index) {
					elem.isEnabled = !isInfinite;
					elem.result.isEnabled = isInfinite ? 0 : 1;
					if (!isInfinite) {
						isInfinite = elem.isInfinite;
					}
					if (!$scope.elemInfinite && isInfinite) {
						$scope.elemInfinite = isInfinite;
					}
				}
			});
		};

		$scope.changeRetention = (index, value) => {
			$scope.extendedRetention[index].retention = value;
			$scope.extendedRetention[index].result.endDays = value;
			$scope.checkRetentionValues(index, $scope.extendedRetention);
			$scope.isDirty = true;
		};

		$scope.changeSelection = (index, result) => {
			const elem = $scope.extendedFreqs.find(ex => ex.value === result);
			$scope.extendedRetention[index].selected = result;
			$scope.extendedRetention[index].label = cvLoc('label.days') + ' ' + elem.label;
			$scope.extendedRetention[index].result.rule = result;
			$scope.extendedErrors.emptyError[index] = '';
			$scope.checkRetentionType(index, $scope.extendedRetention);
			$scope.isDirty = true;
		};
		$scope.changePolicyRetention = value => {
			$scope.policyRetentionValue = value;
			$scope.extendedErrors.hasMainRetError = false;

			$scope.extendedRetention.forEach(elem => {
				if ($scope.policyRetentionValue >= elem.retention && !elem.isInfinite) {
					$scope.extendedErrors.hasMainRetError = true;
				}
			});
			$scope.isDirty = true;
		};

		$scope.changeSelectedAux = value => {
			$scope.policyDirty = true;
			$scope.policySource = value;
			$scope.isDirty = true;
			$scope.policySourceCopyError = false;
		};

		$scope.changeAuxCopy = () => {
			if ($scope.editing.policy) {
				$scope.policyDirty = true;
				$scope.auxCopy = !$scope.auxCopy;
				$scope.isDirty = true;
			}
		};

		$scope.changeDate = date => {
			$scope.policyDirty = true;
			$scope.isDirty = true;
			$scope.datepicker.value = date;
			$scope.datepicker.value.setHours(0, 0, 0, 0);
		};

		$scope.changeBackups = () => {
			if (!$scope.isSelectiveCopy) {
				$scope.policyDirty = true;
				$scope.allBackups = !$scope.allBackups;
			}
			$scope.isDirty = true;
		};

		$scope.removeRetention = index => {
			if (index === $scope.extendedRetentionCount - 1) {
				$scope.extendedRetention[index].isEnabled = false;
				$scope.extendedRetention[index].isHide = true;
			}
			$scope.isDirty = true;
			$scope.extendedRetentionCount = $scope.extendedRetention.filter(item => !item.isHide).length;
		};

		/**
		 * CV Date Standard object when you set new date, the time must be set as 00:00:00
		 */
		function setNewDateCVStandard() {
			var d = new Date();
			d.setHours(0, 0, 0, 0);
			return d;
		}
	}
];

storagePolicyMod.controller(storagePolicyControllers);

export default storagePolicyMod;
