import 'modules/policies/storagePolicy/js/controllers/addStoragePolicy.ctrl.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/controllers/storage.ctrl.js';
import 'vsa/js/controllers/collections.ctrl.js';
import 'storage/js/services/storage.svc.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc.js';

import { getStoragePoliciesTemplates } from 'modules/policies/storagePolicy/js/controllers/storagePolicy.column.template.js';

import { commonStoragePolicy } from 'common/js/modules';

var storagePolicyMod = commonStoragePolicy;

storagePolicyMod.factory('openCustomRangeModal', function() {
	var factory = {
		openDate: null
	};
	factory.openDate = function($scope, $rootScope, $modal, cvLoc) {
		var modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'common/partials/dateRangeSelector.jsp',
			backdrop: 'static',
			controller: [
				'$scope',
				'$uibModalInstance',
				'cvMaxRangeAllowed',
				function($scope, $modalInstance, cvMaxRangeAllowed) {
					$scope.clear = function() {
						$modalInstance.dismiss('clear');
					};

					$scope.saveDateRange = function() {
						$modalInstance.close({
							start: $scope.datepicker.from.value
						});
					};

					// date and time picker options
					$scope.datepicker = {
						from: {
							open: false,
							dateOptions: {
								dateFormat: 'yyyy-MM-dd',
								showWeeks: false
							},
							timeOptions: {
								max: null
							},
							value: new Date()
						}
					};
					$scope.open = function(openToDate) {
						$scope.datepicker[openToDate].open = !$scope.datepicker[openToDate].open;
					};

					$scope.$watchGroup(['datepicker.from.value', 'datepicker.to.value'], function(newValues) {
						// set max value of "from" datepicker as "to" value
						$scope.datepicker.from.dateOptions.maxDate = newValues[1];
						$scope.datepicker.from.timeOptions.max = newValues[1];
					});
				}
			],
			resolve: {
				cvMaxRangeAllowed: function() {
					return $scope.cvMaxRangeAllowed;
				}
			}
		});
		modalInstance.result.then(
			function(range) {
				if (range.start && range.end) {
					$scope.isCustomRange = true;
					$scope.selectedRange = range;
					$scope.selectedRangeString = cvUtil.dateRangeToString($scope.selectedRange.start, $scope.selectedRange.end);
					$scope.ngModel = angular.toJson($scope.selectedRange);
				} else {
					$scope.isCustomRange = false;
					$scope.ngModel = '';
				}
				// call the handler
				$scope.externalCallback();
			},
			function(obj) {
				if (obj === 'close') {
					// x on top the modal is clicked
					if ($scope.selectedRange === 'Custom') {
						// treat as clear button is invoked
						$scope.isCustomRange = false;
						$scope.selectedRange = undefined;
						$scope.ngModel = '';
						$scope.externalCallback();
					}
					// else do nothing
				} else if (obj === 'clear') {
					// clear button is invoked
					$scope.isCustomRange = false;
					$scope.selectedRange = undefined;
					$scope.ngModel = '';
					$scope.externalCallback();
				}
			}
		);
	};
	return factory;
});

var storagePolicyControllers = {};

storagePolicyControllers.storagePolicyController = [
	'$scope',
	'$http',
	'$rootScope',
	'$uibModal',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'$location',
	'storagePolicyService',
	'cvToaster',
	'$filter',
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$compile',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$http,
		$rootScope,
		$modal,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		$location,
		storagePolicyService,
		cvToaster,
		$filter,
		ENTITY_TYPES,
		cvPermissionFactory,
		$compile,
		cvBreadcrumbsTabsFactory
	) {
		$scope.storagePolicyMessage = {
			message: cvLoc('label.loading'),
			type: 'ok'
		};

		let _setupBreadCrumbs = () => {
			let breadCrumbs = [];

			breadCrumbs.push({
				title: cvLoc('label.nav.policies'),
				link: '#nav/policies'
			});

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
		};

		_setupBreadCrumbs();

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		// **************************************
		// 	Functions
		// **************************************

		$scope.showAddStoragePolicyDialog = function() {
			var uibModalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/policies/storagePolicy/partials/addStoragePolicy.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					function($scope, $uibModalInstance) {
						$scope.proxyType = null;
						$scope.clientName = cvLoc('label.gatewayClientName');
						$scope.close = function() {
							$uibModalInstance.dismiss();
						};
					}
				]
			});
			uibModalInstance.result.then(function() {
				$state.reload();
			});
			return uibModalInstance;
		};

		$scope.deleteStoragePolicy = function(storagePolicyId, storagePolicyName) {
			var callBackFunctions = {
				noFunction: () => {},
				yesFunction: () => {
					storagePolicyService
						.deleteStoragePolicy(storagePolicyId)
						.success(data => {
							if (!data.error || data.error.errorCode === 0) {
								$log.debug(cvLoc('log.succesDeletePolicy'));
								$state.forceReload();
							} else {
								$log.error(cvLoc('error.deletePolicyCopy'));
								cvToaster.showErrorMessageWrapper(data.error);
							}
						})
						.error(function(data) {
							cvToaster.showErrorMessageWrapper(data);
							$log.error(cvLoc('error.deletePolicyCopy'));
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationStoragePool', '<b>' + storagePolicyName + '</b>'),
				callBackFunctions
			);
		};

		//	**************************************
		//		Initialize controller
		//	**************************************

		angular.extend(globalGridOptions, {
			data: 'policies',
			columnDefs: [
				{
					field: 'storagePolicy.storagePolicyName',
					displayName: cvLoc('Name'),
					enableHiding: false,
					sort: {
						direction: 'asc',
						priority: 0
					},
					cellClass: 'crop',
					cellTemplate:
						'' +
						'<div>' +
						'<a href="#storagePolicyInfo?storagePolicyId={{row.entity.storagePolicy.storagePolicyId | encodeParam}}">{{row.entity.storagePolicy.storagePolicyName}}</a>' +
						'</div>'
				},
				{
					field: 'numberOfStreams',
					displayName: cvLoc('label.streams'),
					enableFiltering: false
				},
				{
					name: cvLoc('Actions'),
					cellTooltip: true,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"> <li>' +
						'<a class="crop" data-ng-click="grid.appScope.deleteStoragePolicy(row.entity.storagePolicy.storagePolicyId, row.entity.storagePolicy.storagePolicyName);">' +
						cvLoc('action.delete') +
						'</a></li></ul></div>',
					width: '7%',
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false
				}
			]
		});

		$scope.gridOptions = {
			cvGridTitle: 'Storage Policies',
			cvTableName: 'storagePolicieslListTable',
			cvServerMessage: 'storagePolicyMessage',
			cvSearchFields: ['storagePolicy.storagePolicyName'],
			gridOptions: globalGridOptions,
			cvPageLinks: [
				{
					label: 'Add',
					onclick: $scope.showAddStoragePolicyDialog
				}
			],
			cvOnGridEmpty: {
				message: cvLoc('label.noStoragePolicies'),
				links: [
					{
						label: 'Add',
						onclick: $scope.showAddStoragePolicyDialog
					}
				]
			}
		};

		var computePermittedActions = function(data) {
			let arrayOfActionsToOverride = [
				{
					DELETE: {
						onClick: () =>
							$scope.deleteStoragePolicy(data.storagePolicy.storagePolicyId, data.storagePolicy.storagePolicyName)
					}
				}
			];

			return cvPermissionFactory.updateAndGetCommonActionsList(
				arrayOfActionsToOverride,
				false,
				angular.copy(cvPermissionFactory.commonPermittedList)
			);
		};

		var setPermittedOptions = function(data) {
			data.forEach(function(policy) {
				policy.permittedOptions = {
					entityType: ENTITY_TYPES.STORAGE_POLICY_ENTITY,
					entity: angular.copy(policy),
					entityId: policy.storagePolicy.storagePolicyId,
					entityName: policy.storagePolicy.storagePolicyName,
					appendToBody: true,
					permittedActionList: computePermittedActions(policy)
				};
			});
		};

		var getStoragePolicies = function(options) {
			storagePolicyService
				.getAllStoragePolicies()
				.success(function(data) {
					if (!data.error || data.error.errorCode === 0) {
						$scope.storagePolicyMessage = cvUtil.emptyMsg();
						var policies = data.policies && data.policies.length > 0 ? data.policies : [];
						setPermittedOptions(policies);
						options.success(policies);
					} else {
						$log.error(data.error.errorMessage);
						cvToaster.showErrorMessageWrapper(data.error);
						options.success([]);
					}
				})
				.error(function(e) {
					$scope.storagePolicyMessage = cvUtil.errMsg(e);
				});
		};

		var onGridDataBound = function(dataItem, row) {
			var permittedOptions = dataItem.permittedOptions;
			var id = permittedOptions.entityId;
			$scope[`permittedOptions${id}`] = permittedOptions;
			var template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			row.find('.permittedActions').html($compile(template)($scope));
		};

		$scope.kendogridOptions = {
			gridTitle: cvLoc('label.storagePolicies'),
			tableName: 'storagePolicieslListTable',
			url: getStoragePolicies,
			usePageToolbar: true,
			enablePaging: true,
			pageSize: 20,
			gridEmptyMessage: cvLoc('label.noStoragePolicies'),
			columns: getStoragePoliciesTemplates({ cvLoc, $filter }),
			gridToolbarMenu: [
				{
					label: cvLoc('action.add'),
					onSelect: $scope.showAddStoragePolicyDialog
				}
			],
			onGridDataBound
		};
	}
];

storagePolicyControllers.storagePolicyDetailsController = [
	'$scope',
	'$http',
	'storageService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'$location',
	'storagePolicyService',
	'sharedData',
	function(
		$scope,
		$http,
		storageService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		$location,
		storagePolicyService,
		sharedData
	) {
		$scope.changedIndexed = false;
		$scope.streamChange = false;
		$scope.editing = false;
		$scope.plans = [];
		$scope.searchEngineError = false;

		$scope.storagePolicyMessage = {
			message: cvLoc('label.loading'),
			type: 'ok'
		};

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.storagePolicy'),
				link: '#storagePolicies'
			}
		]);

		$scope.storagePolicyId = $stateParams['storagePolicyId'];

		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);

		/**************************************\
		Functions
	\**************************************/

		$scope.onEdit = function() {
			$scope.editing = !$scope.editing;
		};

		$scope.deleteStoragePolicyCopy = copyObject => {
			var callBackFunctions = {
				noFunction: function() {},
				yesFunction: function() {
					storagePolicyService
						.deleteStoragePolicyCopy($scope.storagePolicyId, copyObject.copyId)
						.success(data => {
							if (!data.error || data.error.errorCode === 0) {
								$log.debug(cvLoc('log.succesDeletePolicy'));
								$location.path('/storagePolicyInfo');
								$state.forceReload();
							} else {
								$log.error(cvLoc('log.errorDeletePolicy'));
								$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
							}
						})
						.error(function(data) {
							$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
							$log.error(cvLoc('log.errorDeletePolicy'));
						});
				}
			};
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmationStoragePool', '<b>' + copyObject.copyName + '</b>'),
				callBackFunctions
			);
		};

		$scope.goToCreateStorageCopy = function() {
			$location.url(
				`createStoragePolicyCopy?storagePolicyId=${$scope.storagePolicyId}&storagePolicyName=${$scope.storagePolicyName}`
			);
		};

		$scope.changeIsIndexed = () => {
			$scope.changedIndexed = true;
			$scope.isIndexed = $scope.editing ? !$scope.isIndexed : $scope.isIndexed;
		};

		$scope.changeSearchEngine = value => {
			$scope.changedIndexed = true;
			$scope.selectedSearchEngine = value;
			$scope.searchEngineError = false;
		};

		$scope.onSave = () => {
			if ($scope.changedIndexed && $scope.isIndexed && !$scope.selectedSearchEngine) {
				$scope.searchEngineError = true;
			} else {
				$scope.processSave();
			}
		};

		$scope.processSave = () => {
			if ($scope.changedIndexed || $scope.streamChange) {
				var callBackFunctions = {
					noFunction: () => {
						$state.forceReload();
						$scope.editing = false;
					},
					yesFunction: () => {
						const obj = {
							numberOfStreams: $scope.stream,
							StoragePolicy: {
								storagePolicyName: $scope.storagePolicyName
							}
						};

						$scope.processContentSave();

						if ($scope.streamChange) {
							storagePolicyService
								.updateStoragePolicy($scope.storagePolicyId, obj)
								.success(function(data) {
									if (!data.error || data.error.errorCode === 0) {
										$log.debug(cvLoc('log.succesUpdatePolicy'));
										$scope.editing = false;
									} else {
										$log.error(cvLoc('log.errorUpdatePolicy'));
										$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
									}
									$state.forceReload();
								})
								.error(function(data) {
									$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
									$log.error(cvLoc('log.errorUpdatePolicy'));
								});
						}
					}
				};
				$dialogs.confirm(
					cvLoc('title.confirmStoragePolicy'),
					cvLoc('label.confirmStoragePolicyEdit'),
					callBackFunctions
				);
			} else {
				$scope.editing = false;
			}
		};
		$scope.changeStreams = value => {
			$scope.streamChange = true;
			$scope.stream = value;
		};

		$scope.processContentSave = () => {
			const elem =
				$scope.selectedSearchEngine && $scope.selectedSearchEngine.entityInfo
					? $scope.selectedSearchEngine.entityInfo.id
					: null;
			const contentIndex = {
				operation: 3,
				ciProps: {
					includeDocTypes:
						'*.bmp,*.csv,*.doc,*.docx,*.dot,*.eml,*.htm,*.html,*.jpeg,*.jpg,*.log,*.msg,*.odg,*.odp,*.ods,*.odt,*.pages,*.pdf,*.png,*.ppt,*.pptx,*.rtf,*.txt,*.xls,*.xlsx,*.xmind,*.xml',
					minDocSizeKB: 0,
					archGroupId: Number($scope.storagePolicyId),
					numPeriod: 1,
					flags: 0,
					type: 0,
					entityIds: '',
					filterSelected: 1,
					calendarId: 1,
					retentionDays: -1,
					contentIndexDataOver: 0,
					enable: 0,
					cloudId: elem ? Number(elem) : 1004,
					dayNumber: 0,
					startTime: 0,
					jobsOlderThan: 0,
					sourceCopyId: 0,
					deferredDays: 0,
					maxDocSizeKB: 51200
				}
			};

			if ($scope.changedIndexed) {
				if ($scope.isIndexed) {
					if ($scope.selectedSearchEngine) {
						$scope.selectedSearchEngine = $scope.search_engines.find(
							elem => $scope.selectedSearchEngine.entityInfo.id == elem.entityInfo.id
						);

						contentIndex.operation = 16;
						contentIndex.ciProps.enable = 1;
					}
				}
				storagePolicyService
					.editStoragePolicySearchEngines($scope.storagePolicyId, contentIndex)
					.success(data => {
						if (!data.error || data.error.errorCode === 0 || data.error.errorCode === 1) {
							$log.debug(cvLoc('log.succesUpdatePolic'));
							$scope.editing = false;
						} else {
							$log.error(cvLoc('log.errorUpdatePolic'));
							$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
						}
						$state.forceReload();
					})
					.error(e => {
						$scope.storagePolicyMessage = cvUtil.errMsg(e);
					});
			}
		};

		//  **************************************\
		//		Initialize controller
		//  **************************************/

		storagePolicyService
			.getSearchEngines()
			.success(data => {
				if (!data.error || data.error.errorCode === 0) {
					$scope.search_engines = data.fastClouds;
					$scope.selectedSearchEngine = '';
				} else {
					$log.error(cvLoc('error.loadingStoragePolicyCopyEngines'));
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(e => {
				$scope.storagePolicyMessage = cvUtil.errMsg(e);
			});

		storagePolicyService
			.getStoragePolicyDetails($scope.storagePolicyId)
			.success(function(data) {
				if (!data.error || data.error.errorCode === 0) {
					$scope.storagePolicyMessage = cvUtil.emptyMsg();
					const policy = data.policies && data.policies.length > 0 ? data.policies[0] : null;
					if (policy) {
						$scope.storagePolicyName = policy.storagePolicy.storagePolicyName;
						$scope.stream = policy.numberOfStreams;

						$scope.storageCopies =
							policy.copies && policy.copies.length > 0
								? policy.copies
										.map(elem => {
											const newElem = Object.assign({}, elem, {
												originalPolicyID: $scope.storagePolicyId,
												originalPolicyName: $scope.storagePolicyName,
												retentionRules: {
													retainBackupDataForCycles: elem.retentionRules.retainBackupDataForCycles,
													retainBackupDataForDays:
														elem.retentionRules.retainBackupDataForDays === -1
															? 'Infinite'
															: elem.retentionRules.retainBackupDataForDays
												}
											});
											return newElem;
										})
										.filter(elm => elm.isSnapCopy !== 1)
								: [];
						sharedData.policyCopies = $scope.storageCopies;
						$scope.numberOfCopies = $scope.storageCopies.length;
						$scope.plans = policy.plans && policy.plans.length > 0 ? policy.plans : [];
					}
				} else {
					$log.error(cvLoc('error.loadingStoragePolicyDetails'));
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(function(e) {
				$scope.storagePolicyMessage = cvUtil.errMsg(e);
			});

		storagePolicyService
			.getStoragePolicySearchEngines($scope.storagePolicyId)
			.success(data => {
				if (!data.error || data.error.errorCode === 0 || data.error.errorCode === 1) {
					$scope.isIndexed = data.ciProps && data.ciProps.enable === 1 ? true : false;
					if ($scope.isIndexed) {
						$scope.selectedSearchEngine = $scope.search_engines.find(
							elem => elem.entityInfo.id === data.ciProps.cloudId
						);
					} else {
						$scope.selectedSearchEngine = '';
					}
				} else {
					$log.error(cvLoc('error.loadingStoragePolicyCopyEngines'));
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(e => {
				$scope.storagePolicyMessage = cvUtil.errMsg(e);
			});

		angular.extend(globalGridOptions, {
			data: 'storageCopies',
			columnDefs: [
				{
					field: 'StoragePolicyCopy.copyName',
					displayName: cvLoc('Name'),
					enableHiding: false,
					cellClass: 'crop',
					cellTemplate:
						'<div><a href="#storagePolicyCopyInfo?storagePolicyId={{row.entity.originalPolicyID | encodeParam}}&storagePolicyName={{row.entity.originalPolicyName | encodeParam}}&storagePolicyCopyId={{row.entity.StoragePolicyCopy.copyId | encodeParam}}">{{row.entity.StoragePolicyCopy.copyName}}</a></div>'
				},
				{
					field: 'mediaAgent.mediaAgentName',
					displayName: cvLoc('label.mediaAgentName'),
					enableHiding: false,
					cellClass: 'crop',
					cellTemplate:
						'<div><a href="#mediaAgent/{{row.entity.mediaAgent.mediaAgentId | encodeParam}}">{{row.entity.mediaAgent.mediaAgentName}}</a></div>'
				},
				{
					field: 'library.libraryName',
					displayName: cvLoc('label.storageTarget'),
					enableHiding: false,
					cellClass: 'crop',
					cellTemplate: '<div>{{row.entity.library.libraryName}}</div>'
				},
				{
					field: 'storagePool.storagePoolName',
					displayName: cvLoc('label.nav.storage'),
					enableHiding: false,
					cellClass: 'crop',
					cellTemplate:
						'<div>{{row.entity.storagePool.storagePoolName===""? cvLoc("label.N_SLASH_A") :row.entity.storagePool.storagePoolName}}</div>'
				},
				{
					field: 'retentionRules.retainBackupDataForDays',
					displayName: cvLoc('label.retention') + ' (' + cvLoc('label.days') + ')',
					enableFiltering: false
				},
				{
					name: cvLoc('Actions'),
					cellTooltip: true,
					cellTemplate:
						'<div class="btn-group" uib-dropdown><a href class="uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu"> <li>' +
						'<a class="crop" data-ng-click="grid.appScope.deleteStoragePolicyCopy(row.entity.StoragePolicyCopy);">' +
						cvLoc('action.delete') +
						'</a>',
					width: '7%',
					enableFiltering: false,
					enableSorting: false,
					enableHiding: false
				}
			]
		});

		$scope.gridOptions = {
			cvGridTitle: cvLoc('title.StorageCopy'),
			cvTableName: 'storagePoliciesCopieslListTable',
			cvIsPageTitle: false,
			cvServerMessage: 'storagePolicyMessage',
			cvSearchFields: [
				'StoragePolicyCopy.copyName',
				'mediaAgent.mediaAgentName',
				'library.libraryName',
				'storagePool.storagePoolName',
				'retentionRules.retainBackupDataForDays'
			],
			gridOptions: globalGridOptions,
			cvPageLinks: [
				{
					label: cvLoc('action.add'),
					onclick: $scope.goToCreateStorageCopy
				}
			],
			cvOnGridEmpty: {
				message: cvLoc('label.noStoragePoliciesCopies'),
				links: [
					{
						label: cvLoc('action.add'),
						onclick: $scope.goToCreateStorageCopy
					}
				]
			}
		};
	}
];

storagePolicyMod.controller(storagePolicyControllers);

export default storagePolicyMod;
