import * as GridConstants from 'common/js/newGrid/grid.constants';

export const getStoragePoliciesTemplates = function(serviceVars) {
	return {
		...getPolicyName(serviceVars.cvLoc, serviceVars.$filter),
		...getNumberOfStreams(serviceVars.cvLoc),
		...getActions(serviceVars.cvLoc)
	};
};

const getPolicyName = (cvLoc, $filter) => ({
	'storagePolicy.storagePolicyName': {
		title: cvLoc('Name'),
		width: '45%',
		template: getStoragePolicyTemplate.bind(undefined, $filter)
	}
});

const getNumberOfStreams = cvLoc => ({
	numberOfStreams: {
		title: cvLoc('label.streams'),
		width: '45%',
		type: 'number',
		enableFilterConditionDropdown: true,
		filterConditions: [
			GridConstants.FILTER_CONDITIONS.LESS_THAN,
			GridConstants.FILTER_CONDITIONS.EQUALS,
			GridConstants.FILTER_CONDITIONS.GREATER_THAN
		]
	}
});

const getActions = cvLoc => ({
	actions: {
		title: cvLoc('Actions'),
		template: '<div class="permittedActions"></div>',
		sortable: false,
		disableColumnFilter: true,
		disableViewFiltering: true,
		width: '10%'
	}
});

const getStoragePolicyTemplate = ($filter, rowItem) => {
	let encodedLink = $filter('encodeParam')(rowItem.storagePolicy.storagePolicyId);
	return `<div class="crop"><a href="#storagePolicyInfo?storagePolicyId=${encodedLink}">${kendo.htmlEncode(
		rowItem.storagePolicy.storagePolicyName
	)}</div>`;
};
