import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'commonForAllAgents/js/controllers/pushInstallSoftware.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'modules/alerts/js/services/alerts.svc.js';
import 'storage/js/services/storage.svc.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc.js';
import 'modules/storage/js/controllers/storage.ctrl.js';

import { commonStoragePolicy } from 'common/js/modules';

var storagePolicyMod = commonStoragePolicy;

storagePolicyMod.factory('sharedData', function() {
	var dataHolder = {};

	dataHolder.data = {
		extendedRules: [],
		functionTest: null
	};

	return dataHolder;
});

var controllers = {};

controllers.createStoragePolicyCopyController = [
	'$scope',
	'$http',
	'$stateParams',
	'$rootScope',
	'definitionsService',
	'cvLoc',
	'cvUtil',
	'scheduleUIFactory',
	'alertDetailsService',
	'pushInstallSoftwareFactory',
	'$state',
	'$location',
	'$dialogs',
	'$window',
	'$uibModal',
	'$log',
	'cvTableOptions',
	'mbService',
	'storageService',
	'storagePolicyService',
	'sharedData',
	'cvBreadcrumbsTabsFactory',
	function(
		$scope,
		$http,
		$stateParams,
		$rootScope,
		definitionsService,
		cvLoc,
		cvUtil,
		scheduleUIFactory,
		alertDetailsService,
		pushInstallSoftwareFactory,
		$state,
		$location,
		$dialogs,
		$window,
		$modal,
		$log,
		cvTableOptions,
		mbService,
		storageService,
		storagePolicyService,
		sharedData,
		cvBreadcrumbsTabsFactory
	) {
		$scope.storagePolicyOriginal = $stateParams['storagePolicyName'];
		$scope.storagePolicyOriginalId = $stateParams['storagePolicyId'];

		$scope.selectedPool = null;
		$scope.isSelectiveCopy = { selected: false };
		$scope.isTapePool = false;
		$scope.isDataAging = true;
		$scope.selectedFreq = { frequency: null };
		$scope.throttleValue = 0;
		$scope.retentionValue = 30;
		$scope.retRules = [];
		$scope.auxCopyValues = [];
		$scope.elemInfinite = false;
		$scope.isPrimaryCopy = null;

		$scope.step = 0;
		$scope.lengthValue = 0;
		$scope.allBackups = true;
		$scope.selectedAuxCopy = null;
		$scope.datepicker = {
			open: false,
			dateOptions: {
				dateFormat: 'YYYY-MM-DD',
				showWeeks: false
			},
			value: setNewDateCVStandard()
		};
		$scope.auxCopy = false;
		$scope.isThrottle = false;
		$scope.title = cvLoc('title.addStorageCopy');
		$scope.policyName = '';

		$scope.steps = [
			{
				template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyGeneralTemplate.jsp',
				name: cvLoc('label.general')
			},
			{
				template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyRetentionTemplate.jsp',
				name: cvLoc('label.retention')
			},
			{
				template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyCopyPolicyTemplate.jsp',
				name: cvLoc('label.copyPolicy')
			}
		];

		$scope.generalTabErrors = {
			name: '',
			storagePool: '',
			selectiveCopy: '',
			backups: '',
			sourceCopy: ''
		};

		$scope.extendedErrors = {
			hasRetError: false,
			retentionError: ['', '', ''],
			hasTypError: false,
			typeError: ['', '', ''],
			hasMainRetError: false,
			emptyError: ['', '', '']
		};

		$scope.generalFreqs = identifier => {
			const result = [
				{ value: `${identifier}_ALLFULL`, label: cvLoc('label.allFull') },
				{ value: `${identifier}_HOUR`, label: cvLoc('label.hourlyFull') },
				{ value: `${identifier}_DAY`, label: cvLoc('label.dailyFull') },
				{ value: `${identifier}_WEEK`, label: cvLoc('label.weeklyFull') },
				{ value: `${identifier}_MONTH`, label: cvLoc('label.monthlyFull') },
				{ value: `${identifier}_QUARTER`, label: cvLoc('label.quarterlyFull') },
				{ value: `${identifier}_HALFYEAR`, label: cvLoc('label.halfYearlyFull') },
				{ value: `${identifier}_YEAR`, label: cvLoc('label.yearlyFull') }
			];
			return result;
		};

		$scope.extendedFreqs = $scope.generalFreqs('EXTENDED');
		$scope.selectiveFreqs = $scope.generalFreqs('SELECTIVE');

		// **************************************
		// 	Initialize controller
		// **************************************

		cvBreadcrumbsTabsFactory.addBreadCrumbs([
			{
				title: cvLoc('label.nav.storagePolicy'),
				link: '#storagePolicies'
			},
			{
				title: $scope.storagePolicyOriginal,
				link: '#/storagePolicyInfo?storagePolicyId=' + encodeURIComponent($scope.storagePolicyOriginalId)
			}
		]);

		storageService
			.getAllStoragePools()
			.success(function(data) {
				if (!data.error || data.error.errorCode === 0) {
					$scope.pools = data;
				} else {
					$log.error(data.error.errorMessage);
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(function(e) {
				console.log('Failed to load pools');
			});

		$scope.getCurrentStep = function() {
			return $scope.step;
		};

		storagePolicyService
			.getStoragePolicyDetails($scope.storagePolicyOriginalId)
			.success(function(data) {
				if (!data.error || data.error.errorCode === 0) {
					const policy = data.policies && data.policies.length > 0 ? data.policies[0] : null;
					if (policy && policy.copies && policy.copies.length > 0) {
						var copyList = [];
						angular.forEach(policy.copies, function(auxCopyValues) {
							if (auxCopyValues.isDefault != 1 && auxCopyValues.isSnapCopy === 0) {
								copyList.push(auxCopyValues);
							} else if (auxCopyValues.isDefault === 1) {
								$scope.isPrimaryCopy = auxCopyValues;
							}
						});
						$scope.auxCopyValues = copyList;
						//                $scope.selectedAuxCopy = (policy.copies && policy.copies.length > 0) ? policy.copies[0].StoragePolicyCopy.copyName : null;
					}
				} else {
					$log.error(cvLoc('loadingStoragePolicyCopyDetails'));
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(function(e) {
				$scope.storagePolictMessage = cvUtil.errMsg(e);
			});

		// **************************************
		// 	Functions
		// **************************************

		$scope.openDateModal = () => {
			$scope.generalTabErrors.backups = '';
			$scope.datepicker.open = !$scope.datepicker.open;
		};

		$scope.changeCopyElem = newFreq => {
			if (newFreq !== null) {
				$scope.selectedFreq.frequency = newFreq.frequency;
				$scope.generalTabErrors.selectiveCopy = '';
			}
		};

		$scope.changeSelectedPool = newPool => {
			$scope.selectedPool = JSON.parse(newPool);
			$scope.isTapePool = $scope.selectedPool.storagePoolType == 'SECONDARY_COPY';

			if ($scope.isTapePool) {
				$scope.steps = [
					{
						template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyGeneralTemplate.jsp',
						name: cvLoc('label.general')
					},
					{
						template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyCopyPolicyTemplate.jsp',
						name: cvLoc('label.copyPolicy')
					}
				];
			} else {
				$scope.steps = [
					{
						template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyGeneralTemplate.jsp',
						name: cvLoc('label.general')
					},
					{
						template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyRetentionTemplate.jsp',
						name: cvLoc('label.retention')
					},
					{
						template: appUtil.appRoot + 'modules/policies/storagePolicy/partials/storagePolicyCopyPolicyTemplate.jsp',
						name: cvLoc('label.copyPolicy')
					}
				];
			}

			$scope.generalTabErrors.storagePool = '';
			$scope.changeSelectiveCopy({ selected: $scope.isTapePool });
		};

		$scope.changeName = newName => {
			$scope.policyName = newName;
			$scope.generalTabErrors.name = '';
		};

		$scope.changeRetentionValue = value => {
			$scope.retentionValue = value;
			$scope.extendedErrors.hasMainRetError = false;
			$scope.retRules.forEach(elem => {
				if ($scope.retentionValue >= elem.retention && !elem.isInfinite) {
					$scope.extendedErrors.hasMainRetError = true;
				}
			});
		};

		$scope.changeBackups = () => {
			$scope.allBackups = !$scope.allBackups;
		};

		$scope.changeAuxCopy = () => {
			$scope.auxCopy = !$scope.auxCopy;
			$scope.generalTabErrors.sourceCopy = '';
		};

		$scope.changeSelectiveCopy = function(param) {
			$scope.isSelectiveCopy.selected = param.selected;
			const selectiveOptionDefault = $scope.isTapePool ? { frequency: 'SELECTIVE_WEEK' } : { frequency: null }; // reset dropdown of selective backup at frequency

			if ($scope.isSelectiveCopy.selected) {
				$scope.allBackups = false;
				$scope.datepicker.value = setNewDateCVStandard();
			} else {
				$scope.allBackups = true;
			}
			$scope.generalTabErrors.backups = '';
			$scope.generalTabErrors.selectiveCopy = '';
			$scope.changeCopyElem(selectiveOptionDefault);
		};

		$scope.isSelectiveCopyChecked = function isSelectiveCopyChecked() {
			return $scope.isSelectiveCopy.selected;
		};

		$scope.changeDataAging = function() {
			$scope.isDataAging = !$scope.isDataAging;
		};
		$scope.changeInfinite = function() {
			$scope.isInfinite = !$scope.isInfinite;
		};

		$scope.saveGeneralTab = function() {
			let generalError = false;

			if ($scope.policyName === '') {
				$scope.generalTabErrors.name = cvLoc('error.storagePolicyCopyName.required');
				generalError = true;
			}

			if ($scope.selectedPool === null) {
				$scope.generalTabErrors.storagePool = cvLoc('label.noStoragePoolsSelected');
				generalError = true;
			}

			if ($scope.isSelectiveCopy.selected && $scope.selectedFreq.frequency === null) {
				$scope.generalTabErrors.selectiveCopy = cvLoc('error.storagePolicyCopyBackupFreq.required');
				generalError = true;
			}

			if (!generalError) {
				$scope.processGeneralTab();
			}
		};
		$scope.processGeneralTab = function() {
			$scope.NPolicy = {
				copyName: '',
				storagePolicyCopyInfo: {
					copyType: '',
					StoragePolicyCopy: {
						storagePolicyName: $scope.storagePolicyOriginal
					}
				}
			};

			$scope.NPolicy.copyName = $scope.policyName;

			const selectedPoolCreate = {
				storagePolicyName: $scope.selectedPool.storagePool.clientGroupName,
				storagePolicyId: $scope.selectedPool.storagePool.clientGroupId
			};

			if ($scope.isTapePool) {
				$scope.NPolicy.storagePolicyCopyInfo['globalAuxCopy'] = selectedPoolCreate;
				$scope.NPolicy.storagePolicyCopyInfo['extendedFlags'] = {
					useGlobalAuxCopyPolicy: 1
				};
				$scope.NPolicy.storagePolicyCopyInfo['dedupeFlags'] = {
					enableDeduplication: 0
				};
			} else {
				$scope.NPolicy.storagePolicyCopyInfo['useGlobalPolicy'] = selectedPoolCreate;
				$scope.NPolicy.storagePolicyCopyInfo['dedupeFlags'] = {
					enableDeduplication: 1,
					useGlobalDedupStore: 1,
					enableDASHFull: 1
				};
			}

			if ($scope.isSelectiveCopy.selected) {
				$scope.NPolicy.storagePolicyCopyInfo.copyType = 'SELECTIVE';
				$scope.NPolicy.storagePolicyCopyInfo['selectiveCopyRules'] = {
					selectiveRule: $scope.selectedFreq.frequency,
					dayStartsAt: {
						dayStartsHoursMinutes: {
							hours: 12,
							minutes: 0,
							seconds: 0
						},
						amOrPm: 1
					},
					weekDayStartsOn: 5,
					monthStartsOn: 1
				};
			} else {
				$scope.NPolicy.storagePolicyCopyInfo.copyType = 'SYNCHRONOUS';
				delete $scope.NPolicy.storagePolicyCopyInfo['selectiveCopyRules'];
			}

			$scope.NPolicy.storagePolicyCopyInfo['throttleNetworkBandWidthMBHR'] = $scope.throttleValue;

			if ($scope.steps.length < 3 && !$scope.isSelectiveCopy.selected && $scope.isTapePool) {
				if ($scope.allBackups) {
					const elem = angular.element('#allBackUpsCheckFinal');
					elem[0].click();
				}
			}

			$scope.step += 1;
		};

		$scope.saveRetentionTab = () => {
			if (
				!$scope.extendedErrors.hasRetError &&
				!$scope.extendedErrors.hasTypError &&
				!$scope.extendedErrors.hasMainRetError
			) {
				let pass = true;
				$scope.retRules.forEach((elem, index) => {
					if (elem.selected === '') {
						pass = false;
						$scope.extendedErrors.emptyError[index] = cvLoc('error.noRetention');
					}
				});
				if (pass) {
					$scope.processRetentionTab();
				}
			}
		};

		$scope.processRetentionTab = () => {
			$scope.NPolicy.storagePolicyCopyInfo['retentionRules'] = {
				retainBackupDataForCycles: !$scope.isInfinite ? 1 : -1,
				retainBackupDataForDays: !$scope.isInfinite ? $scope.retentionValue : -1,
				retainArchiverDataForDays: -1,
				retentionFlags: {
					enableDataAging: $scope.isDataAging ? 1 : 0
				}
			};

			delete $scope.NPolicy.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleOne'];
			delete $scope.NPolicy.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleTwo'];
			delete $scope.NPolicy.storagePolicyCopyInfo.retentionRules['extendedRetentionRuleThree'];

			if (!$scope.isInfinite) {
				let isValid = true;
				$scope.retRules.forEach((elem, index) => {
					const keyLabelIndex = index === 0 ? 'One' : index === 1 ? 'Two' : 'Three';
					const realKey = 'extendedRetentionRule' + keyLabelIndex;
					$scope.NPolicy.storagePolicyCopyInfo.retentionRules[realKey] = {
						isEnabled: isValid ? elem.result.isEnabled : 0,
						rule: elem.result.rule.value,
						endDays: elem.isInfinite ? -1 : elem.result.endDays
					};
					isValid = !elem.isInfinite;
				});
			}

			if (!$scope.isSelectiveCopy.selected && !$scope.allBackups) {
				const elem = angular.element('#allBackUpsCheckFinal');
				elem[0].click();
			}
			$scope.step += 1;
		};

		$scope.savePolicyTab = () => {
			let failed = false;

			if (!$scope.allBackups && $scope.datepicker.value === null) {
				$scope.generalTabErrors.backups = cvLoc('error.storagePolicyCopyBackupDate.required');
				failed = true;
			}
			if ($scope.auxCopy && $scope.selectedAuxCopy === null) {
				$scope.generalTabErrors.sourceCopy = cvLoc('error.storageSourcePolicyCopy.required');
				failed = true;
			}

			if (!failed) {
				$scope.NPolicy.storagePolicyCopyInfo['startTime'] = {
					time: !$scope.allBackups ? Math.round($scope.datepicker.value.getTime() / 1000) : -1
				};

				if ($scope.auxCopy) {
					const elem = $scope.auxCopyValues.find(val => val.StoragePolicyCopy.copyName === $scope.selectedAuxCopy);
					$scope.NPolicy.storagePolicyCopyInfo['sourceCopy'] = elem.StoragePolicyCopy;
				} else {
					delete $scope.NPolicy.storagePolicyCopyInfo['sourceCopy'];
				}

				$scope.lastWarning();
			}
		};

		$scope.lastWarning = () => {
			if (!$scope.isSelectiveCopy.selected && $scope.allBackups) {
				const sourceCopyVal = !$scope.auxCopy
					? $scope.isPrimaryCopy
					: $scope.auxCopyValues.find(elem => elem.StoragePolicyCopy.copyName === $scope.selectedAuxCopy);

				storagePolicyService
					.getCopySize($scope.storagePolicyOriginalId, sourceCopyVal.StoragePolicyCopy.copyId)
					.success(function(data) {
						if (!data.error || data.error.errorCode === 0) {
							if (data.copyInfo[0].dataSizeInGB >= 10) {
								var callBackFunctions = {
									noFunction: () => {
										$scope.globalSave();
									},
									yesFunction: () => {
										const elem = angular.element('#allBackUpsCheckFinal');
										elem[0].click();
										$scope.datepicker.value = setNewDateCVStandard();
									}
								};
								$dialogs.confirm(
									cvLoc('label.createStoragePolicyCopy'),
									cvLoc('label.confirmPolicyCopySize'),
									callBackFunctions
								);
							} else {
								$scope.globalSave();
							}
						} else {
							$log.error(cvLoc('error.createPolicyCopy'));
							$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
						}
					})
					.error(function(e) {
						$scope.storagePolictMessage = cvUtil.errMsg(e);
					});
			} else {
				$scope.globalSave();
			}
		};

		$scope.globalSave = () => {
			storagePolicyService
				.createStoragePolicyCopy($scope.storagePolicyOriginalId, $scope.NPolicy)
				.success(function(data) {
					if (!data.error || data.error.errorCode === 0) {
						$log.debug('add Policy');
						$location.url(`storagePolicyInfo?storagePolicyId=${$scope.storagePolicyOriginalId}`);
					} else {
						$log.error(cvLoc('error.createPolicyCopy'));
						$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
					}
				})
				.error(function(e) {
					$log.error(cvLoc('error.createPolicyCopy'));
				});
		};

		$scope.changeSelectedAux = selectedAuxCopy => {
			$scope.selectedAuxCopy = selectedAuxCopy;
		};

		$scope.goPreviousStep = function() {
			$scope.step -= 1;
		};

		$scope.checkDisabled = (index, array) => {
			let isInfinite = array[index].isInfinite;
			$scope.elemInfinite = isInfinite;
			array.forEach((elem, i) => {
				if (i > index) {
					elem.isEnabled = !isInfinite;
					elem.result.isEnabled = isInfinite ? 0 : 1;
					if (!isInfinite) {
						isInfinite = elem.isInfinite;
					}
					if (!$scope.elemInfinite && isInfinite) {
						$scope.elemInfinite = isInfinite;
					}
				}
			});
		};

		$scope.changeRetention = (index, value) => {
			$scope.retRules[index].retention = value;
			$scope.retRules[index].result.endDays = value;
			$scope.checkRetentionValues(index, $scope.retRules);
		};

		$scope.checkRetentionValues = (index, array) => {
			$scope.extendedErrors.hasMainRetError = $scope.retentionValue >= array[index].retention;
			$scope.extendedErrors.hasRetError = false;
			$scope.extendedErrors.retentionError = ['', '', ''];
			array.forEach((elem, i) => {
				if (i < index && elem.retention >= array[index].retention && !elem.isInfinite) {
					$scope.extendedErrors.hasRetError = true;
					$scope.extendedErrors.retentionError[i] = cvLoc('error.retentionLowerError');
				} else if (i > index && elem.retention <= array[index].retention && !elem.isInfinite) {
					$scope.extendedErrors.hasRetError = true;
					$scope.extendedErrors.retentionError[i] = cvLoc('error.retentionGreaterError');
				}
			});
		};

		$scope.checkRetentionType = (index, array) => {
			$scope.extendedErrors.hasTypError = false;
			$scope.extendedErrors.typeError = ['', '', ''];

			const index1 = $scope.extendedFreqs.findIndex(elem => elem.value === array[index].result.rule.value);
			let index2;
			array.forEach((elem, i) => {
				index2 = $scope.extendedFreqs.findIndex(elem2 => elem2.value === elem.result.rule.value);
				if (i < index && index2 >= index1 && index2 !== -1) {
					$scope.extendedErrors.hasTypError = true;
					$scope.extendedErrors.typeError[i] = cvLoc('error.retentionLowerError');
				} else if (i > index && index2 <= index1 && index2 !== -1) {
					$scope.extendedErrors.hasTypError = true;
					$scope.extendedErrors.typeError[i] = cvLoc('error.retentionGreaterError');
				}
			});
		};

		/**
		 * CV Date Standard object when you set new date, the time must be set as 00:00:00
		 */
		function setNewDateCVStandard() {
			// set hour to 00:00:00 Fri May 03 2019 00:00:00 TimeZone
			var d = new Date();
			d.setHours(0, 0, 0, 0);
			return d;
		}
	}
];

storagePolicyMod.controller(controllers);

export default storagePolicyMod;
