import 'commonForAllAgents/js/services/addProxyDialog.svc.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc.js';
import 'storage/js/services/storage.svc.js';

import { commonStoragePolicy } from 'common/js/modules';

var addStoragePolicyMod = commonStoragePolicy;

addStoragePolicyMod.controller('addStoragePolicyController', [
	'$rootScope',
	'$scope',
	'$log',
	'$http',
	'cvLoc',
	'addProxyDialogService',
	'$state',
	'cvUtil',
	'storageService',
	'storagePolicyService',
	function(
		$rootScope,
		$scope,
		$log,
		$http,
		cvLoc,
		addProxyDialogService,
		$state,
		cvUtil,
		storageService,
		storagePolicyService
	) {
		$scope.name = null;
		$scope.retentionRules = 30;
		$scope.nameError = '';
		$scope.poolError = '';
		$scope.retentionError = '';
		$scope.selectedPool = null;
		$scope.isInfinite = false;
		$scope.serverMessage = cvUtil.emptyMsg();

		// **************************************
		// 	Initialize controller
		// **************************************

		storageService
			.getAllStoragePools()
			.success(function(data) {
				if (!data.error || data.error.errorCode === 0) {
					$scope.pools = data.filter(
						elem => elem.storagePoolType === 'DEDUPLICATION' || elem.storagePoolType === 'SCALE_OUT'
					);
				} else {
					$log.error(data.error.errorMessage);
					$dialogs.error(cvLoc('label.error'), data.error.errorMessage);
				}
			})
			.error(function(e) {
				console.log('Failed to load pools');
			});

		// **************************************
		// 	Functions
		// **************************************

		$scope.changeInfinite = () => {
			$scope.isInfine = !$scope.isInfine;
		};

		$scope.addPolicy = () => {
			$scope.nameError = $scope.name ? '' : cvLoc('error.noStoragePoolName');
			$scope.poolError = $scope.selectedPool ? '' : cvLoc('label.noStoragePoolsSelected');
			$scope.retentionError = $scope.isInfinite ? '' : $scope.retentionRules ? '' : cvLoc('label.noRetention');

			if ($scope.nameError === '' && $scope.poolError === '' && $scope.retentionError === '') {
				$scope.savePolicy();
			}
		};
		$scope.changePool = newPool => {
			$scope.selectedPool = newPool;
		};

		$scope.savePolicy = function() {
			const obj = $scope.selectedPool && $scope.selectedPool !== '' ? JSON.parse($scope.selectedPool) : null;

			const finalObj = {
				storagePolicyName: $scope.name,
				type: 1,
				numberOfStreams: 100,
				copyName: 'Primary',
				numberOfCopies: 1,
				storagePolicyCopyInfo: {
					copyType: 1,
					isFromGui: false,
					active: 1,
					isDefault: 1,
					numberOfStreamsToCombine: 1,
					dedupeFlags: {
						enableDASHFull: 1,
						useGlobalDedupStore: 1,
						enableDeduplication: 1,
						enableClientSideDedup: 1
					},
					storagePolicyFlags: {
						blockLevelDedup: 1
					},
					retentionRules: {
						retainBackupDataForCycles: !$scope.isInfinite ? 1 : -1,
						retainArchiverDataForDays: -1,
						retainBackupDataForDays: !$scope.isInfinite ? ($scope.retentionRules ? $scope.retentionRules : 30) : -1,
						retentionFlags: {
							enableDataAging: 1
						}
					},
					useGlobalPolicy: {
						storagePolicyId: obj ? obj.clientGroupId : '',
						storagePolicyName: obj ? obj.clientGroupName : ''
					}
				}
			};

			storagePolicyService
				.createStoragePolicy(finalObj)
				.success(function(data) {
					if (!data.error || data.error.errorCode === 0) {
						$log.debug('add Policy');
						$state.forceReload();
						$scope.close();
					} else {
						$log.error(data.error.errorMessage);
						$scope.serverMessage = cvUtil.errMsg(data.error.errorMessage);
					}
				})
				.error(function(e) {
					$log.error('Adding policy failed');
					$scope.serverMessage = cvUtil.errMsg(e);
					$state.forceReload();
					$scope.close();
				});
		};
	}
]);

export default addStoragePolicyMod;
