<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.dbOptions" bundle="sharepoint"/></h1>
</div>
<div class="setup-content schedule bootstrap-wrapper">
	<div class="{{spSCEditSqlOpts.spSCEditSqlOptsMessage.type}} serverMessage">{{spSCEditSqlOpts.spSCEditSqlOptsMessage.message}}</div>
	<form name="editSPSqlDbInfoForm" data-cv-submit="spSCEditSqlOpts.saveInfo()" novalidate autocomplete="off" class="form-horizontal">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label id="sqlClient" for="sqlClient" class="col-xs-12 col-md-6 col-lg-6"><cv:msg key="label.sqlClientHelp" bundle="sharepoint"/></label>
						<div class="col-xs-12 col-md-6 col-lg-6">
								<select name="sqlClient"
								data-ng-options="sqlClient as sqlClient.clientName for sqlClient in spSCEditSqlOpts.sqlClientList | orderBy: 'clientName'"
								data-ng-model="spSCEditSqlOpts.model.sqlInfo.ContentDatabaseSqlClient"
								data-ng-change="spSCEditSqlOpts.populateDefaultValues()">
								</select>
							<span class="help-block" data-ng-show="spSCEditSqlOpts.validationStatusFlags.sqlClientReq"><cv:msg key="error.selectSqlClient" bundle="sharepoint" /></span>
						</div>
				</div>
				<div class="form-group">
					<label for="dbBackupStreams" class="col-xs-12 col-md-6 col-lg-6"><cv:msg key="label.dbbackupstreams" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-6 col-lg-6">
						<input type="number" min="1" max="32" value="1" id="dbBackupStreams" name="dbBackupStreams"
						data-ng-model="spSCEditSqlOpts.model.sqlInfo.ContentDatabasenumStreams"
						data-ng-disabled = "spSCEditSqlOpts.model.sqlInfo.ContentDatabaseSqlClient.clientId == 0"/>
					</div>
				</div>
				<div class="form-group">
					<label for="vdiTimeOut" class="col-xs-12 col-md-6 col-lg-6"><cv:msg key="label.vdiTimeOut" bundle="sqlserver"/></label>
					<div class="col-xs-12 col-md-6 col-lg-6">
						<input type="number" min="300" max="2147483647" value="300" id="vdiTimeOut" name="vdiTimeOut"
						data-ng-model="spSCEditSqlOpts.model.sqlInfo.ContentDatabaseVDITimeout"
						data-ng-disabled = "spSCEditSqlOpts.model.sqlInfo.ContentDatabaseSqlClient.clientId == 0"/>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="sharepointSCEditSQLClient_button_#5912" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spSCEditSqlOpts.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="sharepointSCEditSQLClient_button_#1467" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>