<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvEnum name="App.SharePointVersion"></cv:cvEnum>
	<cv:cvEnum name="App.SharepointBackupSetType"></cv:cvEnum>
</script>
<div class="office365-app-content">
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="sharepointOnPremBkpSettingsCtrl.backupSetName"></h1>
	</div>
</div>
<div class="row">
    <div class="col-md-12">
        <span class="server-message {{sharepointOnPremBkpSettingsCtrl.serverMessage.type}} text-center" data-ng-bind="sharepointOnPremBkpSettingsCtrl.serverMessage.message"></span>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-ng-show="!sharepointOnPremBkpSettingsCtrl.isClientFarmPseudoClient" data-ac-id="sharepointDetails-heading_clientGeneral-clients" data-title='<cv:msg key="header.sharepointDetails" bundle="sharepoint"/>' data-loader="sharepointOnPremBkpSettingsCtrl.agentDetails">
				<ul class="list-style-secondary">
					<li class="group" id="version">
				        <span class="pageDetail-three-columns-first"><cv:msg key="header.sharepoint.version" bundle="sharepoint" /></span>
					    <span class="pageDetail-three-columns-second" data-ng-bind ="sharepointOnPremBkpSettingsCtrl.sharePointVersionText"/>
					    <a class="pageDetail-three-columns-third" href="" data-ng-click="sharepointOnPremBkpSettingsCtrl.changeSpVersion()">
					    <cv:msg key="label.actionEdit" bundle="messagesJs" /></a>
                   </li>
                    <li class="group" id="spAccount">
                       <span class="pageDetail-three-columns-first">
                       <cv-help-text help-label="label.sp.sql.impersonation" help-text="label.serviceAccounthelp"/>
                       </span>
                       <span class="pageDetail-three-columns-second" ng-bind = "sharepointOnPremBkpSettingsCtrl.sqlUserName" />
                       <a class="pageDetail-three-columns-third" href="" data-ng-click="sharepointOnPremBkpSettingsCtrl._confirmChangeSpSQLAccount()">
                       <cv:msg key="label.actionEdit" bundle="messagesJs" /></a>
				   </li>

				</ul>
		    </cv-tile-component>	
		    
		    <cv-tile-component data-ac-id="sharepointDetails-sp_pseudo_member_servers-sharepoint" data-title='<cv:msg key="sp.pseudo.member.servers" bundle="sharepoint"/>' data-loader="sharepointOnPremBkpSettingsCtrl.spPseudoClientInfo" data-ng-show="sharepointOnPremBkpSettingsCtrl.isClientFarmPseudoClient">
			<div>
				<ul class="list-style-secondary">
					<li class="group" id="version"><span class="pageDetailColumn"><cv:msg key="header.sharepoint.version" bundle="sharepoint" /></span>
						<span class="pageDetailColumn" data-ng-bind="sharepointOnPremBkpSettingsCtrl.sharePointVersionText"></span>
					</li>
					<li class="group" id="pServer"><span class="pageDetailColumn"><cv:msg key="sp.pseudo.primary.member.servers" bundle="sharepoint" /></span>
						<span class="pageDetailColumn" data-ng-bind="sharepointOnPremBkpSettingsCtrl.spPseudoClientInfo.sharepointPseudoClientProperties.primaryMemberServer.client.clientName"></span>
					</li>
					<li class="group" id="secServers">
						<span class="pageDetailColumn"><cv:msg key="sp.pseudo.secondary.member.servers" bundle="sharepoint"/></span>
						<span data-ng-if="sharepointOnPremBkpSettingsCtrl.spPseudoClientInfo.sharepointPseudoClientProperties.spMemberServers.memberServers.length > 0" class="pageDetailColumn" data-uib-tooltip-html="sharepointOnPremBkpSettingsCtrl.secMemberServerString" tooltip-placement="bottom">
							<span class="reduced-size">{{sharepointOnPremBkpSettingsCtrl.secMemberServerString}}</span>
							<span data-ng-if="sharepointOnPremBkpSettingsCtrl.spPseudoClientInfo.sharepointPseudoClientProperties.spMemberServers.memberServers.length>=3">({{sharepointOnPremBkpSettingsCtrl.spPseudoClientInfo.sharepointPseudoClientProperties.spMemberServers.memberServers.length}})</span>
						</span>
					</li>
				</ul>
				<div class="page-details-box-links">
  				 	<a href="" data-ng-click="sharepointOnPremBkpSettingsCtrl.changeMemberServers()"><cv:msg key="action.change.member.servers" bundle="sharepoint" /></a>
 				</div>
			</div>
		</cv-tile-component>
		</div>
		<div class="col-md-6">
				<cv-security-component
					directive-id='sharepointBackupsetSeurityDirective'
					entity-type='sharepointOnPremBkpSettingsCtrl.entityType'
					generic-entity = 'sharepointOnPremBkpSettingsCtrl.backupSetEntity'
					associations='sharepointOnPremBkpSettingsCtrl.formattedSecurityAssociations'
					associations-loaded='sharepointOnPremBkpSettingsCtrl.associationsLoaded'
					show-owners='true'>
				</cv-security-component>
		</div>
	</div>
</div>
</div>

