<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvEnum name="TMMsg.RestoreToDiskType"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.RestoreType"></cv:cvEnum>
	<cv:cvEnum name="App.BrowseLevelInGUI"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.sp.offline.restore" bundle="sharepoint"/></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="col-md-12">
		<div class="{{spOfflineRestoreCtrl.spRestoreOptsMessage.type}} serverMessage">{{spOfflineRestoreCtrl.spRestoreOptsMessage.message}}</div>
	</div>
	<form class="form-horizontal" data-cv-submit="spOfflineRestoreCtrl.prepareAndDoOfflineRestore()" novalidate name="spOfflineRestoreCtrl.spCOfflineRestoreForm" autocomplete="off">
		<div class="panel panel-default">
			<div class="panel-body">
				<!-- The ruling radio buttons. Further page depends on these buttons -->
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="docTypeOfRestore"><cv:msg key="sp.offline.info.typeOfRestore" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="multiple-radio-group">
							<label for="docTypeOfRestore"><input id="docTypeOfRestore" name="docTypeOfRestore" value="DOC" class="" type="radio" data-ng-model="spOfflineRestoreCtrl.model.typeOfRestore"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.typeOfRestore.document" bundle="sharepoint"/></span></label>
						</div>
						<div class="multiple-radio-group">
							<label for="siteTypeOfRestore"><input id="siteTypeOfRestore" name="siteTypeOfRestore" value="SITE" class="" type="radio" data-ng-model="spOfflineRestoreCtrl.model.typeOfRestore"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.typeOfRestore.site" bundle="sharepoint"/></span></label>
						</div>
					</div>
				</div>
				<!-- Radio for Net sites / disk-->
				<div class="form-group">
					<label class="col-xs-12 col-md-4 col-lg-4" for="netSitesRestoreDestination"><cv:msg key="sp.offline.restore.destination" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="multiple-radio-group">
							<label for="netSitesRestoreDestination"><input id="netSitesRestoreDestination" name="netSitesRestoreDestination" value="NETSITE" class="" type="radio"
								data-ng-model="spOfflineRestoreCtrl.model.typeOfRestoreDestination" data-ng-click="spOfflineRestoreCtrl.determineRestoreDestinationPath()"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.typeOfRestoreDestination.netsite" bundle="sharepoint"/></span></label>
						</div>
						<div class="multiple-radio-group">
							<label for="diskTypeOfRestoreDestination"><input id="diskTypeOfRestoreDestination" name="diskTypeOfRestoreDestination" value="DISK" class="" type="radio"
							data-ng-model="spOfflineRestoreCtrl.model.typeOfRestoreDestination" data-ng-click="spOfflineRestoreCtrl.determineRestoreDestinationPath()"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.typeOfRestoreDestination.disk" bundle="sharepoint"/></span></label>
						</div>
					</div>
				</div>
				<!-- End of Radio for Net sites / disk-->
				<!-- Restore as native/orig files -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestore == 'DOC' && spOfflineRestoreCtrl.model.typeOfRestoreDestination == 'DISK'">
					<label class="col-xs-12 col-md-4 col-lg-4" for="docTypeOfRestore"><cv:msg key="sp.offline.restore.to.disk.as" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="multiple-radio-group">
							<label for="restoreToDiskOptNative"><input id="restoreToDiskOptNative" name="restoreToDiskOptNative" value="SPNATIVE" class="" type="radio" data-ng-model="spOfflineRestoreCtrl.model.typeOfSaveToDisk"/>
							<span class="block-indent"><cv:msg key="sp.offline.typeOfSaveToDisk.native" bundle="sharepoint"/></span></label>
						</div>
						<div class="multiple-radio-group">
							<label for="restoreToDiskOptOrigFiles"><input id="restoreToDiskOptOrigFiles" name="restoreToDiskOptOrigFiles" value="ORIGFILES" class="" type="radio" data-ng-model="spOfflineRestoreCtrl.model.typeOfSaveToDisk"/>
							<span class="block-indent"><cv:msg key="sp.offline.typeOfSaveToDisk.orig.files" bundle="sharepoint"/></span></label>
						</div>
					</div>
				</div>
				<!-- End ofRestore as native/orig files -->
				<!-- Path and Browse For Net Sites: -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestoreDestination == 'NETSITE'">
					<label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="sp.offline.restore.destination.path" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="input-group">
							<input readonly name="restoreDestinationSite" id="restoreDestinationSite" value="" type="text"
								data-ng-model="spOfflineRestoreCtrl.model.restoreDestinationNetSite"/>
							<span class="input-group-btn">
								<button id="sharepointOfflineRestoreOptions_button_#0020" type="button" class="btn btn-default browse-btn" data-ng-click="spOfflineRestoreCtrl.openNetSitesBrowseModal()"><cv:msg key="action.browse" bundle="collections"/></button> 
							</span>
						</div>
						<span class="help-block" data-ng-show="spOfflineRestoreCtrl.inputAlerts.destNetSitePath"><cv:msg key="error.sp.restore.to.disk.path.empty" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- End of Path and Browse for Net Sites:-->
				<!-- Path and Browse For Restore to Disk: -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestoreDestination == 'DISK'">
					<label class="col-xs-12 col-md-4 col-lg-4"><cv:msg key="sp.offline.restore.destination.path" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="input-group">
							<input name="restoreDestinationDisk" id="restoreDestinationDisk" value="" type="text"
								data-ng-model="spOfflineRestoreCtrl.model.restoreToDiskPath"
								data-ng-change="spOfflineRestoreCtrl.inputAlerts.destPath=false;"/>
							<span class="input-group-btn">
								<button id="sharepointOfflineRestoreOptions_button_#1101" type="button" class="btn btn-default browse-btn" data-ng-click="spOfflineRestoreCtrl.openDiskDestinationFolder()"><cv:msg key="action.browse" bundle="collections"/></button> 
							</span>
						</div>
						<span class="help-block" data-ng-show="spOfflineRestoreCtrl.inputAlerts.destPath"><cv:msg key="error.sp.restore.to.disk.path.empty" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- End of Path and Browse for Restore to Disk-->
				<!-- Restore ACLs -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestore == 'DOC' && spOfflineRestoreCtrl.model.typeOfRestoreDestination == 'NETSITE'">
					<div class="col-xs-12 col-md-5 col-lg-5" for="restoreACLs">
						<input type="checkbox" id="restoreACLs" name="restoreACLs" data-ng-model="spOfflineRestoreCtrl.model.isRestoreAcls"
							data-ng-click="spOfflineRestoreCtrl.configureWhenDocExists()"/>
                   		<label for="restoreACLs"><cv:msg key="sp.offline.restore.acls" bundle="sharepoint" /></label>
                   	</div>
				</div>
				<!-- End of Restore ACLs  -->
				<!-- When document exists -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestoreDestination == 'NETSITE'">
					<label class="col-xs-12 col-md-4 col-lg-4" for="whenDocExists" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestore == 'DOC'"><cv:msg key="sp.offline.info.whenDocExists" bundle="sharepoint"/></label>
					<label class="col-xs-12 col-md-4 col-lg-4" for="whenDocExists" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestore == 'SITE'"><cv:msg key="sp.offline.info.whenSiteExists" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-8 col-lg-8">
						<div class="multiple-radio-group">
							<label for="whenDocExistsOverwrite"><input id="whenDocExistsOverwrite" name="whenDocExistsOverwrite" value="OVERWRITE" class="" type="radio"
								data-ng-model="spOfflineRestoreCtrl.model.whenDocSiteExists"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.overwrite" bundle="sharepoint"/></span></label>
						</div>
						<div class="multiple-radio-group" data-ng-disabled="spOfflineRestoreCtrl.model.isRestoreAcls">
							<label for="whenDocExists"><input id="whenDocExistsSkip" name="whenDocExistsSkip" value="SKIP" class="" type="radio"
								data-ng-model="spOfflineRestoreCtrl.model.whenDocSiteExists"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.skip" bundle="sharepoint"/></span></label>
						</div>
					</div>
				</div>
				<!-- end of When document exists -->
				<!-- Restore all checkbox -->
				<div class="form-group" data-ng-show="spOfflineRestoreCtrl.model.typeOfRestore == 'DOC'">
					<div class="col-xs-12 col-md-5 col-lg-5" for="restoreAllVersions">
						<input type="checkbox" id="restoreAllVersions" name="restoreAllVersions" data-ng-model="spOfflineRestoreCtrl.model.isRestoreAllVersions"/>
                   		<label for="restoreAllVersions"><cv:msg key="sp.label.restore.all.versions" bundle="sharepoint" /></label>
                   	</div>
				</div>
				<!-- End of Restore all checkbox -->
			</div>
		</div>
		<div class="modal-footer">
			<button id="sharepointOfflineRestoreOptions_button_#5170" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spOfflineRestoreCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="sharepointOfflineRestoreOptions_button_#9156" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.button.restore" bundle="sharepoint"/></button> 
		</div>
	</form>
</div>
