<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>{{spOffBrowseParamsCtrl.titleText}}</h1>
</div>
<div class="setup-content schedule bootstrap-wrapper">
	<div class="{{spOffBrowseParamsCtrl.spOffBrowseParamsCtrlMessage.type}} serverMessage">{{spOffBrowseParamsCtrl.spOffBrowseParamsCtrlMessage.message}}</div>
	<form name="spOfflineBrowseParamsForm" data-cv-submit="spOffBrowseParamsCtrl.prepareOfflineBrowse()" novalidate autocomplete="off" class="form-horizontal">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group" data-ng-if="!spOffBrowseParamsCtrl.isCloneBrowse">
					<label id="sqlInstance" for="sqlInstance" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="sp.offline.browse.sql.instance" bundle="sharepoint"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" name="sqlInstance" data-ng-class="text-right" id="sqlInstance" autofocus data-ng-model="spOffBrowseParamsCtrl.model.sqlInstance" required>
							<span class="help-block" data-ng-show="spOffBrowseParamsCtrl.model && cv.spOfflineBrowseParamsForm.needsAttention(spOfflineBrowseParamsForm.sqlInstance)"><cv:msg key="error.sqlInstance.empty" bundle="sharepoint"/></span>
						</div>
				</div>
				<div class="form-group" data-ng-if="!spOffBrowseParamsCtrl.isCloneBrowse">
					<label id="contentDatabase" for="contentDatabase" class="col-xs-12 col-md-5 col-lg-5"><cv:msg key="sp.offline.browse.content.database" bundle="sharepoint"/></label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="text" name="contentDatabase" data-ng-class="text-right" id="contentDatabase" data-ng-model="spOffBrowseParamsCtrl.model.contentDatabase" required>
							<span class="help-block" data-ng-show="spOffBrowseParamsCtrl.model && cv.spOfflineBrowseParamsForm.needsAttention(spOfflineBrowseParamsForm.contentDatabase)"><cv:msg key="error.contentDatabase.empty" bundle="sharepoint"/></span>
						</div>
				</div>
				
				<div id="clientForClone" class="form-group" data-ng-if="spOffBrowseParamsCtrl.isCloneBrowse">
				    <label id="destinationServer" for="destinationServer" class="col-xs-5"><cv:msg key="label.sharepointClientName" bundle="sharepoint"/></label>
					<div class="col-xs-7">
					      <select id="destinationServer" name="destinationServer"  data-ng-required="true"
								data-ng-model="spOffBrowseParamsCtrl.destinationServer"
								data-ng-options="ds as ds.displayName for ds in spOffBrowseParamsCtrl.destinationServerList track by (ds.displayName|lowercase)"
								data-ng-change="spOffBrowseParamsCtrl.destinationServerChanged()" >
						  </select>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="sharepointOfflineBrowseParams_button_#7251" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spOffBrowseParamsCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="sharepointOfflineBrowseParams_button_#7776" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.sp.view.content" bundle="sharepoint"/></button> 
		</div>
	</form>
</div>
