<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
		<cv:cvEnum name="App.SharePointVersion"></cv:cvEnum>
		<cv:cvEnum name="App.ClientType"></cv:cvEnum>
</script>

<form
	class="form-horizontal bootstrap-wrapper"
	data-cv-submit="manageSharePointDBSubclientCtrl.saveChanges()"
	name="manageSubclientForm"
	id="manage-subclient-form"
	novalidate
	autocomplete="off"
>
	<div class="modal-header">
		<h1 data-ng-bind="manageSharePointDBSubclientCtrl.title"></h1>
	</div>
	<!--End --Modal Header-->

	<div class="modal-body">
		<p
			class="{{ manageSharePointDBSubclientCtrl.updateSubclientMessage.type }} serverMessage"
			data-ng-bind="manageSharePointDBSubclientCtrl.updateSubclientMessage.message"
		></p>

		<div class="form-group row" data-ng-if="!manageSharePointDBSubclientCtrl.isDefaultSubclient">
			<label class="col-xs-12 col-sm-4" for="subclientName">
				<cv:msg key="label.o365.subclientName" bundle="office365"/></label>
			<div class="col-xs-12 col-sm-8">
				<input
					type="text"
					name="subclientName"
					id="subclientName"
					required				
					data-ng-model="manageSharePointDBSubclientCtrl.newSubclientName"
					autofocus/>
				<span class="help-block" data-ng-show="cv.manageSubclientForm.needsAttention(manageSubclientForm.subclientName)">
					<cv:msg key="label.validSubclientName" bundle="office365" />
				</span>
			</div>
		</div>

		<div class="form-group margin-left-0" id="planPolicy" data-ng-if="!manageSharePointDBSubclientCtrl.isOffice365SaaSTenant && (manageSharePointDBSubclientCtrl.isSubclientEdit && !manageSharePointDBSubclientCtrl.isPlanEntityDefined)">
			<cv-entity-plan-policy-select			
				data-cv-app-id="manageSharePointDBSubclientCtrl.APPTYPE"
				data-cv-client-id="manageSharePointDBSubclientCtrl.clientId"
				data-cv-subclient-id="manageSharePointDBSubclientCtrl.subclientId"
				data-cv-model="manageSharePointDBSubclientCtrl.planPolicyModel"
				data-cv-edit-policies="!manageSharePointDBSubclientCtrl.showPlanSelectionState"
				data-cv-is-associated="'true'"
				data-cv-plan-sub-type="'Server'"
				data-cv-wrapper-class="'form-group row'"
				data-cv-label-class="'col-xs-12 col-lg-4'"
				data-cv-select-class="'col-xs-12 col-lg-8'">
			</cv-entity-plan-policy-select>
		</div>

		<div class="form-group" id="planSummary" data-ng-if="!manageSharePointDBSubclientCtrl.isOffice365SaaSTenant && (!manageSharePointDBSubclientCtrl.isSubclientEdit || manageSharePointDBSubclientCtrl.isPlanEntityDefined)">
			<label class="col-xs-12 col-sm-4" for="subclientPlan"> <cv:msg
					key="label.o365.serverPlan" bundle="office365"></cv:msg>
			</label>
			<div class="col-xs-12 col-sm-8">
				<cv-plan-summary-dropdown				
					input-model="manageSharePointDBSubclientCtrl.serverPlanList"
					output-model="manageSharePointDBSubclientCtrl.selectedPlanList"
					button-label="'planName'"
					item-label="'planName'"
					tick-property="'selected'"														                
					selection-mode="'single'"
					directive-id="'subclientPlan'"
					max-labels="1"
					helper-elements="'filter'"
					translation="manageSharePointDBSubclientCtrl.localLang"
					disable-property="'disabled'"
					on-item-clicked="manageSharePointDBSubclientCtrl.processServerPlanSelection()">
				</cv-plan-summary-dropdown>

				<div class="help-block"
					data-ng-if="manageSubclientForm.$submitted"
					data-ng-show="!manageSharePointDBSubclientCtrl.selectedPlanList.length">
					<cv:msg key="placeholder.plan" bundle="capps" />
				</div>
			</div>
		</div>

		<div class="form-group" data-ng-if="!manageSharePointDBSubclientCtrl.isDocBkpUpSet" id="sqlClientSelect">
			<label  class="col-xs-12 col-sm-4" for="sqlClient">
			<cv:msg key="label.spsqlClient" bundle="sharepoint" />
			</label>
		   <div class="col-xs-12 col-sm-8">
				 <select name="sqlClient" 
                 data-ng-model="manageSharePointDBSubclientCtrl.subclientInfo.sharepointsubclientprop.ContentDatabaseSqlClient"
		 data-ng-options="ce as ce.displayName for ce in manageSharePointDBSubclientCtrl.sqlClientList | orderBy:'displayName' track by ce.clientId">
			<option value=""><cv:msg key="label.selectSqlServer" bundle="sharepoint"/></option>
		 </select>
			</div>

		</div>
		
		
		 <div class="form-group" data-ng-if="!manageSharePointDBSubclientCtrl.isDocBkpUpSet">
		  <label for="dbBackupStreams" class="col-xs-12 col-sm-4">
		     <cv:msg key="label.backupstreams" bundle="sharepoint"/>
		   </label>
		  <div class="col-xs-12 col-sm-8">
						<input type="number" min="1" max="32" value="1" id="dbBackupStreams" name="dbBackupStreams"
						data-ng-model="manageSharePointDBSubclientCtrl.subclientInfo.sharepointsubclientprop.ContentDatabasenumStreams"
						data-ng-disabled = "manageSharePointDBSubclientCtrl.subclientInfo.sharepointsubclientprop.ContentDatabaseSqlClient.clientId <= 0"/>
			</div>
		  </div>
		<div class="form-group" data-ng-if="!manageSharePointDBSubclientCtrl.isDocBkpUpSet">
			<label for="vdiTimeOut" class="col-xs-12 col-sm-4">
			   <cv:msg key="label.vdiTimeOut" bundle="sqlserver"/>
			  </label>
					<div class="col-xs-12 col-sm-8">
						<input type="number" min="300" max="2147483647" value="300" id="vdiTimeOut" name="vdiTimeOut"
						data-ng-model="manageSharePointDBSubclientCtrl.subclientInfo.sharepointsubclientprop.ContentDatabaseVDITimeout"
						data-ng-disabled = "manageSharePointDBSubclientCtrl.subclientInfo.sharepointsubclientprop.ContentDatabaseSqlClient.clientId <= 0"/>
					</div>
		</div> 

       <p
			class="{{ manageSharePointDBSubclientCtrl.contentMessage.type }} serverMessage"
			data-ng-bind="manageSharePointDBSubclientCtrl.contentMessage.message"
		></p>
		
		<div class="form-group margin-left-0" data-ng-show= "!manageSharePointDBSubclientCtrl.isDocBkpUpSet" id="browseDBContent">
		    <!--	<cv-kendo-grid data-cv-grid-options="manageSharePointDBSubclientCtrl.gridOptions"></cv-kendo-grid> -->
		    <cv-sp-content-browse-component
					data-subclient-entity="manageSharePointDBSubclientCtrl.subclientEntity"
					data-selected-sp-contents="manageSharePointDBSubclientCtrl.selectedContents"
					data-on-after-receiving-selected-sp-content=manageSharePointDBSubclientCtrl.selectedContentsFromCVSPBrowseDirective>
				</cv-sp-content-browse-component>
				
		</div>
		
		<div class="form-group margin-left-0" data-ng-show= "manageSharePointDBSubclientCtrl.isDocBkpUpSet" id="browseDocContent">
		   <cv-sp-office365-content-browse-component
					data-subclient-entity="manageSharePointDBSubclientCtrl.subclientEntity"
					data-selected-sp-contents="manageSharePointDBSubclientCtrl.selectedContents"
					data-on-after-receiving-selected-sp-content=manageSharePointDBSubclientCtrl.selectedContentsFromCVSPBrowseDirective>
		 </cv-sp-office365-content-browse-component> 
		</div>
		
	</div>
	<!--End --Modal Body-->

	<div class="modal-footer">
		<button class="btn btn-default" id="cancel" type="button" data-ng-click="manageSharePointDBSubclientCtrl.cancel()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button class="btn btn-primary cvBusyOnAjax" id="add" type="submit" ng-show="!manageSharePointDBSubclientCtrl.editMode">
				<i data-ng-if="manageSharePointDBSubclientCtrl.processingRequest" class="fa fa-spinner fa-spin"></i>			
			<cv:msg key="Add" bundle="messages" />
		</button>
		<button class="btn btn-primary cvBusyOnAjax" type="submit" id="save"  ng-show="manageSharePointDBSubclientCtrl.editMode">
				<i data-ng-if="manageSharePointDBSubclientCtrl.processingRequest" class="fa fa-spinner fa-spin"></i>
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
	<!--End --Modal Footer-->
</form>
