<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
  <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
  <cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
  <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
  <cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
  <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
  <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
  <cv:cvEnum name="TMMsg.RestoreToDiskType"></cv:cvEnum>
  <cv:cvEnum name="TMMsg.RestoreType"></cv:cvEnum>
  <cv:cvEnum name="App.BrowseLevelInGUI"></cv:cvEnum>
  </script>
<div class="setup-title">
<h1><cv:msg key="label.restore.options" bundle="sharepoint"/></h1>
</div>
<form class="form-horizontal bootstrap-wrapper"  data-cv-submit="spDocRestoreCtrl.prepareAndDoOfflineRestore()" novalidate name="restoreForm" autocomplete="off">
	<div class="modal-body-fixed no-padding">
		<div class="form-group row margin-top-10 margin-left-5 margin-right-5">
			<label class="col-xs-5"><cv:msg key="label.restoreTo" bundle="exchange" /></label>
			<div class="col-xs-7">
				<isteven-multi-select
					id="restoreTo"
					name="restoreTo"
					class="isteven-multi-select user-group-select isteven-summary-dropdown"
					html-template="true"
					input-model="spDocRestoreCtrl.restoreTypeList"
					output-model="spDocRestoreCtrl.selectedRestoreDestination"
					item-label="template"
					selection-mode="single"
					disable-property="disabled"
					button-label="name"
					max-labels="1"
					helper-elements="filter"
					tick-property="selected"
					on-item-click="spDocRestoreCtrl.restoreTypeChanged()"
					translation="spDocRestoreCtrl.localLang ">
				</isteven-multi-select>

			</div>
		</div>
		<cv-on-boarding-warning-msg backupset-id="spDocRestoreCtrl.entity.backupsetId" client-id="spDocRestoreCtrl.entity.clientId"is-tile-view="false" extra-classes="'margin-right-20 margin-left-20'"></cv-on-boarding-warning-msg>

		<div class="plain-accordion margin-top-10">
			<div class="cv-accordion-header">
				<span class="cv-accordion-text" data-ng-bind="spDocRestoreCtrl.restoreAccountMachineLabel"></span>
				<span class="availableTime-timelabel margin-top-0"><i class="k-icon k-i-information margin-right-5"></i>
					<label data-ng-bind="spDocRestoreCtrl.restoreAccountMachineHelpText"></label>
				</span>
			</div>
		</div>

		<!-- START - TO DISK -->
		<div data-ng-show="spDocRestoreCtrl.restoreType == 'DISK'" class="margin-left-5 margin-right-5 padding-left-15 padding-right-15">
			<div class="form-group margin-top-10">
				<label for="destinationServer" class="col-xs-5" >
					<cv:msg key="label.destClient" bundle="oracle"/>
				</label>
				<div class="col-xs-7">
					<select id="destinationServer" name="destinationServer"  data-ng-required="true" data-ng-disabled="!spDocRestoreCtrl.restoreToDisk"
						data-ng-model="spDocRestoreCtrl.destinationServer"
						data-ng-options="ds as ds.displayName for ds in spDocRestoreCtrl.destinationServerList track by (ds.displayName|lowercase)"
						data-ng-change="spDocRestoreCtrl.destinationServerChanged()" >
					</select>
				</div>
			</div>
			
			<div class="form-group">
				<label for="restoreDestinationDisk" class="col-xs-5"> 
					<cv:msg key="sp.offline.restore.destination.path" bundle="sharepoint"/>
				</label>
				<div class="col-xs-7">
					<div class="input-group">
						<input name="restoreDestinationDisk" id="restoreDestinationDisk" value="" type="text"
							data-ng-model="spDocRestoreCtrl.model.restoreToDiskPath"
							data-ng-pattern='spDocRestoreCtrl.model.winPathRegex' data-ng-required="spDocRestoreCtrl.restoreType == spDocRestoreCtrl.restoreToDisk" />
						<span class="input-group-btn">
						<button type="button" class="icon-style cv-material-button browse" data-ng-click="spDocRestoreCtrl.openDiskDestinationFolder()">
							<div class="cv-material-button-icon cursor-pointer">
								<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
							</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
						</button>
						</span>
					</div>
					<div class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.restoreDestinationDisk)" >
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.sp.restore.to.disk.path.empty" bundle="sharepoint"/>
					</div>
				</div>
			</div>
		</div>
		<!-- END - TO DISK -->		  
		
		<!-- START - TO SHAREPOINT -->
		<div data-ng-show="spDocRestoreCtrl.restoreType == 'NETSITE'" class="margin-left-5 margin-right-5 padding-left-15 padding-right-15">
			<!--Radio options -->
			<div class="form-group">
				<div class="col-xs-12">
					<div class="margin-top-10">
						<cv-radio-group 
							is-vertical="true" 
							is-Disabled="spDocRestoreCtrl.disableOutOfPlaceSiteRestore"
							radio-model="spDocRestoreCtrl.restoreToOriginalLocationRadioVal" 
							radio-obj="spDocRestoreCtrl.restoreLocationOptions" 
							on-click="spDocRestoreCtrl._restoreToOriginalLocationRadioValChange(data)">
						</cv-radio-group>
					</div>
				</div>
			</div>

			<!--in place restore option -->
			<!-- <div class="form-group">
				<div class="col-xs-12">
					<input id="inplace" name="inplace" 	type="checkbox" data-ng-model="spDocRestoreCtrl.restoreToOriginalPath"
				data-ng-change="spDocRestoreCtrl.configureWhenDocExists()" data-ng-disabled = "spDocRestoreCtrl.disableOutOfPlaceSiteRestore"/>
					<label	for="inplace"><cv:msg key="label.restoreToOriginal" bundle="restore"/></label>
				</div>
			</div> -->

			<!-- Out of Place Dest Browse for Document-->
			<div class="form-group" data-ng-if="spDocRestoreCtrl.isDoc">
				<label for="destinationServer" class="col-xs-5" data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath" >
					<cv:msg key="label.destClient" bundle="oracle"/>
				</label>
				<div class="col-xs-7">
					<select id="destinationServer" name="destinationServer"  data-ng-required="true" data-ng-disabled="spDocRestoreCtrl.restoreToOriginalPath"
						data-ng-model="spDocRestoreCtrl.destinationServer"
						data-ng-options="ds as ds.clientName for ds in spDocRestoreCtrl.destinationServerList track by (ds.clientName|lowercase)"
						data-ng-change="spDocRestoreCtrl.destinationServerChanged()" >
					</select>
				</div>
			</div>

			<!--path selection for out of place restore for sp v1 v2 -->
			<div class="form-group" data-ng-show = "!spDocRestoreCtrl.restoreToOriginalPath">
				<label for="restorePath" class="col-xs-5" data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath">
					<cv:msg key="label.destPath" bundle="snapArray"/> </label>
				<div class="col-xs-7">
					<div class="input-group">
						<input readonly type="text" name="restorePath" id="restorePath" data-ng-model="spDocRestoreCtrl.model.restoreDestinationNetSite" data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath" 
						data-ng-required="!spDocRestoreCtrl.restoreToOriginalPath && (spDocRestoreCtrl.restoreType == spDocRestoreCtrl.restoreToServer)" />
						<span class="input-group-btn">
							<button type="button" class="icon-style cv-material-button browse" data-ng-click="spDocRestoreCtrl.openNetSitesBrowseModal()" data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath">
								<div class="cv-material-button-icon cursor-pointer">
									<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
								</div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
							</button>
						</span>
					</div>
					<div class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.restorePath)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.pathRequired" bundle="restore"/>
					</div>
				</div>
			</div>
		</div>

		<!-- Azure Account -->
		<div  data-ng-if="!spDocRestoreCtrl.isAzureAccountSet && !spDocRestoreCtrl.isDoc && spDocRestoreCtrl.restoreType == 'NETSITE'" >
			<div class="plain-accordion margin-top-10">
				<div class="cv-accordion-header">
					<span class="cv-accordion-text"> <cv:msg key="label.azureStorageAccount" bundle="office365" /></span>
				</div>
			</div>
			<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
				<div class="form-group">
					<label class="col-xs-5"  for="azureUserAccount">
							<cv:msg key="label.azureUserAccount" bundle="sharepoint" />
						</label>
					<div class="col-xs-7">
						<input type="text" name="azureUserAccount" id="azureUserAccount" data-ng-model="spDocRestoreCtrl.azureUserAccount" data-ng-required="spDocRestoreCtrl.isV2 && !spDocRestoreCtrl.isAzureAccountSet" autoCompleteType="disable" autocomplete="off"/>
						<div class="help-block"  data-ng-show=" cv.restoreForm.needsAttention(restoreForm.azureUserAccount)">
							<cv:msg key="error.userName" bundle="servers" />
						</div>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-5" for="azurePassword">
						<cv:msg key="label.accountKey" bundle="sharepoint" />
					</label>
					<div class="col-xs-7">
						<input type="password" name="azurePassword" id="azurePassword" data-ng-model="spDocRestoreCtrl.azureAccountKey" data-ng-required="spDocRestoreCtrl.isV2 && !spDocRestoreCtrl.isAzureAccountSet" autoCompleteType="disable" autocomplete="off"/>
						<div class="help-block" data-ng-show=" cv.restoreForm.needsAttention(restoreForm.azurePassword)">
							<cv:msg key="error.pathRequired" bundle="restore"/>
						</div>
					</div>
				</div> 
			</div>
		</div>
		<!-- END - TO SHAREPOINT -->

		
		<!-- File level options -->
		<div class="plain-accordion margin-top-10">
			<cv-plain-accordion accordion-label='<cv:msg key="header.filelevel.options" bundle="office365" />'>
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
					<!-- SHAREPOINT Operation -->
					<div class="form-group margin-top-10" data-ng-show="spDocRestoreCtrl.restoreType == 'NETSITE'">
						<div class="col-xs-4 col-md-4 margin-top-15">
							<cv:msg key="sp.offline.info.whenDocExists" bundle="sharepoint"/>
						</div>
						<div class="col-xs-8 col-md-8">
							<label data-ng-if="spDocRestoreCtrl.restoreType == spDocRestoreCtrl.restoreToServer" data-ng-disabled="spDocRestoreCtrl.model.isDisableRadioDocExistOverwrite" class="element-indent-class" for="whenDocExistsOverwrite"><input id="whenDocExistsOverwrite" name="whenDocExistsRadio" value="OVERWRITE" class="" type="radio"
								data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
								<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.overwrite" bundle="sharepoint"/></span></label>
	
							
								<label data-ng-if="spDocRestoreCtrl.restoreType == spDocRestoreCtrl.restoreToServer"  data-ng-disabled="spDocRestoreCtrl.model.isDisableRadioDocExistSkip" class="element-indent-class" for="whenDocExists"><input id="whenDocExistsSkip" name="whenDocExistsRadio" value="SKIP" class="" type="radio"
									data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
								<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.skip" bundle="sharepoint"/></span></label>

								<label  data-ng-if="spDocRestoreCtrl.isDoc" data-ng-disabled="spDocRestoreCtrl.model.isDisableRadioDocExistAppend" class="element-indent-class" for="whenDocExists"><input id="whenDocExistsAppend" name="whenDocExistsRadio" value="APPEND" class="" type="radio"
								data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
								<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.append" bundle="sharepoint"/></span></label>
								
								<label  data-ng-if="spDocRestoreCtrl.isDoc" data-ng-disabled="spDocRestoreCtrl.model.isDisableRadioDocExistMerge" class="element-indent-class" for="whenDocExists"><input id="whenDocExistsAppend" name="whenDocExistsRadio" value="MERGE" class="" type="radio"
							data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
							<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.merge" bundle="sharepoint"/></span></label>
						</div>
					</div>

					<!-- DISK Operation -->
					<div class="form-group margin-top-10" data-ng-show="spDocRestoreCtrl.restoreType == 'DISK'">
						<div class="col-xs-12">
							<input id="overwrite" name="overwrite" 	type="checkbox" data-ng-model="spDocRestoreCtrl.model.restorDiskWhenSiteExistsOverwrite"/>
							<label	for="overwrite"><cv:msg key="warning.overwrite" bundle="restore"/></label>
						</div>
					</div>

				</div>
			</cv-plain-accordion>
		</div>
		<!-- Advance options -->
		<div class="plain-accordion margin-top-10">
			<cv-plain-accordion accordion-label="header.restoreoptions.advancedOptions">
				<div class="margin-left-5 margin-right-0 padding-left-15 padding-right-15">
					<!-- SHAREPOINT Operation -->
					<div class="form-group margin-top-10" data-ng-show="spDocRestoreCtrl.restoreType == 'NETSITE'">
						<!--ACL option -->
						<div class="col-xs-12">
							<input type="checkbox" id="restoreACLs" name="restoreACLs" data-ng-model="spDocRestoreCtrl.model.isRestoreAcls"
							data-ng-change="spDocRestoreCtrl.restoreOnlyTypeOptn(spDocRestoreCtrl.SHAREPOINT_CONSTANTS.RESTORE_ACLS)"/>
							<label for="restoreACLs"><cv:msg key="sp.offline.restore.acls" bundle="sharepoint" /></label>
						</div>

						<!--Workflow and alerts option -->
						<div class="col-xs-12">
							<input type="checkbox" id="restoreWorkFlow" name="restoreWorkFlow" data-ng-model="spDocRestoreCtrl.model.isRestoreWorkFlow"
							data-ng-change="spDocRestoreCtrl.restoreOnlyTypeOptn(spDocRestoreCtrl.SHAREPOINT_CONSTANTS.RESTORE_WORKFLOW)"/>
							<label for="restoreWorkFlow"><cv:msg key="sp.offline.restore.workflowAndAlert" bundle="sharepoint" /></label>
						</div>
						
					</div>
					<!-- DISK Operation -->
					<div class="form-group margin-top-10" data-ng-show="spDocRestoreCtrl.restoreType == 'DISK'">
						<div class="col-xs-12">
							<div class="global-options remove-border-padding">
								<label for="docTypeOfRestore" >
									<cv:msg key="sp.offline.restore.to.disk.as" bundle="sharepoint"/>
								</label>
								</div>
								<div>
								<label for="restoreToDiskOptNative">
									<input id="restoreToDiskOptNative" name="restoreToDiskOptNative" value="SPNATIVE" class="" type="radio" data-ng-model="spDocRestoreCtrl.model.typeOfSaveToDisk" />
									<cv:msg key="sp.offline.typeOfSaveToDisk.native" bundle="sharepoint"/></label>
										
								<label for="restoreToDiskOptOrigFiles">
									<input id="restoreToDiskOptOrigFiles" name="restoreToDiskOptOrigFiles" value="ORIGFILES" class="" type="radio" data-ng-model="spDocRestoreCtrl.model.typeOfSaveToDisk" />
									<cv:msg key="sp.offline.typeOfSaveToDisk.orig.files" bundle="sharepoint"/></label>
							</div>
						</div>
					</div>
				</div>
			</cv-plain-accordion>
		</div>
	
		<div data-ng-if="spDocRestoreCtrl.isV2 && spDocRestoreCtrl.isSitesSelected" class="plain-accordion float-left margin-top-10">
			<div class="cv-accordion-header input-group">
				<span class="padding-15 k-icon k-i-warning red-font fa-2x"></span>
				<div class="cv-accordion-header text-align-left font-size-12">
					<cv:msg key="warning.restoreoptions.SPsubsiteIncluded" bundle="office365" />
				</div>
			</div>
		</div>
			
	 
	 		
	</div>
<div class="modal-footer">
	<button id="office365RestoreOptions_button_#5169" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spDocRestoreCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
	<button id="office365RestoreOptions_button_#3836" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.button.restore" bundle="sharepoint"/></button> 
</div>
</form>
