<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>

 <form name="editSPOffice365InfoForm" data-cv-submit="spSCEditSqlOpts.saveInfo()" novalidate autocomplete="off" class="form-horizontal bootstrap-wrapper">
     <div class="modal-header">
		<h1><cv:msg key="label.office365Details" bundle="sharepoint" /></h1>
	</div>
     <!--End --Modal Header-->

	<div class="modal-body">
		<p
			class="{{spSCEditSqlOpts.spSCEditSqlOptsMessage.type}} serverMessage"
			data-ng-bind="spSCEditSqlOpts.spSCEditSqlOptsMessage.message"
		></p>
	<div class="form-group row" >	
	     <label for="adminSiteURL" class="col-xs-12 col-sm-4">
			<cv:msg key="label.tenantURL" bundle="sharepoint" /> 
		 </label>
		 <div class="col-xs-12 col-sm-8">	
		   <input type="text" id="adminSiteURL" name="adminSiteURL" 
		     data-ng-model="spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.tenantUrlItem" 
		     data-ng-change="serverMessage.message=''" 
		     required/>
	       <span class="help-block" data-ng-show="cv.editSPOffice365InfoForm.needsAttention(editSPOffice365InfoForm.adminSiteURL);" >
	         <cv:msg key="error.tenantAdminSiteURL" bundle="clients" />
	       </span>
	     </div>
	 </div>
	 
	 <div ng-if="!spSCEditSqlOpts.isOffice365SaaSTenant">
	        <div ng-if="!spSCEditSqlOpts.hideAzure">
		    <div class="form-group row" >
		    <label class="col-xs-12 col-sm-4" for="azureUserAccount" >
			 <cv:msg key="label.azureUserAccount" bundle="sharepoint" /></label>
			 <div class="col-xs-12 col-sm-8">
			    <input type="text" name="azureUserAccount" data-ng-model="spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.azureUserAccount" title={{spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.azureUserAccount}}  autoCompleteType="disable" autocomplete="off"/>
			 <span class="help-block" data-ng-show="cv.editSPOffice365InfoForm.needsAttention(editSPOffice365InfoForm.azureUserAccount);"><cv:msg key="error.userName" bundle="servers" /></span>
	         </div>
	     </div>
	     
	     <div class="form-group row">
		    <label class="col-xs-12 col-sm-4" for="azurePassword">
		         <cv:msg key="label.accountKey" bundle="sharepoint" /></label>
		     <div class="col-xs-12 col-sm-8">
		       <input type="password" name="azurePassword" data-ng-model="spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.azureAccountKey"  placeholder="<cv:msg key="label.keepBlank" bundle="sharepoint"></cv:msg>"autoCompleteType="disable" autocomplete="off"/>
	          </div>
		 </div>
		 </div>
	 </div>
	 <div class="form-group row">
	      <label for="username" class="col-xs-12 col-sm-4">
		   <cv:msg key="label.userName" bundle="serversJs" /></label>
		  <div class="col-xs-12 col-sm-8">
		  <input type="text" name="username" data-ng-model="spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.office365Credentials.userName" title={{spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.office365Credentials.userName}} required autoCompleteType="disable" autocomplete="off"/>
		  <span class="help-block" data-ng-show="cv.editSPOffice365InfoForm.needsAttention(editSPOffice365InfoForm.username);"><cv:msg key="error.userName" bundle="servers" /></span>
	      </div>
	  </div>
	  
      <div class="form-group row">
		<label for="password" class="col-xs-12 col-sm-4">
		  <cv:msg key="label.password" bundle="serversJs" /></label>
		  <div class="col-xs-12 col-sm-8">
		  <input type="password" name="password" data-ng-model="spSCEditSqlOpts.spOffice365Info.spOffice365BackupSetProp.office365Credentials.password"  autoCompleteType="disable" autocomplete="off"/>
		  <span class="help-block" data-ng-show="spSCEditSqlOpts.isPasswordNeeded"><cv:msg key="error.password" bundle="servers" /></span>
	      </div>
	  </div>  
		
	 
      <div class="form-group margin-top-10 margin-left-0">
			<cv-kendo-grid data-cv-grid-options="spSCEditSqlOpts.gridOptions"></cv-kendo-grid>
	  </div>
		
   </div>    
   <div class="modal-footer">
				<button id="editOffice365Prop_button_#9141" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spSCEditSqlOpts.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="editOffice365Prop_button_#3079" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
	</div>

</form>   
