<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvEnum name="App.SharePointVersion"></cv:cvEnum>
</script>
<div class="setup-title">
	<h1 data-ng-show="spCreatePseudoClientCtrl.model.clientId == 0"><cv:msg key="label.sp.create.farm.client" bundle="sharepoint"/></h1>
	<h1 data-ng-show="spCreatePseudoClientCtrl.model.clientId > 0"><cv:msg key="label.sp.edit.farm.client" bundle="sharepoint"/></h1>
</div>
<div class="bootstrap-wrapper">
	<div class="col-md-12">
		<div class="{{spCreatePseudoClientCtrl.spPseudoClientMessage.type}} serverMessage">{{spCreatePseudoClientCtrl.spPseudoClientMessage.message}}</div>
	</div>
	<form class="form-horizontal" data-cv-submit="spCreatePseudoClientCtrl.createPseudoClient()" novalidate name="spPseudoClientForm" autocomplete="off">
		<div class="panel panel-default">
			<div class="panel-body">
				<!-- Client Name -->
				<div class="form-group" data-ng-show="spCreatePseudoClientCtrl.model.clientId == 0">
					<label class="col-xs-12 col-md-5 col-lg-5" for="pseudoClientName"><cv:msg key="sp.pseudo.client.name" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input name="pseudoClientName" id="pseudoClientName" type="text" data-ng-model="spCreatePseudoClientCtrl.model.clientName" required/>
						<span class="help-block" data-ng-show="cv.spPseudoClientForm.needsAttention(spPseudoClientForm.pseudoClientName)"><cv:msg key="error.sp.pseudo.client.empty" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- Client name end -->
				<!-- SharePoint version -->
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="spVersion"><cv:msg key="header.sharepoint.version" bundle="sharepoint"/></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<select id="spVersion" name="spVersion"
								data-ng-model="spCreatePseudoClientCtrl.model.spVersion"
							 	data-ng-options="sharepointVersion.name for sharepointVersion in spCreatePseudoClientCtrl.spVersionList | orderBy:'name'"
							 	data-ng-change="spCreatePseudoClientCtrl.getPrimaryMemberServersForSPVersion(spCreatePseudoClientCtrl.model.spVersion)"
							 	required>
						<option value=""><cv:msg key="label.select.sharepointVersion" bundle="sharepoint" /></option>
						</select>
						<span class="help-block" data-ng-show="cv.spPseudoClientForm.needsAttention(spPseudoClientForm.spVersion)"><cv:msg key="error.sp.pseudo.spVersion.empty" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- End SharePoint version -->
				<!-- Primary servers -->
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="primaryMemberServer"><cv:msg key="sp.pseudo.primary.member.servers" bundle="sharepoint"/>
						<cv-help-component help-text="<cv:msg key="sp.pseudo.primary.member.servers.help.text" bundle="sharepoint"/>"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						 <select id="primaryMemberServer" name="primaryMemberServer"  data-ng-model="spCreatePseudoClientCtrl.model.primaryMemberServer"
							 			   					 data-ng-options="ce as ce.clientName for ce in spCreatePseudoClientCtrl.primaryMemberServerList | orderBy:'clientName'"
							 			   					 data-ng-change="spCreatePseudoClientCtrl.getSecondaryMemberServers(spCreatePseudoClientCtrl.model.primaryMemberServer)" required>
							<option value=""><cv:msg key="label.select.primary.server" bundle="sharepoint"/></option>
						</select>
						<span class="help-block" data-ng-show="cv.spPseudoClientForm.needsAttention(spPseudoClientForm.primaryMemberServer)"><cv:msg key="error.sp.pseudo.primaryMemberServer.empty" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- End Primary servers -->
				<!-- Secondary servers -->
				<div class="form-group">
					<label class="col-xs-12 col-md-5 col-lg-5" for="secondaryMemberServer"><cv:msg key="sp.pseudo.secondary.member.servers" bundle="sharepoint"/>
						<span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
						<cv-help-component help-text="<cv:msg key="sp.pseudo.secondary.member.servers.help.text" bundle="sharepoint"/>"></cv-help-component>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
			   				  input-model="spCreatePseudoClientCtrl.secondaryMemberServerList"
			   				  output-model="spCreatePseudoClientCtrl.model.selectedSecondaryMemberServerList"
			  				  button-label="clientName"
							  item-label="clientName"
			   				  tick-property="selected"
			   				  class="isteven-multi-select user-group-select"
			   				  id="spCreatePseudoClientCtrl.secondaryMemberServerList"
			   				  name="spCreatePseudoClientCtrl.secondaryMemberServerList"
			   				  helper-elements="all none reset filter"
			   				  max-labels="2"
			   				  translation="spCreatePseudoClientCtrl.localLang"
			   				  disable-property="spCreatePseudoClientCtrl.disableSecServerSelect"
			   				  on-item-click="spCreatePseudoClientCtrl.validateSecServerSelection()"
			   				  on-select-none="spCreatePseudoClientCtrl.validateSecServerSelection()"
			   				  on-select-all="spCreatePseudoClientCtrl.validateSecServerSelection()"
			   				  on-reset="spCreatePseudoClientCtrl.validateSecServerSelection()"
			   				  >
						</isteven-multi-select>
					</div>
				</div>
				<!-- End Secondary servers -->
				<!-- Plan -->
				<div class="form-group" data-ng-show="spCreatePseudoClientCtrl.model.clientId == 0">
					<label class="col-xs-12 col-md-5 col-lg-5" for="plan"><cv:msg key="label.profile" bundle="profiles"/>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7" data-ng-if="spCreatePseudoClientCtrl.planList.length > 0">
						<isteven-multi-select id="office365SpCreatePseudoClient_isteven-multi-select_#4064" 
			   				  input-model="spCreatePseudoClientCtrl.planList"
			   				  output-model="spCreatePseudoClientCtrl.model.selectedPlan"
			  				  button-label="planName"
							  item-label="planName"
			   				  tick-property="checked"
			   				  class="isteven-multi-select user-group-select"
			   				  helper-elements="none"
			   				  selection-mode="single"
			   				  translation="spCreatePseudoClientCtrl.localLang"
			   				  group-property="msGroup"
			   				  >
						</isteven-multi-select>
						<span class="help-block" data-ng-show="spCreatePseudoClientCtrl.showPlanErrorMessage"><cv:msg key="error.sp.pseudo.client.no.plan" bundle="sharepoint"/></span>
					</div>
				</div>
				<!-- End of Plan -->
			</div>
		</div>
		<div class="modal-footer">
			<button id="office365SpCreatePseudoClient_button_#2272" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spCreatePseudoClientCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="office365SpCreatePseudoClient_button_#3434" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages"/></button> 
		</div>
	</form>
</div>
