<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
	<cv:cvEnum name="TMMsg.SharePointMetaDataType"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.SharepointDBRestoreType"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.SP_DB_RESTORE_OPT"></cv:cvEnum>
	<cv:cvEnum name="TMMsg.SqlRestoreType"></cv:cvEnum>
</script>
<div class="row bootstrap-wrapper" data-ng-hide="spCntSpcFarmRestCtrl.hideRestoreOpts">
	<div
		class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
		<h1 class="page-header">
			<span data-ng-if="spCntSpcFarmRestCtrl.itemsForWebApplication.length > 0">
				<cv:msg key="label.webAppRestore" bundle="sharepoint" />
				<cv-help-component help-text='<cv:msg key="info.webAppRestore" bundle="sharepoint"/>'></cv-help-component>
			</span>
			<span data-ng-if="spCntSpcFarmRestCtrl.itemsForSharedServices.length > 0">
				<cv:msg key="label.sharedServiceRestore" bundle="sharepoint" />
				<cv-help-component help-text='<cv:msg key="info.sharedServiceRestore" bundle="sharepoint"/>'></cv-help-component>
			</span>
			<span data-ng-if="(spCntSpcFarmRestCtrl.itemsForDatabase.length > 0) && (spCntSpcFarmRestCtrl.itemsForWebApplication.length == 0) && (spCntSpcFarmRestCtrl.itemsForSharedServices.length == 0)">
				<cv:msg key="label.databaseRestore" bundle="sharepoint" />
				<cv-help-component help-text='<cv:msg key="info.databaseRestore" bundle="sharepoint"/>'></cv-help-component>
			</span>
			<span data-ng-if="spCntSpcFarmRestCtrl.NoWaDbSSFound">
				<cv:msg key="label.sharePointRestore" bundle="sharepoint" />
				<cv-help-component help-text='<cv:msg key="info.sharePointRestore" bundle="sharepoint"/>'></cv-help-component>
			</span>
		</h1>
		<form class="form-horizontal" data-cv-submit="spCntSpcFarmRestCtrl.prepareAndDoRestore()" novalidate name="spCntSpcFarmRestCtrl.spContentForSpecificFarmForm" autocomplete="off">
		<!-- General -->
			<uib-accordion close-others="false" class="text-left">
				 <div uib-accordion-group  is-open="true" class="form-panel-holder" data-scroll-to-when-open>
				 	 <uib-accordion-heading><cv:msg key="label.sc.content.browse.restore.opts.general" bundle="sharepoint"/>
				 	 	<!-- <i class="float-right glyphicon glyphicon-chevron-down"></i> -->
				 	 </uib-accordion-heading>
					<div class="panel panel-default">
						<!-- SPclient name -->
						<div class="form-group">
							<label class="col-xs-12 col-md-3 col-lg-3" for="sharepointClientName"><cv:msg key="label.sharepointClientName" bundle="sharepoint" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								 <select name="spClient"  data-ng-disabled="spCntSpcFarmRestCtrl.disableSPClient()"
								 						  data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.spClient"
											 			  data-ng-options="ce as ce.clientName for ce in spCntSpcFarmRestCtrl.spClientList | orderBy:'clientName' track by ce.clientId">
								</select>
							</div>
						</div>
						<!-- SP SQL client -->
						<div class="form-group" data-ng-show="((spCntSpcFarmRestCtrl.itemsForSharePointDB.length > 0) &&(spCntSpcFarmRestCtrl.spContentRestoreModel.originalSqlClient.clientId > 0))">
							<label class="col-xs-12 col-md-3 col-lg-3" for="sqlServerClient"><cv:msg key="label.sqlServerClient" bundle="sharepoint" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								 <select name="sqlClient"  data-ng-disabled="! spCntSpcFarmRestCtrl.isDatabaseSectionNeeded()"
								 						   data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.sqlClient"
											 			   data-ng-options="ce as ce.clientName for ce in spCntSpcFarmRestCtrl.sqlClientList | orderBy:'clientName' track by ce.clientId">
								</select>
								<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.sqlClient"><cv:msg key="error.restore.sql.client" bundle="sharepoint"/></span>
							</div>
						</div>
						<!-- Restore mode DD (custom) -->
						<div class="form-group" data-ng-show="((spCntSpcFarmRestCtrl.itemsForWebApplication.length > 0) && (spCntSpcFarmRestCtrl.itemsForDatabase.length > 0)) || ((spCntSpcFarmRestCtrl.itemsForSharedServices.length > 0) && (spCntSpcFarmRestCtrl.itemsForDatabase.length > 0))">
							<label class="col-xs-12 col-md-3 col-lg-3" for="restoreOptions"><cv:msg key="label.restore.options" bundle="sharepoint" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<select data-ng-if="(spCntSpcFarmRestCtrl.itemsForWebApplication.length > 0) && (spCntSpcFarmRestCtrl.itemsForDatabase.length > 0)" name="restoreOpts"
										data-ng-init="spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption = {value:spCntSpcFarmRestCtrl.restoreModeType}"
										data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption"
										data-ng-change="spCntSpcFarmRestCtrl.restoreModeType = spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption"
										data-ng-options="wa.name for wa in spCntSpcFarmRestCtrl.resoreOptionsWA track by wa.value">
								</select>
								<select data-ng-if="(spCntSpcFarmRestCtrl.itemsForSharedServices.length > 0) && (spCntSpcFarmRestCtrl.itemsForDatabase.length > 0)" name="restoreOpts"
										data-ng-init="spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption = {value:spCntSpcFarmRestCtrl.restoreModeType}"
										data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption"
										data-ng-change="spCntSpcFarmRestCtrl.restoreModeType = spCntSpcFarmRestCtrl.spContentRestoreModel.restoreOption"
										data-ng-options="ss.name for ss in spCntSpcFarmRestCtrl.resoreOptionsSS track by ss.value">
								</select>
							</div>
						</div>
					</div>
				</div>
			</uib-accordion>
			<!-- End of General -->
			<!-- Database --> <!-- Control the accordion by the drop-down-values -->
			<uib-accordion close-others="false" class="text-left" data-ng-show="(spCntSpcFarmRestCtrl.itemsForDatabase.length > 0) && spCntSpcFarmRestCtrl.isDatabaseSectionNeeded()">
				 <div uib-accordion-group  is-open="true" class="panel form-panel-holder" data-scroll-to-when-open>
					<uib-accordion-heading><cv:msg key="label.sc.content.browse.restore.opts.database" bundle="sharepoint"/>
					 	 	<i class="float-right glyphicon glyphicon-chevron-down"></i>
					</uib-accordion-heading>
					<div class="panel panel-default">
						<div class="form-group">
							<label class="col-xs-12 col-md-3 col-lg-3" for="recoveryTypesLbl"><cv:msg key="label.recovery.types" bundle="sharepoint" /></label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<div class="storage-type">
						            <label>
						                <input type="radio" data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.recoveryType" value="{{spCntSpcFarmRestCtrl.recoveryTypeRecovery}}" name="RECOVERYTYPE">
						                <cv:msg key="label.recovery.type.recovery" bundle="sharepoint"/>
						            </label>
						            <label>&nbsp;</label>
						            <label>
						                <input type="radio" data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.recoveryType" value="{{spCntSpcFarmRestCtrl.recoveryTypeNoRecovery}}" name="RECOVERYTYPE">
						                <cv:msg key="label.recovery.type.norecovery" bundle="sharepoint"/>
						            </label>
						        </div>
							</div>
						</div>
						<div class="form-group">
							<div class="col-xs-12 col-md-5 col-lg-5" for="restoreDiskPath">
								<input type="checkbox" id="restoreToDisk" name="restoreToDisk" data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.isRestoreToDisk" data-ng-change="spCntSpcFarmRestCtrl.inputAlerts.dbDestPath=false;"/>
	                    		<label for="restoreToDisk"><cv:msg key="sp.label.restore.to.disk" bundle="sharepoint" /></label>
	                    	</div>
						</div>
						<div class="form-group" data-ng-disabled="!spCntSpcFarmRestCtrl.spContentRestoreModel.isRestoreToDisk">
							<label class="col-xs-12 col-md-3 col-lg-3" for="pathOnDestinationServer"><cv:msg key="label.path.on.dest.server" bundle="sharepoint"/>
							</label>
							<div class="col-xs-12 col-md-7 col-lg-7">
								<div class="input-group">
									<input type="text" name="dbDestPath" id="pathOnDestinationServer" data-ng-model="spCntSpcFarmRestCtrl.spContentRestoreModel.dbDestPath" data-ng-pattern='pathPattern' data-ng-change="spCntSpcFarmRestCtrl.inputAlerts.dbDestPath=false;"/>
									<span class="input-group-btn">
										<button id="office365SpContentSpecificFarmRestore_button_#8404" type="button" data-ng-click="spCntSpcFarmRestCtrl.browse()" class="btn btn-default browse-btn"> 
											<cv:msg key="Browse" bundle="storage" />
										</button>
									</span>
								</div>
								<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.dbDestPath"><cv:msg key="error.sp.restore.to.disk.path.empty" bundle="sharepoint"/></span>
							</div>
						</div>
					</div>
				</div>
			</uib-accordion>
			<!-- End of Database -->
			<!-- WebApplication -->
			 <uib-accordion close-others="false" class="text-left" data-ng-show="spCntSpcFarmRestCtrl.isWebAppSectionNeeded()">
				<div uib-accordion-group  is-open="true" class="panel form-panel-holder" data-scroll-to-when-open>
					<uib-accordion-heading><cv:msg key="label.sc.content.browse.restore.opts.web.application" bundle="sharepoint"/>
					 	 	<i class="float-right glyphicon glyphicon-chevron-down"></i>
					</uib-accordion-heading>
			 	 	<div class="panel panel-default" data-ng-if="spCntSpcFarmRestCtrl.itemsForWebApplication.length > 0">
			 	 		<div class="panel-body">
			 	 			<div class="form-group">
					 	 		<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.webAppLoginName"><cv:msg key="error.restore.web.app.username" bundle="sharepoint"/></span>
								<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.webAppPwd"><cv:msg key="error.restore.web.app.pwd" bundle="sharepoint"/></span>
					 	 		<cv-grid cv-grid-options="spCntSpcFarmRestCtrl.spWebAppGridOptions"></cv-grid>
					 	 	</div>
				 	 	</div>
			 	 	</div>
				</div>
			</uib-accordion>
			<!-- End of WebApplication -->
			<!-- SharedService -->
			<uib-accordion close-others="false" class="text-left" data-ng-show="spCntSpcFarmRestCtrl.isSharedServiceSectionNeeded()">
				<div uib-accordion-group  is-open="true" class="panel form-panel-holder" data-scroll-to-when-open>
					<uib-accordion-heading><cv:msg key="label.sc.content.browse.restore.opts.service.application" bundle="sharepoint"/>
					 	 	<i class="float-right glyphicon glyphicon-chevron-down"></i>
					</uib-accordion-heading>
					<div class="panel panel-default" data-ng-if="spCntSpcFarmRestCtrl.itemsForSharedServices.length > 0">
						<div class="panel-body">
							<div class="form-group">
								<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.sharedServiceUsername"><cv:msg key="error.restore.shared.service.username" bundle="sharepoint"/></span>
								<span class="help-block" data-ng-show="spCntSpcFarmRestCtrl.inputAlerts.sharedServicePwd"><cv:msg key="error.restore.shared.service.pwd" bundle="sharepoint"/></span>
					 	 		<cv-grid cv-grid-options="spCntSpcFarmRestCtrl.spSharedApplicationsGridOptions"></cv-grid>
					 	 	</div>
				 	 	</div>
			 	 	</div>
				</div>
			</uib-accordion>
			<!-- End of SharedService -->
			<div class="button-container">
					<button id="office365SpContentSpecificFarmRestore_button_#0570" type="button" class="btn btn-default" data-ng-click="spCntSpcFarmRestCtrl.backToSpContentBrowse()"> 
						<cv:msg key="Back" bundle="messages" />
					</button>
					<button id="office365SpContentSpecificFarmRestore_button_#6272" type="submit" class="btn btn-primary"><cv:msg key="label.button.restore" bundle="sharepoint"/></button> 
			</div>
		</form>
	</div>
</div>