<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="heading.selectSharepointServer" bundle="sharepoint"/></h1>
</div>
<div class="setup-content">
	<form id="NewBackupSetForm" name="NewBackupSetForm" data-cv-submit="SPClientModalCtrl.submitNewBackupSetModal()" novalidate>
		<!-- isteven with single-select -->
		<label>
			<span class="long-label-span"><cv:msg key="label.serverName" bundle="sharepoint" /></span>
			<div class="company-multi-select">
				<isteven-multi-select
					translation="SPClientModalCtrl.localLang"
			 		input-model="SPClientModalCtrl.serversList"
			 		output-model="SPClientModalCtrl.selectedServer"
			 		button-label="servername"
			 		item-label="servername"
			 		tick-property="selected"
			 		helper-elements="none"
			 		selection-mode="single"
			 		class="isteven-multi-select user-group-select"
			 		id="server"
			 		name="server"
			 		max-labels="1"
			 		ng-cloak>
				</isteven-multi-select>
			</div>
			<span class="help-block" data-ng-show="inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
		</label>
		<div class="button-container">
	  		<button id="office365SelectClient_button_#1834" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="SPClientModalCtrl.cancelSelectClientModal()"><cv:msg key="Cancel" bundle="messages" /></button> 
    		<button id="office365SelectClient_button_#7516" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="SPClientModalCtrl.selectedServer.length <= 0"><cv:msg key="OK" bundle="messages" /></button> 
		</div>
	</form>
</div>