<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
  <cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
  <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
  <cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
  <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
  <cv:cvEnum name="TMMsg.RestoreToDiskType"></cv:cvEnum>
  <cv:cvEnum name="TMMsg.RestoreType"></cv:cvEnum>
  <cv:cvEnum name="App.BrowseLevelInGUI"></cv:cvEnum>
  </script>
  
<div class="setup-title">
<h1><cv:msg key="label.restore.options" bundle="sharepoint"/></h1>
</div>
<div class="setup-content">
	<form class="restore-form" data-cv-submit="spDocRestoreCtrl.prepareAndDoOfflineRestore()" novalidate name="spDocRestoreCtrl.spCOfflineRestoreForm" autocomplete="off">
	<div class="global-options destinationServerDiv">
					<label for="destinationServer" class="select-label restorePathLabel" >
					 <cv:msg key="label.destClient" bundle="oracle"/>
						<select id="destinationServer" name="destinationServer"  data-ng-required="true" data-ng-disabled="!spDocRestoreCtrl.restoreToDisk"
								data-ng-model="spDocRestoreCtrl.destinationServer"
								data-ng-options="ds as ds.clientName for ds in spDocRestoreCtrl.destinationServerList track by (ds.clientName|lowercase)"
								data-ng-change="spDocRestoreCtrl.destinationServerChanged()" >
						</select>
					</label>
	</div>
	
	<div class="global-options remove-border-padding">
	<div style="clear:both;" data-ng-disabled="spDocRestoreCtrl.restoreToDisk">
					<input name="originalPath" id="originalPath" type="checkbox"
					    data-ng-model="spDocRestoreCtrl.restoreToOriginalPath"
					    data-ng-click="spDocRestoreCtrl.configureWhenDocExists()">
					<label for="originalPath" class="overwriteLabel"><cv:msg key="label.restoreToOriginal" bundle="restore"/></label>
	</div>
	
	<label for="restorePath" class="restorePathLabel">
		<cv:msg key="label.destPath" bundle="snapArray"/>
					<button id="office365RestoreOptions_button_#7331" type="button" 
						data-ng-click="spDocRestoreCtrl.openNetSitesBrowseModal()"
						class="btn btn-default browse-btn"  data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath || spDocRestoreCtrl.restoreToDisk">
						<cv:msg key="label.browse" bundle="restore"/>
					</button>
					<input readonly type="text" name="restorePath" id="restorePath" data-ng-model="spDocRestoreCtrl.model.restoreDestinationNetSite" data-ng-disabled = "spDocRestoreCtrl.restoreToOriginalPath || spDocRestoreCtrl.restoreToDisk" data-ng-required="!spDocRestoreCtrl.restoreToOriginalPath">
					<span class="help-block" data-ng-show="spDocRestoreCtrl.isRestoreDestinationPathNeeded() && cv.restoreForm.needsAttention(restoreForm.restorePath)">
						<cv:msg key="error.pathRequired" bundle="restore"/>
					</span>
				
	</label>
	
	
				
	<div style="clear:both;">
					<input name="diskTypeOfRestoreDestination" id="rtd" type="checkbox"  data-ng-model="spDocRestoreCtrl.restoreToDisk" data-ng-click="spDocRestoreCtrl.restoreToDiskAction()">
					<label for="rtd" class="overwriteLabel"><cv:msg key="label.restoreToDisk" bundle="sqlserver"/></label>
	</div>
	
	
	
	<div class="global-options remove-border-padding"  data-ng-show="spDocRestoreCtrl.restoreToDisk">
	    <label for="docTypeOfRestore"><cv:msg key="sp.offline.restore.to.disk.as" bundle="sharepoint"/></label>
	
        <div class="global-options remove-border-padding form-panel-holder" data-ng-show="spDocRestoreCtrl.restoreToDisk">
						
				<label class="element-indent-class" for="restoreToDiskOptNative"><input id="restoreToDiskOptNative" name="restoreToDiskOptNative" value="SPNATIVE" class="" type="radio" data-ng-model="spDocRestoreCtrl.model.typeOfSaveToDisk"/>
				<cv:msg key="sp.offline.typeOfSaveToDisk.native" bundle="sharepoint"/></label>
						
				<label class="element-indent-class" for="restoreToDiskOptOrigFiles"><input id="restoreToDiskOptOrigFiles" name="restoreToDiskOptOrigFiles" value="ORIGFILES" class="" type="radio" data-ng-model="spDocRestoreCtrl.model.typeOfSaveToDisk"/>
				<cv:msg key="sp.offline.typeOfSaveToDisk.orig.files" bundle="sharepoint"/></label>
						
	    </div>
		
					
	
	<label for="restoreDestinationDisk" class="restorePathLabel"><cv:msg key="sp.offline.restore.destination.path" bundle="sharepoint"/>
		<button id="office365RestoreOptions_button_#7926" type="button" class="btn btn-default browse-btn" data-ng-click="spDocRestoreCtrl.openDiskDestinationFolder()"> 
				<cv:msg key="action.browse" bundle="collections"/>
		</button>
		<input name="restoreDestinationDisk" id="restoreDestinationDisk" value="" type="text"
								data-ng-model="spDocRestoreCtrl.model.restoreToDiskPath"
								data-ng-change="spDocRestoreCtrl.inputAlerts.destPath=false;">
							
		<span class="help-block" data-ng-show="spDocRestoreCtrl.inputAlerts.destPath">
		<cv:msg key="error.sp.restore.to.disk.path.empty" bundle="sharepoint"/>
		</span>
	 </label>
	 </div>
	
	<div data-ng-show="!spDocRestoreCtrl.restoreToDisk">
					
						<input type="checkbox" id="restoreACLs" name="restoreACLs" data-ng-model="spDocRestoreCtrl.model.isRestoreAcls"
							data-ng-click="spDocRestoreCtrl.configureWhenDocExists()"/>
                   		<label for="restoreACLs"><cv:msg key="sp.offline.restore.acls" bundle="sharepoint" /></label>
                   
				</div>
				
	
			
				
	<div class="global-options remove-border-padding">
					<label  for="whenDocExists">
					<cv:msg key="sp.offline.info.whenDocExists" bundle="sharepoint"/></label>
	</div>
				   
	<div class="global-options remove-border-padding form-panel-holder">
							
	<label data-ng-disabled="!spDocRestoreCtrl.restoreToOriginalPath && !spDocRestoreCtrl.restoreToDisk " class="element-indent-class" for="whenDocExistsOverwrite"><input id="whenDocExistsOverwrite" name="whenDocExistsOverwrite" value="OVERWRITE" class="" type="radio"
		data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
	<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.overwrite" bundle="sharepoint"/></span></label>
						
						
	<label data-ng-disabled="spDocRestoreCtrl.model.isRestoreAcls || spDocRestoreCtrl.model.isSiteHierarchy || (!spDocRestoreCtrl.restoreToOriginalPath && !spDocRestoreCtrl.restoreToDisk)" class="element-indent-class" for="whenDocExists"><input id="whenDocExistsSkip" name="whenDocExistsSkip" value="SKIP" class="" type="radio"
		data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
	<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.skip" bundle="sharepoint"/></span></label>
						
	
	<label data-ng-disabled="spDocRestoreCtrl.model.isRestoreAcls || spDocRestoreCtrl.model.isSiteHierarchy || spDocRestoreCtrl.restoreToDisk" class="element-indent-class" for="whenDocExists"><input id="whenDocExistsSkip" name="whenDocExistsSkip" value="APPEND" class="" type="radio"
	  data-ng-model="spDocRestoreCtrl.model.whenDocSiteExists"/>
	<span class="block-indent"><cv:msg key="sp.offline.info.whenDocSiteExists.append" bundle="sharepoint"/></span></label>
				
	</div>			
  <div class="modal-footer">
	   <button id="office365RestoreOptions_button_#1052" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="spDocRestoreCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
	   <button id="office365RestoreOptions_button_#9790" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="label.button.restore" bundle="sharepoint"/></button> 
  </div>
</form>
</div>
