<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="heading.createOffice365backupset" bundle="sharepoint" /></h1>
</div>
<div class="setup-content">
	<form id="editPlanForm" name="NewBackupSetForm" data-cv-submit="createSPBackupsetController.submitNewBackupSetModal()" novalidate>
        
		<span class="server-message {{createSPBackupsetController.serverMessage.type}}" data-ng-bind="serverMessage.message"></span>
		<label for="backupSetName" class="input">
		<span class="long-label-span"><cv:msg key="label.backupSetName" bundle="clients" /></span>
			<input type="text" id="backupSetName" name="backupSetName" data-ng-model="createSPBackupsetController.backupsetInfo.backupSetName" title={{createSPBackupsetController.backupsetInfo.backupSetName}} data-ng-change="createSPBackupsetController.serverMessage.message=''" required/>
			<span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.backupSetName);" ><cv:msg key="error.BackupsetName" bundle="clients" /></span>
		</label>
		
				
		<label for="adminSiteURL" class="input">
		<span class="long-label-span"><cv:msg key="label.tenantURL" bundle="sharepoint" /></span>
			<input type="text" id="adminSiteURL" name="adminSiteURL" data-ng-model="createSPBackupsetController.backupsetInfo.adminSiteURL" title={{createSPBackupsetController.backupsetInfo.adminSiteURL}} data-ng-change="serverMessage.message=''" required/>
			<span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.adminSiteURL);" ><cv:msg key="error.BackupsetName" bundle="clients" /></span>
		</label>
		
		<label for="username" class="input">
		<span class="long-label-span"><cv:msg key="label.userName" bundle="serversJs" /></span>
		  <input type="text" name="username" data-ng-model="createSPBackupsetController.backupsetInfo.UserName" title="{{createSPBackupsetController.backupsetInfo.UserName}}" required autoCompleteType="disable" autocomplete="off"/>
		  <span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.username);"><cv:msg key="error.userName" bundle="servers" /></span>
		</label>
		
		<label for="password" class="input">
		<span class="long-label-span"><cv:msg key="label.password" bundle="serversJs" /></span>
		  <input type="password" name="password" data-ng-model="createSPBackupsetController.backupsetInfo.Password"  required autoCompleteType="disable" autocomplete="off"/>
		  <span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.password);"><cv:msg key="error.password" bundle="servers" /></span>
		</label>				
					    
		
		<label class="input" for="azureUserAccount">
		<span class="long-label-span"><cv:msg key="label.azureUserAccount" bundle="sharepoint" /></span> 
		 <input type="text" name="azureUserAccount" data-ng-model="createSPBackupsetController.backupsetInfo.azureUserAccount" title="{{createSPBackupsetController.backupsetInfo.azureUserAccount}}" required autoCompleteType="disable" autocomplete="off"/>
		 <span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.azureUserAccount);"><cv:msg key="error.username" bundle="servers" /></span>
	    </label>
	    
	    <label class="input" for="azurePassword">
	    <span class="long-label-span"><cv:msg key="label.accountKey" bundle="sharepoint" /></span> 
	     <input type="password" name="azurePassword" data-ng-model="createSPBackupsetController.backupsetInfo.azurePassword" required autoCompleteType="disable" autocomplete="off"/>
		 <span class="help-block" data-ng-show="cv.NewBackupSetForm.needsAttention(NewBackupSetForm.azurePassword);"><cv:msg key="error.password" bundle="servers" /></span>
	    </label>
		
		<label for="plans">
		<span class="long-label-span"><cv:msg key="label.profile" bundle="profiles" /></span>
        	<div class="company-multi-select">
	            <isteven-multi-select id="createoffice365BackupSet_isteven-multi-select_#1784" 
		            input-model="createSPBackupsetController.planList"
		            output-model="createSPBackupsetController.selectedPlanList"
		            button-label="planName"
		            item-label="planName"
		            tick-property="selected"
		            class="isteven-multi-select user-group-select"
		            helper-elements="none"
		            selection-mode="single"
		            on-close="createSPBackupsetController.parseIStevenOutput()"
		            translation="createSPBackupsetController.localLang"
		            group-property="msGroup">
		       </isteven-multi-select>
           </div>
        	<span class="help-block" data-ng-show="inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
       </label>
	 	<div class="button-container">
	  		<button id="createoffice365BackupSet_button_#6561" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="createSPBackupsetController.cancelNewBackupSetModal()"><cv:msg key="Cancel" bundle="messages" /></button> 
    		<button id="createoffice365BackupSet_button_#2783" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="createSPBackupsetController.selectedPlanList.length <= 0"><cv:msg key="OK" bundle="messages" /></button> 
		</div>
	</form>
</div>