(function() {
	'use strict';

	var reports = angular.module("reports");

	reports.controller('viewModalCtrl', [
			'$scope',
			'customReportSvc',
			'reportService',
			function($scope, customReportSvc, reportService) {
				$scope.rules = [];
				$scope.serverMessage = {};
				$scope.saveOrUpdateUserView = function(currentIndex) {
					reportService.saveView($scope.customReport.report.customReportId, $scope.currentView, 'filter')
							.then(function(data) {
								$scope.currentView = data.data;
								$scope.selectedView = data.data;
								if (currentIndex === 0) {
									$scope.page.userFilters.push($scope.currentView);
								} else {
									$scope.page.userFilters[currentIndex] = $scope.currentView;
								}
								$scope.changeView($scope.currentView);
								if ($scope.isDefault) {
									$scope.saveUserView('defaultView', $scope.currentView.id);
								} else if ($scope.userView.url.defaultView === $scope.currentView.id) {
									$scope.saveUserView('defaultView', undefined);
								}
							});
				}

				/* -- adinng value options aka condtional statements like Equal to , less than etc */
				$scope.stringOptions = [ {
					"id" : '=',
					"label" : "Equal To"
				}, {
					"id" : "!=",
					"label" : "Not Equal To"
				}, {
					"id" : "contains:",
					"label" : "Contains"
				}, {
					"id" : "notcontains:",
					"label" : "Not Contains"
				}, {
					"id" : "isempty",
					"label" : "Is Empty"
				}, {
					"id" : "notempty",
					"label" : "Not Empty"
				} ];
				$scope.dateOptions = [ {
					"id" : '>-',
					"label" : "In Last"
				}, {
					"id" : '>-',
					"label" : "Beyond Last"
				}, {
					"id" : '<',
					"label" : "In Next"
				}, {
					"id" : '<',
					"label" : "Beyond Next"
				} ];

				$scope.numberOptions = [ {
					"id" : '=',
					"label" : "Equal To"
				}, {
					"id" : '!=',
					"label" : "Not Equal To"
				}, {
					"id" : '<',
					"label" : "Less Than"
				}, {
					"id" : '>',
					"label" : "More Than"
				} ];

				$scope.conditions = $scope.stringOptions;

				$scope.changeRule = function(rule) {
					console.log(rule);
				}

				$scope.getConditions = function(rule) {
					var type;
					var selectedCol;
					angular.forEach($scope.component.columns, function(column, key) {
						if (rule.columnId == column.id) {
							type = column.type;
							selectedCol = column;
						}
					});

					if (type == "String") {
						rule.conditions = $scope.stringOptions;
					} else if (type == "Time" || type == "TimeStamp") {
						rule.conditions = $scope.dateOptions;
					} else {
						rule.conditions = $scope.numberOptions;
					}
				}

				$scope.addRule = function(columnId, condtion, value) {
					var rule = {
						columnId : columnId,
						value : value
					};
					$scope.getConditions(rule);
					if (value) {
						angular.forEach(rule.conditions, function(condId, index) {
							var idx = value.indexOf(condId.id);
							if (condId.id && idx === 0) {
								rule.condition = rule.conditions[index].id;
								rule.value = rule.value.substring(idx + condId.id.length, rule.value.length);
							}
						});
					} else {
						rule.condition = rule.conditions[0]['id'];
					}

					$scope.rules.push(rule);
				}

				$scope.removeRule = function(index) {
					$scope.rules.splice(index, 1);
				}

				$scope.getUrl = function() {
					var urlObj = {};
					var url = "";
					if ($scope.reportMode !== 'builder' && $scope.tableMode) {
						for (var i = 0; i < $scope.rules.length; i++) {
							var rule = $scope.rules[i];
							if (rule.columnId) {
								var key = $scope.component.id + ".filter." + rule.columnId;
								var value = rule.condition + rule.value;
								if (!rule.value) {
									$scope.serverMessage.type = "error";
									$scope.serverMessage.message = "Rule(s) cannot be empty";
									return false;
								}
								if (urlObj[key]) {
									urlObj[key] = urlObj[key] + "," + value;
								} else {
									urlObj[key] = value;
								}
							}
						}

						for ( var key in urlObj) {
							url = url + key + "=" + urlObj[key] + "&";
						}
						if (url) {
							url = url.substring(0, url.lastIndexOf("&"));
						}
					} else {
						if ($scope.appName !== 'adminconsole') {
							url = document.location.search;
						} else {
							var hash = document.location.hash;
							url = hash.substring(hash.indexOf('?'));
						}
					}

					return url;
				}

				$scope.getId = function() {
					var id = ($scope.reportMode === 'builder' ? "view" : "uview") + "-" +
							$scope.currentView.view.reportViewName;
					id = id.replace(/\s/g, " ");
					id = id.replace(/[^a-zA-Z0-9_]/g, '');
					return id;
				}

				$scope.updateUrl = function(previous) {
					var currentParams = customReportSvc.getUrlParams();
					var previous = customReportSvc.getUrlParams(previous);
					delete currentParams['view']; // remove the view parameter
					var result = _.merge(previous, currentParams);
					var url = dataSetUtility.requestToUrl(result);
					return url;
				}

				$scope.saveView = function() {

					//update the local scope.
					$scope.serverMessage = {};
					if ($scope.tableMode) {
						$scope.currentView.url = $scope.getUrl();
					}

					if (!$scope.currentView.url) {
						return;
					}

					if ($scope.reportMode === 'builder') {
						if (!$scope.page.systemFilters) {
							$scope.page.systemFilters = [];
						}
						if ($scope.isDefault) {
							$scope.page.systemFilters = _.map($scope.page.systemFilters, function(o) {
								return _.omit(o, 'isDefault');
							});
							$scope.currentView.isDefault = true;
						}
					}

					if ($scope.viewMode === "Create") {
						$scope.currentView.id = ($scope.reportMode === 'builder' ? "view" : "uview") + "-"
								+ $scope.currentView.view.reportViewName.replace(/[^a-zA-Z0-9]/g, '');
								
						// if it is a user view, the id should be unique to each user.
						if ($scope.reportMode === 'viewer') {
							$scope.currentView.id = $scope.currentView.id + "-" + new Date().getTime();
						}		
						var existingViewName = false;
						var viewIdInc = 0;
						_.forEach($scope.pageViews, function(eachView) {
							if (eachView.view.reportViewName == $scope.currentView.view.reportViewName) { //Check if the view name already exists
								existingViewName = true;
								return false;
							}
							if (eachView.id.indexOf($scope.currentView.id) >= 0) {
								viewIdInc++
							}
						});
						if (existingViewName) {
							console.error($scope.currentView.view.reportViewName + ' : View name already exist.');
							customReportSvc.errorToast(localMsg.customReport.ViewNameExist);
							return;
						}
						$scope.currentView.id = $scope.currentView.id + (viewIdInc > 0 ? viewIdInc.toString() : ""); //To generate a unique ID
						var currentParams = customReportSvc.getUrlParams();
						let selectedView = currentParams['view'];
						if (typeof selectedView !== "undefined") {
							let view = _.find($scope.pageViews, [ 'id', selectedView ]);
							$scope.currentView.url = $scope.updateUrl(view.url);
						}
						$scope.currentView.deleteEnabled = true;
						$scope.pageViews.push($scope.currentView);
						if ($scope.reportMode === 'builder') {
							$scope.page.systemFilters.push($scope.currentView);
							$scope.changeView($scope.currentView);
						} else {
							$scope.saveOrUpdateUserView($scope.currentIndex);
						}
					} else {
						$scope.currentView.url = $scope.updateUrl($scope.currentView.url);
						if ($scope.reportMode === 'builder') {
							$scope.page.systemFilters[$scope.currentIndex] = ($scope.currentView);
						} else {
							$scope.saveOrUpdateUserView($scope.currentIndex);
						}
					}
					$scope.$close();
				}

				$scope.intiRulesFromView = function(view) {
					var urlParams = customReportSvc.getUrlParams(view.url);
					for ( var param in urlParams) {
						var splitComps = param.split(".");
						var componentId = splitComps[0];
						var filter = splitComps[1];
						var columnId = splitComps[2];
						var value = urlParams[param];
						var multis = value.split(",");
						for (var k = 0; k < multis.length; k++) {
							$scope.addRule(columnId, undefined, multis[k]);
						}

					}
				}

				if ($scope.viewMode === "Edit") {
					if ($scope.tableMode) {
						$scope.currentView = $scope.selectedView;
					}
					if ($scope.reportMode !== 'builder' && $scope.tableMode) {
						$scope.intiRulesFromView($scope.currentView);
					}

					if ($scope.currentView.type !== 'system'
							&& $scope.userView.url.defaultView === $scope.currentView.id) {
						$scope.isDefault = true;
					} else {
						$scope.isDefault = $scope.currentView.isDefault;
					}

				} else {
					if ($scope.component) {
						$scope.addRule($scope.component.columns[2].id, undefined, "");
					}
				}

				if (!$scope.currentView) {
					$scope.currentView = {
						view : {
							reportViewName : ""
						},
						pageName : $scope.page.pageName
					};
					if (!$scope.tableMode) {
						$scope.currentView.url = $scope.getUrl();
					}
				}
			} ]);

}());