<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="addDataSetModal" cv-modal-draggable>
		<!-- FIXME: Localize -->
		<!-- Modal header -->
		<div class="modal-header">
			<h3 class="modal-title">
				<span data-ng-if="mode === 'Add'"><fmt:message
						key="CustomReport.Add" /></span><span data-ng-if="mode === 'Edit'"><fmt:message
						key="CustomReport.Edit" />&nbsp;</span>
				<fmt:message key="CustomReport.ReportInput" />
			</h3>
		</div>
		<!-- End modal header -->

		<!-- Modal body -->
		<div id="addDataSetModalBodyWrapper">
			<div id="addDataSetRightPane">
				<!-- Start New Input Form -->
				<div id="addNewInputForm">
					<form class="form-horizontal" role="form" name="inputForm"
						data-ng-submit="addInput(inputForm.$valid)" novalidate>
						<div class="modal-body">
							<div class="form-group">
								<label for="inputEmail3" class="inputLabel control-label"><fmt:message
										key="CustomReport.InputVariable" /></label>
								<div class="inputValue">
									<input type="text" class="form-control" name="inputId"
										data-ng-model="currentInput.id" required
										data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" /> <span
										class="text-danger"
										data-ng-show="inputForm.inputId.$error.pattern">*ID
										should contain characters,digits and underscore only.</span>
								</div>
							</div>
							<div class="form-group">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.DisplayName" /></label>
								<div class="inputValue">
									<input type="text" class="form-control"
										data-ng-model="currentInput.displayName" />
								</div>
							</div>
							<div class="form-group">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.Properties.ToolTip" /></label>
								<div class="inputValue">
									<input type="text" class="form-control"
										data-ng-model="currentInput.toolTip" />
								</div>
							</div>
							<div class="form-group">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.InputVariableType" /></label>
								<div class="inputValue">
									<select class="form-control input-sm"
										data-ng-model="currentInput.type"
										data-ng-change="updateControltypes(currentInput.type)"
										data-ng-options="inputType for inputType in inputTypes">
									</select>
								</div>
							</div>
							<div class="form-group " data-ng-show="showMultiSelect">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.AllowMultiSelection" /></label>
								<div class="inputValue ">
									<input type="checkbox"
										data-ng-model="currentInput.allowMultipleSelection"
										data-ng-change="updateControltypes(currentInput.type)">
								</div>
							</div>
							<div class="form-group">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.InputControlType" /></label>
								<div class="inputValue">
									<select class="form-control input-sm"
										data-ng-model="currentInput.controlType"
										data-ng-options="controlType for controlType in controlTypes"
										data-ng-change="initControlType()">
									</select>
								</div>
							</div>
							<div class="form-group ">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.HideInput" /></label>
								<div class="inputValue ">
									<input type="checkbox" data-ng-model="currentInput.hidden">
								</div>
							</div>
							<div class="form-group ">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.Required" /></label>
								<div class="inputValue ">
									<input type="radio" class="inputRadio"
										data-ng-model="currentInput.required" data-ng-value="false" />
									<fmt:message key="CustomReport.Optional" />
									<input type="radio" class="inputRadio"
										data-ng-model="currentInput.required" data-ng-value="true" />
									<fmt:message key="CustomReport.Required" />
								</div>
							</div>
							<div class="form-group" data-ng-if="currentInput.type !== 'DateRange'">
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.DefaultValue" /></label>
								<div class="inputValue"
									data-ng-if="!currentInput.allowMultipleSelection">
									<input type="text" class="form-control" data-ng-model="currentInput.defaultValue" />
									<select class="frequency" data-ng-if="currentInput.type === 'DateRange'" data-ng-model="currentInput.defaultValue" data-ng-options="opt.value as opt.label for opt in possibleOptions"></select>
								</div>
								<div class="inputValue"
									data-ng-if="currentInput.allowMultipleSelection">
									<textarea data-ng-model="currentInput.defaultValue" rows="5"
										cols="27" placeholder="Values must be separated by a new line"></textarea>
								</div>
							</div>
							<div
								data-ng-hide="currentInput.controlType == 'ToggleBox' || currentInput.type == 'DateRange' || currentInput.controlType == 'TextArea' || currentInput.controlType == 'TextBox' || currentInput.controlType == 'Hidden' || currentInput.controlType == 'DatePicker' || currentInput.controlType == 'DateTimePicker' || currentInput.controlType == 'TimePicker' || currentInput.controlType == 'DateRange' || currentInput.controlType == 'Slider' || currentInput.type === 'CommcellEntity'">
								<div class="form-group"
									data-ng-if="currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.Values" /></label>
									<div class="inputValue ">
										<input type="radio" class="inputRadio"
											data-ng-model="currentInput.fromDataSet"
											data-ng-value="false" />
										<fmt:message key="CustomReport.Manual" />
										<input type="radio" class="inputRadio"
											data-ng-model="currentInput.fromDataSet" data-ng-value="true"
											data-ng-init="getDataSets()" />
										<fmt:message key="CustomReport.DataSet" />
									</div>
								</div>
								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == false">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.PossibleLabels" /></label>
									<div class="inputValue ">
										<textarea data-ng-show="currentInput.fromDataSet == false"
											data-ng-model="currentInput.possibleValueLabels"
											data-ng-list="&#10;" data-ng-trim="false" rows="5" cols="27"
											placeholder="Labels must be separated by a new line"></textarea>
									</div>
								</div>
								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == false">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.PossibleValues" /></label>
									<div class="inputValue ">
										<textarea data-ng-show="currentInput.fromDataSet == false"
											data-ng-model="currentInput.possibleValues"
											data-ng-list="&#10;" data-ng-trim="false" rows="5" cols="27"
											placeholder="Values must be separated by a new line"></textarea>
									</div>
								</div>
								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == true && currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.DataSet" /></label>
									<div class="inputValue ">
										<select data-ng-show="currentInput.fromDataSet == true"
											class="form-control input-sm"
											data-ng-model="currentInput.dataSetEntity"
											data-ng-options="dataSet.dataSet as dataSet.dataSet.dataSetName for dataSet in dsList"
											data-ng-change="getFieldsFromDataSet(currentInput.dataSetEntity)">
										</select>
									</div>
								</div>
								<div class="form-group"
									data-ng-show="(currentInput.fromDataSet == true || currentInput.type === 'Commcell') && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.ValueField" /></label>
									<div class="inputValue ">
										<select data-ng-show="currentInput.fromDataSet == true"
											class="form-control input-sm"
											data-ng-model="currentInput.valueField"
											data-ng-options="field for field in fields">
										</select>
									</div>
								</div>
								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == true && currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.LabelField" /></label>
									<div class="inputValue ">
										<select data-ng-show="currentInput.fromDataSet == true"
											class="form-control input-sm"
											data-ng-model="currentInput.labelField"
											data-ng-options="field for field in fields"></select>
									</div>
								</div>
								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == true && currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label">Depends
										On</label>
									<div class="inputValue dependent-inputs">
										<div ng-dropdown-multiselect="" options="dependentInputs"
											selected-model="currentInput.dependendent"
											extra-settings="dependsOnSettings"
											events="eventSettings"></div>
									</div>
								</div>

								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == true && currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label">Sort
										by</label>
									<div class="inputValue ">
										<select class="form-control input-sm"
											data-ng-model="currentInput.sort.columnId"
											data-ng-options="field for field in fields"><option
												value=""></option></select>
									</div>
								</div>

								<div class="form-group"
									data-ng-show="currentInput.fromDataSet == true && currentInput.type !== 'Commcell' && currentInput.type !== 'CommcellEntity'">
									<label for="inputPassword3" class="inputLabel control-label">Sort
										Direction</label>
									<div class="inputValue ">
										<select class="form-control input-sm"
											data-ng-model="currentInput.sort.direction"
											data-ng-options="sortDir for sortDir in sortDirs"><option
												value=""></option></select>
									</div>
								</div>

							</div>

							<div data-ng-if="currentInput.controlType === 'ToggleBox'">
								<div class="form-group">
									<label for="inputEmail3" class="inputLabel control-label"><fmt:message
											key="CustomReport.TrueValue" /></label>
									<div class="inputValue">
										<input type="text"
											data-ng-model="currentInput.possibleValues[0]" />
									</div>
								</div>
								<div class="form-group">
									<label for="inputEmail3" class="inputLabel control-label"><fmt:message
											key="CustomReport.FalseValue" /></label>
									<div class="inputValue">
										<input type="text"
											data-ng-model="currentInput.possibleValues[1]" />
									</div>

								</div>
							</div>
							<div
								data-ng-show="currentInput.type === 'CommcellEntity' && currentInput.fromDataSet">
								<div class="form-group">
									<label for="restAPI" class="inputLabel control-label">Entity
										Type</label>
									<div class="inputValue ">
										<select id="entityTypeSelect" class="form-control input-sm"
											data-ng-model="currentInput.entityTypeId"
											data-ng-options="entityType.entityTypeId as entityType.entityTypeName for entityType in commcellEntityTypes">
										</select>
									</div>
								</div>
								<div class="form-group">
									<label for="restAPI" class="inputLabel control-label">REST
										API</label>
									<div class="inputValue ">
										<input type="text" name="restAPI" id="restAPI"
											class="form-control" data-ng-model="currentInput.apiName">
									</div>
								</div>
								<div class="form-group">
									<label for="labelField" class="inputLabel control-label"><fmt:message
											key="CustomReport.LabelField" /></label>
									<div class="inputValue ">
										<input type="text" name="labelField" id="labelField"
											class="form-control input-sm"
											data-ng-model="currentInput.labelField">
									</div>
								</div>
								<div class="form-group">
									<label for="valueField" class="inputLabel control-label"><fmt:message
											key="CustomReport.ValueField" /></label>
									<div class="inputValue ">
										<input type="text" name="valueField" id="valueField"
											class="form-control input-sm"
											data-ng-model="currentInput.valueField">
									</div>
								</div>
							</div>

							<div id="dateRangeOptions"
								data-ng-show="currentInput.type == 'DateRange' || currentInput.controlType == 'DateRange'">
								<fieldset>
									<legend>
										<fmt:message key="CustomReport.DateRangeOptions" />
									</legend>
									<div class="groupOptions">
										<div>
											<label><fmt:message key="CustomReport.Options" /></label>
											<ul class="dateRangeOptions">
												<li data-ng-repeat="pValue in defaultRelativeOptions">
													<label> <input type="checkbox"
														checklist-model="currentInput.relativeOptions"
														checklist-value="pValue.value"
														data-ng-change="updateDefaultRelativeOpts(pValue.value,checked)" > {{pValue.label}}
														<span data-ng-if="pValue.value=='Last'" class="timeUnitToolTip glyphicon glyphicon-info-sign" uib-tooltip='<fmt:message
														key="CustomReport.DateRange.LastNTooltip"/>'></span>
														<span data-ng-if="pValue.value=='Previous'" class="timeUnitToolTip glyphicon glyphicon-info-sign" uib-tooltip='<fmt:message
														key="CustomReport.DateRange.PreviousNTooltip"/>'></span> 
												</label>
												</li>
												<li
													data-ng-hide="currentInput.relativeOptions == undefined || currentInput.relativeOptions.indexOf('Custom') === -1">
													<label> <input type="checkbox"
														data-ng-model="currentInput.includeTime" /> <fmt:message
															key="CustomReport.IncludeTimeSelection" />
												</label>
												</li>
											</ul>

											<div data-ng-hide="currentInput.relativeOptions.length == 0 || (currentInput.relativeOptions.length == 1 && currentInput.relativeOptions.indexOf('Custom') != -1)">
												<label><fmt:message key="CustomReport.AllowedUnits" /></label>
												<ul class="relativeOptions">
													<li data-ng-repeat="pValue in defaultRelativeUnits"><label>
															<input type="checkbox"
															checklist-model="currentInput.relativeUnits"
															checklist-value="pValue.label"
															data-ng-change="updateDefaultRelativeUnitOpts(pValue.label,checked)" /> {{pValue.value}}
															<span data-ng-if="pValue.label=='Quarters'" class="timeUnitToolTip glyphicon glyphicon-info-sign" uib-tooltip='<fmt:message
															key="CustomReport.DateRange.QuarterTooltip"/>'></span>
													</label></li>
												</ul>
											<div>
										</div>
									</div>

								</fieldset>
							</div>

							<div class="form-group" data-ng-if="currentInput.type === 'DateRange' && !(currentInput.relativeOptions.length === 1 && currentInput.relativeOptions[0] === 'Custom') && currentInput.relativeOptions.length > 0">
									<label for="inputPassword3" class="inputLabel control-label"><fmt:message
											key="CustomReport.PossibleValues" /></label>

									<div class="inputValue ">
										<div class="relative-value" data-ng-repeat="opt in possibleOptions track by opt.value">
											<input class="relative-label" data-ng-value="opt.labelLocalized" readonly></input><span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteTimeRange(opt.value)"></span>
										</div>
										<div class="relativePanel">
												  <span data-ng-if="currentInput.relativeOptions.length > 0">
												  	<select class="frequency" data-ng-model="$parent.model.relFrequency" data-ng-options="opt as opt.localizedLabel for opt in relativeOpts" data-ng-change="changeRelativeUnits(model.relFrequency,model.relUnit)"></select>
												  </span>
												  <span >
												   		<input type="number" data-ng-model="relValue" min="0" max="365" placeholder="N"/>
												   		<select class="frequency" data-ng-model="model.relUnit" data-ng-options="option as option.singularLabel for option in relativeUnits"></select>
												  </span>
												  <span>
												  	<button type="button" class="btn btn-link" data-ng-click="addRelativeOption(model.relFrequency,model.relUnit,relValue)">Add</button>
												  </span>
						 				</div>
									</div>
							</div>

							<div class="form-group" data-ng-if="currentInput.type === 'DateRange' && ((currentInput.relativeOptions.length === 1 && currentInput.relativeOptions[0] === 'Custom') || possibleOptions.length > 0 )" >
								<label for="inputPassword3" class="inputLabel control-label"><fmt:message
										key="CustomReport.DefaultValue" /></label>
								<div class="inputValue" data-ng-if="!(currentInput.relativeOptions.length === 1 && currentInput.relativeOptions[0] === 'Custom') && possibleOptions.length > 0">
									<select class="frequency" data-ng-if="currentInput.type === 'DateRange'" data-ng-model="currentInput.defaultValue" data-ng-options="opt.value as opt.labelLocalized for opt in possibleOptions"></select>
								</div>
								<div class="inputValue" data-ng-if="currentInput.relativeOptions.length === 1 && currentInput.relativeOptions[0] === 'Custom'">
									<input type="text" class="form-control" data-ng-model="currentInput.defaultValue" placeholder='<fmt:message key="CustomReport.DateRange.CustomDatePlaceholder" />'/>
								</div>
							</div>

							<div data-ng-if="currentInput.controlType == 'Slider'">
								<div class="form-group">
									<label for="inputPassword3" class="inputLabel control-label">Minimum
										Value</label>
									<div class="inputValue">
										<input type="text" class="form-control"
											data-ng-model="currentInput.rangeParam.floor" />
									</div>
								</div>

								<div class="form-group">
									<label for="inputPassword3" class="inputLabel control-label">Max
										Value</label>
									<div class="inputValue">
										<input type="text" class="form-control"
											data-ng-model="currentInput.rangeParam.ceil" />
									</div>
								</div>

								<div class="form-group">
									<label for="inputPassword3" class="inputLabel control-label">Step</label>
									<div class="inputValue">
										<input type="text" class="form-control"
											data-ng-model="currentInput.rangeParam.step" />
									</div>
								</div>
							</div>
						</div>
					</form>
				</div>

				<!-- End New Input Form -->
			</div>

		</div>
		<!-- Modal footer -->
		<div class="modal-footer">
			<!-- <a class="btn btn-default btn-sm pull-left">Help</a> -->
			<a class="btn btn-primary btn-sm pull-right"
				data-ng-class="{'insertNotAllowed': !currentInput || currentInput.id == undefined || currentInput.id == '' || currentInput.displayName == undefined || currentInput.displayName == ''}"
				data-ng-click="commitChanges()"><fmt:message
					key="CustomReport.Done" /></a> <a
				class="btn btn-default btn-sm pull-right" data-ng-click="$close()"><fmt:message
					key="CustomReport.Cancel" /></a>
		</div>
		<!-- End modal footer -->
	</div>
</fmt:bundle>
