<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="reportId" value="0"></c:set>
<c:set var="reportName" value=""></c:set>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<c:if test="${param.includeBootstrapCss == null || param.includeBootstrapCss != 'false'}" >
		<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/templatestyles.css?${applicationScope.BUILD_TS}" />
	</c:if>
	<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/sprites.css?${applicationScope.BUILD_TS}" />
</head>
<body>

<jsp:include page="../common/jquery.jsp" flush="true" />
<jsp:include page="../common/jqueryui.jsp" flush="true" />
<jsp:include page="reportHeader.jsp">
	<jsp:param value="webconsole" name="applicationName" />
	<jsp:param value="false" name="includeImport" />
</jsp:include>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
	if(!cv){
			var cv = cv || {};
			cv.additionalSettings = "${sessionScope.ADDITIONAL_SETTINGS}" === "" ? {} :JSON.parse("${sessionScope.ADDITIONAL_SETTINGS}".replace(/&#034;/g, '\"'));
			cv.userPref = "${sessionScope.userPreferences}" === "" ? {} :JSON.parse("${sessionScope.userPreferences}".replace(/&#034;/g, '\"'));
			cv.locale = '${sessionScope.PREF_LOCALE}';
			cv.loggedInUserSmtp = "${loginContext.getUserInfo().getSmtpAddress()}";
			cv.isAdmin = "${sessionScope.isAdminUser}" === "true";
			cv.isAdminOnCommcellLevel = "${sessionScope.IS_ADMIN_ON_COMMCELL}" === "true";
			cv.contextPath= '${pageContext.request.contextPath}';
			cv.isDomainUser= ${sessionScope.IS_DOMAIN_USER};
			cv.isTenantAdmin = ${sessionScope.IS_TENANT_ADMIN};
			cv.isMspUser = ${sessionScope.IS_MSP_USER};
			var System = cv;
		}
</script>
<style>
table{
	font-size: 0.88em;
}
.reportTable {
	padding-bottom: 0px;
}
</style>
<c:if test="${not empty param.reportId}">
	<c:set var="reportId" value="${fn:escapeXml(param.reportId)}"></c:set>
</c:if>
<c:if test="${not empty param.reportName}">
	<c:set var="reportName" value="${fn:escapeXml(param.reportName)}"></c:set>
</c:if>
<div id="reportArea">
	<div class="dashboardError"></div>
	<div id="ng-app" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init('${reportId}', '${reportName}',false)">
		<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
			<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
		</div>
	</div>
</div>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript">
$(document).ready(function() {
	window.allOnReadiesExecuted=true; //while exporting we need to know when the page has completed its execution
});
</script>
</body>
</html>