<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@ taglib uri="https://github.com/d8bitr/packtag" prefix="cvpack"%>

<fmt:bundle basename="localization.ScheduleMessages">
	<fmt:message key="schedule.repeat.invalid_hours" var="schedule_repeat_invalid_hours"/>
	<fmt:message key="schedule.repeat.invalid_mins" var="schedule_repeat_invalid_mins"/>
	<fmt:message key="schedule.repeat.invalid_hours_mins" var="schedule_repeat_invalid_hours_mins"/>
	<fmt:message key="schedule.repeat.required_mins" var="schedule_repeat_required_mins"/>
	<fmt:message key="schedule.repeat.required_hours" var="schedule_repeat_required_hours"/>
</fmt:bundle>
<script nonce="${sessionScope.cspNonce}" type="text/javascript">
	var isPublicMetricsCloud = "${applicationScope.isPublicMetricsCloud}";
	var surveySingleCommcellUser = "${sessionScope.SurveySingleCommcellUser}";
	var CS_TIMEZONE_STR = "${CS_TIMEZONE_STR}"
	var defaultTimeZoneId = "${commServTimeZone}";
	var docURL = "${applicationScope.DOCUMENTATION_LINK}"; //To get DocURL for Activity report's 'Top 10 Errors in Last 24 Hours' table title
	if (typeof defaultTimeZoneId == undefined || !defaultTimeZoneId) {
		defaultTimeZoneId = 1000;//default commserv timezone
	}
	var customReports = {
		contextPath : '${pageContext.request.contextPath}',
		appName : '${fn:escapeXml(param.applicationName)}',
		subAppName : '${fn:escapeXml(param.subApplicationName)}',
		prefLocale : '${sessionScope.PREF_LOCALE}'
	};

	if(customReports.appName === "adminconsole"){
		customReports.prefLocale = System.locale;
	}
	var nonceVar = "${sessionScope.cspNonce}";
	var isDcubeEnabledInCustomReports = "${cvConfig.isDcubeEnabledInCustomReports()}";
	if (isDcubeEnabledInCustomReports === 'true')
		isDcubeEnabledInCustomReports = true;
	else
		isDcubeEnabledInCustomReports = false;

	var isComputedColumnEnabled = "${cvConfig.isComputedColumnEnabled()}";
	if (isComputedColumnEnabled === 'true')
		isComputedColumnEnabled = true;
	else
		isComputedColumnEnabled = false;

	var SESSION_ID = "${pageContext.session.id}";
	var localMsg = localMsg || {};
	localMsg["schedule.repeat.invalid_hours_mins"] = '${schedule_repeat_invalid_hours_mins}';
	localMsg["schedule.repeat.invalid_hours"] = '${schedule_repeat_invalid_hours}';
	localMsg["schedule.repeat.invalid_mins"] = '${schedule_repeat_invalid_mins}';
	localMsg["schedule.repeat.required_hours"] = '${schedule_repeat_required_hours}';
	localMsg["schedule.repeat.required_mins"] = '${schedule_repeat_required_mins}';
</script>
<c:set var="disabledStyle" value="" />

<c:if test="${param.disableStyles == 'true'}">
	<c:set var="disabledStyle" value="disabled" />
</c:if>

<c:if test="${not empty param.applicationName}">
	<c:set var="applicationName" value="${fn:escapeXml(param.applicationName)}"></c:set>
</c:if>




<c:if test="${applicationName != null && applicationName == 'webconsole'}" >

	<c:if test="${param.includeLMjs == null || param.includeLMjs != 'false'}" >
		<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/highstock.js?${applicationScope.BUILD_TS}"></script>
	</c:if>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/dist/reportsWCLibs/reportsWCLibs.js?${applicationScope.BUILD_TS}"></script>
	<c:if test="${param.includeLMjsp == null || param.includeLMjsp == 'true'}" >
		<jsp:include page="../logMonitoring/lmUtils.jsp" flush="true" />
	</c:if>

	<c:if test="${param.includeImport == null || empty param.includeImport}" >
		<jsp:include page="../reports/reportsBase.jsp?${applicationScope.BUILD_TS}"></jsp:include>
		<jsp:include page="../reports/reportImportExport.jsp?${applicationScope.BUILD_TS}"></jsp:include>
	</c:if>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reports/js/reportsUtil.js?${applicationScope.BUILD_TS}"></script>
	<c:choose>
		<c:when test="${param.exportType==null && param.readme==null}">
			<jsp:include page="../forms/forms.jsp" flush="true" >
				<jsp:param value="true" name="doNotIncludeKendoLibs"/>
			</jsp:include>
		</c:when>
		<c:otherwise>
			<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/dist/core/reportsplus.dll.js?${applicationScope.BUILD_TS}"></script>
			<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/dist/reportsExport/reportsExport.js?${applicationScope.BUILD_TS}"></script>
		</c:otherwise>
	</c:choose>

	<!-- Map Box Api -->
		<script nonce="${sessionScope.cspNonce}"
			src="${pageContext.request.contextPath}/common/thirdParty/mapbox/mapbox.js?secure"></script>
		<link
			href="${pageContext.request.contextPath}/common/thirdParty/mapbox/mapbox.css"
			rel='stylesheet' />
		<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdParty/lodash.js?${applicationScope.BUILD_TS}"></script>
</c:if>

<c:if test="${param.applicationName == null || param.applicationName != 'adminconsole'}" >
	<jsp:include page="cssIncludes.jsp" flush="true">
		<jsp:param value="${fn:escapeXml(param.applicationName)}" name="applicationName" />
	</jsp:include>
</c:if>

<!-- For alarms JS localization in WC & AC -->
<jsp:include page="alarms/alarmlocale.jsp" flush="true" />

<c:if test="${param.includeLMjs == null || param.includeLMjs != 'false'}" >
	<%-- <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/dist/reportsHighCharts/reportsHighCharts.js?${applicationScope.BUILD_TS}"></script> --%>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/exporting.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}"  type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/canvas-tools.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/highcharts-export-clientside.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/hm.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/treemap.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/highcharts-more.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/highchart.interactive.plugin.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highmaps/map.js?${applicationScope.BUILD_TS}"></script>
	<c:if test="${param.includeLMjs == 'true'}">
		<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highmaps/data.js?${applicationScope.BUILD_TS}"></script>
			<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highmaps/drilldown.js?${applicationScope.BUILD_TS}"></script>
		</c:if>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highmaps/proj4.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highmaps/world.js?${applicationScope.BUILD_TS}"></script>
</c:if>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/highcharts-3d.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}"  type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/accessibility.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/highcharts/pattern-fill-v2.js?${applicationScope.BUILD_TS}"></script>


<!-- D3 tag cloud -->
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/d3/d3.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/d3/d3.layout.cloud.js?${applicationScope.BUILD_TS}"></script>

<!-- Date and Time Picker library -->

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdPartyV2/moment/moment.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdPartyV2/moment/locale/locales.custom.min.js?${applicationScope.BUILD_TS}"></script>

<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdParty/moment-timezone.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdParty/moment-timezone-with-data-2012-2022.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdParty/moment-timezone-with-data.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/daterangepicker.js?${applicationScope.BUILD_TS}"></script>

<!-- mapbox files for web GL version -->
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/thirdParty/mapbox/v2/mapbox-gl.js"></script>
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/thirdParty/mapbox/v2/supercluster.min.js"></script>
<link href="${pageContext.request.contextPath}/common/thirdParty/mapbox/v2/mapbox-gl.css" rel='stylesheet'/>

<c:if test="${applicationName != null && applicationName == 'adminconsole'}" >
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/js/cvutil.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/common/thirdPartyV3/bootstrap-4.4.1/js/bootstrap.bundle.min.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}">
		cvUtil.CONTEXT_PATH = '${pageContext.request.contextPath}';
	</script>
</c:if>


<jsp:include page="../searchcomponents/includejs.jsp">
	<jsp:param value="${param.isFromDataCube}" name="isFromDataCube" />
</jsp:include>



<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular/ng-infinite-scroll.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/checklist-model.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular-gridster/jquery.resize.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular-gridster/angular-gridster.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/angular/rzslider.min.js"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/	angular-ui-ace-editor/ace.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/	angular-ui-ace-editor/ui-ace.min.js?${applicationScope.BUILD_TS}"></script>
<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/	angular-ui-ace-editor/ext-language_tools.js?${applicationScope.BUILD_TS}"></script>


<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/ng-table/ng-table.min.js?${applicationScope.BUILD_TS}"></script>

<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/dist/reportsViewer/reportsViewer.js?${applicationScope.BUILD_TS}"></script>
<c:if test="${applicationName != null && applicationName == 'adminconsole'}" >
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/locService/rptAcLocService.js?${applicationScope.BUILD_TS}"></script>
</c:if>
<c:if test="${applicationName != null && applicationName == 'webconsole'}" >
	<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="${pageContext.request.contextPath}/reportsplus/js/locService/rptWcLocService.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/kendoui/kendo.custom.js?${applicationScope.BUILD_TS}"></script>
</c:if>
<c:if test="${param.customReportsMode == 'build' || param.customReportsMode == 'edit'}" >
	<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/dist/reportsBuilder/reportsBuilder.js?${applicationScope.BUILD_TS}"></script>
	<script nonce="${sessionScope.cspNonce}">
    	var isCloudSurvey = ("${cvConfig.isCloudSurvey()}"=="true")?true:false;
	</script>
</c:if>