  <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div class="form-group">
		<label class="col-xs-12 col-lg-4" for="title_{{component.id}}" title='<fmt:message key="CustomReport.Properties.ComponentTitle"/>'><fmt:message key="CustomReport.Properties.ComponentTitle"/></label>
		<div class="col-xs-12 col-lg-8"><input type="text" id="title_{{component.id}}" name="title" data-ng-model="component.title.text" /></div>
	</div>
	<div class="form-group">
		<label class="col-xs-12 col-lg-4" for="id_{{component.id}}" title='<fmt:message key="CustomReport.Properties.ComponentId"/>'><fmt:message key="CustomReport.Properties.ComponentId"/></label>
		<div class="col-xs-12 col-lg-8"><input type="text" id="id_{{component.id}}" name="id" data-ng-model="component.id" /></div>
	</div>
	<div class="form-group" data-ng-if="component.type !== 'MenuItem'">
		<label class="col-xs-12 col-lg-4" for="type" title='<fmt:message key="CustomReport.Properties.ComponentType"/>'><fmt:message key="CustomReport.Properties.ComponentType"/></label>
		<div class="col-xs-12 col-lg-8">
			<select id="type" name="type" data-ng-model="component.type">
				<option value="">Select Type</option>
				<option value="menu"><fmt:message key="CustomReport.Properties.ComponentType.Menu"/></option>
				<option value="image"><fmt:message key="CustomReport.Properties.ComponentType.Image"/></option>
				<option value="link"><fmt:message key="CustomReport.Properties.ComponentType.Link"/></option>
				<option value="button"><fmt:message key="CustomReport.Properties.ComponentType.Button"/></option>
			</select>
		</div>
	</div>													
	<div class="form-group">
		<label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.ComponentVisible"/>'><fmt:message key="CustomReport.Properties.ComponentVisible"/></label>
		<div class="col-xs-12 col-lg-8">
			<select id="type" name="type" data-ng-model="component.visible">
				<option value="always"><fmt:message key="CustomReport.Properties.ComponentEnable.Always"/></option>
				<option value="custom"><fmt:message key="CustomReport.Properties.ComponentEnable.Expression"/></option>
			</select>
		</div>
	</div>
	<div data-ng-show="component.visible === 'custom'" >
		<div class="row noLftRghtMargin">
        	<div class="col-xs-12 noLftRghtPadding">
				<!-- FIXME: Localize -->
				<label  class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ComponentVisibleExpression"/>'>
					<fmt:message key="CustomReport.Properties.ComponentVisibleExpression"/><br>
				</label>
      			<span class="input-group-sm col-xs-12 noLftRghtPadding">
        			<textarea rows="2" data-ng-model="component.visibleExpression" placeholder="<fmt:message key="CustomReport.Properties.ButtonEnableExpressionResult"/>"></textarea>
      			</span>
        	</div>
		</div>
	</div>	
	
	<div data-ng-if="component.type === 'button'" data-ng-init="!component.imageType ? component.imageType='none' : '' ">													
	    <div class="form-group">
	         <label class="col-xs-12 col-lg-4" title="<fmt:message key="CustomReport.Properties.ImageType"/>"><fmt:message key="CustomReport.Properties.ImageType"/></label>
	            <div class="col-xs-12 col-lg-8">
	             	<select  data-ng-model="component.imageType">
						<option value="none"><fmt:message key="CustomReport.Properties.ImageType.none"/></option>
						<option value="url"><fmt:message key="CustomReport.Properties.ImageType.url"/></option>
						<option value="custom"><fmt:message key="CustomReport.Properties.ImageType.custom"/></option>
					</select>
	            </div>
	    </div>
	    <div class="row noLftRghtMargin" data-ng-hide="component.imageType == 'none'">
	            <div class="form-group">
	                <label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.ImageSource"/>'><fmt:message key="CustomReport.Properties.ImageSource"/></label>
	                <div class="col-xs-12 col-lg-8">
	                	<input class="form-control input-sm" type="text" placeholder="{{component.imageType === 'url' ? '../reports/img/settings.png' : '&lt;span class=&quot;sprite icon-refresh&quot;&gt;&lt;/span&gt;'}}" data-ng-model="component.imageValue">
	                </div>
	            </div>
	    </div>													    
	    												    
	    <div class="row noLftRghtMargin">
		<!-- FIXME: Localize -->
					<label class="col-xs-12 noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ButtonStyles"/>'>
						<fmt:message key="CustomReport.Properties.ButtonStyles"/><br>
					</label>
		      <span class="input-group-sm col-xs-12 noLftRghtPadding">
		          <textarea  data-ng-model="component.style" rows="5" ></textarea>
		      </span>
		 </div>
</div>	

	<div data-ng-show="component.type === 'image'">
		 <div class="form-group">
	         <label class="col-xs-12 col-lg-4" title="Image Type"><fmt:message key="CustomReport.Properties.ImageType"/></label>
	            <div class="col-xs-12 col-lg-8">
	             	<select  data-ng-model="component.imageType">
						<option value="url"><fmt:message key="CustomReport.Properties.ImageType.url"/></option>
						<option value="custom"><fmt:message key="CustomReport.Properties.ImageType.custom"/></option>
					</select>
	            </div>
	    </div>
	    
	    <div class="form-group">
	                <label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.ImageSource"/>'><fmt:message key="CustomReport.Properties.ImageSource"/></label>
	                <div class="col-xs-12 col-lg-8">
	                	<input class="form-control input-sm" type="text" placeholder="{{component.imageType === 'url' ? '../reports/img/settings.png' : '&lt;span class=&quot;sprite icon-refresh&quot;&gt;&lt;/span&gt;'}}" data-ng-model="component.imageValue">
                </div>
	    </div>
	    
	     <div class="row noLftRghtMargin">
	        <event-properties event-type="onClick" event-model="component.events['onClick']"></event-properties>
	     </div>
	</div>
	
	<!-- Enable/Disable -->
	<div data-ng-if="component.type !== 'menu'" class="form-group">
		<label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.ComponentEnable"/>'><fmt:message key="CustomReport.Properties.ComponentEnable"/></label>
		<div class="col-xs-12 col-lg-8">
			<select id="type" name="type" data-ng-model="component.enable">
				<option value="always"><fmt:message key="CustomReport.Properties.ComponentEnable.Always"/></option>
				<option value="custom"><fmt:message key="CustomReport.Properties.ComponentEnable.Expression"/></option>
			</select>
		</div>
	</div>
	
	<div data-ng-if="component.type !== 'menu' && component.enable === 'custom'" >
		<div class="row noLftRghtMargin">
			<div class="col-xs-12 noLftRghtPadding">
				<!-- FIXME: Localize -->
				<label  class="col-xs-12 noLftRghtPadding" title='onClick' title='<fmt:message key="CustomReport.Properties.ComponentEnableExpression"/>'>
				<fmt:message key="CustomReport.Properties.ComponentEnableExpression"/><br>
				</label>
						<span class="input-group-sm col-xs-12 noLftRghtPadding">
							<textarea rows="2" data-ng-model="component.enableExpression" placeholder="<fmt:message key="CustomReport.Properties.ButtonEnableExpressionResult"/>"></textarea>
							</span>
			</div>
		</div>
	</div>
	
	<div data-ng-if="component.type === 'menu'" >
		<div class="col-xs-12 noLftRghtPadding">
	       <span title="<fmt:message key="CustomReport.Properties.MenuItems"/>"><fmt:message key="CustomReport.Properties.MenuItems"/></span>
	       <span class="pull-right ico ico-plus-circle" title="Add Items" data-ng-click="addMenuItems($index)"></span>
	    </div>
	    <br/>
	    <div data-ng-repeat="item in component.items" data-ng-init="collapsed['item'+$index] = true">
	    	<div data-ng-class="{'collapsed': collapsed['item']}" class="">
	    		<div class="row menu-item noLftRghtMargin fieldPanel secondary-header inner-panel">
	    			 <div class="fieldHeader" data-ng-click="collapsed['item'+$index]=!collapsed['item'+$index]">                
		                  <label class="col-lg-9 noLftRghtPadding" >
		                      <span title="{{item.title.text}}">{{item.title.text}}</span>
		                  </label>
		                   <span class="pull-right">
		                        <span data-ng-click="deleteMenuItem($parent.$index, $index)" class="ico ico-trash2" title='<fmt:message key="DeleteField"/>'></span>
		                        <span class="ico inner-panel-expand-icon ico-chevron-right" data-ng-class="{'ico-chevron-down':!collapsed['item'+$index], 'ico-chevron-right':collapsed['item'+$index]}" title="ItemDetails"></span>
		                    </span> 
		                    <br style="clear: both;">                                    
		             </div>      
		             <div data-ng-class="{'collapsed': collapsed['item'+$index]}" class="collapsed">
	    				<component-properties component="item"></component-properties>	
	    			</div>
	    		</div>
	    	</div>
	    </div>			
	</div>
	<!-- mobile options -->
	<div class="form-group">
		<label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.Mobile.Column.List"/>'><fmt:message key="CustomReport.Properties.Mobile.Column.List"/></label>
		<div class="col-xs-12 col-lg-8">
			<select  class="form-control input-sm" data-ng-model="component.mobile.viewOnList" data-ng-options="o.v as o.n for o in [{ n: 'Yes', v: false }, { n: 'No', v: true }]">
			</select>
		</div>
	</div>
	<div class="form-group">
		<label class="col-xs-12 col-lg-4" title='<fmt:message key="CustomReport.Properties.Mobile.Column.Detail"/>'><fmt:message key="CustomReport.Properties.Mobile.Column.Detail"/></label>
		<div class="col-xs-12 col-lg-8">
				<select  class="form-control input-sm" data-ng-model="component.mobile.viewOnDetail" data-ng-options="o.v as o.n for o in [{ n: 'Yes', v: false }, { n: 'No', v: true }]">
				</select>
		</div>
	</div>
	
	<div data-ng-if="component.type !== 'menu'" >
		<event-properties event-type="onClick" event-model="component.events['onClick']" is-cell-component="true"></event-properties>
	</div>
	
													
</fmt:bundle>