<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
    <li class="sub-header" title="Filters" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
        <span class="ico ico-funnel"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
	        <span class="ico ico-form-field"></span>
	</li>
</ul>

<div data-ng-show="selectedPropertyCategory==='general'">
	<div class="row noLftRghtMargin">
    	<div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RenamePageID"/>'><fmt:message key="CustomReport.Properties.RenamePageID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" class="form-control input-sm" ng-model="page.pageName" ng-blur="validatePageName()">
                </div>
            </div>  
            </div>
        </div>    
        <div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.RenamePageDisplayName"/>'><fmt:message key="CustomReport.Properties.RenamePageDisplayName"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" class="form-control input-sm" ng-model="page.pageTitle.text" ng-blur="validatePageDisplayName()">
                </div>
            </div>
            </div> 
        </div> 
        <div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.IsDefaultPage"/>'><fmt:message key="CustomReport.Properties.IsDefaultPage"/></label>
                <div class="col-sm-3 noLftRghtPadding" data-ng-class="{'button-disabled' : page.isDefault}">
                    <input type="checkbox" cv-toggle-switch ng-checked="page.isDefault" ng-disabled="page.isDefault" ng-click="setCurrentPageAsDefault()" title="<fmt:message key='CustomReport.Properties.SetDefaultPageTooltip'/>" id="isdefault">
                </div>
            </div>
            </div>
        </div>   
        <div class="row noLftRghtMargin" style="display: none;">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Grid Columns'>Grid Columns</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="page.body.reportLayout['gridsterOpts'].columns" data-ng-blur="refreshGridLayout()">
                </div>
            </div>
            </div>
        </div>  
        <div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Autorefresh'>Autorefresh</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch ng-checked="page.body.autoRefresh" data-ng-click="updateAutoRefreshOption()" data-ng-model="page.body.autoRefresh" id="autorefresh{{page.pageName}}">
                </div>
            </div>
            </div>
        </div>   
        <div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group" data-ng-if="page.body.autoRefresh">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Autorefresh Interval (seconds)'>Autorefresh Interval (seconds)</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="page.body.autoRefreshTime"  data-ng-blur="startAutoRefreshTimer(true)" min="10" title="in seconds">
                </div>
            </div> 
            </div>                                                                                                                     		
    	</div>     
    	<div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Default URL'>Default URL</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch ng-checked="page.defaultUrlEnabled" data-ng-model="page.defaultUrlEnabled" id="defaultUrlEnabled">
                </div>
            </div>
            </div>
        </div>
        <div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group" data-ng-if="page.defaultUrlEnabled">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Default URL Parameters'>Default Url Parameters</label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" class="form-control input-sm" data-ng-model="page.defaultUrlParams" >
                </div>
            </div>
            </div>
    	</div>
    	
    	
    	
    	<div class="row noLftRghtMargin">
            <div class="col-sm-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='headerComponent'>HeaderComponent</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch ng-checked="page.headerComponentEnabled" data-ng-model="page.headerComponentEnabled" id="headerComponentEnabled">
                </div>
            </div>
            </div>
        </div>
    	
    	    
    	<!-- Begin "Views" -->
	<!-- <div >
	    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['views']=!collapsed['views']">
	       <div class="col-xs-12 noLftRghtPadding">
	           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['views'], 'ico-chevron-right':collapsed['views']}" style="margin-right:5px"></span>
	           <span>Views</span>
	           <span class="pull-right ico ico-plus-circle" title="Add Sorting" data-ng-click="collapsed['views']=true;addSystemFilter()"></span>
	       </div>
	    </div>
    	<div data-ng-class="{'collapsed': collapsed['views']}">	   								  			
   			<div class="row  noLftRghtMargin secondary-header property-header" data-ng-repeat="view in page.systemFilters">
            	<div class="col-xs-8 col-sm-8 col-md-8 col-lg-8">{{view.view.reportViewName}}</div>
            	<div class="col-xs-2"><span class="ico ico-edit pro-dlt-btn" data-ng-click="editSystemFilter(view,$index)"></span></div>
            	<div class="col-xs-2"><span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteView($index)"></span></div>
            </div>	
        </div>
    Mobile Visible Option
    </div> -->
    <!-- End "Views" -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
    	<div class="form-group">
              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="label.disable_mobile_mode"/>'><fmt:message key="label.disable_mobile_mode"/></label>
              <div class="col-sm-3 noLftRghtPadding">
                  <input type="checkbox" cv-toggle-switch ng-checked="page.body.disableMobileMode" data-ng-model="page.body.disableMobileMode" id="disableMobileMode">
              </div>
        </div>
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
    
        </div>  
    	<div class="clear-floats"></div>
    </div> 
        
<div data-ng-show="selectedPropertyCategory==='customcode'">        
	<div class="row noLftRghtMargin">
        <div  class="col-xs-12">            
                <div class="col-xs-12 noLftRghtPadding">
                    <label><fmt:message key="CustomReport.Properties.CustomJavaScript"/></label> 
                   <label> &lt;script&gt;</label>
                </div>
                <div class="col-xs-12 noLftRghtPadding">
                    <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(page.body.customJsCode,'javascript',writeJsToDom,'page.body.customJsCode')">
                        <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddScript"/>
                    </button>
                 </div>                                 
                 <label class="col-xs-12 noLftRghtPadding">&lt;/script&gt;</label>           
        </div>
	</div>
	
    <div class="row noLftRghtMargin" >
        <div  class="col-xs-12">
            <div class="col-xs-12 noLftRghtPadding">
                <label><fmt:message key="CustomReport.Properties.CustomStyles"/></label>
                <label>&lt;style&gt;</label> 
            </div>
            <div class="col-xs-12 noLftRghtPadding">
                <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(page.body.customStyle,'css',writeCSSToDom)">
                    <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddStyle"/>
                </button>                
            </div>
            <label class="col-xs-12 noLftRghtPadding">&lt;/style&gt;</label>
        </div>
	</div>   
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['pagevariables']=!collapsed['pagevariables']">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['pagevariables'], 'ico ico-chevron-right':collapsed['pagevariables']}"></span>
           <span>Page Variables</span>
           <span class="pull-right ico ico-plus-circle" title="Add New Page Variable" data-ng-click="collapsed['pagevariables']=false;addPageVariable($event)"></span>
       </div>
   </div>
   <div class="row noLftRghtMargin seriesLabelRow noLftRghtMargins"  data-ng-repeat="pageVariable in propData.body.pageVariables">            
            <div class="form-group">                
                <div class="col-sm-3" style="padding-right:0px">
                    <input type="text" name="" id="variableName" class="form-control" data-ng-model='pageVariable.variableName' pattern="" title="Variable Name" placeholder="Variable Name" />
                 </div>
                 <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" name="" id="variableRestApi" class="form-control" data-ng-model='pageVariable.variableRestApi' pattern="" title="REST API" placeholder="REST API" />
                </div>
                <div class="col-sm-1 noLftRghtPadding">
                    <span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deletePageVariable($index)"></span>
                </div>
            </div>
	</div>

</div>

<!-- Begin "Filters" group -->
<div data-ng-show="selectedPropertyCategory==='filters'">    
    <cvfacet config="propData" type="'pageProperties'" page="page" filters="page.body.filters" filter-mode="'builder'" report-mode="reportMode"></cvfacet>
</div>

<!-- End "Custom Code" group -->
</fmt:bundle>
