<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li>
    <li class="sub-header" title="Filters" data-ng-show="ds && ds.endpoint === 'DATACUBE'" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
        <span class="ico ico-funnel"></span>
    </li>
</ul>

<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

<div data-ng-show="selectedPropertyCategory==='general'">
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" cv-label-title><fmt:message key="CustomReport.Properties.ChartTitle"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.title.text"
                       type="text"
                       placeholder="<fmt:message key="CustomReport.Properties.ChartName"/>">
                </div>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>' cv-label-title><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div>
        </div>
    </div>
   	<div class="row noLftRghtMargin" data-ng-if="propData.chartType != 'Pie' && propData.chartType != 'Donut'">
        <div class="col-xs-12">
		<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='{{getFieldLabel(propData.chartType, "y")}} <fmt:message key="CustomReport.Properties.Title"/>'>{{getFieldLabel(propData.chartType, 'y')}} <fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   data-ng-model="propData.yAxisTitle.text"
                   type="text">
                </div>
            </div>
        </div>
    </div>
    <div class="row noLftRghtMargin" data-ng-if="propData.chartType != 'Pie' && propData.chartType != 'Donut'">
        <div class="col-xs-12">
		<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='{{getFieldLabel(propData.chartType, "x")}} <fmt:message key="CustomReport.Properties.Title"/>'>{{getFieldLabel(propData.chartType, 'x')}} <fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.xAxisTitle.text"
                       type="text">
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin">
        <div class="col-xs-12" ng-hide="propData.chartType=='TimeSeries' || propData.chartType=='Histogram'">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ChartType"/>'><fmt:message key="CustomReport.Properties.ChartType"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select  class="form-control input-sm" data-ng-model="propData.chartType"  >
                        <option data-ng-hide="propData.isDateTime"  value="HorizontalBar"><fmt:message key="CustomReport.Properties.HorizontalBar"/></option>
                        <option data-ng-hide="propData.isDateTime" value="VerticalBar"><fmt:message key="CustomReport.Properties.VerticalBar"/></option>
                        <option data-ng-hide="propData.isDateTime" value="Line"><fmt:message key="CustomReport.Properties.Line"/></option>
                        <option data-ng-show="isPieChartApplicable()"  value="Pie"><fmt:message key="CustomReport.Properties.Pie"/></option>
                        <option data-ng-show="isPieChartApplicable()"  value="Donut"><fmt:message key="CustomReport.Properties.Donut"/></option>
                        <option data-ng-show="isHeatMapApplicable()"  value="heatmap">Heat Map</option> <!-- TOOD: localize -->
                        <option data-ng-show="isTileStatusChartApplicable()"  value="TileStatusChart"><fmt:message key="CustomReport.Properties.StatusChart"/></option> <!-- TOOD: localize -->
                        <option  value="scatter">Scatter</option> <!-- TOOD: localize -->
                        <option data-ng-show="isTreeMapApplicable()"  value="treemap">Tree Map</option> <!-- TOOD: localize -->
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="row noLftRghtMargin" data-ng-show="(propData.dimensionDataField.length > 1 || propData.measureDataField.length > 1 )
    									 && (propData.chartType =='VerticalBar' ||  propData.chartType =='HorizontalBar')">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Grouped"/>'><fmt:message key="CustomReport.Properties.Grouped"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.isGrouped" id="isgrouped">

                </div>
            </div>
        </div>
    </div>
      <div data-ng-if="propData.chartType==='Histogram'">
			<!-- <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['binProperties']=!collapsed['binProperties']">
			   <div class="col-xs-12 noLftRghtPadding">
				   <span data-ng-class="{'ico ico-chevron-down':!collapsed['binProperties'], 'ico ico-chevron-right':collapsed['binProperties']}"></span>
				   <span>Bins</span>
			   </div>
		   </div> -->
		   <!-- <div data-ng-class="{'collapsed': collapsed['binProperties']}"> -->
              <!-- Define the bucketType properties , bucketType = FIXEDBINCOUNT|FIXEDRANGE|VARIABLEBINWIDTH|CUSTOM -->
              <div class="col-xs-12">
		         <div class="form-group">
		            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Bucket Type'><fmt:message key="DataSet.Preview.Parameters.Type"/></label>
		                <div class="col-sm-8 noLftRghtPadding">
		                    <select  class="form-control input-sm" data-ng-model="propData.binType" data-ng-change="updateVariables()">
		                        <option value="FIXEDBINCOUNT"><fmt:message key="CustomReport.Properties.FixedBinCount"/></option>
		                        <option value="FIXEDBINWIDTH"><fmt:message key="CustomReport.Properties.FixedBinWidth"/></option>
		                        <option value="VARIABLEBINWIDTH"><fmt:message key="CustomReport.Properties.VariableBinWidth"/></option>
		                        <option value="CUSTOMBINWIDTH"><fmt:message key="CustomReport.Properties.CustomBinWidth"/></option>
		                	</select>
		                </div>
		         </div>
		   	  </div>
    	      <div class="col-xs-12" data-ng-show="propData.binType === 'FIXEDBINCOUNT'">
		         <div class="form-group">
		            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='Bucket Type'><fmt:message key="CustomReport.Properties.NumberOfBins"/></label>
		            <div class="noLftRghtPadding col-sm-4 pull-right">
	                  <input type="text" size=3 data-ng-model="propData.binValues[0].value" data-ng-blur="updateChart()">
		          	</div>
		      	 </div>
		   	  </div>
		   	  <div class="col-xs-12" data-ng-show="propData.binType === 'FIXEDBINWIDTH'">
		         <div class="form-group">
		            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Bucket Type'><fmt:message key="CustomReport.Properties.Width"/></label>
		            <div class="noLftRghtPadding col-sm-4">
	                  <input type="text" size=3 data-ng-model="propData.binValues[0].value" data-ng-blur="updateChart()">
		          	</div>
		          	<div class="noLftRghtPadding col-sm-4">
	                   	<select class="form-control input-sm seriesSelect"  data-ng-model="propData.binValues[0].unit" data-ng-options="opt.value as opt.label for opt in fixedRangeOptions()" data-ng-change="updateChart()"></select>
	          		</div>
		      	 </div>
		   	  </div>

    	       <div class="col-xs-12" data-ng-show="propData.binType === 'VARIABLEBINWIDTH'">
		        <div class="form-group">
			   	  <div class="row row noLftRghtMargin seriesLabelRow noLftRghtMargins" data-ng-repeat="vars in propData.binValues">
	              	<div class="noLftRghtPadding col-sm-5">
	                    <input type="text" size=3 data-ng-model="vars.value" data-ng-blur="updateChart()">
		          	</div>
	          		<div class="noLftRghtPadding col-sm-5">
	                   	<select class="form-control input-sm seriesSelect"  data-ng-model="vars.unit" data-ng-options="opt.value as opt.label group by opt.groupName for opt in fixedRangeOptions()" data-ng-change="updateChart()"></select>
	          		</div>
	          		<div class="col-sm-1 noLftRghtPadding" title="<fmt:message key="CustomReport.Properties.DeleteVariable"/>" data-ng-hide="propData.binValues.length === 1">
	                    <span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteVariable($index)"></span>
	                </div>
	                <div class="col-sm-1 noLftRghtPadding pull-right" title="<fmt:message key="CustomReport.Properties.AddNewVariable"/>" data-ng-show="propData.binValues.length-1 === $index">
	                    <span class="ico ico ico-plus-circle pro-add-btn" data-ng-click="addNewVariable($event)"></span>
	             	</div>
		   	      </div>
		   	  	</div>

   				<div class="col-xs-12" data-ng-show="propData.binType === 'CUSTOMBINWIDTH'">
		        	<div class="row noLftRghtMargin">
							<label class="col-xs-12 noLftRghtPadding">
								<fmt:message key="CustomReport.Properties.WidthExpression"/><br>
							</label>
				            <span class="col-xs-12 noLftRghtPadding">
				                <textarea  data-ng-model="propData.customWidthExpression" data-ng-blur="updateChart()"></textarea>
				            </span>
				    </div>
				 </div>
   				</div>
   			</div>
<!-- End "General" group -->

<!-- Begin "Look and Feel" group -->
 <%--   <div class="row noLftRghtMargin">
        <div class="col-xs-6">
<!-- FIXME: Localize -->
            <label>
                <fmt:message key="CustomReport.Properties.Height"/><br>
                <span class="input-group input-group-sm">
                    <input class="form-control"
                    	   data-ng-model="propData.styles.height"
                    	   placeholder="350"
                           type="text">
				<span class="input-group-addon">px</span>
                </span>
            </label>
        </div>

        <div class="col-xs-6">
<!-- FIXME: Localize -->
            <label>
                <fmt:message key="CustomReport.Properties.Width"/><br>
                <span class="input-group input-group-sm">
                    <input class="form-control"
                    	   data-ng-model="propData.styles.width"
                    	   placeholder="1000"
                           type="text">
                    <span class="input-group-addon">px</span>
                </span>
            </label>
        </div>
    </div>    --%>
   <div class="row noLftRghtMargin" >

   		<div class="col-xs-12"  data-ng-if="propData.chartType === 'HorizontalBar' || propData.chartType === 'VerticalBar' || propData.chartType === 'Pie' || propData.chartType === 'Donut'" >
             <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowAs3D"/>'><fmt:message key="CustomReport.Properties.ShowAs3D"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <div class="on-off-switch">
                        <input type="checkbox" name="on-off-switch" data-ng-model="propData.styles.chartPlotOptions.enable3dGraph" class="on-off-switch-checkbox" id="showAs3D" data-ng-change="updateChart()">
                        <label class="on-off-switch-label" for="showAs3D">
                            <span class="on-off-switch-inner"></span>
                            <span class="on-off-switch-switch"></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>


   		<div class="col-xs-12" data-ng-if="propData.chartType === 'TimeSeries'">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowGridlines"/>'>Include Missing Times</label>
                <div class="col-sm-3 noLftRghtPadding">
                    <div class="on-off-switch">
                        <input type="checkbox" name="on-off-switch" data-ng-model="propData.includeMissingTimes" class="on-off-switch-checkbox" id="includeMissingTimes" data-ng-change="updateChart()">
                        <label class="on-off-switch-label" for="includeMissingTimes">
                            <span class="on-off-switch-inner"></span>
                            <span class="on-off-switch-switch"></span>
                        </label>
                    </div>
                </div>
            </div>
        </div>

		<div class="col-xs-12" data-ng-if="propData.chartType != 'Pie' && propData.chartType != 'Donut' && propData.chartType != 'treemap'">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowGridlines"/>'><fmt:message key="CustomReport.Properties.ShowGridlines"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isShowGridlines" id="isshowgridlines">
                </div>
            </div>
        </div>

        <div class="col-xs-12" data-ng-if="propData.chartType != 'Line' && propData.chartType != 'TimeSeries' && propData.chartType != 'Pie' && propData.chartType != 'Donut'">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ToggleChart"/>'><fmt:message key="CustomReport.Properties.ToggleChart"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.toggleChart" id="togglechart">
                </div>
            </div>
        </div>
     </div>
	<div class="row noLftRghtMargin" data-ng-if="propData.chartType == 'Line' || propData.chartType == 'TimeSeries'">
		<div class="col-xs-12" >
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SmoothLines"/>'><fmt:message key="CustomReport.Properties.SmoothLines"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isSmoothLines" id="issmoothlines">
                </div>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowArea"/>'><fmt:message key="CustomReport.Properties.ShowArea"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isShowArea" id="isshowarea">
                </div>
            </div>
        </div>
		<div class="col-xs-12" data-ng-if="propData.chartType == 'Line' || propData.chartType == 'TimeSeries'">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowMarkers"/>'><fmt:message key="CustomReport.Properties.ShowMarkers"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isShowLineMarkers" id="isshowlinemarkers">
                </div>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SkipLinesForMissingData"/>'><fmt:message key="CustomReport.Properties.SkipLinesForMissingData"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.SkipLinesForMissingData" id="SkipLinesForMissingData" data-ng-change="updateChart()">
                </div>
            </div>
        </div>
  	</div>
	<div class="row noLftRghtMargin" >
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowLabels"/>'><fmt:message key="CustomReport.Properties.ShowLabels"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isShowLabels" id="isshowlabels" data-ng-change="updateChart()">
                </div>
            </div>
        </div>
        <div class="col-xs-12" data-ng-if="propData.chartType != 'treemap'">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ShowLegend"/>'><fmt:message key="CustomReport.Properties.ShowLegend"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.isShowLegend" id="showLabels" data-ng-change="updateChart()">
                </div>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='Show in Tabular Form'>Show in Tabular Form</label> <!-- TODO: Localize -->
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.showInTabularForm" id="showTabularForm">
                </div>
            </div>
        </div>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisableInteractivity"/>'><fmt:message key="CustomReport.Properties.DisableInteractivity"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.disableInteractivity" id="disableInteractivity">
                </div>
            </div>
        </div>
         <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">
                </div>
            </div>
        </div>
         <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.showTopRightTooltipTitle"/>'><fmt:message key="CustomReport.Properties.showTopRightTooltip"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.showTopRightTooltip" id="topRightTooltip">                        
                </div>
            </div>            
        </div>
        <div data-ng-if="propData.chartType === 'Pie' || propData.chartType === 'Donut'"class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.enableMonochromeFill"/>'><fmt:message key="CustomReport.Properties.enableMonochromeFill"/></label>
                <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.enableMonochromeFill" id="colorGradient">
                </div>
            </div>
        </div>
        <div data-ng-if="propData.enableMonochromeFill && (propData.chartType === 'Pie' || propData.chartType === 'Donut')" data-ng-init="propData.chartColor = propData.chartColor || '#004080'" class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Color"/>'><fmt:message key="CustomReport.Properties.Color"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="seriesColor form-control input-sm" type="color" data-ng-model="propData.chartColor">
                </div>
            </div>
        </div>
    </div>
        <div class="col-xs-12">
            <div class="form-group" data-ng-show="propData.styles.chartPlotOptions.isShowLegend && propData.chartType != 'treemap'">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.LegendPosition"/>'><fmt:message key="CustomReport.Properties.LegendPosition"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.legendPosition" data-ng-change="updateChart()">
                        <option value="top"><fmt:message key="CustomReport.Properties.LegendPlacementTop"/></option>
                        <option value="right"><fmt:message key="CustomReport.Properties.LegendPlacementRight"/></option>
                        <option value="bottom"><fmt:message key="CustomReport.Properties.LegendPlacementBottom"/></option>
                        <option value="left"><fmt:message key="CustomReport.Properties.LegendPlacementLeft"/></option>
                     </select>
                </div>
            </div>
        </div>
	 </div>
	 <div class="row noLftRghtMargin" data-ng-show="propData.styles.chartPlotOptions.isShowLegend && propData.chartType != 'treemap'">
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.MaxLegendLabelLength"/>'><fmt:message key="CustomReport.Properties.MaxLegendLabelLength"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.maxLegendLabelLength" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
	 </div>


 <div data-ng-show="propData.styles.chartPlotOptions.enable3dGraph">
	<div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['options3d']=!collapsed['options3d']">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['options3d'], 'ico ico-chevron-right':collapsed['options3d']}"></span>
           <span><fmt:message key="CustomReport.Properties.options3d"/></span>
       </div>
   </div>

	 <div class="row noLftRghtMargin padding-left-10 " data-ng-class="{collapsed:collapsed['options3d']}" >
        <div class="col-xs-12" data-ng-if="propData.chartType === 'HorizontalBar' || propData.chartType === 'VerticalBar' ">
	        <div class="form-group">
	             <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Stacking3D"/>'><fmt:message key="CustomReport.Properties.Stacking3D"/></label>
	             <div class="col-sm-3 noLftRghtPadding">
	                 <div class="on-off-switch">
	                     <input type="checkbox" name="on-off-switch" data-ng-model="propData.styles.chartPlotOptions.stackIn3d" class="on-off-switch-checkbox" id="3dStacking" data-ng-change="updateChart()">
	                     <label class="on-off-switch-label" for="3dStacking">
	                         <span class="on-off-switch-inner"></span>
	                         <span class="on-off-switch-switch"></span>
	                     </label>
	                 </div>
	             </div>
	        </div>
        </div>
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.alpha3D"/>'><fmt:message key="CustomReport.Properties.alpha3D"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.alpha3D" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
	 	<div class="col-xs-12" data-ng-if="propData.chartType === 'HorizontalBar' || propData.chartType === 'VerticalBar' ">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.beta3D"/>'><fmt:message key="CustomReport.Properties.beta3D"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.beta3D" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.depth3D"/>'><fmt:message key="CustomReport.Properties.depth3D"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.depth3D" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
	 	<div class="col-xs-12" data-ng-if="propData.chartType === 'HorizontalBar' || propData.chartType === 'VerticalBar' ">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.columnPadding3D"/>'><fmt:message key="CustomReport.Properties.columnPadding3D"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="form-control input-sm" data-ng-model="propData.styles.chartPlotOptions.columnPadding3D" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
	 </div>

</div>

	 </div>



     <!-- <div class="row formatter-option noLftRghtMargin" data-ng-show="propData.styles.chartPlotOptions.isShowLegend">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.LabelConversion"/>'>
                        <fmt:message key="CustomReport.Properties.LabelConversion"/>
                    </label>
                    <div class="col-sm-5 noLftRghtPadding" style="margin-top:5px;">
                        <span class="pull-right">
                            <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(propData,'convertLabels')">{{getFormatterType(propData.convertLabels)}}</span>
                        </span>
                    </div>
                </div>
            </div>
    </div>	 -->
	 <div class="row noLftRghtMargin" data-ng-if="propData.chartType == 'Donut'">
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.StartAngle"/>'><fmt:message key="CustomReport.Properties.StartAngle"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" size=3 data-ng-model="propData.styles.chartPlotOptions.startAngle" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.EndAngle"/>'><fmt:message key="CustomReport.Properties.EndAngle"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" size=3 data-ng-model="propData.styles.chartPlotOptions.endAngle" data-ng-blur="updateChart()">
                </div>
            </div>
        </div>
	 	<div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.InnerWidth"/>'><fmt:message key="CustomReport.Properties.InnerWidth"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="text" size=3 data-ng-model="propData.styles.chartPlotOptions.innerWidth" data-ng-blur="updateChart()">
                </div>
            </div>
	 	</div>
     </div>
     <!--  End "Look and Feel" group -->

     <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>
            </div>
        </div>
    </div>

	<entity-security data-item="propData"></entity-security>

</div>


<!-- Sorting group -->
<div data-ng-show="selectedPropertyCategory==='fields'">
   <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['sorting']=!collapsed['sorting']">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['sorting'], 'ico ico-chevron-right':collapsed['sorting']}"></span>
           <span><fmt:message key="CustomReport.Properties.Sorting"/></span>
       </div>
   </div>
   <div class="row noLftRghtMargin" data-ng-class="{collapsed:collapsed['sorting']}">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SortBy"/>'><fmt:message key="CustomReport.Properties.SortBy"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select  class="form-control input-sm" data-ng-model="propData.sorting[0].sortAxis"  data-ng-change="updateChart()" data-ng-class="{disabled: propData.isTimeGrouping}">
                        <option data-ng-if="propData.chartType!='TimeSeries'" value="None"><fmt:message key="CustomReport.None"/></option>
                        <option value="XAxis"><fmt:message key="CustomReport.Properties.XAxis"/></option>
                        <option data-ng-if="isYSortApplicable()" value="YAxis"><fmt:message key="CustomReport.Properties.YAxis"/></option>
                    </select>
                </div>
            </div>
   	 </div>
   </div>


   <div class="row noLftRghtMargin" data-ng-class="{collapsed:collapsed['sorting']}">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SortOrder"/>'><fmt:message key="CustomReport.Properties.SortOrder"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select  class="form-control input-sm" data-ng-model="propData.sorting[0].direction" data-ng-change="updateChart()" data-ng-class="{disabled: propData.sorting[0].sortAxis == 'None'}">
                        <option value="Desc">Desc</option>
                        <option value="Asc">Asc</option>
                    </select>
                </div>
            </div>
   	 </div>
   </div>
<!-- End Sorting group -->

<!-- Begin "Y-axis" group -->
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['measure']=!collapsed['measure']" data-ng-hide="propData.chartType=='Histogram'">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['measure'], 'ico ico-chevron-right':collapsed['measure']}"></span>
           <span>Measure</span>
       </div>
   </div>
    <div data-ng-if="propData.measureDataField && propData.measureDataField.length!=0" data-ng-class="{'collapsed': collapsed['measure']}">
        <div class="row noLftRghtMargin">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.AutoConvertYValues"/>'><fmt:message key="CustomReport.Properties.AutoConvertYValues"/></label>
                    <div class="col-sm-3 noLftRghtPadding">
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.styles.chartPlotOptions.autoConvertYValues" id="autoconvertyvalues">
                    </div>
                </div>
              </div>
          </div>
        <!-- <div class="row formatter-option noLftRghtMargin" data-ng-show="!propData.styles.chartPlotOptions.autoConvertYValues">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='Customize Y-Axis Labels'>
                        Customize Y-Axis Labels<!-- TODO: Localize
                    </label>
                    <div class="col-sm-5 noLftRghtPadding" style="margin-top:5px;">
                        <span class="pull-right">
                            <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(propData,'convertYAxisLabel')">{{getFormatterType(propData.convertYAxisLabel)}}</span>
                        </span>
                    </div>
                </div>
            </div>
        </div> -->
        <div data-ng-repeat="measure in propData.measureDataField" data-ng-init="collapsed['measure'+$index]=true">
        	<div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
    	        <div class="fieldHeader"  data-ng-click="collapsed['measure'+$index]=!collapsed['measure'+$index]">
    	            <label class="col-lg-9 noLftRghtPadding">
    	               <span data-ng-if="measure.aggrType!='None'">{{measure.aggrType}}(</span>{{measure.column}}<span data-ng-if="measure.aggrType!='None'">)</span>
    	            </label>
                   <span class="pull-right">
                        <span class="ico inner-panel-expand-icon" data-ng-class="{'ico ico-chevron-down':!collapsed['measure'+$index], 'ico ico-chevron-right':collapsed['measure'+$index]}"></span>
                        <span class="ico inner-panel-expand-icon ico-trash2" title="Remove Measure" data-ng-click="deleteMeasure($index)" ></span>
                    </span>
    	       </div>
               <div data-ng-class="{'collapsed': collapsed['measure'+$index]}">
        	       <div class="row noLftRghtMargin" data-ng-if="propData.measureDataField.length>1">
            	        <div class="col-xs-12 noLftRghtPadding">
                            <div class="form-group">
                                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.LegendLabel"/>'><fmt:message key="CustomReport.Properties.LegendLabel"/></label>
                                <div class="col-sm-8 noLftRghtPadding">
                                    <input class="fieldTitleText form-control input-sm" data-ng-model="measure.title.text" data-ng-blur="updateChart()" type="text">
                                </div>
                            </div>
            	       	 </div>
            		</div>
        	       	 <div id="measureAggregate">
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Aggregate"/>'> <fmt:message key="CustomReport.Properties.Aggregate"/></label>
                            <div class="col-sm-8 noLftRghtPadding">
                                <select  class="form-control fieldPropValue input-sm" data-ng-model="measure.aggrType" data-ng-change="changeAggregation()">
                                    <option  data-ng-if="measure.showNumberOps" value="None"><fmt:message key="CustomReport.None"/></option>
                                    <option value="Count"><fmt:message key="CustomReport.Count"/></option>
                                    <option value="CountDistinct"><fmt:message key="CustomReport.Distinct"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
                                    <option data-ng-if="measure.showNumberOps"  value="Min"><fmt:message key="CustomReport.Min"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Max"><fmt:message key="CustomReport.Max"/></option>
                                </select>
                            </div>
                        </div>
        	        </div>
                    <div class="row formatter-option">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='Formatter'>
                                    Formatter <!-- TODO: localize -->
                                </label>
                                <div class="col-sm-5 noLftRghtPadding">
                                    <span class="pull-right">
                                        <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(measure,'formatter')">{{getFormatterType(measure.formatter)}}</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
    	    </div>
        </div>
    </div>
<!-- End "Y-axis" group -->

<!-- Begin "X-Axis" group -->
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['dimension']=!collapsed['dimension']"  data-ng-if="propData.dimensionDataField && propData.dimensionDataField.length!=0">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['dimension'], 'ico ico-chevron-right':collapsed['dimension']}"></span>
           <span>Dimension</span>
       </div>
   </div>
<!--    enable in SP1a  -->
<!--     <div class="row noLftRghtMargin" data-ng-show="propData.chartType !='Pie'"> -->
<!-- 	    <div class="col-xs-12"> -->
<!-- 	            <label> -->
<!-- 	        		<input class="input-sm" data-ng-model="propData.isDateTime" type="checkbox" cv-toggle-switch> -->
<!-- 	                Plot as timeline  -->
<!-- 	            </label> -->
<!-- 	      </div> -->
<!--       </div> -->

    <div data-ng-class="{'collapsed': collapsed['dimension']}">
        <div class="row noLftRghtMargin" data-ng-show="propData.chartType !='Pie' && propData.chartType != 'Donut'  && propData.chartType != 'TimeSeries'"">
    	    <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-10 col-sm-10 col-md-10 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.SlantXAxisLabels"/>'><fmt:message key="CustomReport.Properties.SlantXAxisLabels"/><!-- TODO: Localize --></label>
                    <div class="col-sm-3 noLftRghtPadding">
                            <input type="checkbox" cv-toggle-switch data-ng-model="propData.rotateXAxisLabels" id="slantxaxis">
                    </div>
                </div>
            </div>
            <div class="col-xs-12" data-ng-show="propData.rotateXAxisLabels">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='Angle'>Angle<br> <!-- TODO: Localize --></label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <div class="input-group">
                            <input class="input-sm form-control" type="text" data-ng-model="propData.rotateXAxisLabelsDegrees" title="<fmt:message key="CustomReport.Properties.SlantXAxisDegreesLabel"/>">
                            <span class="input-group-addon input-sm">&deg;</span>
                        </div>
                    </div>
                </div>
    	    </div>
          </div>

        <div data-ng-repeat="dimension in propData.dimensionDataField" data-ng-init="collapsed['dimension'+$index]=true">
        	<div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" data-ng-hide="propData.chartType === 'TimeSeries' && $index === 0">
    	        <div class="fieldHeader"  data-ng-click="collapsed['dimension'+$index]=!collapsed['dimension'+$index]">
    	            <label class="col-lg-9 noLftRghtPadding">
    		             <span>{{dimension.column}}</span>
    	            </label>
                    <span class="pull-right">
                        <span class="ico inner-panel-expand-icon" data-ng-class="{'ico ico-chevron-down':!collapsed['dimension'+$index], 'ico ico-chevron-right':collapsed['dimension'+$index]}"></span>
                        <span class="ico inner-panel-expand-icon ico-trash2" title="Remove Dimension" data-ng-click="deleteDimension($index)"></span>
                    </span>
    	        </div>
    	        <div data-ng-class="{'collapsed' : collapsed['dimension' + $index]}">
        	        <div id="pointsToPlot">
                        <div class="row noLftRghtMargin">
                          <div class="form-group">
                              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message key="CustomReport.Properties.MaxPoints"/> <!-- TODO: Localize --></label>
                              <div class="col-sm-8 noLftRghtPadding">
                                  <input  id="maxPointTextbox" class="fieldPropValue form-control" data-ng-model="dimension.numPointsToDisplay.maxPoints" data-ng-readonly="dimension.numPointsToDisplay.includeAll"
                                    data-ng-change="updateChart(false)" type="text">
                              </div>
                          </div>
                        </div>
                        <div class="row noLftRghtMargin">
                          <div class="form-group">
                              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message key="CustomReport.Properties.All"/><!-- TODO: Localize --></label>
                              <div class="col-sm-3 noLftRghtPadding">
                                    <input type="checkbox" cv-toggle-switch data-ng-model="dimension.numPointsToDisplay.includeAll" id="includeall{{$index}}"  data-ng-change="updateChart(false)">

                              </div>
                          </div>
        	            </div>
                        <div class="row noLftRghtMargin" data-ng-show="propData.chartType =='Pie'" data-ng-class="{disabled:dimension.numPointsToDisplay.includeAll}">
                          <div class="form-group">
                              <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.showOthers"/>'><fmt:message key="CustomReport.Properties.showOthers"/><!-- TODO: Localize --></label>
                              <div class="col-sm-3 noLftRghtPadding">
                                    <input type="checkbox" cv-toggle-switch data-ng-model="propData.showOthers" id="showothers{{$index}}" data-ng-change="updateChart(false)">

                              </div>
                          </div>
                        </div>

        	    	</div>
        	    	<div class="row formatter-option">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='Formatter'>
                                    Formatter <!-- TODO: localize -->
                                </label>
                                <div class="col-sm-5 noLftRghtPadding">
                                    <span class="pull-right">
                                        <span class="label label-info cursor-pointer" data-ng-click="showFormatterOptions(dimension,'formatter')">{{getFormatterType(dimension.formatter)}}</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                     <div class="row mincount-option" data-ng-class="{hide:!dimension.showMinCount}">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='Mincount'>
                                    Mincount <!-- TODO: localize -->
                                </label>
                                <div class="col-sm-5 noLftRghtPadding">
                                   <input type="number" class="form-control" value="dimension.minCount"
                                        data-ng-model="dimension.minCount" min="1" data-ng-blur="updateChart()">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

    	    </div>
        </div>
    </div>
<!-- End "X-Axis" group -->

<!-- Begin "Series" group -->
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['series']=!collapsed['series']">
       <div class="col-xs-12 noLftRghtPadding">
           <span data-ng-class="{'ico ico-chevron-down':!collapsed['series'], 'ico ico-chevron-right':collapsed['series']}"></span>
           <span><fmt:message key="CustomReport.Properties.CustomColors"/></span>
           <span class="pull-right ico ico-plus-circle" title="<fmt:message key='CustomReport.Properties.CustomizeSeriesColors'/>" data-ng-click="collapsed['series']=false;addCustomSeriesColor($event)"></span>
       </div>
   </div>
    <div data-ng-class="{'collapsed': collapsed['series']}">
    	<div class="row noLftRghtMargin" data-ng-show="propData.multiBars == false  &&  propData.chartType != 'Pie' && propData.chartType != 'Donut'">
            <div class="col-xs-12">
                <div class="form-group">
                    <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DefaultColor"/>'><fmt:message key="CustomReport.Properties.DefaultColor"/></label>
                    <div class="col-sm-8 noLftRghtPadding">
                        <input class="seriesColor form-control input-sm" type="color" data-ng-model="propData.styles.barColor">
                    </div>
                </div>
            </div>
    	</div>

        <div class="row noLftRghtMargin"  data-ng-hide="propData.multiBars == false  && propData.chartType == 'Line'" >
          <div class="col-xs-12 seriesLabelRow noLftRghtMargins">
        	<!--<label><fmt:message key="CustomReport.Properties.CustomizeSeriesColors"/><span id="seriesNote"></span></label>
    	     <input class="seriesButton"
    	               data-ng-click="addCustomSeriesColor()"
    	               type="button"
    	               value="Add Custom Colors">  -->
        </div>
        </div>

         <div data-ng-hide="propData.multiBars == false  && propData.chartType == 'Line'" class="row noLftRghtMargin seriesLabelRow noLftRghtMargins"  data-ng-repeat="series in propData.seriesFormatting">
            <div class="form-group">
                <div class="col-sm-9" style="padding-right:0px">
                   <div class="seriesNameDiv">
                    <input class="seriesTextField" type="text" data-ng-model=series.value>
                        <select class="form-control input-sm seriesSelect"  data-ng-model="series.value">
                          <option data-ng-repeat="currSeries in propData.currDataSeries" data-ng-show="!currSeries.selected" data-ng-model="currSeries.value" >{{currSeries.value}}</option>
                        </select>
    <!--                <select class="form-control input-sm seriesSelect" data-ng-change="seriesSelectionChange(series, currSeries.value)"                         -->
    <!--                     data-ng-options="currSeries.value as currSeries.value for currSeries in propData.currDataSeries" data-ng-show="!currSeries.selected"  data-ng-model="currSeries.value"> -->
    <!--                </select>       -->
                    </div>
                </div>
                <div class="col-sm-2 noLftRghtPadding">
                    <input class="seriesColor form-control input-sm"
                       type="color"
                       data-ng-model="series.color">
                </div>
                <div class="col-sm-1 noLftRghtPadding">
                    <span class="ico ico-trash2 pro-dlt-btn" data-ng-click="deleteSeries($index)"></span>
                </div>
            </div>
    			 <!-- <div class="col-xs-12 propCheckBox" cv-toggle-switch>
            		 <a class="compButtons sprite  reports-actions-downarrow noLftRghtMargin" data-ng-click="moveSeries('Down',$index)"> </a>
    			</div>
    			 <div class="col-xs-12 propCheckBox" cv-toggle-switch>
            		 <a class="compButtons sprite  reports-actions-uparrow noLftRghtMargin" data-ng-click="moveSeriesUp('UP,'$index)"> </a>
    			</div> -->
    		</div>

        </div>
        <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['otherProperties']=!collapsed['otherProperties']" data-ng-show="propData.dimensionDataField.length>0 && propData.dimensionDataField[0].customGroupsAvailable != undefined">
           <div class="col-xs-12 noLftRghtPadding">
               <span data-ng-class="{'ico ico-chevron-down':!collapsed['otherProperties'], 'ico ico-chevron-right':collapsed['otherProperties']}"></span>
               <span>Custom Groups</span>
           </div>
       </div>
        <div data-ng-class="{'collapsed': collapsed['otherProperties']}" data-ng-show="propData.dimensionDataField.length>0 && propData.dimensionDataField[0].customGroupsAvailable != undefined">
            <div class="row noLftRghtMargin" data-ng-repeat="dimension in propData.dimensionDataField">
                <div class="row noLftRghtMargin">
                    <div class="col-xs-12">
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='{{dimension.column}}'>
                                {{dimension.column}}
                            </label>
                            <div class="col-sm-5 noLftRghtPadding">
                                <span class="pull-left" style="margin-top: 3px">
                                    <input type="checkbox" cv-toggle-switch data-ng-model="dimension.customGroupsAvailable" id="customgroup{{$index}}" data-ng-click="updateCustomGroupsAvailable(dimension)">
                                </span>
                                <span class="ico ico-pencil pro-btn-algn cursor-pointer pull-right" data-ng-click="showAdditionalProperties(dimension)" data-ng-show="dimension.customGroupsAvailable"></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<!-- End "Series" group -->
<!-- Begin "custom(pre-defined) groups" group -->
</div>
<!-- End "custom groups" group -->

<!-- Begin "Custom Code" group -->
<div data-ng-show="selectedPropertyCategory==='customcode'">
	<div class="row noLftRghtMargin">
        <event-properties event-type="onClick" event-model="propData.events.onClick" is-chart="true"></event-properties>
    </div>

    <div class="row noLftRghtMargin">
    	<div class="col-xs-12">
	    	<label title='<fmt:message key="CustomReport.Properties.Script"/>'>
				<fmt:message key="CustomReport.Properties.Script"/><br>
			</label>
            <div class="pull-right">
                <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.chartScript,'javascript','updateChart()','propData.chartScript')">
                    <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddScript"/>
                </button>
             </div>
    	</div>

    </div>
</div>

<!-- Begin "Filters" group -->
<div data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
    <cvfacet config="propData" type="'properties'" page="page" filters="propData.filters" filter-mode="'builder'" report-mode="reportMode"></cvfacet>
</div>

<!-- End "Custom Code" group -->
<!-- FIXME: Localize -->
<%-- <div style="text-align: center;" data-ng-show="selectedPropertyCategory!=='filters'">
    <a id="resetButton" class="mainBtn btn btn-primary btn-sm" data-ng-click="resetDefault()">
        <fmt:message key="CustomReport.Properties.ResetToDefault"/>
    </a>
</div> --%>

</fmt:bundle>
