<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
  <div>
    <div class="quick-chart-options">
      <div class="chart-config-option">
        <label  class="select-label" for="typeSelect"><fmt:message key="CustomReport.QuickAnalysis.Type"/>
          <select  id="typeSelect" data-ng-model="config.type" data-ng-change="updateQuickChart()"
          data-ng-options="type.label for type in chartTypes | orderBy track by type.type">
          <option value="">---</option>
        </select></label>
      </div>
      <div class="chart-config-option">
        <label for="aggr-type" class="select-label"><select class="aggr-type" data-ng-model="config.aggrType" data-ng-change="updateQuickChart()" >
          <option value="Count">Count</option>
          <option value="CountDistinct">Distinct</option>
          <option value="Sum"><fmt:message key="CustomReport.Sum"/></option>
          <option value="Avg"><fmt:message key="CustomReport.Avg"/></option>
          <option value="Min"><fmt:message key="CustomReport.Min"/></option>
          <option value="Max"><fmt:message key="CustomReport.Max"/></option>
        </select></label>
      </div>
      <div class="inline-block"><fmt:message key="CustomReport.Of"/></div>
      <div class="chart-config-option">
        <label for="measureSelect" class="select-label more">
        <select  id="measureSelect" data-ng-model="config.measure"
        data-ng-options="column.displayName for column in columns | filter:measureFilter | orderBy:'displayName' track by column.id">
        <option value="">---</option>
        </select></label>
      </div>
      <div class="chart-config-option" data-ng-if="showFirstDimension()">
        <label  class="select-label" for="dimensionSelect"><span data-ng-if="config.type.type != 'TimeSeries'"><fmt:message key="CustomReport.QuickAnalysis.Grouped"/></span><span data-ng-if="config.type.type == 'TimeSeries'"><fmt:message key="CustomReport.QuickAnalysis.TimeLimeGrouped"/></span>
        <select  id="dimensionSelect" data-ng-model="config.dimension" data-ng-change="updateQuickChart()"
          data-ng-options="column.displayName for column in columns | filter:dimensionFilter | orderBy:'displayName' track by column.id">
          <option value="">---</option>
        </select></label>
        <span data-ng-if="isTwoDimensionChart()">
        <div class="inline-block"><fmt:message key="CustomReport.QuickAnalysis.And"/></div>
        <label for="dimensionSelect2" class="select-label"><select   id="dimensionSelect2" data-ng-model="config.dimension2" data-ng-disabled="!config.dimension" data-ng-change="updateQuickChart()"
          data-ng-options="column.displayName for column in columns | filter:dimension2Filter | orderBy:'displayName' track by column.id">
          <option value=""><fmt:message key="CustomReport.Optional"/></option>
        </select></label>
        </span>
      </div>
    </div>
    <div>
      <div data-ng-show="initialized"
          data-ng-hide="appName === 'adminconsole' && (component.type === 'PANEL_HEADER' && component.header)"
          class="quick-chart-mode"
          data-component-type='{{component.type}}'
          data-ng-class="{'no-border': component.hideborder && reportMode==='viewer'}"
          comp="{{component.id}}"
          data-ng-style="$index != 0 ? { 'page-break-inside':'avoid' } : { 'page-break-inside':'inherit' }">
          <div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/component.jsp'" class="full-height"></div>
      </div>
    </div>
  </div>
</fmt:bundle>