(function() {
  'use strict';

  var app = angular.module("reports").controller("previewModalCtrl",['$scope','$uibModalInstance','$timeout','formatterOptions','getPreviewData',  'tableProperties', '$sanitize',
    function($scope,$uibModalInstance,$timeout,formatterOptions,getPreviewData,tableProperties,$sanitize) {                        
        $scope.formatter = formatterOptions.formatter;
        $scope.columns = formatterOptions.columns;
        $scope.getPreviewData = getPreviewData;  
        $scope.tableProperties = tableProperties;
        $scope.propertiesToMap = tableProperties.propertiesToMap;

        $scope.callBack = function(htmlData) {
          $scope.isProcessing = false;
          $timeout(function() {
            try {
                    htmlData = $sanitize(htmlData);
                } catch(e) {
                    htmlData = htmlData;
                }
            $("#previewModal .previewContent").html(htmlData);           
          }); 
        }

        $scope.getArguments = function() {
          return {
              formatter:$scope.formatter,
              rowData :$scope.tableProperties[$scope.propertiesToMap.tableData][$scope.formatter.rowIndex],
              columns:$scope.columns,
              callBack: $scope.callBack

           };
        }

       $scope.init = function() {     
          $scope.isProcessing = true;
          $scope.getPreviewData($scope.getArguments()); 
          if($scope.propertiesToMap) {
             if(typeof $scope.tableProperties[$scope.propertiesToMap.totalPageCnt] === 'function')    
                 $scope.totalPageCnt = $scope.tableProperties[$scope.propertiesToMap.totalPageCnt]();
            else
                $scope.totalPageCnt =   $scope.tableProperties[$scope.propertiesToMap.totalPageCnt];
            if(typeof $scope.tableProperties[$scope.propertiesToMap.pageSize] === 'function')
              $scope.pageSize = $scope.tableProperties[$scope.propertiesToMap.pageSize]();
            else
               $scope.pageSize = $scope.tableProperties[$scope.propertiesToMap.pageSize];
          }

       }       
        
       $scope.loadPrevPreview = function() {
          let triggerPrevPagination = false,
          totalRows = $scope.tableProperties[$scope.propertiesToMap.tableData].length - 1,curPage;
          if($scope.tableProperties) {
            curPage =  $scope.tableProperties.page();
            triggerPrevPagination = $scope.formatter.rowIndex === 0 && curPage > 1;
          }          
          
          if(triggerPrevPagination || $scope.formatter.rowIndex > 0) {
            $scope.isProcessing = true;
            if(triggerPrevPagination) {
              $scope.formatter.rowIndex = $scope.pageSize - 1;
              $scope.tableProperties.page(--curPage);
            } else {
              $scope.formatter.rowIndex--;
              $scope.htmlData = null;
              $scope.getPreviewData($scope.getArguments());
            }
           
          }  

         
        }

       $scope.loadNextPreview = function() {
          let triggerNxtPagination = false,
          totalRows = $scope.tableProperties[$scope.propertiesToMap.tableData].length - 1,curPage;
          if($scope.tableProperties) {
            curPage =  $scope.tableProperties.page();
            triggerNxtPagination = $scope.formatter.rowIndex === totalRows && curPage < $scope.totalPageCnt;
          }            
          
          if(triggerNxtPagination || $scope.formatter.rowIndex < totalRows) {
            $scope.isProcessing = true;
            if(triggerNxtPagination) {
              $scope.formatter.rowIndex = 0;
              $scope.tableProperties.page(++curPage);
            } else {
              $scope.formatter.rowIndex++;
               $scope.htmlData = null;
              $scope.getPreviewData($scope.getArguments());
            }
           
          }  
        }

        $scope.$watch('tableProperties[propertiesToMap.tableData]', function(newValue,oldValue) {
          if(newValue !== undefined && (newValue !== oldValue)){
            $scope.htmlData = null;
            $scope.getPreviewData($scope.getArguments());
          }             

        });
        
       $scope.closeModal = function() {
          delete tableProperties.propertiesToMap;
          $uibModalInstance.dismiss()
        }
       
      $scope.init();

      }]);
})();