(function() {
	'use strict';
	var app = angular.module("reports");
	app.filter('orderObjectBy', function() {
	  return function(items, field, searchInput) {
	    var filtered = [];
	    angular.forEach(items, function(item) {
	      filtered.push(item);
	    });
	    filtered.sort(function (a, b) {
	      return (a[field] > b[field] ? 1 : -1);
	    });
	    if(reverse) filtered.reverse();
	    return filtered;
	  };
	});

	app.controller("columnSettingCtrl",["$scope", "$uibModalInstance", "columns", "dataSet","Title", "$timeout", function ($scope, $uibModalInstance,columns,dataSet,Title, $timeout) {
		$scope.columns = columns;
		$scope.dataSet = dataSet;		
		$scope.searchColumns = [];
		$scope.pageSize = 0;
		$scope.Title = Title;
        $scope.init = function() {
             if($scope.columns.length < 10) {
                var fields =  $scope.dataSet.fields;
                for(var i=0 ; i < fields.length ; i++) {
                    var field = fields[i],
                    isColPresent = $scope.columns.filter(function(col) {
                        return col.dataField === field.dataField
                    }).length !== 0;

                    if(!isColPresent) {
                        columns.push({
                            name : field.name,
                            dataField : field.dataField,
                            type : field.type,
                            visible : false
                        });                                                                
                                                                        
                    }
                    if(columns.length >= 10)
                        break;                                                      
                }       
            } 
        }
       
		$scope.showNoResultMsg = function() {
			return angular.element("#columnSettingModal #colList").children().not( ".noResultInfo" ).length === 0;									
    	}
    	
    	$scope.isSelectAll = function() {
    		var visibleCols = $scope.columns.filter(function(col) {
				return col.visible;
			});
    		return $scope.selectAll || (visibleCols.length === $scope.dataSet.fields.length);
    	}
    	$scope.toggleSelectAll = function () {
			$timeout(function() {
				var fields = $scope.dataSet.fields;
				angular.forEach($scope.columns, function(col) {
					col.visible = $scope.selectAll;
				});
				if($scope.selectAll && ($scope.columns.length < fields.length)) {
					var remainingFields = fields.filter(function(field) {
						return $scope.columns.filter(function(col) {
							return field.dataField === col.dataField;
						}).length === 0;
					});
					angular.forEach(remainingFields, function(field) {
						$scope.columns.push({
								name : field.name,
								dataField : field.dataField,
								type : field.type,
								visible : true
							});	
					});
				}
			});
    	}

    	$scope.loadMoreValues = function() {
    		var fields = $scope.dataSet.fields,
    		cols = $scope.columns, filterColArr,col;
    		$scope.pageSize++;
    		
    		for(var i=0; i < fields.length; i++) {
    			if(cols.length > ($scope.pageSize * 10))
    				break;
    			filterColArr = cols.filter(function(col) {
					return fields[i].dataField === col.dataField;
				});
				if(filterColArr.length === 0) {
					cols.push({
							name : fields[i].name,
							dataField : fields[i].dataField,
							type : fields[i].type,
							visible : false
						});	
				} 								
    		}
    		
    	}
    	$scope.addSelectedCol = function(col) {
			$timeout(function() {
				if(!col.visible) {    			
					var visibleCols = $scope.columns.filter(function(col) {
						return col.visible;
					});
					if(visibleCols.length === 0) {
						col.visible = !col.visible
						return;
					}					
					$scope.selectAll = false;
				} else if(col.visible && $scope.searchColumns.length > 0) {
					var isColPresent = $scope.columns.filter(function(column) {
						return col.dataField === column.dataField;
					}).length > 0;
					if(!isColPresent)
						$scope.columns.push(col);
				} 
			});
    		
    	}
    	$scope.$watch('searchInput', function(newValue,oldValue) {						    		  				
    		$scope.searchColumns = [];
            var searchResultsCnt = 10;
    		//As all columns need not be there in the modal sp
    		//we need to call below logic to form search list based on users search query. 
    		if(newValue !== oldValue && angular.isDefined(newValue) && newValue !== "") {	
    			var fields = $scope.dataSet.fields,
    			cols = $scope.columns;

                for(var j=0; j < cols.length; j++) {
                    if($scope.searchColumns.length === searchResultsCnt)
                        break;
                    var fieldName = cols[j].displayName ? cols[j].displayName : cols[j].dataField;
                    if(fieldName.toLowerCase().startsWith(newValue.toLowerCase())) 
                        $scope.searchColumns.push(cols[j]);
                    
                }                    

    			for(var i=0; i < fields.length; i++) {
                    if($scope.searchColumns.length === searchResultsCnt)
                        break;
                    var isColAlreadyAdded = $scope.searchColumns.filter(function(col) {
                        return fields[i].dataField === col.dataField;
                    }).length > 0;
    				if(!isColAlreadyAdded && fields[i].dataField.toLowerCase().startsWith(newValue.toLowerCase()))
    					$scope.searchColumns.push(angular.copy(fields[i]));
    				
    			}
    			
    			/*for(var i=0; i < $scope.searchColumns.length; i++) {
    				for(var j=0; j < cols.length; j++)
    					if($scope.searchColumns[i].dataField === cols[j].dataField) {
    						$scope.searchColumns[i] = cols[j];
    						break;
    					}
    			}
*/
    		}
			
		});	
		$scope.ok = function() {
			var visibleCols = $scope.columns.filter(function(col) {
				return col.visible;
			});
			if(visibleCols.length > 0)
				$uibModalInstance.close(visibleCols);
		};

		$scope.cancel = function() {
			$uibModalInstance.dismiss()
		}
        $scope.init();
	}]);
})();