(function() {
	'use strict';

	let app = angular.module("reports");

	app.controller("aceEditorCtrl", [
			"$scope",
			"$uibModalInstance",
			"modalTitle",
			"editorOptions",
			"editorContent",
			"inputVariables",
			"helpText",
			function($scope, $uibModalInstance, modalTitle, editorOptions, editorContent,inputVariables,helpText) {				
				$scope.title = modalTitle;
				$scope.helpText = helpText;
				$scope.aceLoaded = function (_editor) {
					$scope.editor = _editor;
					$scope.editorSession = _editor.getSession();
				}
				let defaultOptions = {
					useWrapMode : true,
		            showPrintMargin : false,
		            theme : 'eclipse',
		            require: ['ace/ext/language_tools'],
		            onLoad : $scope.aceLoaded,
				    advanced: {
					      enableSnippets: true,
					      enableBasicAutocompletion: true
					  }
      			};
      			$scope.editorOptions = angular.extend(defaultOptions,editorOptions);

      			if($.isArray(editorOptions.mode)) {
      				$scope.editorModes = editorOptions.mode;
      				$scope.editorOptions.mode = $scope.editorModes[0];
      			}
      			
      			$scope.editorContent = editorContent;
      			$uibModalInstance.rendered.then(function() {
      				$('.aceEditorModalWindow .modal-content').resizable({
					   "handles" : "n, e,w,ne,nw"
					});
      				
      				$('.aceEditorModalWindow .modal-dialog').draggable({
					    handle: '.modal-header',
					    opacity: 0.5
					  });

      				if(helpText)
						  $("#aceEditorModal .tooltipElm").tooltip();
					
					//move cursor to end of content 
					if($scope.editorContent) {
						const row = $scope.editorSession.doc.getLength();
						const column = $scope.editorSession.getLine(row-1).length;
						$scope.editorSession.selection.moveTo(row,column);
					}					
					$scope.editor.focus();
				});
      			 
      			if(!$.isEmptyObject(inputVariables)) {
      				let rootElmArray = [];
      				angular.forEach(inputVariables, function(childrens,label) {
      					let rootElm = {
							label: label,
							children : []						
											
						};
						if(childrens && childrens.length > 0) {
							angular.forEach(childrens, function(col) {
								rootElm.children.push({
									label : col.dataField || col.name,
									endExp : col.endExp,
									isLeaf : true
								});
							});
							rootElm["state"] = "expanded";
							
						} else {
							rootElm["isLeaf"] = true;
						}
						rootElmArray.push(rootElm);
      				});
      				
					
					$scope.selectedItems = [];
					$scope.treeParent = rootElmArray;
      			}

      			$scope.onItemSelection = function (selectedItem) {
      				let mode =$scope.editorOptions.mode,exp;
      				if(selectedItem.isLeaf) {
						let parentLabel =  mode !== "expression" && selectedItem.parent ? selectedItem.parent.label : "",
						childLabel = parentLabel ? "['" + selectedItem.label + "']" : selectedItem.label,
						startExp = "",
						endExp = "";
						if(mode === "html" || !$.isArray(editorOptions.mode)) {
							startExp = mode === "expression" ? "" : "{{";
							const entityEndExp = selectedItem.entity.endExp;
							endExp =  mode === "expression" ? (entityEndExp ? entityEndExp : "") : "}}";
						}
						exp = startExp + parentLabel + childLabel + endExp;	      					
					} 
					const start = {
						row:0,
						column:0
					};
					//if no curOp defined that means there is no content in editor. So insert/add expression to start
					const currentCurPos = $scope.editorSession.curOp ? $scope.editorSession.curOp.selectionAfter.end :start;
					$scope.editorSession.insert(currentCurPos,exp);
					$scope.editor.focus();
      			}

      			$scope.changeEditorMode = function(mode) {
      				$scope.editorOptions.mode = mode;
					  $scope.editorSession.setMode(mode);
					const editorContent = $scope.editorSession.getValue();
      				if(mode === "javascript" && !editorContent)
      					$scope.editorContent = ":=";
      			}
      			$scope.ok = function() {
					$scope.editorContent = $scope.editorSession.getValue();
					
					if($scope.editorContent && $scope.editorContent.trim() === ":=")
      					$scope.editorContent = "";
					
						$uibModalInstance.close($scope.editorContent);
				};

				$scope.cancel = function() {
					$uibModalInstance.dismiss()
				}
			} ]);
})();