// Closure to isolate scope, as per best practices
(function() {
	"use strict";
	
	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");
		
	// Controller for "Localization" modal
	app.controller("localizationModalCtrl", ["$scope","$uibModal", 
		function($scope,$modal) {
			$scope.rows = $scope.customReport.translations;
			
			/** Currently active row */
			$scope.currentRow = null;

			$scope.setCurrentRow = function(row) {
				$scope.currentRow = row;
			};

			$scope.isCurrentParameter = function(row) {
				return $scope.currentRow === row;
			};

			$scope.addRow = function(row) {
				if(typeof $scope.rows === "undefined" || $scope.rows === null) {
					$scope.rows = [];
				}
				if(typeof row === "undefined" || row === null) {
					$scope.rows.push({locale: "", localeKey: "", localeValue: ""});
				} else {
					$scope.rows.push(row);
				}
			}

			$scope.deleteRow = function() {
				$scope.rows.splice($scope.rows.indexOf($scope.currentRow), 1);
			}

			$scope.cloneRow = function() {
				if(typeof $scope.currentRow !== "undefined" && $scope.currentRow !== null) {
					var rowClone = angular.copy($scope.currentRow);
					rowClone.locale = "";
					rowClone.localeValue = "";
					$scope.addRow(rowClone);					
				} else {
					$scope.addRow();
				}
			}

			$scope.saveAndCloseModal = function() {
				$scope.loadTranslations($scope.customReport.translations,false);
				$scope.closeModal();
			}

			$scope.closeModal = function() {
				$scope.$close();
			}
		}
	]);
})();